// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetJobReader is a Reader for the WaypointGetJob structure.
type WaypointGetJobReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetJobReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetJobOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetJobDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetJobOK creates a WaypointGetJobOK with default headers values
func NewWaypointGetJobOK() *WaypointGetJobOK {
	return &WaypointGetJobOK{}
}

/*
WaypointGetJobOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetJobOK struct {
	Payload *models.HashicorpWaypointJob
}

// IsSuccess returns true when this waypoint get job o k response has a 2xx status code
func (o *WaypointGetJobOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get job o k response has a 3xx status code
func (o *WaypointGetJobOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get job o k response has a 4xx status code
func (o *WaypointGetJobOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get job o k response has a 5xx status code
func (o *WaypointGetJobOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get job o k response a status code equal to that given
func (o *WaypointGetJobOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetJobOK) Error() string {
	return fmt.Sprintf("[GET /jobs/{job_id}][%d] waypointGetJobOK  %+v", 200, o.Payload)
}

func (o *WaypointGetJobOK) String() string {
	return fmt.Sprintf("[GET /jobs/{job_id}][%d] waypointGetJobOK  %+v", 200, o.Payload)
}

func (o *WaypointGetJobOK) GetPayload() *models.HashicorpWaypointJob {
	return o.Payload
}

func (o *WaypointGetJobOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointJob)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetJobDefault creates a WaypointGetJobDefault with default headers values
func NewWaypointGetJobDefault(code int) *WaypointGetJobDefault {
	return &WaypointGetJobDefault{
		_statusCode: code,
	}
}

/*
WaypointGetJobDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetJobDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get job default response
func (o *WaypointGetJobDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get job default response has a 2xx status code
func (o *WaypointGetJobDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get job default response has a 3xx status code
func (o *WaypointGetJobDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get job default response has a 4xx status code
func (o *WaypointGetJobDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get job default response has a 5xx status code
func (o *WaypointGetJobDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get job default response a status code equal to that given
func (o *WaypointGetJobDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetJobDefault) Error() string {
	return fmt.Sprintf("[GET /jobs/{job_id}][%d] Waypoint_GetJob default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetJobDefault) String() string {
	return fmt.Sprintf("[GET /jobs/{job_id}][%d] Waypoint_GetJob default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetJobDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetJobDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
