// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetConfigSourceReader is a Reader for the WaypointGetConfigSource structure.
type WaypointGetConfigSourceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetConfigSourceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetConfigSourceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetConfigSourceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetConfigSourceOK creates a WaypointGetConfigSourceOK with default headers values
func NewWaypointGetConfigSourceOK() *WaypointGetConfigSourceOK {
	return &WaypointGetConfigSourceOK{}
}

/*
WaypointGetConfigSourceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetConfigSourceOK struct {
	Payload *models.HashicorpWaypointGetConfigSourceResponse
}

// IsSuccess returns true when this waypoint get config source o k response has a 2xx status code
func (o *WaypointGetConfigSourceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get config source o k response has a 3xx status code
func (o *WaypointGetConfigSourceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get config source o k response has a 4xx status code
func (o *WaypointGetConfigSourceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get config source o k response has a 5xx status code
func (o *WaypointGetConfigSourceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get config source o k response a status code equal to that given
func (o *WaypointGetConfigSourceOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetConfigSourceOK) Error() string {
	return fmt.Sprintf("[GET /config-source][%d] waypointGetConfigSourceOK  %+v", 200, o.Payload)
}

func (o *WaypointGetConfigSourceOK) String() string {
	return fmt.Sprintf("[GET /config-source][%d] waypointGetConfigSourceOK  %+v", 200, o.Payload)
}

func (o *WaypointGetConfigSourceOK) GetPayload() *models.HashicorpWaypointGetConfigSourceResponse {
	return o.Payload
}

func (o *WaypointGetConfigSourceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetConfigSourceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetConfigSourceDefault creates a WaypointGetConfigSourceDefault with default headers values
func NewWaypointGetConfigSourceDefault(code int) *WaypointGetConfigSourceDefault {
	return &WaypointGetConfigSourceDefault{
		_statusCode: code,
	}
}

/*
WaypointGetConfigSourceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetConfigSourceDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get config source default response
func (o *WaypointGetConfigSourceDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get config source default response has a 2xx status code
func (o *WaypointGetConfigSourceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get config source default response has a 3xx status code
func (o *WaypointGetConfigSourceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get config source default response has a 4xx status code
func (o *WaypointGetConfigSourceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get config source default response has a 5xx status code
func (o *WaypointGetConfigSourceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get config source default response a status code equal to that given
func (o *WaypointGetConfigSourceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetConfigSourceDefault) Error() string {
	return fmt.Sprintf("[GET /config-source][%d] Waypoint_GetConfigSource default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetConfigSourceDefault) String() string {
	return fmt.Sprintf("[GET /config-source][%d] Waypoint_GetConfigSource default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetConfigSourceDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetConfigSourceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
