// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetConfigSourceParams creates a new WaypointGetConfigSourceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetConfigSourceParams() *WaypointGetConfigSourceParams {
	return &WaypointGetConfigSourceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetConfigSourceParamsWithTimeout creates a new WaypointGetConfigSourceParams object
// with the ability to set a timeout on a request.
func NewWaypointGetConfigSourceParamsWithTimeout(timeout time.Duration) *WaypointGetConfigSourceParams {
	return &WaypointGetConfigSourceParams{
		timeout: timeout,
	}
}

// NewWaypointGetConfigSourceParamsWithContext creates a new WaypointGetConfigSourceParams object
// with the ability to set a context for a request.
func NewWaypointGetConfigSourceParamsWithContext(ctx context.Context) *WaypointGetConfigSourceParams {
	return &WaypointGetConfigSourceParams{
		Context: ctx,
	}
}

// NewWaypointGetConfigSourceParamsWithHTTPClient creates a new WaypointGetConfigSourceParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetConfigSourceParamsWithHTTPClient(client *http.Client) *WaypointGetConfigSourceParams {
	return &WaypointGetConfigSourceParams{
		HTTPClient: client,
	}
}

/*
WaypointGetConfigSourceParams contains all the parameters to send to the API endpoint

	for the waypoint get config source operation.

	Typically these are written to a http.Request.
*/
type WaypointGetConfigSourceParams struct {

	// ApplicationApplication.
	ApplicationApplication *string

	// ApplicationProject.
	ApplicationProject *string

	// ProjectProject.
	ProjectProject *string

	/* Type.

	     config source type. This is optional. If this is omitted, all
	config source types matching the above scoping will be returned.
	This is a prefix-search. All config sources with this type prefix
	will be returned.
	*/
	Type *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get config source params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetConfigSourceParams) WithDefaults() *WaypointGetConfigSourceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get config source params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetConfigSourceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithTimeout(timeout time.Duration) *WaypointGetConfigSourceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithContext(ctx context.Context) *WaypointGetConfigSourceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithHTTPClient(client *http.Client) *WaypointGetConfigSourceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithApplicationApplication(applicationApplication *string) *WaypointGetConfigSourceParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetApplicationApplication(applicationApplication *string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithApplicationProject(applicationProject *string) *WaypointGetConfigSourceParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetApplicationProject(applicationProject *string) {
	o.ApplicationProject = applicationProject
}

// WithProjectProject adds the projectProject to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithProjectProject(projectProject *string) *WaypointGetConfigSourceParams {
	o.SetProjectProject(projectProject)
	return o
}

// SetProjectProject adds the projectProject to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetProjectProject(projectProject *string) {
	o.ProjectProject = projectProject
}

// WithType adds the typeVar to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithType(typeVar *string) *WaypointGetConfigSourceParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointGetConfigSourceParams {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get config source params
func (o *WaypointGetConfigSourceParams) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetConfigSourceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationApplication != nil {

		// query param application.application
		var qrApplicationApplication string

		if o.ApplicationApplication != nil {
			qrApplicationApplication = *o.ApplicationApplication
		}
		qApplicationApplication := qrApplicationApplication
		if qApplicationApplication != "" {

			if err := r.SetQueryParam("application.application", qApplicationApplication); err != nil {
				return err
			}
		}
	}

	if o.ApplicationProject != nil {

		// query param application.project
		var qrApplicationProject string

		if o.ApplicationProject != nil {
			qrApplicationProject = *o.ApplicationProject
		}
		qApplicationProject := qrApplicationProject
		if qApplicationProject != "" {

			if err := r.SetQueryParam("application.project", qApplicationProject); err != nil {
				return err
			}
		}
	}

	if o.ProjectProject != nil {

		// query param project.project
		var qrProjectProject string

		if o.ProjectProject != nil {
			qrProjectProject = *o.ProjectProject
		}
		qProjectProject := qrProjectProject
		if qProjectProject != "" {

			if err := r.SetQueryParam("project.project", qProjectProject); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
