// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointCreateHostnameReader is a Reader for the WaypointCreateHostname structure.
type WaypointCreateHostnameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointCreateHostnameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointCreateHostnameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointCreateHostnameDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointCreateHostnameOK creates a WaypointCreateHostnameOK with default headers values
func NewWaypointCreateHostnameOK() *WaypointCreateHostnameOK {
	return &WaypointCreateHostnameOK{}
}

/*
WaypointCreateHostnameOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointCreateHostnameOK struct {
	Payload *models.HashicorpWaypointCreateHostnameResponse
}

// IsSuccess returns true when this waypoint create hostname o k response has a 2xx status code
func (o *WaypointCreateHostnameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint create hostname o k response has a 3xx status code
func (o *WaypointCreateHostnameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint create hostname o k response has a 4xx status code
func (o *WaypointCreateHostnameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint create hostname o k response has a 5xx status code
func (o *WaypointCreateHostnameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint create hostname o k response a status code equal to that given
func (o *WaypointCreateHostnameOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointCreateHostnameOK) Error() string {
	return fmt.Sprintf("[POST /project/{target.application.application.project}/application/{target.application.application.application}/hostname][%d] waypointCreateHostnameOK  %+v", 200, o.Payload)
}

func (o *WaypointCreateHostnameOK) String() string {
	return fmt.Sprintf("[POST /project/{target.application.application.project}/application/{target.application.application.application}/hostname][%d] waypointCreateHostnameOK  %+v", 200, o.Payload)
}

func (o *WaypointCreateHostnameOK) GetPayload() *models.HashicorpWaypointCreateHostnameResponse {
	return o.Payload
}

func (o *WaypointCreateHostnameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointCreateHostnameResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointCreateHostnameDefault creates a WaypointCreateHostnameDefault with default headers values
func NewWaypointCreateHostnameDefault(code int) *WaypointCreateHostnameDefault {
	return &WaypointCreateHostnameDefault{
		_statusCode: code,
	}
}

/*
WaypointCreateHostnameDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointCreateHostnameDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint create hostname default response
func (o *WaypointCreateHostnameDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint create hostname default response has a 2xx status code
func (o *WaypointCreateHostnameDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint create hostname default response has a 3xx status code
func (o *WaypointCreateHostnameDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint create hostname default response has a 4xx status code
func (o *WaypointCreateHostnameDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint create hostname default response has a 5xx status code
func (o *WaypointCreateHostnameDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint create hostname default response a status code equal to that given
func (o *WaypointCreateHostnameDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointCreateHostnameDefault) Error() string {
	return fmt.Sprintf("[POST /project/{target.application.application.project}/application/{target.application.application.application}/hostname][%d] Waypoint_CreateHostname default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCreateHostnameDefault) String() string {
	return fmt.Sprintf("[POST /project/{target.application.application.project}/application/{target.application.application.application}/hostname][%d] Waypoint_CreateHostname default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCreateHostnameDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointCreateHostnameDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
