// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointAdoptRunnerReader is a Reader for the WaypointAdoptRunner structure.
type WaypointAdoptRunnerReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointAdoptRunnerReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointAdoptRunnerOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointAdoptRunnerDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointAdoptRunnerOK creates a WaypointAdoptRunnerOK with default headers values
func NewWaypointAdoptRunnerOK() *WaypointAdoptRunnerOK {
	return &WaypointAdoptRunnerOK{}
}

/*
WaypointAdoptRunnerOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointAdoptRunnerOK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint adopt runner o k response has a 2xx status code
func (o *WaypointAdoptRunnerOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint adopt runner o k response has a 3xx status code
func (o *WaypointAdoptRunnerOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint adopt runner o k response has a 4xx status code
func (o *WaypointAdoptRunnerOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint adopt runner o k response has a 5xx status code
func (o *WaypointAdoptRunnerOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint adopt runner o k response a status code equal to that given
func (o *WaypointAdoptRunnerOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointAdoptRunnerOK) Error() string {
	return fmt.Sprintf("[POST /runner/{runner_id}/adopt][%d] waypointAdoptRunnerOK  %+v", 200, o.Payload)
}

func (o *WaypointAdoptRunnerOK) String() string {
	return fmt.Sprintf("[POST /runner/{runner_id}/adopt][%d] waypointAdoptRunnerOK  %+v", 200, o.Payload)
}

func (o *WaypointAdoptRunnerOK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointAdoptRunnerOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointAdoptRunnerDefault creates a WaypointAdoptRunnerDefault with default headers values
func NewWaypointAdoptRunnerDefault(code int) *WaypointAdoptRunnerDefault {
	return &WaypointAdoptRunnerDefault{
		_statusCode: code,
	}
}

/*
WaypointAdoptRunnerDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointAdoptRunnerDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint adopt runner default response
func (o *WaypointAdoptRunnerDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint adopt runner default response has a 2xx status code
func (o *WaypointAdoptRunnerDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint adopt runner default response has a 3xx status code
func (o *WaypointAdoptRunnerDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint adopt runner default response has a 4xx status code
func (o *WaypointAdoptRunnerDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint adopt runner default response has a 5xx status code
func (o *WaypointAdoptRunnerDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint adopt runner default response a status code equal to that given
func (o *WaypointAdoptRunnerDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointAdoptRunnerDefault) Error() string {
	return fmt.Sprintf("[POST /runner/{runner_id}/adopt][%d] Waypoint_AdoptRunner default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointAdoptRunnerDefault) String() string {
	return fmt.Sprintf("[POST /runner/{runner_id}/adopt][%d] Waypoint_AdoptRunner default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointAdoptRunnerDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointAdoptRunnerDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
