// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointJobGit hashicorp waypoint job git
//
// swagger:model hashicorp.waypoint.Job.Git
type HashicorpWaypointJobGit struct {

	// basic
	Basic *HashicorpWaypointJobGitBasic `json:"basic,omitempty"`

	// This setting only takes effect if both "path" is true AND the
	// Git polling is enabled. Under those conditions, if this option
	// is true, then only changes in Git commits within the "path" will
	// trigger a deploy. Changes outside the "path" will be ignored.
	IgnoreChangesOutsidePath bool `json:"ignore_changes_outside_path,omitempty"`

	// path is a subdirectory within the checked out repository to
	// go into for the project's configuration. This must be a relative path
	// and may not contain ".."
	Path string `json:"path,omitempty"`

	// The max depth for recursively cloning submodules. 0 disables submodule
	// cloning.
	RecurseSubmodules int64 `json:"recurse_submodules,omitempty"`

	// a ref to checkout. If this isn't specified, then the default
	// ref that is cloned from the URL above will be used.
	Ref string `json:"ref,omitempty"`

	// ssh
	SSH *HashicorpWaypointJobGitSSH `json:"ssh,omitempty"`

	// url of the repository to clone. Local paths are not allowed.
	URL string `json:"url,omitempty"`
}

// Validate validates this hashicorp waypoint job git
func (m *HashicorpWaypointJobGit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBasic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSSH(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobGit) validateBasic(formats strfmt.Registry) error {
	if swag.IsZero(m.Basic) { // not required
		return nil
	}

	if m.Basic != nil {
		if err := m.Basic.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("basic")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("basic")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJobGit) validateSSH(formats strfmt.Registry) error {
	if swag.IsZero(m.SSH) { // not required
		return nil
	}

	if m.SSH != nil {
		if err := m.SSH.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ssh")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ssh")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint job git based on the context it is used
func (m *HashicorpWaypointJobGit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBasic(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSSH(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobGit) contextValidateBasic(ctx context.Context, formats strfmt.Registry) error {

	if m.Basic != nil {
		if err := m.Basic.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("basic")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("basic")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJobGit) contextValidateSSH(ctx context.Context, formats strfmt.Registry) error {

	if m.SSH != nil {
		if err := m.SSH.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ssh")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ssh")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointJobGit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointJobGit) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointJobGit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
