// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointRunTriggerReader is a Reader for the WaypointRunTrigger structure.
type WaypointRunTriggerReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointRunTriggerReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointRunTriggerOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointRunTriggerDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointRunTriggerOK creates a WaypointRunTriggerOK with default headers values
func NewWaypointRunTriggerOK() *WaypointRunTriggerOK {
	return &WaypointRunTriggerOK{}
}

/*
WaypointRunTriggerOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointRunTriggerOK struct {
	Payload *models.HashicorpWaypointRunTriggerResponse
}

// IsSuccess returns true when this waypoint run trigger o k response has a 2xx status code
func (o *WaypointRunTriggerOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint run trigger o k response has a 3xx status code
func (o *WaypointRunTriggerOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint run trigger o k response has a 4xx status code
func (o *WaypointRunTriggerOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint run trigger o k response has a 5xx status code
func (o *WaypointRunTriggerOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint run trigger o k response a status code equal to that given
func (o *WaypointRunTriggerOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointRunTriggerOK) Error() string {
	return fmt.Sprintf("[PUT /trigger/{ref.id}][%d] waypointRunTriggerOK  %+v", 200, o.Payload)
}

func (o *WaypointRunTriggerOK) String() string {
	return fmt.Sprintf("[PUT /trigger/{ref.id}][%d] waypointRunTriggerOK  %+v", 200, o.Payload)
}

func (o *WaypointRunTriggerOK) GetPayload() *models.HashicorpWaypointRunTriggerResponse {
	return o.Payload
}

func (o *WaypointRunTriggerOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointRunTriggerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointRunTriggerDefault creates a WaypointRunTriggerDefault with default headers values
func NewWaypointRunTriggerDefault(code int) *WaypointRunTriggerDefault {
	return &WaypointRunTriggerDefault{
		_statusCode: code,
	}
}

/*
WaypointRunTriggerDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointRunTriggerDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint run trigger default response
func (o *WaypointRunTriggerDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint run trigger default response has a 2xx status code
func (o *WaypointRunTriggerDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint run trigger default response has a 3xx status code
func (o *WaypointRunTriggerDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint run trigger default response has a 4xx status code
func (o *WaypointRunTriggerDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint run trigger default response has a 5xx status code
func (o *WaypointRunTriggerDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint run trigger default response a status code equal to that given
func (o *WaypointRunTriggerDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointRunTriggerDefault) Error() string {
	return fmt.Sprintf("[PUT /trigger/{ref.id}][%d] Waypoint_RunTrigger default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointRunTriggerDefault) String() string {
	return fmt.Sprintf("[PUT /trigger/{ref.id}][%d] Waypoint_RunTrigger default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointRunTriggerDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointRunTriggerDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
