// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListOIDCAuthMethodsReader is a Reader for the WaypointListOIDCAuthMethods structure.
type WaypointListOIDCAuthMethodsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListOIDCAuthMethodsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListOIDCAuthMethodsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListOIDCAuthMethodsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListOIDCAuthMethodsOK creates a WaypointListOIDCAuthMethodsOK with default headers values
func NewWaypointListOIDCAuthMethodsOK() *WaypointListOIDCAuthMethodsOK {
	return &WaypointListOIDCAuthMethodsOK{}
}

/*
WaypointListOIDCAuthMethodsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListOIDCAuthMethodsOK struct {
	Payload *models.HashicorpWaypointListOIDCAuthMethodsResponse
}

// IsSuccess returns true when this waypoint list o Id c auth methods o k response has a 2xx status code
func (o *WaypointListOIDCAuthMethodsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list o Id c auth methods o k response has a 3xx status code
func (o *WaypointListOIDCAuthMethodsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list o Id c auth methods o k response has a 4xx status code
func (o *WaypointListOIDCAuthMethodsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list o Id c auth methods o k response has a 5xx status code
func (o *WaypointListOIDCAuthMethodsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list o Id c auth methods o k response a status code equal to that given
func (o *WaypointListOIDCAuthMethodsOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListOIDCAuthMethodsOK) Error() string {
	return fmt.Sprintf("[GET /oidc/methods][%d] waypointListOIdCAuthMethodsOK  %+v", 200, o.Payload)
}

func (o *WaypointListOIDCAuthMethodsOK) String() string {
	return fmt.Sprintf("[GET /oidc/methods][%d] waypointListOIdCAuthMethodsOK  %+v", 200, o.Payload)
}

func (o *WaypointListOIDCAuthMethodsOK) GetPayload() *models.HashicorpWaypointListOIDCAuthMethodsResponse {
	return o.Payload
}

func (o *WaypointListOIDCAuthMethodsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListOIDCAuthMethodsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListOIDCAuthMethodsDefault creates a WaypointListOIDCAuthMethodsDefault with default headers values
func NewWaypointListOIDCAuthMethodsDefault(code int) *WaypointListOIDCAuthMethodsDefault {
	return &WaypointListOIDCAuthMethodsDefault{
		_statusCode: code,
	}
}

/*
WaypointListOIDCAuthMethodsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListOIDCAuthMethodsDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list o ID c auth methods default response
func (o *WaypointListOIDCAuthMethodsDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list o ID c auth methods default response has a 2xx status code
func (o *WaypointListOIDCAuthMethodsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list o ID c auth methods default response has a 3xx status code
func (o *WaypointListOIDCAuthMethodsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list o ID c auth methods default response has a 4xx status code
func (o *WaypointListOIDCAuthMethodsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list o ID c auth methods default response has a 5xx status code
func (o *WaypointListOIDCAuthMethodsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list o ID c auth methods default response a status code equal to that given
func (o *WaypointListOIDCAuthMethodsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListOIDCAuthMethodsDefault) Error() string {
	return fmt.Sprintf("[GET /oidc/methods][%d] Waypoint_ListOIDCAuthMethods default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListOIDCAuthMethodsDefault) String() string {
	return fmt.Sprintf("[GET /oidc/methods][%d] Waypoint_ListOIDCAuthMethods default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListOIDCAuthMethodsDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListOIDCAuthMethodsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
