// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListBuilds2Params creates a new WaypointListBuilds2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListBuilds2Params() *WaypointListBuilds2Params {
	return &WaypointListBuilds2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListBuilds2ParamsWithTimeout creates a new WaypointListBuilds2Params object
// with the ability to set a timeout on a request.
func NewWaypointListBuilds2ParamsWithTimeout(timeout time.Duration) *WaypointListBuilds2Params {
	return &WaypointListBuilds2Params{
		timeout: timeout,
	}
}

// NewWaypointListBuilds2ParamsWithContext creates a new WaypointListBuilds2Params object
// with the ability to set a context for a request.
func NewWaypointListBuilds2ParamsWithContext(ctx context.Context) *WaypointListBuilds2Params {
	return &WaypointListBuilds2Params{
		Context: ctx,
	}
}

// NewWaypointListBuilds2ParamsWithHTTPClient creates a new WaypointListBuilds2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListBuilds2ParamsWithHTTPClient(client *http.Client) *WaypointListBuilds2Params {
	return &WaypointListBuilds2Params{
		HTTPClient: client,
	}
}

/*
WaypointListBuilds2Params contains all the parameters to send to the API endpoint

	for the waypoint list builds2 operation.

	Typically these are written to a http.Request.
*/
type WaypointListBuilds2Params struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	// OrderDesc.
	OrderDesc *bool

	/* OrderLimit.

	   Limit the number of results.

	   Format: int64
	*/
	OrderLimit *int64

	/* OrderOrder.

	   Order for the results.

	   Default: "UNSET"
	*/
	OrderOrder *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list builds2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListBuilds2Params) WithDefaults() *WaypointListBuilds2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list builds2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListBuilds2Params) SetDefaults() {
	var (
		orderOrderDefault = string("UNSET")
	)

	val := WaypointListBuilds2Params{
		OrderOrder: &orderOrderDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithTimeout(timeout time.Duration) *WaypointListBuilds2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithContext(ctx context.Context) *WaypointListBuilds2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithHTTPClient(client *http.Client) *WaypointListBuilds2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithApplicationApplication(applicationApplication string) *WaypointListBuilds2Params {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithApplicationProject(applicationProject string) *WaypointListBuilds2Params {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithOrderDesc adds the orderDesc to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithOrderDesc(orderDesc *bool) *WaypointListBuilds2Params {
	o.SetOrderDesc(orderDesc)
	return o
}

// SetOrderDesc adds the orderDesc to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetOrderDesc(orderDesc *bool) {
	o.OrderDesc = orderDesc
}

// WithOrderLimit adds the orderLimit to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithOrderLimit(orderLimit *int64) *WaypointListBuilds2Params {
	o.SetOrderLimit(orderLimit)
	return o
}

// SetOrderLimit adds the orderLimit to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetOrderLimit(orderLimit *int64) {
	o.OrderLimit = orderLimit
}

// WithOrderOrder adds the orderOrder to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithOrderOrder(orderOrder *string) *WaypointListBuilds2Params {
	o.SetOrderOrder(orderOrder)
	return o
}

// SetOrderOrder adds the orderOrder to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetOrderOrder(orderOrder *string) {
	o.OrderOrder = orderOrder
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) WithWorkspaceWorkspace(workspaceWorkspace string) *WaypointListBuilds2Params {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list builds2 params
func (o *WaypointListBuilds2Params) SetWorkspaceWorkspace(workspaceWorkspace string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListBuilds2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.OrderDesc != nil {

		// query param order.desc
		var qrOrderDesc bool

		if o.OrderDesc != nil {
			qrOrderDesc = *o.OrderDesc
		}
		qOrderDesc := swag.FormatBool(qrOrderDesc)
		if qOrderDesc != "" {

			if err := r.SetQueryParam("order.desc", qOrderDesc); err != nil {
				return err
			}
		}
	}

	if o.OrderLimit != nil {

		// query param order.limit
		var qrOrderLimit int64

		if o.OrderLimit != nil {
			qrOrderLimit = *o.OrderLimit
		}
		qOrderLimit := swag.FormatInt64(qrOrderLimit)
		if qOrderLimit != "" {

			if err := r.SetQueryParam("order.limit", qOrderLimit); err != nil {
				return err
			}
		}
	}

	if o.OrderOrder != nil {

		// query param order.order
		var qrOrderOrder string

		if o.OrderOrder != nil {
			qrOrderOrder = *o.OrderOrder
		}
		qOrderOrder := qrOrderOrder
		if qOrderOrder != "" {

			if err := r.SetQueryParam("order.order", qOrderOrder); err != nil {
				return err
			}
		}
	}

	// path param workspace.workspace
	if err := r.SetPathParam("workspace.workspace", o.WorkspaceWorkspace); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
