// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListAuthMethodsReader is a Reader for the WaypointListAuthMethods structure.
type WaypointListAuthMethodsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListAuthMethodsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListAuthMethodsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListAuthMethodsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListAuthMethodsOK creates a WaypointListAuthMethodsOK with default headers values
func NewWaypointListAuthMethodsOK() *WaypointListAuthMethodsOK {
	return &WaypointListAuthMethodsOK{}
}

/*
WaypointListAuthMethodsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListAuthMethodsOK struct {
	Payload *models.HashicorpWaypointListAuthMethodsResponse
}

// IsSuccess returns true when this waypoint list auth methods o k response has a 2xx status code
func (o *WaypointListAuthMethodsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list auth methods o k response has a 3xx status code
func (o *WaypointListAuthMethodsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list auth methods o k response has a 4xx status code
func (o *WaypointListAuthMethodsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list auth methods o k response has a 5xx status code
func (o *WaypointListAuthMethodsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list auth methods o k response a status code equal to that given
func (o *WaypointListAuthMethodsOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListAuthMethodsOK) Error() string {
	return fmt.Sprintf("[GET /auth-methods][%d] waypointListAuthMethodsOK  %+v", 200, o.Payload)
}

func (o *WaypointListAuthMethodsOK) String() string {
	return fmt.Sprintf("[GET /auth-methods][%d] waypointListAuthMethodsOK  %+v", 200, o.Payload)
}

func (o *WaypointListAuthMethodsOK) GetPayload() *models.HashicorpWaypointListAuthMethodsResponse {
	return o.Payload
}

func (o *WaypointListAuthMethodsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListAuthMethodsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListAuthMethodsDefault creates a WaypointListAuthMethodsDefault with default headers values
func NewWaypointListAuthMethodsDefault(code int) *WaypointListAuthMethodsDefault {
	return &WaypointListAuthMethodsDefault{
		_statusCode: code,
	}
}

/*
WaypointListAuthMethodsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListAuthMethodsDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list auth methods default response
func (o *WaypointListAuthMethodsDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list auth methods default response has a 2xx status code
func (o *WaypointListAuthMethodsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list auth methods default response has a 3xx status code
func (o *WaypointListAuthMethodsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list auth methods default response has a 4xx status code
func (o *WaypointListAuthMethodsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list auth methods default response has a 5xx status code
func (o *WaypointListAuthMethodsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list auth methods default response a status code equal to that given
func (o *WaypointListAuthMethodsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListAuthMethodsDefault) Error() string {
	return fmt.Sprintf("[GET /auth-methods][%d] Waypoint_ListAuthMethods default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListAuthMethodsDefault) String() string {
	return fmt.Sprintf("[GET /auth-methods][%d] Waypoint_ListAuthMethods default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListAuthMethodsDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListAuthMethodsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
