// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetPipelineParams creates a new WaypointGetPipelineParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetPipelineParams() *WaypointGetPipelineParams {
	return &WaypointGetPipelineParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetPipelineParamsWithTimeout creates a new WaypointGetPipelineParams object
// with the ability to set a timeout on a request.
func NewWaypointGetPipelineParamsWithTimeout(timeout time.Duration) *WaypointGetPipelineParams {
	return &WaypointGetPipelineParams{
		timeout: timeout,
	}
}

// NewWaypointGetPipelineParamsWithContext creates a new WaypointGetPipelineParams object
// with the ability to set a context for a request.
func NewWaypointGetPipelineParamsWithContext(ctx context.Context) *WaypointGetPipelineParams {
	return &WaypointGetPipelineParams{
		Context: ctx,
	}
}

// NewWaypointGetPipelineParamsWithHTTPClient creates a new WaypointGetPipelineParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetPipelineParamsWithHTTPClient(client *http.Client) *WaypointGetPipelineParams {
	return &WaypointGetPipelineParams{
		HTTPClient: client,
	}
}

/*
WaypointGetPipelineParams contains all the parameters to send to the API endpoint

	for the waypoint get pipeline operation.

	Typically these are written to a http.Request.
*/
type WaypointGetPipelineParams struct {

	/* PipelineID.

	   Reference a single pipeline by ID.
	*/
	PipelineID *string

	/* PipelineOwnerPipelineName.

	   the name of the defined pipeline config
	*/
	PipelineOwnerPipelineName string

	// PipelineOwnerProjectProject.
	PipelineOwnerProjectProject string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get pipeline params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetPipelineParams) WithDefaults() *WaypointGetPipelineParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get pipeline params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetPipelineParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) WithTimeout(timeout time.Duration) *WaypointGetPipelineParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) WithContext(ctx context.Context) *WaypointGetPipelineParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) WithHTTPClient(client *http.Client) *WaypointGetPipelineParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPipelineID adds the pipelineID to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) WithPipelineID(pipelineID *string) *WaypointGetPipelineParams {
	o.SetPipelineID(pipelineID)
	return o
}

// SetPipelineID adds the pipelineId to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) SetPipelineID(pipelineID *string) {
	o.PipelineID = pipelineID
}

// WithPipelineOwnerPipelineName adds the pipelineOwnerPipelineName to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) WithPipelineOwnerPipelineName(pipelineOwnerPipelineName string) *WaypointGetPipelineParams {
	o.SetPipelineOwnerPipelineName(pipelineOwnerPipelineName)
	return o
}

// SetPipelineOwnerPipelineName adds the pipelineOwnerPipelineName to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) SetPipelineOwnerPipelineName(pipelineOwnerPipelineName string) {
	o.PipelineOwnerPipelineName = pipelineOwnerPipelineName
}

// WithPipelineOwnerProjectProject adds the pipelineOwnerProjectProject to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) WithPipelineOwnerProjectProject(pipelineOwnerProjectProject string) *WaypointGetPipelineParams {
	o.SetPipelineOwnerProjectProject(pipelineOwnerProjectProject)
	return o
}

// SetPipelineOwnerProjectProject adds the pipelineOwnerProjectProject to the waypoint get pipeline params
func (o *WaypointGetPipelineParams) SetPipelineOwnerProjectProject(pipelineOwnerProjectProject string) {
	o.PipelineOwnerProjectProject = pipelineOwnerProjectProject
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetPipelineParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.PipelineID != nil {

		// query param pipeline.id
		var qrPipelineID string

		if o.PipelineID != nil {
			qrPipelineID = *o.PipelineID
		}
		qPipelineID := qrPipelineID
		if qPipelineID != "" {

			if err := r.SetQueryParam("pipeline.id", qPipelineID); err != nil {
				return err
			}
		}
	}

	// path param pipeline.owner.pipeline_name
	if err := r.SetPathParam("pipeline.owner.pipeline_name", o.PipelineOwnerPipelineName); err != nil {
		return err
	}

	// path param pipeline.owner.project.project
	if err := r.SetPathParam("pipeline.owner.project.project", o.PipelineOwnerProjectProject); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
