// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetLatestPipelineRunReader is a Reader for the WaypointGetLatestPipelineRun structure.
type WaypointGetLatestPipelineRunReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetLatestPipelineRunReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetLatestPipelineRunOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetLatestPipelineRunDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetLatestPipelineRunOK creates a WaypointGetLatestPipelineRunOK with default headers values
func NewWaypointGetLatestPipelineRunOK() *WaypointGetLatestPipelineRunOK {
	return &WaypointGetLatestPipelineRunOK{}
}

/*
WaypointGetLatestPipelineRunOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetLatestPipelineRunOK struct {
	Payload *models.HashicorpWaypointGetPipelineRunResponse
}

// IsSuccess returns true when this waypoint get latest pipeline run o k response has a 2xx status code
func (o *WaypointGetLatestPipelineRunOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get latest pipeline run o k response has a 3xx status code
func (o *WaypointGetLatestPipelineRunOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get latest pipeline run o k response has a 4xx status code
func (o *WaypointGetLatestPipelineRunOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get latest pipeline run o k response has a 5xx status code
func (o *WaypointGetLatestPipelineRunOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get latest pipeline run o k response a status code equal to that given
func (o *WaypointGetLatestPipelineRunOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetLatestPipelineRunOK) Error() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/latest-run][%d] waypointGetLatestPipelineRunOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLatestPipelineRunOK) String() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/latest-run][%d] waypointGetLatestPipelineRunOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLatestPipelineRunOK) GetPayload() *models.HashicorpWaypointGetPipelineRunResponse {
	return o.Payload
}

func (o *WaypointGetLatestPipelineRunOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetPipelineRunResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetLatestPipelineRunDefault creates a WaypointGetLatestPipelineRunDefault with default headers values
func NewWaypointGetLatestPipelineRunDefault(code int) *WaypointGetLatestPipelineRunDefault {
	return &WaypointGetLatestPipelineRunDefault{
		_statusCode: code,
	}
}

/*
WaypointGetLatestPipelineRunDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetLatestPipelineRunDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get latest pipeline run default response
func (o *WaypointGetLatestPipelineRunDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get latest pipeline run default response has a 2xx status code
func (o *WaypointGetLatestPipelineRunDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get latest pipeline run default response has a 3xx status code
func (o *WaypointGetLatestPipelineRunDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get latest pipeline run default response has a 4xx status code
func (o *WaypointGetLatestPipelineRunDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get latest pipeline run default response has a 5xx status code
func (o *WaypointGetLatestPipelineRunDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get latest pipeline run default response a status code equal to that given
func (o *WaypointGetLatestPipelineRunDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetLatestPipelineRunDefault) Error() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/latest-run][%d] Waypoint_GetLatestPipelineRun default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLatestPipelineRunDefault) String() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/latest-run][%d] Waypoint_GetLatestPipelineRun default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLatestPipelineRunDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetLatestPipelineRunDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
