// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetDeploymentReader is a Reader for the WaypointGetDeployment structure.
type WaypointGetDeploymentReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetDeploymentReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetDeploymentOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetDeploymentDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetDeploymentOK creates a WaypointGetDeploymentOK with default headers values
func NewWaypointGetDeploymentOK() *WaypointGetDeploymentOK {
	return &WaypointGetDeploymentOK{}
}

/*
WaypointGetDeploymentOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetDeploymentOK struct {
	Payload *models.HashicorpWaypointDeployment
}

// IsSuccess returns true when this waypoint get deployment o k response has a 2xx status code
func (o *WaypointGetDeploymentOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get deployment o k response has a 3xx status code
func (o *WaypointGetDeploymentOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get deployment o k response has a 4xx status code
func (o *WaypointGetDeploymentOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get deployment o k response has a 5xx status code
func (o *WaypointGetDeploymentOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get deployment o k response a status code equal to that given
func (o *WaypointGetDeploymentOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetDeploymentOK) Error() string {
	return fmt.Sprintf("[GET /deployment/{ref.id}][%d] waypointGetDeploymentOK  %+v", 200, o.Payload)
}

func (o *WaypointGetDeploymentOK) String() string {
	return fmt.Sprintf("[GET /deployment/{ref.id}][%d] waypointGetDeploymentOK  %+v", 200, o.Payload)
}

func (o *WaypointGetDeploymentOK) GetPayload() *models.HashicorpWaypointDeployment {
	return o.Payload
}

func (o *WaypointGetDeploymentOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointDeployment)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetDeploymentDefault creates a WaypointGetDeploymentDefault with default headers values
func NewWaypointGetDeploymentDefault(code int) *WaypointGetDeploymentDefault {
	return &WaypointGetDeploymentDefault{
		_statusCode: code,
	}
}

/*
WaypointGetDeploymentDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetDeploymentDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get deployment default response
func (o *WaypointGetDeploymentDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get deployment default response has a 2xx status code
func (o *WaypointGetDeploymentDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get deployment default response has a 3xx status code
func (o *WaypointGetDeploymentDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get deployment default response has a 4xx status code
func (o *WaypointGetDeploymentDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get deployment default response has a 5xx status code
func (o *WaypointGetDeploymentDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get deployment default response a status code equal to that given
func (o *WaypointGetDeploymentDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetDeploymentDefault) Error() string {
	return fmt.Sprintf("[GET /deployment/{ref.id}][%d] Waypoint_GetDeployment default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetDeploymentDefault) String() string {
	return fmt.Sprintf("[GET /deployment/{ref.id}][%d] Waypoint_GetDeployment default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetDeploymentDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetDeploymentDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
