// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetBuildReader is a Reader for the WaypointGetBuild structure.
type WaypointGetBuildReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetBuildReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetBuildOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetBuildDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetBuildOK creates a WaypointGetBuildOK with default headers values
func NewWaypointGetBuildOK() *WaypointGetBuildOK {
	return &WaypointGetBuildOK{}
}

/*
WaypointGetBuildOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetBuildOK struct {
	Payload *models.HashicorpWaypointBuild
}

// IsSuccess returns true when this waypoint get build o k response has a 2xx status code
func (o *WaypointGetBuildOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get build o k response has a 3xx status code
func (o *WaypointGetBuildOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get build o k response has a 4xx status code
func (o *WaypointGetBuildOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get build o k response has a 5xx status code
func (o *WaypointGetBuildOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get build o k response a status code equal to that given
func (o *WaypointGetBuildOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetBuildOK) Error() string {
	return fmt.Sprintf("[GET /build/{ref.id}][%d] waypointGetBuildOK  %+v", 200, o.Payload)
}

func (o *WaypointGetBuildOK) String() string {
	return fmt.Sprintf("[GET /build/{ref.id}][%d] waypointGetBuildOK  %+v", 200, o.Payload)
}

func (o *WaypointGetBuildOK) GetPayload() *models.HashicorpWaypointBuild {
	return o.Payload
}

func (o *WaypointGetBuildOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointBuild)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetBuildDefault creates a WaypointGetBuildDefault with default headers values
func NewWaypointGetBuildDefault(code int) *WaypointGetBuildDefault {
	return &WaypointGetBuildDefault{
		_statusCode: code,
	}
}

/*
WaypointGetBuildDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetBuildDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get build default response
func (o *WaypointGetBuildDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get build default response has a 2xx status code
func (o *WaypointGetBuildDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get build default response has a 3xx status code
func (o *WaypointGetBuildDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get build default response has a 4xx status code
func (o *WaypointGetBuildDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get build default response has a 5xx status code
func (o *WaypointGetBuildDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get build default response a status code equal to that given
func (o *WaypointGetBuildDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetBuildDefault) Error() string {
	return fmt.Sprintf("[GET /build/{ref.id}][%d] Waypoint_GetBuild default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetBuildDefault) String() string {
	return fmt.Sprintf("[GET /build/{ref.id}][%d] Waypoint_GetBuild default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetBuildDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetBuildDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
