// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointDeleteUserReader is a Reader for the WaypointDeleteUser structure.
type WaypointDeleteUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointDeleteUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointDeleteUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointDeleteUserDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointDeleteUserOK creates a WaypointDeleteUserOK with default headers values
func NewWaypointDeleteUserOK() *WaypointDeleteUserOK {
	return &WaypointDeleteUserOK{}
}

/*
WaypointDeleteUserOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointDeleteUserOK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint delete user o k response has a 2xx status code
func (o *WaypointDeleteUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint delete user o k response has a 3xx status code
func (o *WaypointDeleteUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint delete user o k response has a 4xx status code
func (o *WaypointDeleteUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint delete user o k response has a 5xx status code
func (o *WaypointDeleteUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint delete user o k response a status code equal to that given
func (o *WaypointDeleteUserOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointDeleteUserOK) Error() string {
	return fmt.Sprintf("[DELETE /user/by-id/{user.id.id}][%d] waypointDeleteUserOK  %+v", 200, o.Payload)
}

func (o *WaypointDeleteUserOK) String() string {
	return fmt.Sprintf("[DELETE /user/by-id/{user.id.id}][%d] waypointDeleteUserOK  %+v", 200, o.Payload)
}

func (o *WaypointDeleteUserOK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointDeleteUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointDeleteUserDefault creates a WaypointDeleteUserDefault with default headers values
func NewWaypointDeleteUserDefault(code int) *WaypointDeleteUserDefault {
	return &WaypointDeleteUserDefault{
		_statusCode: code,
	}
}

/*
WaypointDeleteUserDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointDeleteUserDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint delete user default response
func (o *WaypointDeleteUserDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint delete user default response has a 2xx status code
func (o *WaypointDeleteUserDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint delete user default response has a 3xx status code
func (o *WaypointDeleteUserDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint delete user default response has a 4xx status code
func (o *WaypointDeleteUserDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint delete user default response has a 5xx status code
func (o *WaypointDeleteUserDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint delete user default response a status code equal to that given
func (o *WaypointDeleteUserDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointDeleteUserDefault) Error() string {
	return fmt.Sprintf("[DELETE /user/by-id/{user.id.id}][%d] Waypoint_DeleteUser default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointDeleteUserDefault) String() string {
	return fmt.Sprintf("[DELETE /user/by-id/{user.id.id}][%d] Waypoint_DeleteUser default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointDeleteUserDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointDeleteUserDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
