// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointConfigSyncPipelineParams creates a new WaypointConfigSyncPipelineParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointConfigSyncPipelineParams() *WaypointConfigSyncPipelineParams {
	return &WaypointConfigSyncPipelineParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointConfigSyncPipelineParamsWithTimeout creates a new WaypointConfigSyncPipelineParams object
// with the ability to set a timeout on a request.
func NewWaypointConfigSyncPipelineParamsWithTimeout(timeout time.Duration) *WaypointConfigSyncPipelineParams {
	return &WaypointConfigSyncPipelineParams{
		timeout: timeout,
	}
}

// NewWaypointConfigSyncPipelineParamsWithContext creates a new WaypointConfigSyncPipelineParams object
// with the ability to set a context for a request.
func NewWaypointConfigSyncPipelineParamsWithContext(ctx context.Context) *WaypointConfigSyncPipelineParams {
	return &WaypointConfigSyncPipelineParams{
		Context: ctx,
	}
}

// NewWaypointConfigSyncPipelineParamsWithHTTPClient creates a new WaypointConfigSyncPipelineParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointConfigSyncPipelineParamsWithHTTPClient(client *http.Client) *WaypointConfigSyncPipelineParams {
	return &WaypointConfigSyncPipelineParams{
		HTTPClient: client,
	}
}

/*
WaypointConfigSyncPipelineParams contains all the parameters to send to the API endpoint

	for the waypoint config sync pipeline operation.

	Typically these are written to a http.Request.
*/
type WaypointConfigSyncPipelineParams struct {

	// Body.
	Body *models.HashicorpWaypointConfigSyncPipelineRequest

	// ProjectProject.
	ProjectProject string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint config sync pipeline params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointConfigSyncPipelineParams) WithDefaults() *WaypointConfigSyncPipelineParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint config sync pipeline params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointConfigSyncPipelineParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) WithTimeout(timeout time.Duration) *WaypointConfigSyncPipelineParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) WithContext(ctx context.Context) *WaypointConfigSyncPipelineParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) WithHTTPClient(client *http.Client) *WaypointConfigSyncPipelineParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) WithBody(body *models.HashicorpWaypointConfigSyncPipelineRequest) *WaypointConfigSyncPipelineParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) SetBody(body *models.HashicorpWaypointConfigSyncPipelineRequest) {
	o.Body = body
}

// WithProjectProject adds the projectProject to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) WithProjectProject(projectProject string) *WaypointConfigSyncPipelineParams {
	o.SetProjectProject(projectProject)
	return o
}

// SetProjectProject adds the projectProject to the waypoint config sync pipeline params
func (o *WaypointConfigSyncPipelineParams) SetProjectProject(projectProject string) {
	o.ProjectProject = projectProject
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointConfigSyncPipelineParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param project.project
	if err := r.SetPathParam("project.project", o.ProjectProject); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
