// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointCompleteOIDCAuthReader is a Reader for the WaypointCompleteOIDCAuth structure.
type WaypointCompleteOIDCAuthReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointCompleteOIDCAuthReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointCompleteOIDCAuthOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointCompleteOIDCAuthDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointCompleteOIDCAuthOK creates a WaypointCompleteOIDCAuthOK with default headers values
func NewWaypointCompleteOIDCAuthOK() *WaypointCompleteOIDCAuthOK {
	return &WaypointCompleteOIDCAuthOK{}
}

/*
WaypointCompleteOIDCAuthOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointCompleteOIDCAuthOK struct {
	Payload *models.HashicorpWaypointCompleteOIDCAuthResponse
}

// IsSuccess returns true when this waypoint complete o Id c auth o k response has a 2xx status code
func (o *WaypointCompleteOIDCAuthOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint complete o Id c auth o k response has a 3xx status code
func (o *WaypointCompleteOIDCAuthOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint complete o Id c auth o k response has a 4xx status code
func (o *WaypointCompleteOIDCAuthOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint complete o Id c auth o k response has a 5xx status code
func (o *WaypointCompleteOIDCAuthOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint complete o Id c auth o k response a status code equal to that given
func (o *WaypointCompleteOIDCAuthOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointCompleteOIDCAuthOK) Error() string {
	return fmt.Sprintf("[POST /oidc/{auth_method.name}/complete][%d] waypointCompleteOIdCAuthOK  %+v", 200, o.Payload)
}

func (o *WaypointCompleteOIDCAuthOK) String() string {
	return fmt.Sprintf("[POST /oidc/{auth_method.name}/complete][%d] waypointCompleteOIdCAuthOK  %+v", 200, o.Payload)
}

func (o *WaypointCompleteOIDCAuthOK) GetPayload() *models.HashicorpWaypointCompleteOIDCAuthResponse {
	return o.Payload
}

func (o *WaypointCompleteOIDCAuthOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointCompleteOIDCAuthResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointCompleteOIDCAuthDefault creates a WaypointCompleteOIDCAuthDefault with default headers values
func NewWaypointCompleteOIDCAuthDefault(code int) *WaypointCompleteOIDCAuthDefault {
	return &WaypointCompleteOIDCAuthDefault{
		_statusCode: code,
	}
}

/*
WaypointCompleteOIDCAuthDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointCompleteOIDCAuthDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint complete o ID c auth default response
func (o *WaypointCompleteOIDCAuthDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint complete o ID c auth default response has a 2xx status code
func (o *WaypointCompleteOIDCAuthDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint complete o ID c auth default response has a 3xx status code
func (o *WaypointCompleteOIDCAuthDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint complete o ID c auth default response has a 4xx status code
func (o *WaypointCompleteOIDCAuthDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint complete o ID c auth default response has a 5xx status code
func (o *WaypointCompleteOIDCAuthDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint complete o ID c auth default response a status code equal to that given
func (o *WaypointCompleteOIDCAuthDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointCompleteOIDCAuthDefault) Error() string {
	return fmt.Sprintf("[POST /oidc/{auth_method.name}/complete][%d] Waypoint_CompleteOIDCAuth default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCompleteOIDCAuthDefault) String() string {
	return fmt.Sprintf("[POST /oidc/{auth_method.name}/complete][%d] Waypoint_CompleteOIDCAuth default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointCompleteOIDCAuthDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointCompleteOIDCAuthDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
