// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointTokenLogin hashicorp waypoint token login
//
// swagger:model hashicorp.waypoint.Token.Login
type HashicorpWaypointTokenLogin struct {

	// If set, this login token can only be used for entrypoint-related
	// APIs against the configured deployment.
	Entrypoint *HashicorpWaypointTokenEntrypoint `json:"entrypoint,omitempty"`

	// User that this token represents. This is the internal user ID (ULID),
	// not the username/email/etc. The special value of "waypoint" means the
	// superuser (default user) that is setup on bootstrap. This is for
	// historical reasons only and is the only valid non-ULID value.
	UserID string `json:"user_id,omitempty"`
}

// Validate validates this hashicorp waypoint token login
func (m *HashicorpWaypointTokenLogin) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEntrypoint(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTokenLogin) validateEntrypoint(formats strfmt.Registry) error {
	if swag.IsZero(m.Entrypoint) { // not required
		return nil
	}

	if m.Entrypoint != nil {
		if err := m.Entrypoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entrypoint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("entrypoint")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint token login based on the context it is used
func (m *HashicorpWaypointTokenLogin) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEntrypoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTokenLogin) contextValidateEntrypoint(ctx context.Context, formats strfmt.Registry) error {

	if m.Entrypoint != nil {
		if err := m.Entrypoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entrypoint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("entrypoint")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointTokenLogin) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointTokenLogin) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointTokenLogin
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
