// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointTokenInvite hashicorp waypoint token invite
//
// swagger:model hashicorp.waypoint.Token.Invite
type HashicorpWaypointTokenInvite struct {

	// The user that initiated the invite
	FromUserID string `json:"from_user_id,omitempty"`

	// The login token we'd like to create. This can be used to setup
	// all the policy attachments and other restrictions. If this is a
	// signup-only invite token, then "user_id" in this login field will
	// be ignored and set to the newly created user ID.
	Login *HashicorpWaypointTokenLogin `json:"login,omitempty"`

	// Signup, if non-nil, makes this invite a signup-only invite token. This
	// means that this token can only be used to create a new account, not
	// to exchange for a token for an existing account.
	Signup *HashicorpWaypointTokenInviteSignup `json:"signup,omitempty"`
}

// Validate validates this hashicorp waypoint token invite
func (m *HashicorpWaypointTokenInvite) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLogin(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSignup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTokenInvite) validateLogin(formats strfmt.Registry) error {
	if swag.IsZero(m.Login) { // not required
		return nil
	}

	if m.Login != nil {
		if err := m.Login.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("login")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("login")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTokenInvite) validateSignup(formats strfmt.Registry) error {
	if swag.IsZero(m.Signup) { // not required
		return nil
	}

	if m.Signup != nil {
		if err := m.Signup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("signup")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("signup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint token invite based on the context it is used
func (m *HashicorpWaypointTokenInvite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSignup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTokenInvite) contextValidateLogin(ctx context.Context, formats strfmt.Registry) error {

	if m.Login != nil {
		if err := m.Login.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("login")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("login")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTokenInvite) contextValidateSignup(ctx context.Context, formats strfmt.Registry) error {

	if m.Signup != nil {
		if err := m.Signup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("signup")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("signup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointTokenInvite) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointTokenInvite) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointTokenInvite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
