// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointPipelineStep A single step within the pipeline.
//
// swagger:model hashicorp.waypoint.Pipeline.Step
type HashicorpWaypointPipelineStep struct {

	// Built-in build operation
	Build *HashicorpWaypointPipelineStepBuild `json:"build,omitempty"`

	// The steps that must come before this step. If this is empty,
	// this is considered a "root" step. Only one step may be root.
	// See "steps" on the Pipeline message for details.
	DependsOn []string `json:"depends_on"`

	// Built-in deploy operation
	Deploy *HashicorpWaypointPipelineStepDeploy `json:"deploy,omitempty"`

	// Docker execute.
	Exec *HashicorpWaypointPipelineStepExec `json:"exec,omitempty"`

	// Docker image to execute. This should be a fully qualified image URL.
	Image string `json:"image,omitempty"`

	// Name of the step. This is unique within a pipeline. In the "steps"
	// map, this must match the map key.
	Name string `json:"name,omitempty"`

	// A reference to a different pipeline
	Pipeline *HashicorpWaypointPipelineStepPipeline `json:"pipeline,omitempty"`

	// Built-in release operation
	Release *HashicorpWaypointPipelineStepRelease `json:"release,omitempty"`

	// Built-in up operation
	Up *HashicorpWaypointPipelineStepUp `json:"up,omitempty"`

	// Workspace to use in step execution. If undefined, will default to the
	// Workspace used when running the pipeline, otherwise 'default'
	Workspace *HashicorpWaypointRefWorkspace `json:"workspace,omitempty"`
}

// Validate validates this hashicorp waypoint pipeline step
func (m *HashicorpWaypointPipelineStep) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBuild(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeploy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExec(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePipeline(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelease(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointPipelineStep) validateBuild(formats strfmt.Registry) error {
	if swag.IsZero(m.Build) { // not required
		return nil
	}

	if m.Build != nil {
		if err := m.Build.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) validateDeploy(formats strfmt.Registry) error {
	if swag.IsZero(m.Deploy) { // not required
		return nil
	}

	if m.Deploy != nil {
		if err := m.Deploy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deploy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deploy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) validateExec(formats strfmt.Registry) error {
	if swag.IsZero(m.Exec) { // not required
		return nil
	}

	if m.Exec != nil {
		if err := m.Exec.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("exec")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("exec")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) validatePipeline(formats strfmt.Registry) error {
	if swag.IsZero(m.Pipeline) { // not required
		return nil
	}

	if m.Pipeline != nil {
		if err := m.Pipeline.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) validateRelease(formats strfmt.Registry) error {
	if swag.IsZero(m.Release) { // not required
		return nil
	}

	if m.Release != nil {
		if err := m.Release.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) validateUp(formats strfmt.Registry) error {
	if swag.IsZero(m.Up) { // not required
		return nil
	}

	if m.Up != nil {
		if err := m.Up.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("up")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("up")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint pipeline step based on the context it is used
func (m *HashicorpWaypointPipelineStep) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBuild(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeploy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExec(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePipeline(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidateBuild(ctx context.Context, formats strfmt.Registry) error {

	if m.Build != nil {
		if err := m.Build.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidateDeploy(ctx context.Context, formats strfmt.Registry) error {

	if m.Deploy != nil {
		if err := m.Deploy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deploy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deploy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidateExec(ctx context.Context, formats strfmt.Registry) error {

	if m.Exec != nil {
		if err := m.Exec.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("exec")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("exec")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidatePipeline(ctx context.Context, formats strfmt.Registry) error {

	if m.Pipeline != nil {
		if err := m.Pipeline.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidateRelease(ctx context.Context, formats strfmt.Registry) error {

	if m.Release != nil {
		if err := m.Release.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidateUp(ctx context.Context, formats strfmt.Registry) error {

	if m.Up != nil {
		if err := m.Up.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("up")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("up")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipelineStep) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointPipelineStep) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointPipelineStep) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointPipelineStep
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
