// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListTaskParams creates a new WaypointListTaskParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListTaskParams() *WaypointListTaskParams {
	return &WaypointListTaskParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListTaskParamsWithTimeout creates a new WaypointListTaskParams object
// with the ability to set a timeout on a request.
func NewWaypointListTaskParamsWithTimeout(timeout time.Duration) *WaypointListTaskParams {
	return &WaypointListTaskParams{
		timeout: timeout,
	}
}

// NewWaypointListTaskParamsWithContext creates a new WaypointListTaskParams object
// with the ability to set a context for a request.
func NewWaypointListTaskParamsWithContext(ctx context.Context) *WaypointListTaskParams {
	return &WaypointListTaskParams{
		Context: ctx,
	}
}

// NewWaypointListTaskParamsWithHTTPClient creates a new WaypointListTaskParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListTaskParamsWithHTTPClient(client *http.Client) *WaypointListTaskParams {
	return &WaypointListTaskParams{
		HTTPClient: client,
	}
}

/*
WaypointListTaskParams contains all the parameters to send to the API endpoint

	for the waypoint list task operation.

	Typically these are written to a http.Request.
*/
type WaypointListTaskParams struct {

	// TaskState.
	TaskState []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListTaskParams) WithDefaults() *WaypointListTaskParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListTaskParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint list task params
func (o *WaypointListTaskParams) WithTimeout(timeout time.Duration) *WaypointListTaskParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list task params
func (o *WaypointListTaskParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list task params
func (o *WaypointListTaskParams) WithContext(ctx context.Context) *WaypointListTaskParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list task params
func (o *WaypointListTaskParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list task params
func (o *WaypointListTaskParams) WithHTTPClient(client *http.Client) *WaypointListTaskParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list task params
func (o *WaypointListTaskParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithTaskState adds the taskState to the waypoint list task params
func (o *WaypointListTaskParams) WithTaskState(taskState []string) *WaypointListTaskParams {
	o.SetTaskState(taskState)
	return o
}

// SetTaskState adds the taskState to the waypoint list task params
func (o *WaypointListTaskParams) SetTaskState(taskState []string) {
	o.TaskState = taskState
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListTaskParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.TaskState != nil {

		// binding items for taskState
		joinedTaskState := o.bindParamTaskState(reg)

		// query array param taskState
		if err := r.SetQueryParam("taskState", joinedTaskState...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWaypointListTask binds the parameter taskState
func (o *WaypointListTaskParams) bindParamTaskState(formats strfmt.Registry) []string {
	taskStateIR := o.TaskState

	var taskStateIC []string
	for _, taskStateIIR := range taskStateIR { // explode []string

		taskStateIIV := taskStateIIR // string as string
		taskStateIC = append(taskStateIC, taskStateIIV)
	}

	// items.CollectionFormat: "multi"
	taskStateIS := swag.JoinByFormat(taskStateIC, "multi")

	return taskStateIS
}
