// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListPushedArtifacts2Params creates a new WaypointListPushedArtifacts2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListPushedArtifacts2Params() *WaypointListPushedArtifacts2Params {
	return &WaypointListPushedArtifacts2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListPushedArtifacts2ParamsWithTimeout creates a new WaypointListPushedArtifacts2Params object
// with the ability to set a timeout on a request.
func NewWaypointListPushedArtifacts2ParamsWithTimeout(timeout time.Duration) *WaypointListPushedArtifacts2Params {
	return &WaypointListPushedArtifacts2Params{
		timeout: timeout,
	}
}

// NewWaypointListPushedArtifacts2ParamsWithContext creates a new WaypointListPushedArtifacts2Params object
// with the ability to set a context for a request.
func NewWaypointListPushedArtifacts2ParamsWithContext(ctx context.Context) *WaypointListPushedArtifacts2Params {
	return &WaypointListPushedArtifacts2Params{
		Context: ctx,
	}
}

// NewWaypointListPushedArtifacts2ParamsWithHTTPClient creates a new WaypointListPushedArtifacts2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListPushedArtifacts2ParamsWithHTTPClient(client *http.Client) *WaypointListPushedArtifacts2Params {
	return &WaypointListPushedArtifacts2Params{
		HTTPClient: client,
	}
}

/*
WaypointListPushedArtifacts2Params contains all the parameters to send to the API endpoint

	for the waypoint list pushed artifacts2 operation.

	Typically these are written to a http.Request.
*/
type WaypointListPushedArtifacts2Params struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	/* IncludeBuild.

	     Indicate if the Build value should be returned for each
	of the artifacts as well.
	*/
	IncludeBuild *bool

	// OrderDesc.
	OrderDesc *bool

	/* OrderLimit.

	   Limit the number of results.

	   Format: int64
	*/
	OrderLimit *int64

	/* OrderOrder.

	   Order for the results.

	   Default: "UNSET"
	*/
	OrderOrder *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list pushed artifacts2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListPushedArtifacts2Params) WithDefaults() *WaypointListPushedArtifacts2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list pushed artifacts2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListPushedArtifacts2Params) SetDefaults() {
	var (
		orderOrderDefault = string("UNSET")
	)

	val := WaypointListPushedArtifacts2Params{
		OrderOrder: &orderOrderDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithTimeout(timeout time.Duration) *WaypointListPushedArtifacts2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithContext(ctx context.Context) *WaypointListPushedArtifacts2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithHTTPClient(client *http.Client) *WaypointListPushedArtifacts2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithApplicationApplication(applicationApplication string) *WaypointListPushedArtifacts2Params {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithApplicationProject(applicationProject string) *WaypointListPushedArtifacts2Params {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithIncludeBuild adds the includeBuild to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithIncludeBuild(includeBuild *bool) *WaypointListPushedArtifacts2Params {
	o.SetIncludeBuild(includeBuild)
	return o
}

// SetIncludeBuild adds the includeBuild to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetIncludeBuild(includeBuild *bool) {
	o.IncludeBuild = includeBuild
}

// WithOrderDesc adds the orderDesc to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithOrderDesc(orderDesc *bool) *WaypointListPushedArtifacts2Params {
	o.SetOrderDesc(orderDesc)
	return o
}

// SetOrderDesc adds the orderDesc to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetOrderDesc(orderDesc *bool) {
	o.OrderDesc = orderDesc
}

// WithOrderLimit adds the orderLimit to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithOrderLimit(orderLimit *int64) *WaypointListPushedArtifacts2Params {
	o.SetOrderLimit(orderLimit)
	return o
}

// SetOrderLimit adds the orderLimit to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetOrderLimit(orderLimit *int64) {
	o.OrderLimit = orderLimit
}

// WithOrderOrder adds the orderOrder to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithOrderOrder(orderOrder *string) *WaypointListPushedArtifacts2Params {
	o.SetOrderOrder(orderOrder)
	return o
}

// SetOrderOrder adds the orderOrder to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetOrderOrder(orderOrder *string) {
	o.OrderOrder = orderOrder
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) WithWorkspaceWorkspace(workspaceWorkspace string) *WaypointListPushedArtifacts2Params {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list pushed artifacts2 params
func (o *WaypointListPushedArtifacts2Params) SetWorkspaceWorkspace(workspaceWorkspace string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListPushedArtifacts2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.IncludeBuild != nil {

		// query param include_build
		var qrIncludeBuild bool

		if o.IncludeBuild != nil {
			qrIncludeBuild = *o.IncludeBuild
		}
		qIncludeBuild := swag.FormatBool(qrIncludeBuild)
		if qIncludeBuild != "" {

			if err := r.SetQueryParam("include_build", qIncludeBuild); err != nil {
				return err
			}
		}
	}

	if o.OrderDesc != nil {

		// query param order.desc
		var qrOrderDesc bool

		if o.OrderDesc != nil {
			qrOrderDesc = *o.OrderDesc
		}
		qOrderDesc := swag.FormatBool(qrOrderDesc)
		if qOrderDesc != "" {

			if err := r.SetQueryParam("order.desc", qOrderDesc); err != nil {
				return err
			}
		}
	}

	if o.OrderLimit != nil {

		// query param order.limit
		var qrOrderLimit int64

		if o.OrderLimit != nil {
			qrOrderLimit = *o.OrderLimit
		}
		qOrderLimit := swag.FormatInt64(qrOrderLimit)
		if qOrderLimit != "" {

			if err := r.SetQueryParam("order.limit", qOrderLimit); err != nil {
				return err
			}
		}
	}

	if o.OrderOrder != nil {

		// query param order.order
		var qrOrderOrder string

		if o.OrderOrder != nil {
			qrOrderOrder = *o.OrderOrder
		}
		qOrderOrder := qrOrderOrder
		if qOrderOrder != "" {

			if err := r.SetQueryParam("order.order", qOrderOrder); err != nil {
				return err
			}
		}
	}

	// path param workspace.workspace
	if err := r.SetPathParam("workspace.workspace", o.WorkspaceWorkspace); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
