// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListBuildsParams creates a new WaypointListBuildsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListBuildsParams() *WaypointListBuildsParams {
	return &WaypointListBuildsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListBuildsParamsWithTimeout creates a new WaypointListBuildsParams object
// with the ability to set a timeout on a request.
func NewWaypointListBuildsParamsWithTimeout(timeout time.Duration) *WaypointListBuildsParams {
	return &WaypointListBuildsParams{
		timeout: timeout,
	}
}

// NewWaypointListBuildsParamsWithContext creates a new WaypointListBuildsParams object
// with the ability to set a context for a request.
func NewWaypointListBuildsParamsWithContext(ctx context.Context) *WaypointListBuildsParams {
	return &WaypointListBuildsParams{
		Context: ctx,
	}
}

// NewWaypointListBuildsParamsWithHTTPClient creates a new WaypointListBuildsParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListBuildsParamsWithHTTPClient(client *http.Client) *WaypointListBuildsParams {
	return &WaypointListBuildsParams{
		HTTPClient: client,
	}
}

/*
WaypointListBuildsParams contains all the parameters to send to the API endpoint

	for the waypoint list builds operation.

	Typically these are written to a http.Request.
*/
type WaypointListBuildsParams struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	// OrderDesc.
	OrderDesc *bool

	/* OrderLimit.

	   Limit the number of results.

	   Format: int64
	*/
	OrderLimit *int64

	/* OrderOrder.

	   Order for the results.

	   Default: "UNSET"
	*/
	OrderOrder *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list builds params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListBuildsParams) WithDefaults() *WaypointListBuildsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list builds params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListBuildsParams) SetDefaults() {
	var (
		orderOrderDefault = string("UNSET")
	)

	val := WaypointListBuildsParams{
		OrderOrder: &orderOrderDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint list builds params
func (o *WaypointListBuildsParams) WithTimeout(timeout time.Duration) *WaypointListBuildsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list builds params
func (o *WaypointListBuildsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list builds params
func (o *WaypointListBuildsParams) WithContext(ctx context.Context) *WaypointListBuildsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list builds params
func (o *WaypointListBuildsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list builds params
func (o *WaypointListBuildsParams) WithHTTPClient(client *http.Client) *WaypointListBuildsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list builds params
func (o *WaypointListBuildsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list builds params
func (o *WaypointListBuildsParams) WithApplicationApplication(applicationApplication string) *WaypointListBuildsParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list builds params
func (o *WaypointListBuildsParams) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list builds params
func (o *WaypointListBuildsParams) WithApplicationProject(applicationProject string) *WaypointListBuildsParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list builds params
func (o *WaypointListBuildsParams) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithOrderDesc adds the orderDesc to the waypoint list builds params
func (o *WaypointListBuildsParams) WithOrderDesc(orderDesc *bool) *WaypointListBuildsParams {
	o.SetOrderDesc(orderDesc)
	return o
}

// SetOrderDesc adds the orderDesc to the waypoint list builds params
func (o *WaypointListBuildsParams) SetOrderDesc(orderDesc *bool) {
	o.OrderDesc = orderDesc
}

// WithOrderLimit adds the orderLimit to the waypoint list builds params
func (o *WaypointListBuildsParams) WithOrderLimit(orderLimit *int64) *WaypointListBuildsParams {
	o.SetOrderLimit(orderLimit)
	return o
}

// SetOrderLimit adds the orderLimit to the waypoint list builds params
func (o *WaypointListBuildsParams) SetOrderLimit(orderLimit *int64) {
	o.OrderLimit = orderLimit
}

// WithOrderOrder adds the orderOrder to the waypoint list builds params
func (o *WaypointListBuildsParams) WithOrderOrder(orderOrder *string) *WaypointListBuildsParams {
	o.SetOrderOrder(orderOrder)
	return o
}

// SetOrderOrder adds the orderOrder to the waypoint list builds params
func (o *WaypointListBuildsParams) SetOrderOrder(orderOrder *string) {
	o.OrderOrder = orderOrder
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list builds params
func (o *WaypointListBuildsParams) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointListBuildsParams {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list builds params
func (o *WaypointListBuildsParams) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListBuildsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.OrderDesc != nil {

		// query param order.desc
		var qrOrderDesc bool

		if o.OrderDesc != nil {
			qrOrderDesc = *o.OrderDesc
		}
		qOrderDesc := swag.FormatBool(qrOrderDesc)
		if qOrderDesc != "" {

			if err := r.SetQueryParam("order.desc", qOrderDesc); err != nil {
				return err
			}
		}
	}

	if o.OrderLimit != nil {

		// query param order.limit
		var qrOrderLimit int64

		if o.OrderLimit != nil {
			qrOrderLimit = *o.OrderLimit
		}
		qOrderLimit := swag.FormatInt64(qrOrderLimit)
		if qOrderLimit != "" {

			if err := r.SetQueryParam("order.limit", qOrderLimit); err != nil {
				return err
			}
		}
	}

	if o.OrderOrder != nil {

		// query param order.order
		var qrOrderOrder string

		if o.OrderOrder != nil {
			qrOrderOrder = *o.OrderOrder
		}
		qOrderOrder := qrOrderOrder
		if qOrderOrder != "" {

			if err := r.SetQueryParam("order.order", qOrderOrder); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
