// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetProjectReader is a Reader for the WaypointGetProject structure.
type WaypointGetProjectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetProjectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetProjectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetProjectDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetProjectOK creates a WaypointGetProjectOK with default headers values
func NewWaypointGetProjectOK() *WaypointGetProjectOK {
	return &WaypointGetProjectOK{}
}

/*
WaypointGetProjectOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetProjectOK struct {
	Payload *models.HashicorpWaypointGetProjectResponse
}

// IsSuccess returns true when this waypoint get project o k response has a 2xx status code
func (o *WaypointGetProjectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get project o k response has a 3xx status code
func (o *WaypointGetProjectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get project o k response has a 4xx status code
func (o *WaypointGetProjectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get project o k response has a 5xx status code
func (o *WaypointGetProjectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get project o k response a status code equal to that given
func (o *WaypointGetProjectOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetProjectOK) Error() string {
	return fmt.Sprintf("[GET /project/{project.project}][%d] waypointGetProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointGetProjectOK) String() string {
	return fmt.Sprintf("[GET /project/{project.project}][%d] waypointGetProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointGetProjectOK) GetPayload() *models.HashicorpWaypointGetProjectResponse {
	return o.Payload
}

func (o *WaypointGetProjectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetProjectResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetProjectDefault creates a WaypointGetProjectDefault with default headers values
func NewWaypointGetProjectDefault(code int) *WaypointGetProjectDefault {
	return &WaypointGetProjectDefault{
		_statusCode: code,
	}
}

/*
WaypointGetProjectDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetProjectDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get project default response
func (o *WaypointGetProjectDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get project default response has a 2xx status code
func (o *WaypointGetProjectDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get project default response has a 3xx status code
func (o *WaypointGetProjectDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get project default response has a 4xx status code
func (o *WaypointGetProjectDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get project default response has a 5xx status code
func (o *WaypointGetProjectDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get project default response a status code equal to that given
func (o *WaypointGetProjectDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetProjectDefault) Error() string {
	return fmt.Sprintf("[GET /project/{project.project}][%d] Waypoint_GetProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetProjectDefault) String() string {
	return fmt.Sprintf("[GET /project/{project.project}][%d] Waypoint_GetProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetProjectDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetProjectDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
