// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointGetLogStream2Params creates a new WaypointGetLogStream2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetLogStream2Params() *WaypointGetLogStream2Params {
	return &WaypointGetLogStream2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetLogStream2ParamsWithTimeout creates a new WaypointGetLogStream2Params object
// with the ability to set a timeout on a request.
func NewWaypointGetLogStream2ParamsWithTimeout(timeout time.Duration) *WaypointGetLogStream2Params {
	return &WaypointGetLogStream2Params{
		timeout: timeout,
	}
}

// NewWaypointGetLogStream2ParamsWithContext creates a new WaypointGetLogStream2Params object
// with the ability to set a context for a request.
func NewWaypointGetLogStream2ParamsWithContext(ctx context.Context) *WaypointGetLogStream2Params {
	return &WaypointGetLogStream2Params{
		Context: ctx,
	}
}

// NewWaypointGetLogStream2ParamsWithHTTPClient creates a new WaypointGetLogStream2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetLogStream2ParamsWithHTTPClient(client *http.Client) *WaypointGetLogStream2Params {
	return &WaypointGetLogStream2Params{
		HTTPClient: client,
	}
}

/*
WaypointGetLogStream2Params contains all the parameters to send to the API endpoint

	for the waypoint get log stream2 operation.

	Typically these are written to a http.Request.
*/
type WaypointGetLogStream2Params struct {

	// ApplicationApplicationApplication.
	ApplicationApplicationApplication string

	// ApplicationApplicationProject.
	ApplicationApplicationProject string

	// Body.
	Body *models.HashicorpWaypointGetLogStreamRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get log stream2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetLogStream2Params) WithDefaults() *WaypointGetLogStream2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get log stream2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetLogStream2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) WithTimeout(timeout time.Duration) *WaypointGetLogStream2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) WithContext(ctx context.Context) *WaypointGetLogStream2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) WithHTTPClient(client *http.Client) *WaypointGetLogStream2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplicationApplication adds the applicationApplicationApplication to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) WithApplicationApplicationApplication(applicationApplicationApplication string) *WaypointGetLogStream2Params {
	o.SetApplicationApplicationApplication(applicationApplicationApplication)
	return o
}

// SetApplicationApplicationApplication adds the applicationApplicationApplication to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) SetApplicationApplicationApplication(applicationApplicationApplication string) {
	o.ApplicationApplicationApplication = applicationApplicationApplication
}

// WithApplicationApplicationProject adds the applicationApplicationProject to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) WithApplicationApplicationProject(applicationApplicationProject string) *WaypointGetLogStream2Params {
	o.SetApplicationApplicationProject(applicationApplicationProject)
	return o
}

// SetApplicationApplicationProject adds the applicationApplicationProject to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) SetApplicationApplicationProject(applicationApplicationProject string) {
	o.ApplicationApplicationProject = applicationApplicationProject
}

// WithBody adds the body to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) WithBody(body *models.HashicorpWaypointGetLogStreamRequest) *WaypointGetLogStream2Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint get log stream2 params
func (o *WaypointGetLogStream2Params) SetBody(body *models.HashicorpWaypointGetLogStreamRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetLogStream2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application.application
	if err := r.SetPathParam("application.application.application", o.ApplicationApplicationApplication); err != nil {
		return err
	}

	// path param application.application.project
	if err := r.SetPathParam("application.application.project", o.ApplicationApplicationProject); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
