// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointExpediteStatusReportReader is a Reader for the WaypointExpediteStatusReport structure.
type WaypointExpediteStatusReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointExpediteStatusReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointExpediteStatusReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointExpediteStatusReportDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointExpediteStatusReportOK creates a WaypointExpediteStatusReportOK with default headers values
func NewWaypointExpediteStatusReportOK() *WaypointExpediteStatusReportOK {
	return &WaypointExpediteStatusReportOK{}
}

/*
WaypointExpediteStatusReportOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointExpediteStatusReportOK struct {
	Payload *models.HashicorpWaypointExpediteStatusReportResponse
}

// IsSuccess returns true when this waypoint expedite status report o k response has a 2xx status code
func (o *WaypointExpediteStatusReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint expedite status report o k response has a 3xx status code
func (o *WaypointExpediteStatusReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint expedite status report o k response has a 4xx status code
func (o *WaypointExpediteStatusReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint expedite status report o k response has a 5xx status code
func (o *WaypointExpediteStatusReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint expedite status report o k response a status code equal to that given
func (o *WaypointExpediteStatusReportOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointExpediteStatusReportOK) Error() string {
	return fmt.Sprintf("[PUT /deployment/{deployment.id}/status-report][%d] waypointExpediteStatusReportOK  %+v", 200, o.Payload)
}

func (o *WaypointExpediteStatusReportOK) String() string {
	return fmt.Sprintf("[PUT /deployment/{deployment.id}/status-report][%d] waypointExpediteStatusReportOK  %+v", 200, o.Payload)
}

func (o *WaypointExpediteStatusReportOK) GetPayload() *models.HashicorpWaypointExpediteStatusReportResponse {
	return o.Payload
}

func (o *WaypointExpediteStatusReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointExpediteStatusReportResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointExpediteStatusReportDefault creates a WaypointExpediteStatusReportDefault with default headers values
func NewWaypointExpediteStatusReportDefault(code int) *WaypointExpediteStatusReportDefault {
	return &WaypointExpediteStatusReportDefault{
		_statusCode: code,
	}
}

/*
WaypointExpediteStatusReportDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointExpediteStatusReportDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint expedite status report default response
func (o *WaypointExpediteStatusReportDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint expedite status report default response has a 2xx status code
func (o *WaypointExpediteStatusReportDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint expedite status report default response has a 3xx status code
func (o *WaypointExpediteStatusReportDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint expedite status report default response has a 4xx status code
func (o *WaypointExpediteStatusReportDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint expedite status report default response has a 5xx status code
func (o *WaypointExpediteStatusReportDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint expedite status report default response a status code equal to that given
func (o *WaypointExpediteStatusReportDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointExpediteStatusReportDefault) Error() string {
	return fmt.Sprintf("[PUT /deployment/{deployment.id}/status-report][%d] Waypoint_ExpediteStatusReport default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointExpediteStatusReportDefault) String() string {
	return fmt.Sprintf("[PUT /deployment/{deployment.id}/status-report][%d] Waypoint_ExpediteStatusReport default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointExpediteStatusReportDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointExpediteStatusReportDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
