// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.17.3
// source: pkg/server/proto/server.proto

package gen

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// WaypointClient is the client API for Waypoint service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WaypointClient interface {
	// GetVersionInfo returns information about the server. This RPC call does
	// NOT require authentication. It can be used by clients to determine if they
	// are capable of talking to this server.
	GetVersionInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetVersionInfoResponse, error)
	// List the available OIDC providers for authentication. The "name" of the
	// OIDC provider can be used with GetOIDCAuthURL and CompleteOIDCAuth to
	// perform OIDC-based authentication.
	ListOIDCAuthMethods(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListOIDCAuthMethodsResponse, error)
	// Get the URL to visit to start authentication with OIDC.
	GetOIDCAuthURL(ctx context.Context, in *GetOIDCAuthURLRequest, opts ...grpc.CallOption) (*GetOIDCAuthURLResponse, error)
	// Complete the OIDC auth cycle after receiving the callback from the
	// OIDC provider.
	CompleteOIDCAuth(ctx context.Context, in *CompleteOIDCAuthRequest, opts ...grpc.CallOption) (*CompleteOIDCAuthResponse, error)
	// Attempts to run a trigger given a trigger ID reference. If the trigger does
	// not exist, we return not found. If the trigger exists but requires authentication
	// we return an error.
	NoAuthRunTrigger(ctx context.Context, in *RunTriggerRequest, opts ...grpc.CallOption) (*RunTriggerResponse, error)
	// GetUser returns the current logged in user or some other user.
	GetUser(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*GetUserResponse, error)
	// List all users in the system.
	ListUsers(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListUsersResponse, error)
	// Update the details about an existing user.
	UpdateUser(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*UpdateUserResponse, error)
	// Delete a user. This will invalidate all authentication for this user
	// as well since they no longer exist.
	DeleteUser(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// UpsertAuthMethod upserts the auth method. All users logged in with
	// this auth method will remain logged in even if settings change.
	UpsertAuthMethod(ctx context.Context, in *UpsertAuthMethodRequest, opts ...grpc.CallOption) (*UpsertAuthMethodResponse, error)
	// GetAuthMethod returns the auth method.
	GetAuthMethod(ctx context.Context, in *GetAuthMethodRequest, opts ...grpc.CallOption) (*GetAuthMethodResponse, error)
	// ListAuthMethods returns a list of all the auth methods.
	ListAuthMethods(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListAuthMethodsResponse, error)
	// Delete an auth method. This will invalidate all users authenticated
	// using this auth method and they will have to reauthenticate some other
	// way.
	DeleteAuthMethod(ctx context.Context, in *DeleteAuthMethodRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// ListWorkspaces returns a list of all workspaces.
	//
	// Note that currently this list is never pruned, even if a workspace is
	// no longer in use. We plan to prune this in a future improvement.
	ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error)
	// GetWorkspace returns the workspace.
	GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*GetWorkspaceResponse, error)
	// UpsertWorkspace upserts the workspace. Changes to a Workspace's Projects
	// are ignored at this time.
	UpsertWorkspace(ctx context.Context, in *UpsertWorkspaceRequest, opts ...grpc.CallOption) (*UpsertWorkspaceResponse, error)
	// UpsertProject upserts the project.
	UpsertProject(ctx context.Context, in *UpsertProjectRequest, opts ...grpc.CallOption) (*UpsertProjectResponse, error)
	// GetProject returns the project.
	GetProject(ctx context.Context, in *GetProjectRequest, opts ...grpc.CallOption) (*GetProjectResponse, error)
	// ListProjects returns a list of all the projects. There is no equivalent
	// ListApplications because applications are a part of projects and you
	// can use GetProject to get more information about the project.
	ListProjects(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListProjectsResponse, error)
	// DestroyProject deletes a project from the database as well as (optionally)
	// destroys all resources created within a project
	DestroyProject(ctx context.Context, in *DestroyProjectRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// GetApplication returns one application on the project.
	GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*GetApplicationResponse, error)
	// UpsertApplication upserts an application with a project.
	UpsertApplication(ctx context.Context, in *UpsertApplicationRequest, opts ...grpc.CallOption) (*UpsertApplicationResponse, error)
	// ListBuilds returns the builds.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// GetBuild returns a build
	GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// GetLatestBuild returns the most recent successfully completed build
	// for an app.
	GetLatestBuild(ctx context.Context, in *GetLatestBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// ListPushedArtifacts returns the builds.
	ListPushedArtifacts(ctx context.Context, in *ListPushedArtifactsRequest, opts ...grpc.CallOption) (*ListPushedArtifactsResponse, error)
	// GetPushedArtifact returns a deployment
	GetPushedArtifact(ctx context.Context, in *GetPushedArtifactRequest, opts ...grpc.CallOption) (*PushedArtifact, error)
	// GetLatestPushedArtifact returns the most recent successfully completed
	// artifact push for an app.
	GetLatestPushedArtifact(ctx context.Context, in *GetLatestPushedArtifactRequest, opts ...grpc.CallOption) (*PushedArtifact, error)
	// ListDeployments returns the deployments.
	ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// GetDeployment returns a deployment
	GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// ListInstances returns the running instances of deployments.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// ListReleases returns the releases.
	ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error)
	// GetRelease returns a release
	GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error)
	// GetLatestRelease returns the most recent successfully completed
	// release for an app.
	GetLatestRelease(ctx context.Context, in *GetLatestReleaseRequest, opts ...grpc.CallOption) (*Release, error)
	// GetStatusReport returns a StatusReport
	GetStatusReport(ctx context.Context, in *GetStatusReportRequest, opts ...grpc.CallOption) (*StatusReport, error)
	// GetLatestStatusReport returns the most recent successfully completed
	// health report for an app
	GetLatestStatusReport(ctx context.Context, in *GetLatestStatusReportRequest, opts ...grpc.CallOption) (*StatusReport, error)
	// ListStatusReports returns the deployments.
	ListStatusReports(ctx context.Context, in *ListStatusReportsRequest, opts ...grpc.CallOption) (*ListStatusReportsResponse, error)
	// ExpediteStatusReport returns the queued status report job id
	ExpediteStatusReport(ctx context.Context, in *ExpediteStatusReportRequest, opts ...grpc.CallOption) (*ExpediteStatusReportResponse, error)
	// GetLogStream reads the log stream for a deployment. This will immediately
	// send a single LogEntry with the lines we have so far. If there are no
	// available lines this will NOT block and instead will return an error.
	// The client can choose to retry or not.
	GetLogStream(ctx context.Context, in *GetLogStreamRequest, opts ...grpc.CallOption) (Waypoint_GetLogStreamClient, error)
	// StartExecStream starts an exec session.
	StartExecStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_StartExecStreamClient, error)
	// Set one or more configuration variables for applications or runners.
	SetConfig(ctx context.Context, in *ConfigSetRequest, opts ...grpc.CallOption) (*ConfigSetResponse, error)
	// Retrieve merged configuration values for a specific scope. You can determine
	// where a configuration variable was set by looking at the scope field on
	// each variable.
	GetConfig(ctx context.Context, in *ConfigGetRequest, opts ...grpc.CallOption) (*ConfigGetResponse, error)
	// Set the configuration for a dynamic configuration source. If you're looking
	// to set application configuration, you probably want SetConfig instead.
	SetConfigSource(ctx context.Context, in *SetConfigSourceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get the matching configuration source for the request. This will return
	// the most specific matching config source given the scope in the request.
	// For example, if you search for an app-specific config source and only
	// a global config exists, the global config will be returned.
	GetConfigSource(ctx context.Context, in *GetConfigSourceRequest, opts ...grpc.CallOption) (*GetConfigSourceResponse, error)
	// Create a hostname with the URL service.
	CreateHostname(ctx context.Context, in *CreateHostnameRequest, opts ...grpc.CallOption) (*CreateHostnameResponse, error)
	// Delete a hostname with the URL service.
	DeleteHostname(ctx context.Context, in *DeleteHostnameRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all our registered hostnames.
	ListHostnames(ctx context.Context, in *ListHostnamesRequest, opts ...grpc.CallOption) (*ListHostnamesResponse, error)
	// QueueJob queues a job for execution by a runner. This will return as
	// soon as the job is queued, it will not wait for execution.
	QueueJob(ctx context.Context, in *QueueJobRequest, opts ...grpc.CallOption) (*QueueJobResponse, error)
	// CancelJob cancels a job. If the job is still queued this is a quick
	// and easy operation. If the job is already completed, then this does
	// nothing. If the job is assigned or running, then this will signal
	// the runner about the cancellation but it may take time.
	//
	// This RPC always returns immediately. You must use GetJob or GetJobStream
	// to wait on the status of the cancellation.
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// GetJob queries a job by ID.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// ListJobs will return a list of jobs known to Waypoint server. Can be filtered
	// by request on values like workspace, project, application, job state, etc.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// ValidateJob checks if a job appears valid. This will check the job
	// structure itself (i.e. missing fields) and can also check to ensure
	// the job is assignable to a runner.
	ValidateJob(ctx context.Context, in *ValidateJobRequest, opts ...grpc.CallOption) (*ValidateJobResponse, error)
	// GetJobStream opens a job event stream for a running job. This can be
	// used to listen for terminal output and other events of a running job.
	// Multiple listeners can open a job stream.
	GetJobStream(ctx context.Context, in *GetJobStreamRequest, opts ...grpc.CallOption) (Waypoint_GetJobStreamClient, error)
	// GetRunner gets information about a single runner.
	GetRunner(ctx context.Context, in *GetRunnerRequest, opts ...grpc.CallOption) (*Runner, error)
	// ListRunners lists runners that are currently registered with the waypoint server.
	// This list does not include previous on-demand runners that have exited.
	ListRunners(ctx context.Context, in *ListRunnersRequest, opts ...grpc.CallOption) (*ListRunnersResponse, error)
	// AdoptRunners allows marking a runner as adopted or rejected.
	AdoptRunner(ctx context.Context, in *AdoptRunnerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// ForgetRunner deletes an existing runner entry and makes the server
	// behave as if the runner no longer exists. If the runner is currently
	// running, it will receive errors on subsequent jobs, and will have to
	// re-register. A forgotten runner will not be assigned new jobs until
	// re-registered.
	ForgetRunner(ctx context.Context, in *ForgetRunnerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// GetServerConfig sets configuration for the Waypoint server.
	GetServerConfig(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetServerConfigResponse, error)
	// SetServerConfig sets configuration for the Waypoint server.
	SetServerConfig(ctx context.Context, in *SetServerConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// CreateSnapshot creates a new database snapshot.
	CreateSnapshot(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (Waypoint_CreateSnapshotClient, error)
	// RestoreSnapshot performs a database restore with the given snapshot.
	// This API doesn't do a full online restore, it only stages the restore
	// for the next server start to finalize the restore. See the arguments for
	// more information.
	RestoreSnapshot(ctx context.Context, opts ...grpc.CallOption) (Waypoint_RestoreSnapshotClient, error)
	// BootstrapToken returns the initial token for the server. This can only
	// be requested once on first startup. After initial request this will
	// always return a PermissionDenied error.
	BootstrapToken(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*NewTokenResponse, error)
	// DecodeToken takes a token string and returns the structured information
	// about the given token. This is useful for frontends (CLI, UI, etc.) to
	// learn more about a token before using it. For example, if a UI wants to
	// create a signup flow around signup tokens, they can validate the token
	// ahead of time.
	//
	// This endpoint does NOT require authentication.
	DecodeToken(ctx context.Context, in *DecodeTokenRequest, opts ...grpc.CallOption) (*DecodeTokenResponse, error)
	// Generate a new invite token that users can exchange for a login token.
	// This can be used to also invite new users to the Waypoint server.
	GenerateInviteToken(ctx context.Context, in *InviteTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error)
	// Generate a new login token that users can use to login directly.
	// This can only be called for existing users.
	GenerateLoginToken(ctx context.Context, in *LoginTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error)
	// Generate a new runner token that can be used with runners so they
	// immediately begin work. The recommended appraoch is to instead use
	// the adoption flow but this also works.
	GenerateRunnerToken(ctx context.Context, in *GenerateRunnerTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error)
	// Exchange a invite token for a login token. If the invite token is
	// for a new user, this will create a new user account with the provided
	// username hint.
	ConvertInviteToken(ctx context.Context, in *ConvertInviteTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error)
	// RunnerToken is called to register a runner and request a token for
	// remaining runner API calls. This kicks off the "adoption" process
	// (if necessary).
	//
	// This is unauthenticated (but requires a cookie in the metadata).
	RunnerToken(ctx context.Context, in *RunnerTokenRequest, opts ...grpc.CallOption) (*RunnerTokenResponse, error)
	// RunnerConfig is called to receive the configuration for the runner.
	// The response is a stream so that the configuration can be updated later.
	RunnerConfig(ctx context.Context, opts ...grpc.CallOption) (Waypoint_RunnerConfigClient, error)
	// RunnerJobStream is called by a runner to request a single job for
	// execution and update the status of that job.
	RunnerJobStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_RunnerJobStreamClient, error)
	// RunnerGetDeploymentConfig is called by a runner for a deployment operation
	// to determine the settings to use for a deployment.
	RunnerGetDeploymentConfig(ctx context.Context, in *RunnerGetDeploymentConfigRequest, opts ...grpc.CallOption) (*RunnerGetDeploymentConfigResponse, error)
	// EntrypointConfig is called to get the configuration for the entrypoint
	// and also to get any potential updates.
	//
	// This endpoint also registers the instance with the server. This MUST be
	// called first otherwise other RPCs related to the entrypoint may fail
	// with FailedPrecondition.
	EntrypointConfig(ctx context.Context, in *EntrypointConfigRequest, opts ...grpc.CallOption) (Waypoint_EntrypointConfigClient, error)
	// EntrypointLogStream is called to open the stream that logs are sent to.
	EntrypointLogStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_EntrypointLogStreamClient, error)
	// EntrypointExecStream is called to open the data stream for the exec session.
	EntrypointExecStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_EntrypointExecStreamClient, error)
	// WaypointHclFmt formats a waypoint.hcl file. This must be in HCL format.
	// JSON formatting is not supported.
	WaypointHclFmt(ctx context.Context, in *WaypointHclFmtRequest, opts ...grpc.CallOption) (*WaypointHclFmtResponse, error)
	// UpsertOnDemandRunnerConfig updates or inserts a on-demand runner
	// configuration. This configuration can be used by projects for running
	// operations on just-in-time launched runners.
	UpsertOnDemandRunnerConfig(ctx context.Context, in *UpsertOnDemandRunnerConfigRequest, opts ...grpc.CallOption) (*UpsertOnDemandRunnerConfigResponse, error)
	// GetOnDemandRunnerConfig returns the on-demand runner configuration.
	GetOnDemandRunnerConfig(ctx context.Context, in *GetOnDemandRunnerConfigRequest, opts ...grpc.CallOption) (*GetOnDemandRunnerConfigResponse, error)
	// GetOnDemandRunnerConfig returns the on-demand runner configuration.
	GetDefaultOnDemandRunnerConfig(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetOnDemandRunnerConfigResponse, error)
	// GetOnDemandRunnerConfig returns the on-demand runner configuration.
	DeleteOnDemandRunnerConfig(ctx context.Context, in *DeleteOnDemandRunnerConfigRequest, opts ...grpc.CallOption) (*DeleteOnDemandRunnerConfigResponse, error)
	// ListOnDemandRunnerConfigs returns a list of all the on-demand runners configs.
	ListOnDemandRunnerConfigs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListOnDemandRunnerConfigsResponse, error)
	// UpsertBuild updates or inserts a build. A build is responsible for
	// taking some set of source information and turning it into an initial
	// artifact. This artifact is considered "local" until it is pushed.
	UpsertBuild(ctx context.Context, in *UpsertBuildRequest, opts ...grpc.CallOption) (*UpsertBuildResponse, error)
	// UpsertPushedArtifact updates or inserts a pushed artifact. This is
	// useful for local operations to work on a pushed artifact.
	UpsertPushedArtifact(ctx context.Context, in *UpsertPushedArtifactRequest, opts ...grpc.CallOption) (*UpsertPushedArtifactResponse, error)
	// UpsertDeployment updates or inserts a deployment.
	UpsertDeployment(ctx context.Context, in *UpsertDeploymentRequest, opts ...grpc.CallOption) (*UpsertDeploymentResponse, error)
	// UpsertRelease updates or inserts a release.
	UpsertRelease(ctx context.Context, in *UpsertReleaseRequest, opts ...grpc.CallOption) (*UpsertReleaseResponse, error)
	// UpsertStatusReport updates or inserts a statusreport.
	UpsertStatusReport(ctx context.Context, in *UpsertStatusReportRequest, opts ...grpc.CallOption) (*UpsertStatusReportResponse, error)
	// GetTask returns a requested Task message. Or an error if it does not exist.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*GetTaskResponse, error)
	// ListTask will return a list of all existing Tasks
	ListTask(ctx context.Context, in *ListTaskRequest, opts ...grpc.CallOption) (*ListTaskResponse, error)
	// CancelTask will attempt to gracefully cancel each job in the task job triple
	CancelTask(ctx context.Context, in *CancelTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// UpsertTrigger updates or inserts a trigger URL configuration.
	UpsertTrigger(ctx context.Context, in *UpsertTriggerRequest, opts ...grpc.CallOption) (*UpsertTriggerResponse, error)
	// GetTrigger returns a requested trigger message. Or an error if it does not exist.
	GetTrigger(ctx context.Context, in *GetTriggerRequest, opts ...grpc.CallOption) (*GetTriggerResponse, error)
	// DeleteTrigger takes a trigger id and deletes it, if it exists.
	DeleteTrigger(ctx context.Context, in *DeleteTriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// ListTriggers takes a request filter, and returns any matching existing triggers
	ListTriggers(ctx context.Context, in *ListTriggerRequest, opts ...grpc.CallOption) (*ListTriggerResponse, error)
	// RunTrigger will look up the referenced trigger and attempt to queue a job
	// based on the trigger configuration.
	RunTrigger(ctx context.Context, in *RunTriggerRequest, opts ...grpc.CallOption) (*RunTriggerResponse, error)
	// UpsertPipeline updates or inserts a pipeline. This is an INTERNAL ONLY
	// endpoint that is meant to only be called by runners. Calling this manually
	// can risk the internal state for pipelines. In the future, we'll restrict
	// access to this via ACLs.
	UpsertPipeline(ctx context.Context, in *UpsertPipelineRequest, opts ...grpc.CallOption) (*UpsertPipelineResponse, error)
	// RunPipeline queues a pipeline execution.
	RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*RunPipelineResponse, error)
	// GetPipeline returns a pipeline proto by pipeline ref id
	GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*GetPipelineResponse, error)
	// GetPipelineRun returns a pipeline run proto by pipeline ref id and sequence
	GetPipelineRun(ctx context.Context, in *GetPipelineRunRequest, opts ...grpc.CallOption) (*GetPipelineRunResponse, error)
	// GetLatestPipelineRun returns a pipeline run proto by pipeline ref id and sequence
	GetLatestPipelineRun(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*GetPipelineRunResponse, error)
	// ListPipelines takes a project and evaluates the projects config to get
	// a list of Pipeline protos to return in the response. These pipelines
	// are scoped to a single project from the request. It will return an
	// error if the requested project does not exist, or an empty response
	// if no pipelines are defined for the project.
	ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error)
	// ListPipelineRuns takes a pipeline ref and returns a list of runs of that pipeline.
	// It will return an error if the requested pipeline does not exist, or an empty response
	// if there are no runs for the pipeline.
	ListPipelineRuns(ctx context.Context, in *ListPipelineRunsRequest, opts ...grpc.CallOption) (*ListPipelineRunsResponse, error)
	// ConfigSyncPipeline takes a request for a given project and syncs the current
	// project config to the Waypoint database.
	ConfigSyncPipeline(ctx context.Context, in *ConfigSyncPipelineRequest, opts ...grpc.CallOption) (*ConfigSyncPipelineResponse, error)
	// Get a given project with useful related records.
	UI_GetProject(ctx context.Context, in *UI_GetProjectRequest, opts ...grpc.CallOption) (*UI_GetProjectResponse, error)
	// List deployments for a given application.
	UI_ListDeployments(ctx context.Context, in *UI_ListDeploymentsRequest, opts ...grpc.CallOption) (*UI_ListDeploymentsResponse, error)
	// List releases for a given application.
	UI_ListReleases(ctx context.Context, in *UI_ListReleasesRequest, opts ...grpc.CallOption) (*UI_ListReleasesResponse, error)
}

type waypointClient struct {
	cc grpc.ClientConnInterface
}

func NewWaypointClient(cc grpc.ClientConnInterface) WaypointClient {
	return &waypointClient{cc}
}

func (c *waypointClient) GetVersionInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetVersionInfoResponse, error) {
	out := new(GetVersionInfoResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetVersionInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListOIDCAuthMethods(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListOIDCAuthMethodsResponse, error) {
	out := new(ListOIDCAuthMethodsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListOIDCAuthMethods", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetOIDCAuthURL(ctx context.Context, in *GetOIDCAuthURLRequest, opts ...grpc.CallOption) (*GetOIDCAuthURLResponse, error) {
	out := new(GetOIDCAuthURLResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetOIDCAuthURL", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) CompleteOIDCAuth(ctx context.Context, in *CompleteOIDCAuthRequest, opts ...grpc.CallOption) (*CompleteOIDCAuthResponse, error) {
	out := new(CompleteOIDCAuthResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/CompleteOIDCAuth", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) NoAuthRunTrigger(ctx context.Context, in *RunTriggerRequest, opts ...grpc.CallOption) (*RunTriggerResponse, error) {
	out := new(RunTriggerResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/NoAuthRunTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetUser(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*GetUserResponse, error) {
	out := new(GetUserResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListUsers(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListUsersResponse, error) {
	out := new(ListUsersResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListUsers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpdateUser(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*UpdateUserResponse, error) {
	out := new(UpdateUserResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpdateUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DeleteUser(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DeleteUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertAuthMethod(ctx context.Context, in *UpsertAuthMethodRequest, opts ...grpc.CallOption) (*UpsertAuthMethodResponse, error) {
	out := new(UpsertAuthMethodResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertAuthMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetAuthMethod(ctx context.Context, in *GetAuthMethodRequest, opts ...grpc.CallOption) (*GetAuthMethodResponse, error) {
	out := new(GetAuthMethodResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetAuthMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListAuthMethods(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListAuthMethodsResponse, error) {
	out := new(ListAuthMethodsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListAuthMethods", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DeleteAuthMethod(ctx context.Context, in *DeleteAuthMethodRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DeleteAuthMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error) {
	out := new(ListWorkspacesResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListWorkspaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*GetWorkspaceResponse, error) {
	out := new(GetWorkspaceResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertWorkspace(ctx context.Context, in *UpsertWorkspaceRequest, opts ...grpc.CallOption) (*UpsertWorkspaceResponse, error) {
	out := new(UpsertWorkspaceResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertProject(ctx context.Context, in *UpsertProjectRequest, opts ...grpc.CallOption) (*UpsertProjectResponse, error) {
	out := new(UpsertProjectResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetProject(ctx context.Context, in *GetProjectRequest, opts ...grpc.CallOption) (*GetProjectResponse, error) {
	out := new(GetProjectResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListProjects(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListProjectsResponse, error) {
	out := new(ListProjectsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListProjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DestroyProject(ctx context.Context, in *DestroyProjectRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DestroyProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*GetApplicationResponse, error) {
	out := new(GetApplicationResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertApplication(ctx context.Context, in *UpsertApplicationRequest, opts ...grpc.CallOption) (*UpsertApplicationResponse, error) {
	out := new(UpsertApplicationResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetLatestBuild(ctx context.Context, in *GetLatestBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetLatestBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListPushedArtifacts(ctx context.Context, in *ListPushedArtifactsRequest, opts ...grpc.CallOption) (*ListPushedArtifactsResponse, error) {
	out := new(ListPushedArtifactsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListPushedArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetPushedArtifact(ctx context.Context, in *GetPushedArtifactRequest, opts ...grpc.CallOption) (*PushedArtifact, error) {
	out := new(PushedArtifact)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetPushedArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetLatestPushedArtifact(ctx context.Context, in *GetLatestPushedArtifactRequest, opts ...grpc.CallOption) (*PushedArtifact, error) {
	out := new(PushedArtifact)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetLatestPushedArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error) {
	out := new(ListReleasesResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListReleases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error) {
	out := new(Release)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetLatestRelease(ctx context.Context, in *GetLatestReleaseRequest, opts ...grpc.CallOption) (*Release, error) {
	out := new(Release)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetLatestRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetStatusReport(ctx context.Context, in *GetStatusReportRequest, opts ...grpc.CallOption) (*StatusReport, error) {
	out := new(StatusReport)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetStatusReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetLatestStatusReport(ctx context.Context, in *GetLatestStatusReportRequest, opts ...grpc.CallOption) (*StatusReport, error) {
	out := new(StatusReport)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetLatestStatusReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListStatusReports(ctx context.Context, in *ListStatusReportsRequest, opts ...grpc.CallOption) (*ListStatusReportsResponse, error) {
	out := new(ListStatusReportsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListStatusReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ExpediteStatusReport(ctx context.Context, in *ExpediteStatusReportRequest, opts ...grpc.CallOption) (*ExpediteStatusReportResponse, error) {
	out := new(ExpediteStatusReportResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ExpediteStatusReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetLogStream(ctx context.Context, in *GetLogStreamRequest, opts ...grpc.CallOption) (Waypoint_GetLogStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[0], "/hashicorp.waypoint.Waypoint/GetLogStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointGetLogStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Waypoint_GetLogStreamClient interface {
	Recv() (*LogBatch, error)
	grpc.ClientStream
}

type waypointGetLogStreamClient struct {
	grpc.ClientStream
}

func (x *waypointGetLogStreamClient) Recv() (*LogBatch, error) {
	m := new(LogBatch)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) StartExecStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_StartExecStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[1], "/hashicorp.waypoint.Waypoint/StartExecStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointStartExecStreamClient{stream}
	return x, nil
}

type Waypoint_StartExecStreamClient interface {
	Send(*ExecStreamRequest) error
	Recv() (*ExecStreamResponse, error)
	grpc.ClientStream
}

type waypointStartExecStreamClient struct {
	grpc.ClientStream
}

func (x *waypointStartExecStreamClient) Send(m *ExecStreamRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *waypointStartExecStreamClient) Recv() (*ExecStreamResponse, error) {
	m := new(ExecStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) SetConfig(ctx context.Context, in *ConfigSetRequest, opts ...grpc.CallOption) (*ConfigSetResponse, error) {
	out := new(ConfigSetResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/SetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetConfig(ctx context.Context, in *ConfigGetRequest, opts ...grpc.CallOption) (*ConfigGetResponse, error) {
	out := new(ConfigGetResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) SetConfigSource(ctx context.Context, in *SetConfigSourceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/SetConfigSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetConfigSource(ctx context.Context, in *GetConfigSourceRequest, opts ...grpc.CallOption) (*GetConfigSourceResponse, error) {
	out := new(GetConfigSourceResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetConfigSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) CreateHostname(ctx context.Context, in *CreateHostnameRequest, opts ...grpc.CallOption) (*CreateHostnameResponse, error) {
	out := new(CreateHostnameResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/CreateHostname", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DeleteHostname(ctx context.Context, in *DeleteHostnameRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DeleteHostname", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListHostnames(ctx context.Context, in *ListHostnamesRequest, opts ...grpc.CallOption) (*ListHostnamesResponse, error) {
	out := new(ListHostnamesResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListHostnames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) QueueJob(ctx context.Context, in *QueueJobRequest, opts ...grpc.CallOption) (*QueueJobResponse, error) {
	out := new(QueueJobResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/QueueJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/CancelJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ValidateJob(ctx context.Context, in *ValidateJobRequest, opts ...grpc.CallOption) (*ValidateJobResponse, error) {
	out := new(ValidateJobResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ValidateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetJobStream(ctx context.Context, in *GetJobStreamRequest, opts ...grpc.CallOption) (Waypoint_GetJobStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[2], "/hashicorp.waypoint.Waypoint/GetJobStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointGetJobStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Waypoint_GetJobStreamClient interface {
	Recv() (*GetJobStreamResponse, error)
	grpc.ClientStream
}

type waypointGetJobStreamClient struct {
	grpc.ClientStream
}

func (x *waypointGetJobStreamClient) Recv() (*GetJobStreamResponse, error) {
	m := new(GetJobStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) GetRunner(ctx context.Context, in *GetRunnerRequest, opts ...grpc.CallOption) (*Runner, error) {
	out := new(Runner)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetRunner", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListRunners(ctx context.Context, in *ListRunnersRequest, opts ...grpc.CallOption) (*ListRunnersResponse, error) {
	out := new(ListRunnersResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListRunners", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) AdoptRunner(ctx context.Context, in *AdoptRunnerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/AdoptRunner", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ForgetRunner(ctx context.Context, in *ForgetRunnerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ForgetRunner", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetServerConfig(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetServerConfigResponse, error) {
	out := new(GetServerConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) SetServerConfig(ctx context.Context, in *SetServerConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/SetServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) CreateSnapshot(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (Waypoint_CreateSnapshotClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[3], "/hashicorp.waypoint.Waypoint/CreateSnapshot", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointCreateSnapshotClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Waypoint_CreateSnapshotClient interface {
	Recv() (*CreateSnapshotResponse, error)
	grpc.ClientStream
}

type waypointCreateSnapshotClient struct {
	grpc.ClientStream
}

func (x *waypointCreateSnapshotClient) Recv() (*CreateSnapshotResponse, error) {
	m := new(CreateSnapshotResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) RestoreSnapshot(ctx context.Context, opts ...grpc.CallOption) (Waypoint_RestoreSnapshotClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[4], "/hashicorp.waypoint.Waypoint/RestoreSnapshot", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointRestoreSnapshotClient{stream}
	return x, nil
}

type Waypoint_RestoreSnapshotClient interface {
	Send(*RestoreSnapshotRequest) error
	CloseAndRecv() (*emptypb.Empty, error)
	grpc.ClientStream
}

type waypointRestoreSnapshotClient struct {
	grpc.ClientStream
}

func (x *waypointRestoreSnapshotClient) Send(m *RestoreSnapshotRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *waypointRestoreSnapshotClient) CloseAndRecv() (*emptypb.Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(emptypb.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) BootstrapToken(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*NewTokenResponse, error) {
	out := new(NewTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/BootstrapToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DecodeToken(ctx context.Context, in *DecodeTokenRequest, opts ...grpc.CallOption) (*DecodeTokenResponse, error) {
	out := new(DecodeTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DecodeToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GenerateInviteToken(ctx context.Context, in *InviteTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error) {
	out := new(NewTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GenerateInviteToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GenerateLoginToken(ctx context.Context, in *LoginTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error) {
	out := new(NewTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GenerateLoginToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GenerateRunnerToken(ctx context.Context, in *GenerateRunnerTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error) {
	out := new(NewTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GenerateRunnerToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ConvertInviteToken(ctx context.Context, in *ConvertInviteTokenRequest, opts ...grpc.CallOption) (*NewTokenResponse, error) {
	out := new(NewTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ConvertInviteToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) RunnerToken(ctx context.Context, in *RunnerTokenRequest, opts ...grpc.CallOption) (*RunnerTokenResponse, error) {
	out := new(RunnerTokenResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/RunnerToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) RunnerConfig(ctx context.Context, opts ...grpc.CallOption) (Waypoint_RunnerConfigClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[5], "/hashicorp.waypoint.Waypoint/RunnerConfig", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointRunnerConfigClient{stream}
	return x, nil
}

type Waypoint_RunnerConfigClient interface {
	Send(*RunnerConfigRequest) error
	Recv() (*RunnerConfigResponse, error)
	grpc.ClientStream
}

type waypointRunnerConfigClient struct {
	grpc.ClientStream
}

func (x *waypointRunnerConfigClient) Send(m *RunnerConfigRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *waypointRunnerConfigClient) Recv() (*RunnerConfigResponse, error) {
	m := new(RunnerConfigResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) RunnerJobStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_RunnerJobStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[6], "/hashicorp.waypoint.Waypoint/RunnerJobStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointRunnerJobStreamClient{stream}
	return x, nil
}

type Waypoint_RunnerJobStreamClient interface {
	Send(*RunnerJobStreamRequest) error
	Recv() (*RunnerJobStreamResponse, error)
	grpc.ClientStream
}

type waypointRunnerJobStreamClient struct {
	grpc.ClientStream
}

func (x *waypointRunnerJobStreamClient) Send(m *RunnerJobStreamRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *waypointRunnerJobStreamClient) Recv() (*RunnerJobStreamResponse, error) {
	m := new(RunnerJobStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) RunnerGetDeploymentConfig(ctx context.Context, in *RunnerGetDeploymentConfigRequest, opts ...grpc.CallOption) (*RunnerGetDeploymentConfigResponse, error) {
	out := new(RunnerGetDeploymentConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/RunnerGetDeploymentConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) EntrypointConfig(ctx context.Context, in *EntrypointConfigRequest, opts ...grpc.CallOption) (Waypoint_EntrypointConfigClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[7], "/hashicorp.waypoint.Waypoint/EntrypointConfig", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointEntrypointConfigClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Waypoint_EntrypointConfigClient interface {
	Recv() (*EntrypointConfigResponse, error)
	grpc.ClientStream
}

type waypointEntrypointConfigClient struct {
	grpc.ClientStream
}

func (x *waypointEntrypointConfigClient) Recv() (*EntrypointConfigResponse, error) {
	m := new(EntrypointConfigResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) EntrypointLogStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_EntrypointLogStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[8], "/hashicorp.waypoint.Waypoint/EntrypointLogStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointEntrypointLogStreamClient{stream}
	return x, nil
}

type Waypoint_EntrypointLogStreamClient interface {
	Send(*EntrypointLogBatch) error
	CloseAndRecv() (*emptypb.Empty, error)
	grpc.ClientStream
}

type waypointEntrypointLogStreamClient struct {
	grpc.ClientStream
}

func (x *waypointEntrypointLogStreamClient) Send(m *EntrypointLogBatch) error {
	return x.ClientStream.SendMsg(m)
}

func (x *waypointEntrypointLogStreamClient) CloseAndRecv() (*emptypb.Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(emptypb.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) EntrypointExecStream(ctx context.Context, opts ...grpc.CallOption) (Waypoint_EntrypointExecStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Waypoint_ServiceDesc.Streams[9], "/hashicorp.waypoint.Waypoint/EntrypointExecStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &waypointEntrypointExecStreamClient{stream}
	return x, nil
}

type Waypoint_EntrypointExecStreamClient interface {
	Send(*EntrypointExecRequest) error
	Recv() (*EntrypointExecResponse, error)
	grpc.ClientStream
}

type waypointEntrypointExecStreamClient struct {
	grpc.ClientStream
}

func (x *waypointEntrypointExecStreamClient) Send(m *EntrypointExecRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *waypointEntrypointExecStreamClient) Recv() (*EntrypointExecResponse, error) {
	m := new(EntrypointExecResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *waypointClient) WaypointHclFmt(ctx context.Context, in *WaypointHclFmtRequest, opts ...grpc.CallOption) (*WaypointHclFmtResponse, error) {
	out := new(WaypointHclFmtResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/WaypointHclFmt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertOnDemandRunnerConfig(ctx context.Context, in *UpsertOnDemandRunnerConfigRequest, opts ...grpc.CallOption) (*UpsertOnDemandRunnerConfigResponse, error) {
	out := new(UpsertOnDemandRunnerConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertOnDemandRunnerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetOnDemandRunnerConfig(ctx context.Context, in *GetOnDemandRunnerConfigRequest, opts ...grpc.CallOption) (*GetOnDemandRunnerConfigResponse, error) {
	out := new(GetOnDemandRunnerConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetOnDemandRunnerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetDefaultOnDemandRunnerConfig(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetOnDemandRunnerConfigResponse, error) {
	out := new(GetOnDemandRunnerConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetDefaultOnDemandRunnerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DeleteOnDemandRunnerConfig(ctx context.Context, in *DeleteOnDemandRunnerConfigRequest, opts ...grpc.CallOption) (*DeleteOnDemandRunnerConfigResponse, error) {
	out := new(DeleteOnDemandRunnerConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DeleteOnDemandRunnerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListOnDemandRunnerConfigs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ListOnDemandRunnerConfigsResponse, error) {
	out := new(ListOnDemandRunnerConfigsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListOnDemandRunnerConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertBuild(ctx context.Context, in *UpsertBuildRequest, opts ...grpc.CallOption) (*UpsertBuildResponse, error) {
	out := new(UpsertBuildResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertPushedArtifact(ctx context.Context, in *UpsertPushedArtifactRequest, opts ...grpc.CallOption) (*UpsertPushedArtifactResponse, error) {
	out := new(UpsertPushedArtifactResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertPushedArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertDeployment(ctx context.Context, in *UpsertDeploymentRequest, opts ...grpc.CallOption) (*UpsertDeploymentResponse, error) {
	out := new(UpsertDeploymentResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertRelease(ctx context.Context, in *UpsertReleaseRequest, opts ...grpc.CallOption) (*UpsertReleaseResponse, error) {
	out := new(UpsertReleaseResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertStatusReport(ctx context.Context, in *UpsertStatusReportRequest, opts ...grpc.CallOption) (*UpsertStatusReportResponse, error) {
	out := new(UpsertStatusReportResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertStatusReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*GetTaskResponse, error) {
	out := new(GetTaskResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListTask(ctx context.Context, in *ListTaskRequest, opts ...grpc.CallOption) (*ListTaskResponse, error) {
	out := new(ListTaskResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) CancelTask(ctx context.Context, in *CancelTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/CancelTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertTrigger(ctx context.Context, in *UpsertTriggerRequest, opts ...grpc.CallOption) (*UpsertTriggerResponse, error) {
	out := new(UpsertTriggerResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetTrigger(ctx context.Context, in *GetTriggerRequest, opts ...grpc.CallOption) (*GetTriggerResponse, error) {
	out := new(GetTriggerResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) DeleteTrigger(ctx context.Context, in *DeleteTriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/DeleteTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListTriggers(ctx context.Context, in *ListTriggerRequest, opts ...grpc.CallOption) (*ListTriggerResponse, error) {
	out := new(ListTriggerResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListTriggers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) RunTrigger(ctx context.Context, in *RunTriggerRequest, opts ...grpc.CallOption) (*RunTriggerResponse, error) {
	out := new(RunTriggerResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/RunTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UpsertPipeline(ctx context.Context, in *UpsertPipelineRequest, opts ...grpc.CallOption) (*UpsertPipelineResponse, error) {
	out := new(UpsertPipelineResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UpsertPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*RunPipelineResponse, error) {
	out := new(RunPipelineResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/RunPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*GetPipelineResponse, error) {
	out := new(GetPipelineResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetPipelineRun(ctx context.Context, in *GetPipelineRunRequest, opts ...grpc.CallOption) (*GetPipelineRunResponse, error) {
	out := new(GetPipelineRunResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetPipelineRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) GetLatestPipelineRun(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*GetPipelineRunResponse, error) {
	out := new(GetPipelineRunResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/GetLatestPipelineRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error) {
	out := new(ListPipelinesResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListPipelines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ListPipelineRuns(ctx context.Context, in *ListPipelineRunsRequest, opts ...grpc.CallOption) (*ListPipelineRunsResponse, error) {
	out := new(ListPipelineRunsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ListPipelineRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) ConfigSyncPipeline(ctx context.Context, in *ConfigSyncPipelineRequest, opts ...grpc.CallOption) (*ConfigSyncPipelineResponse, error) {
	out := new(ConfigSyncPipelineResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/ConfigSyncPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UI_GetProject(ctx context.Context, in *UI_GetProjectRequest, opts ...grpc.CallOption) (*UI_GetProjectResponse, error) {
	out := new(UI_GetProjectResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UI_GetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UI_ListDeployments(ctx context.Context, in *UI_ListDeploymentsRequest, opts ...grpc.CallOption) (*UI_ListDeploymentsResponse, error) {
	out := new(UI_ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UI_ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *waypointClient) UI_ListReleases(ctx context.Context, in *UI_ListReleasesRequest, opts ...grpc.CallOption) (*UI_ListReleasesResponse, error) {
	out := new(UI_ListReleasesResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.waypoint.Waypoint/UI_ListReleases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WaypointServer is the server API for Waypoint service.
// All implementations must embed UnimplementedWaypointServer
// for forward compatibility
type WaypointServer interface {
	// GetVersionInfo returns information about the server. This RPC call does
	// NOT require authentication. It can be used by clients to determine if they
	// are capable of talking to this server.
	GetVersionInfo(context.Context, *emptypb.Empty) (*GetVersionInfoResponse, error)
	// List the available OIDC providers for authentication. The "name" of the
	// OIDC provider can be used with GetOIDCAuthURL and CompleteOIDCAuth to
	// perform OIDC-based authentication.
	ListOIDCAuthMethods(context.Context, *emptypb.Empty) (*ListOIDCAuthMethodsResponse, error)
	// Get the URL to visit to start authentication with OIDC.
	GetOIDCAuthURL(context.Context, *GetOIDCAuthURLRequest) (*GetOIDCAuthURLResponse, error)
	// Complete the OIDC auth cycle after receiving the callback from the
	// OIDC provider.
	CompleteOIDCAuth(context.Context, *CompleteOIDCAuthRequest) (*CompleteOIDCAuthResponse, error)
	// Attempts to run a trigger given a trigger ID reference. If the trigger does
	// not exist, we return not found. If the trigger exists but requires authentication
	// we return an error.
	NoAuthRunTrigger(context.Context, *RunTriggerRequest) (*RunTriggerResponse, error)
	// GetUser returns the current logged in user or some other user.
	GetUser(context.Context, *GetUserRequest) (*GetUserResponse, error)
	// List all users in the system.
	ListUsers(context.Context, *emptypb.Empty) (*ListUsersResponse, error)
	// Update the details about an existing user.
	UpdateUser(context.Context, *UpdateUserRequest) (*UpdateUserResponse, error)
	// Delete a user. This will invalidate all authentication for this user
	// as well since they no longer exist.
	DeleteUser(context.Context, *DeleteUserRequest) (*emptypb.Empty, error)
	// UpsertAuthMethod upserts the auth method. All users logged in with
	// this auth method will remain logged in even if settings change.
	UpsertAuthMethod(context.Context, *UpsertAuthMethodRequest) (*UpsertAuthMethodResponse, error)
	// GetAuthMethod returns the auth method.
	GetAuthMethod(context.Context, *GetAuthMethodRequest) (*GetAuthMethodResponse, error)
	// ListAuthMethods returns a list of all the auth methods.
	ListAuthMethods(context.Context, *emptypb.Empty) (*ListAuthMethodsResponse, error)
	// Delete an auth method. This will invalidate all users authenticated
	// using this auth method and they will have to reauthenticate some other
	// way.
	DeleteAuthMethod(context.Context, *DeleteAuthMethodRequest) (*emptypb.Empty, error)
	// ListWorkspaces returns a list of all workspaces.
	//
	// Note that currently this list is never pruned, even if a workspace is
	// no longer in use. We plan to prune this in a future improvement.
	ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error)
	// GetWorkspace returns the workspace.
	GetWorkspace(context.Context, *GetWorkspaceRequest) (*GetWorkspaceResponse, error)
	// UpsertWorkspace upserts the workspace. Changes to a Workspace's Projects
	// are ignored at this time.
	UpsertWorkspace(context.Context, *UpsertWorkspaceRequest) (*UpsertWorkspaceResponse, error)
	// UpsertProject upserts the project.
	UpsertProject(context.Context, *UpsertProjectRequest) (*UpsertProjectResponse, error)
	// GetProject returns the project.
	GetProject(context.Context, *GetProjectRequest) (*GetProjectResponse, error)
	// ListProjects returns a list of all the projects. There is no equivalent
	// ListApplications because applications are a part of projects and you
	// can use GetProject to get more information about the project.
	ListProjects(context.Context, *emptypb.Empty) (*ListProjectsResponse, error)
	// DestroyProject deletes a project from the database as well as (optionally)
	// destroys all resources created within a project
	DestroyProject(context.Context, *DestroyProjectRequest) (*emptypb.Empty, error)
	// GetApplication returns one application on the project.
	GetApplication(context.Context, *GetApplicationRequest) (*GetApplicationResponse, error)
	// UpsertApplication upserts an application with a project.
	UpsertApplication(context.Context, *UpsertApplicationRequest) (*UpsertApplicationResponse, error)
	// ListBuilds returns the builds.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// GetBuild returns a build
	GetBuild(context.Context, *GetBuildRequest) (*Build, error)
	// GetLatestBuild returns the most recent successfully completed build
	// for an app.
	GetLatestBuild(context.Context, *GetLatestBuildRequest) (*Build, error)
	// ListPushedArtifacts returns the builds.
	ListPushedArtifacts(context.Context, *ListPushedArtifactsRequest) (*ListPushedArtifactsResponse, error)
	// GetPushedArtifact returns a deployment
	GetPushedArtifact(context.Context, *GetPushedArtifactRequest) (*PushedArtifact, error)
	// GetLatestPushedArtifact returns the most recent successfully completed
	// artifact push for an app.
	GetLatestPushedArtifact(context.Context, *GetLatestPushedArtifactRequest) (*PushedArtifact, error)
	// ListDeployments returns the deployments.
	ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error)
	// GetDeployment returns a deployment
	GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error)
	// ListInstances returns the running instances of deployments.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// ListReleases returns the releases.
	ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error)
	// GetRelease returns a release
	GetRelease(context.Context, *GetReleaseRequest) (*Release, error)
	// GetLatestRelease returns the most recent successfully completed
	// release for an app.
	GetLatestRelease(context.Context, *GetLatestReleaseRequest) (*Release, error)
	// GetStatusReport returns a StatusReport
	GetStatusReport(context.Context, *GetStatusReportRequest) (*StatusReport, error)
	// GetLatestStatusReport returns the most recent successfully completed
	// health report for an app
	GetLatestStatusReport(context.Context, *GetLatestStatusReportRequest) (*StatusReport, error)
	// ListStatusReports returns the deployments.
	ListStatusReports(context.Context, *ListStatusReportsRequest) (*ListStatusReportsResponse, error)
	// ExpediteStatusReport returns the queued status report job id
	ExpediteStatusReport(context.Context, *ExpediteStatusReportRequest) (*ExpediteStatusReportResponse, error)
	// GetLogStream reads the log stream for a deployment. This will immediately
	// send a single LogEntry with the lines we have so far. If there are no
	// available lines this will NOT block and instead will return an error.
	// The client can choose to retry or not.
	GetLogStream(*GetLogStreamRequest, Waypoint_GetLogStreamServer) error
	// StartExecStream starts an exec session.
	StartExecStream(Waypoint_StartExecStreamServer) error
	// Set one or more configuration variables for applications or runners.
	SetConfig(context.Context, *ConfigSetRequest) (*ConfigSetResponse, error)
	// Retrieve merged configuration values for a specific scope. You can determine
	// where a configuration variable was set by looking at the scope field on
	// each variable.
	GetConfig(context.Context, *ConfigGetRequest) (*ConfigGetResponse, error)
	// Set the configuration for a dynamic configuration source. If you're looking
	// to set application configuration, you probably want SetConfig instead.
	SetConfigSource(context.Context, *SetConfigSourceRequest) (*emptypb.Empty, error)
	// Get the matching configuration source for the request. This will return
	// the most specific matching config source given the scope in the request.
	// For example, if you search for an app-specific config source and only
	// a global config exists, the global config will be returned.
	GetConfigSource(context.Context, *GetConfigSourceRequest) (*GetConfigSourceResponse, error)
	// Create a hostname with the URL service.
	CreateHostname(context.Context, *CreateHostnameRequest) (*CreateHostnameResponse, error)
	// Delete a hostname with the URL service.
	DeleteHostname(context.Context, *DeleteHostnameRequest) (*emptypb.Empty, error)
	// List all our registered hostnames.
	ListHostnames(context.Context, *ListHostnamesRequest) (*ListHostnamesResponse, error)
	// QueueJob queues a job for execution by a runner. This will return as
	// soon as the job is queued, it will not wait for execution.
	QueueJob(context.Context, *QueueJobRequest) (*QueueJobResponse, error)
	// CancelJob cancels a job. If the job is still queued this is a quick
	// and easy operation. If the job is already completed, then this does
	// nothing. If the job is assigned or running, then this will signal
	// the runner about the cancellation but it may take time.
	//
	// This RPC always returns immediately. You must use GetJob or GetJobStream
	// to wait on the status of the cancellation.
	CancelJob(context.Context, *CancelJobRequest) (*emptypb.Empty, error)
	// GetJob queries a job by ID.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// ListJobs will return a list of jobs known to Waypoint server. Can be filtered
	// by request on values like workspace, project, application, job state, etc.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// ValidateJob checks if a job appears valid. This will check the job
	// structure itself (i.e. missing fields) and can also check to ensure
	// the job is assignable to a runner.
	ValidateJob(context.Context, *ValidateJobRequest) (*ValidateJobResponse, error)
	// GetJobStream opens a job event stream for a running job. This can be
	// used to listen for terminal output and other events of a running job.
	// Multiple listeners can open a job stream.
	GetJobStream(*GetJobStreamRequest, Waypoint_GetJobStreamServer) error
	// GetRunner gets information about a single runner.
	GetRunner(context.Context, *GetRunnerRequest) (*Runner, error)
	// ListRunners lists runners that are currently registered with the waypoint server.
	// This list does not include previous on-demand runners that have exited.
	ListRunners(context.Context, *ListRunnersRequest) (*ListRunnersResponse, error)
	// AdoptRunners allows marking a runner as adopted or rejected.
	AdoptRunner(context.Context, *AdoptRunnerRequest) (*emptypb.Empty, error)
	// ForgetRunner deletes an existing runner entry and makes the server
	// behave as if the runner no longer exists. If the runner is currently
	// running, it will receive errors on subsequent jobs, and will have to
	// re-register. A forgotten runner will not be assigned new jobs until
	// re-registered.
	ForgetRunner(context.Context, *ForgetRunnerRequest) (*emptypb.Empty, error)
	// GetServerConfig sets configuration for the Waypoint server.
	GetServerConfig(context.Context, *emptypb.Empty) (*GetServerConfigResponse, error)
	// SetServerConfig sets configuration for the Waypoint server.
	SetServerConfig(context.Context, *SetServerConfigRequest) (*emptypb.Empty, error)
	// CreateSnapshot creates a new database snapshot.
	CreateSnapshot(*emptypb.Empty, Waypoint_CreateSnapshotServer) error
	// RestoreSnapshot performs a database restore with the given snapshot.
	// This API doesn't do a full online restore, it only stages the restore
	// for the next server start to finalize the restore. See the arguments for
	// more information.
	RestoreSnapshot(Waypoint_RestoreSnapshotServer) error
	// BootstrapToken returns the initial token for the server. This can only
	// be requested once on first startup. After initial request this will
	// always return a PermissionDenied error.
	BootstrapToken(context.Context, *emptypb.Empty) (*NewTokenResponse, error)
	// DecodeToken takes a token string and returns the structured information
	// about the given token. This is useful for frontends (CLI, UI, etc.) to
	// learn more about a token before using it. For example, if a UI wants to
	// create a signup flow around signup tokens, they can validate the token
	// ahead of time.
	//
	// This endpoint does NOT require authentication.
	DecodeToken(context.Context, *DecodeTokenRequest) (*DecodeTokenResponse, error)
	// Generate a new invite token that users can exchange for a login token.
	// This can be used to also invite new users to the Waypoint server.
	GenerateInviteToken(context.Context, *InviteTokenRequest) (*NewTokenResponse, error)
	// Generate a new login token that users can use to login directly.
	// This can only be called for existing users.
	GenerateLoginToken(context.Context, *LoginTokenRequest) (*NewTokenResponse, error)
	// Generate a new runner token that can be used with runners so they
	// immediately begin work. The recommended appraoch is to instead use
	// the adoption flow but this also works.
	GenerateRunnerToken(context.Context, *GenerateRunnerTokenRequest) (*NewTokenResponse, error)
	// Exchange a invite token for a login token. If the invite token is
	// for a new user, this will create a new user account with the provided
	// username hint.
	ConvertInviteToken(context.Context, *ConvertInviteTokenRequest) (*NewTokenResponse, error)
	// RunnerToken is called to register a runner and request a token for
	// remaining runner API calls. This kicks off the "adoption" process
	// (if necessary).
	//
	// This is unauthenticated (but requires a cookie in the metadata).
	RunnerToken(context.Context, *RunnerTokenRequest) (*RunnerTokenResponse, error)
	// RunnerConfig is called to receive the configuration for the runner.
	// The response is a stream so that the configuration can be updated later.
	RunnerConfig(Waypoint_RunnerConfigServer) error
	// RunnerJobStream is called by a runner to request a single job for
	// execution and update the status of that job.
	RunnerJobStream(Waypoint_RunnerJobStreamServer) error
	// RunnerGetDeploymentConfig is called by a runner for a deployment operation
	// to determine the settings to use for a deployment.
	RunnerGetDeploymentConfig(context.Context, *RunnerGetDeploymentConfigRequest) (*RunnerGetDeploymentConfigResponse, error)
	// EntrypointConfig is called to get the configuration for the entrypoint
	// and also to get any potential updates.
	//
	// This endpoint also registers the instance with the server. This MUST be
	// called first otherwise other RPCs related to the entrypoint may fail
	// with FailedPrecondition.
	EntrypointConfig(*EntrypointConfigRequest, Waypoint_EntrypointConfigServer) error
	// EntrypointLogStream is called to open the stream that logs are sent to.
	EntrypointLogStream(Waypoint_EntrypointLogStreamServer) error
	// EntrypointExecStream is called to open the data stream for the exec session.
	EntrypointExecStream(Waypoint_EntrypointExecStreamServer) error
	// WaypointHclFmt formats a waypoint.hcl file. This must be in HCL format.
	// JSON formatting is not supported.
	WaypointHclFmt(context.Context, *WaypointHclFmtRequest) (*WaypointHclFmtResponse, error)
	// UpsertOnDemandRunnerConfig updates or inserts a on-demand runner
	// configuration. This configuration can be used by projects for running
	// operations on just-in-time launched runners.
	UpsertOnDemandRunnerConfig(context.Context, *UpsertOnDemandRunnerConfigRequest) (*UpsertOnDemandRunnerConfigResponse, error)
	// GetOnDemandRunnerConfig returns the on-demand runner configuration.
	GetOnDemandRunnerConfig(context.Context, *GetOnDemandRunnerConfigRequest) (*GetOnDemandRunnerConfigResponse, error)
	// GetOnDemandRunnerConfig returns the on-demand runner configuration.
	GetDefaultOnDemandRunnerConfig(context.Context, *emptypb.Empty) (*GetOnDemandRunnerConfigResponse, error)
	// GetOnDemandRunnerConfig returns the on-demand runner configuration.
	DeleteOnDemandRunnerConfig(context.Context, *DeleteOnDemandRunnerConfigRequest) (*DeleteOnDemandRunnerConfigResponse, error)
	// ListOnDemandRunnerConfigs returns a list of all the on-demand runners configs.
	ListOnDemandRunnerConfigs(context.Context, *emptypb.Empty) (*ListOnDemandRunnerConfigsResponse, error)
	// UpsertBuild updates or inserts a build. A build is responsible for
	// taking some set of source information and turning it into an initial
	// artifact. This artifact is considered "local" until it is pushed.
	UpsertBuild(context.Context, *UpsertBuildRequest) (*UpsertBuildResponse, error)
	// UpsertPushedArtifact updates or inserts a pushed artifact. This is
	// useful for local operations to work on a pushed artifact.
	UpsertPushedArtifact(context.Context, *UpsertPushedArtifactRequest) (*UpsertPushedArtifactResponse, error)
	// UpsertDeployment updates or inserts a deployment.
	UpsertDeployment(context.Context, *UpsertDeploymentRequest) (*UpsertDeploymentResponse, error)
	// UpsertRelease updates or inserts a release.
	UpsertRelease(context.Context, *UpsertReleaseRequest) (*UpsertReleaseResponse, error)
	// UpsertStatusReport updates or inserts a statusreport.
	UpsertStatusReport(context.Context, *UpsertStatusReportRequest) (*UpsertStatusReportResponse, error)
	// GetTask returns a requested Task message. Or an error if it does not exist.
	GetTask(context.Context, *GetTaskRequest) (*GetTaskResponse, error)
	// ListTask will return a list of all existing Tasks
	ListTask(context.Context, *ListTaskRequest) (*ListTaskResponse, error)
	// CancelTask will attempt to gracefully cancel each job in the task job triple
	CancelTask(context.Context, *CancelTaskRequest) (*emptypb.Empty, error)
	// UpsertTrigger updates or inserts a trigger URL configuration.
	UpsertTrigger(context.Context, *UpsertTriggerRequest) (*UpsertTriggerResponse, error)
	// GetTrigger returns a requested trigger message. Or an error if it does not exist.
	GetTrigger(context.Context, *GetTriggerRequest) (*GetTriggerResponse, error)
	// DeleteTrigger takes a trigger id and deletes it, if it exists.
	DeleteTrigger(context.Context, *DeleteTriggerRequest) (*emptypb.Empty, error)
	// ListTriggers takes a request filter, and returns any matching existing triggers
	ListTriggers(context.Context, *ListTriggerRequest) (*ListTriggerResponse, error)
	// RunTrigger will look up the referenced trigger and attempt to queue a job
	// based on the trigger configuration.
	RunTrigger(context.Context, *RunTriggerRequest) (*RunTriggerResponse, error)
	// UpsertPipeline updates or inserts a pipeline. This is an INTERNAL ONLY
	// endpoint that is meant to only be called by runners. Calling this manually
	// can risk the internal state for pipelines. In the future, we'll restrict
	// access to this via ACLs.
	UpsertPipeline(context.Context, *UpsertPipelineRequest) (*UpsertPipelineResponse, error)
	// RunPipeline queues a pipeline execution.
	RunPipeline(context.Context, *RunPipelineRequest) (*RunPipelineResponse, error)
	// GetPipeline returns a pipeline proto by pipeline ref id
	GetPipeline(context.Context, *GetPipelineRequest) (*GetPipelineResponse, error)
	// GetPipelineRun returns a pipeline run proto by pipeline ref id and sequence
	GetPipelineRun(context.Context, *GetPipelineRunRequest) (*GetPipelineRunResponse, error)
	// GetLatestPipelineRun returns a pipeline run proto by pipeline ref id and sequence
	GetLatestPipelineRun(context.Context, *GetPipelineRequest) (*GetPipelineRunResponse, error)
	// ListPipelines takes a project and evaluates the projects config to get
	// a list of Pipeline protos to return in the response. These pipelines
	// are scoped to a single project from the request. It will return an
	// error if the requested project does not exist, or an empty response
	// if no pipelines are defined for the project.
	ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error)
	// ListPipelineRuns takes a pipeline ref and returns a list of runs of that pipeline.
	// It will return an error if the requested pipeline does not exist, or an empty response
	// if there are no runs for the pipeline.
	ListPipelineRuns(context.Context, *ListPipelineRunsRequest) (*ListPipelineRunsResponse, error)
	// ConfigSyncPipeline takes a request for a given project and syncs the current
	// project config to the Waypoint database.
	ConfigSyncPipeline(context.Context, *ConfigSyncPipelineRequest) (*ConfigSyncPipelineResponse, error)
	// Get a given project with useful related records.
	UI_GetProject(context.Context, *UI_GetProjectRequest) (*UI_GetProjectResponse, error)
	// List deployments for a given application.
	UI_ListDeployments(context.Context, *UI_ListDeploymentsRequest) (*UI_ListDeploymentsResponse, error)
	// List releases for a given application.
	UI_ListReleases(context.Context, *UI_ListReleasesRequest) (*UI_ListReleasesResponse, error)
	mustEmbedUnimplementedWaypointServer()
}

// UnimplementedWaypointServer must be embedded to have forward compatible implementations.
type UnimplementedWaypointServer struct {
}

func (UnimplementedWaypointServer) GetVersionInfo(context.Context, *emptypb.Empty) (*GetVersionInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersionInfo not implemented")
}
func (UnimplementedWaypointServer) ListOIDCAuthMethods(context.Context, *emptypb.Empty) (*ListOIDCAuthMethodsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOIDCAuthMethods not implemented")
}
func (UnimplementedWaypointServer) GetOIDCAuthURL(context.Context, *GetOIDCAuthURLRequest) (*GetOIDCAuthURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOIDCAuthURL not implemented")
}
func (UnimplementedWaypointServer) CompleteOIDCAuth(context.Context, *CompleteOIDCAuthRequest) (*CompleteOIDCAuthResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteOIDCAuth not implemented")
}
func (UnimplementedWaypointServer) NoAuthRunTrigger(context.Context, *RunTriggerRequest) (*RunTriggerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NoAuthRunTrigger not implemented")
}
func (UnimplementedWaypointServer) GetUser(context.Context, *GetUserRequest) (*GetUserResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUser not implemented")
}
func (UnimplementedWaypointServer) ListUsers(context.Context, *emptypb.Empty) (*ListUsersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUsers not implemented")
}
func (UnimplementedWaypointServer) UpdateUser(context.Context, *UpdateUserRequest) (*UpdateUserResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUser not implemented")
}
func (UnimplementedWaypointServer) DeleteUser(context.Context, *DeleteUserRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUser not implemented")
}
func (UnimplementedWaypointServer) UpsertAuthMethod(context.Context, *UpsertAuthMethodRequest) (*UpsertAuthMethodResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertAuthMethod not implemented")
}
func (UnimplementedWaypointServer) GetAuthMethod(context.Context, *GetAuthMethodRequest) (*GetAuthMethodResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthMethod not implemented")
}
func (UnimplementedWaypointServer) ListAuthMethods(context.Context, *emptypb.Empty) (*ListAuthMethodsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuthMethods not implemented")
}
func (UnimplementedWaypointServer) DeleteAuthMethod(context.Context, *DeleteAuthMethodRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuthMethod not implemented")
}
func (UnimplementedWaypointServer) ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkspaces not implemented")
}
func (UnimplementedWaypointServer) GetWorkspace(context.Context, *GetWorkspaceRequest) (*GetWorkspaceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkspace not implemented")
}
func (UnimplementedWaypointServer) UpsertWorkspace(context.Context, *UpsertWorkspaceRequest) (*UpsertWorkspaceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertWorkspace not implemented")
}
func (UnimplementedWaypointServer) UpsertProject(context.Context, *UpsertProjectRequest) (*UpsertProjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertProject not implemented")
}
func (UnimplementedWaypointServer) GetProject(context.Context, *GetProjectRequest) (*GetProjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProject not implemented")
}
func (UnimplementedWaypointServer) ListProjects(context.Context, *emptypb.Empty) (*ListProjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjects not implemented")
}
func (UnimplementedWaypointServer) DestroyProject(context.Context, *DestroyProjectRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DestroyProject not implemented")
}
func (UnimplementedWaypointServer) GetApplication(context.Context, *GetApplicationRequest) (*GetApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApplication not implemented")
}
func (UnimplementedWaypointServer) UpsertApplication(context.Context, *UpsertApplicationRequest) (*UpsertApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertApplication not implemented")
}
func (UnimplementedWaypointServer) ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuilds not implemented")
}
func (UnimplementedWaypointServer) GetBuild(context.Context, *GetBuildRequest) (*Build, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBuild not implemented")
}
func (UnimplementedWaypointServer) GetLatestBuild(context.Context, *GetLatestBuildRequest) (*Build, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLatestBuild not implemented")
}
func (UnimplementedWaypointServer) ListPushedArtifacts(context.Context, *ListPushedArtifactsRequest) (*ListPushedArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPushedArtifacts not implemented")
}
func (UnimplementedWaypointServer) GetPushedArtifact(context.Context, *GetPushedArtifactRequest) (*PushedArtifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPushedArtifact not implemented")
}
func (UnimplementedWaypointServer) GetLatestPushedArtifact(context.Context, *GetLatestPushedArtifactRequest) (*PushedArtifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLatestPushedArtifact not implemented")
}
func (UnimplementedWaypointServer) ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (UnimplementedWaypointServer) GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (UnimplementedWaypointServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedWaypointServer) ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReleases not implemented")
}
func (UnimplementedWaypointServer) GetRelease(context.Context, *GetReleaseRequest) (*Release, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRelease not implemented")
}
func (UnimplementedWaypointServer) GetLatestRelease(context.Context, *GetLatestReleaseRequest) (*Release, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLatestRelease not implemented")
}
func (UnimplementedWaypointServer) GetStatusReport(context.Context, *GetStatusReportRequest) (*StatusReport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStatusReport not implemented")
}
func (UnimplementedWaypointServer) GetLatestStatusReport(context.Context, *GetLatestStatusReportRequest) (*StatusReport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLatestStatusReport not implemented")
}
func (UnimplementedWaypointServer) ListStatusReports(context.Context, *ListStatusReportsRequest) (*ListStatusReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStatusReports not implemented")
}
func (UnimplementedWaypointServer) ExpediteStatusReport(context.Context, *ExpediteStatusReportRequest) (*ExpediteStatusReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExpediteStatusReport not implemented")
}
func (UnimplementedWaypointServer) GetLogStream(*GetLogStreamRequest, Waypoint_GetLogStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GetLogStream not implemented")
}
func (UnimplementedWaypointServer) StartExecStream(Waypoint_StartExecStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method StartExecStream not implemented")
}
func (UnimplementedWaypointServer) SetConfig(context.Context, *ConfigSetRequest) (*ConfigSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConfig not implemented")
}
func (UnimplementedWaypointServer) GetConfig(context.Context, *ConfigGetRequest) (*ConfigGetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedWaypointServer) SetConfigSource(context.Context, *SetConfigSourceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConfigSource not implemented")
}
func (UnimplementedWaypointServer) GetConfigSource(context.Context, *GetConfigSourceRequest) (*GetConfigSourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfigSource not implemented")
}
func (UnimplementedWaypointServer) CreateHostname(context.Context, *CreateHostnameRequest) (*CreateHostnameResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHostname not implemented")
}
func (UnimplementedWaypointServer) DeleteHostname(context.Context, *DeleteHostnameRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHostname not implemented")
}
func (UnimplementedWaypointServer) ListHostnames(context.Context, *ListHostnamesRequest) (*ListHostnamesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHostnames not implemented")
}
func (UnimplementedWaypointServer) QueueJob(context.Context, *QueueJobRequest) (*QueueJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueueJob not implemented")
}
func (UnimplementedWaypointServer) CancelJob(context.Context, *CancelJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelJob not implemented")
}
func (UnimplementedWaypointServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (UnimplementedWaypointServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (UnimplementedWaypointServer) ValidateJob(context.Context, *ValidateJobRequest) (*ValidateJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateJob not implemented")
}
func (UnimplementedWaypointServer) GetJobStream(*GetJobStreamRequest, Waypoint_GetJobStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GetJobStream not implemented")
}
func (UnimplementedWaypointServer) GetRunner(context.Context, *GetRunnerRequest) (*Runner, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRunner not implemented")
}
func (UnimplementedWaypointServer) ListRunners(context.Context, *ListRunnersRequest) (*ListRunnersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRunners not implemented")
}
func (UnimplementedWaypointServer) AdoptRunner(context.Context, *AdoptRunnerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AdoptRunner not implemented")
}
func (UnimplementedWaypointServer) ForgetRunner(context.Context, *ForgetRunnerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForgetRunner not implemented")
}
func (UnimplementedWaypointServer) GetServerConfig(context.Context, *emptypb.Empty) (*GetServerConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServerConfig not implemented")
}
func (UnimplementedWaypointServer) SetServerConfig(context.Context, *SetServerConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetServerConfig not implemented")
}
func (UnimplementedWaypointServer) CreateSnapshot(*emptypb.Empty, Waypoint_CreateSnapshotServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (UnimplementedWaypointServer) RestoreSnapshot(Waypoint_RestoreSnapshotServer) error {
	return status.Errorf(codes.Unimplemented, "method RestoreSnapshot not implemented")
}
func (UnimplementedWaypointServer) BootstrapToken(context.Context, *emptypb.Empty) (*NewTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BootstrapToken not implemented")
}
func (UnimplementedWaypointServer) DecodeToken(context.Context, *DecodeTokenRequest) (*DecodeTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DecodeToken not implemented")
}
func (UnimplementedWaypointServer) GenerateInviteToken(context.Context, *InviteTokenRequest) (*NewTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateInviteToken not implemented")
}
func (UnimplementedWaypointServer) GenerateLoginToken(context.Context, *LoginTokenRequest) (*NewTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateLoginToken not implemented")
}
func (UnimplementedWaypointServer) GenerateRunnerToken(context.Context, *GenerateRunnerTokenRequest) (*NewTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateRunnerToken not implemented")
}
func (UnimplementedWaypointServer) ConvertInviteToken(context.Context, *ConvertInviteTokenRequest) (*NewTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConvertInviteToken not implemented")
}
func (UnimplementedWaypointServer) RunnerToken(context.Context, *RunnerTokenRequest) (*RunnerTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunnerToken not implemented")
}
func (UnimplementedWaypointServer) RunnerConfig(Waypoint_RunnerConfigServer) error {
	return status.Errorf(codes.Unimplemented, "method RunnerConfig not implemented")
}
func (UnimplementedWaypointServer) RunnerJobStream(Waypoint_RunnerJobStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method RunnerJobStream not implemented")
}
func (UnimplementedWaypointServer) RunnerGetDeploymentConfig(context.Context, *RunnerGetDeploymentConfigRequest) (*RunnerGetDeploymentConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunnerGetDeploymentConfig not implemented")
}
func (UnimplementedWaypointServer) EntrypointConfig(*EntrypointConfigRequest, Waypoint_EntrypointConfigServer) error {
	return status.Errorf(codes.Unimplemented, "method EntrypointConfig not implemented")
}
func (UnimplementedWaypointServer) EntrypointLogStream(Waypoint_EntrypointLogStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method EntrypointLogStream not implemented")
}
func (UnimplementedWaypointServer) EntrypointExecStream(Waypoint_EntrypointExecStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method EntrypointExecStream not implemented")
}
func (UnimplementedWaypointServer) WaypointHclFmt(context.Context, *WaypointHclFmtRequest) (*WaypointHclFmtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WaypointHclFmt not implemented")
}
func (UnimplementedWaypointServer) UpsertOnDemandRunnerConfig(context.Context, *UpsertOnDemandRunnerConfigRequest) (*UpsertOnDemandRunnerConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertOnDemandRunnerConfig not implemented")
}
func (UnimplementedWaypointServer) GetOnDemandRunnerConfig(context.Context, *GetOnDemandRunnerConfigRequest) (*GetOnDemandRunnerConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOnDemandRunnerConfig not implemented")
}
func (UnimplementedWaypointServer) GetDefaultOnDemandRunnerConfig(context.Context, *emptypb.Empty) (*GetOnDemandRunnerConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultOnDemandRunnerConfig not implemented")
}
func (UnimplementedWaypointServer) DeleteOnDemandRunnerConfig(context.Context, *DeleteOnDemandRunnerConfigRequest) (*DeleteOnDemandRunnerConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOnDemandRunnerConfig not implemented")
}
func (UnimplementedWaypointServer) ListOnDemandRunnerConfigs(context.Context, *emptypb.Empty) (*ListOnDemandRunnerConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOnDemandRunnerConfigs not implemented")
}
func (UnimplementedWaypointServer) UpsertBuild(context.Context, *UpsertBuildRequest) (*UpsertBuildResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertBuild not implemented")
}
func (UnimplementedWaypointServer) UpsertPushedArtifact(context.Context, *UpsertPushedArtifactRequest) (*UpsertPushedArtifactResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertPushedArtifact not implemented")
}
func (UnimplementedWaypointServer) UpsertDeployment(context.Context, *UpsertDeploymentRequest) (*UpsertDeploymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertDeployment not implemented")
}
func (UnimplementedWaypointServer) UpsertRelease(context.Context, *UpsertReleaseRequest) (*UpsertReleaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertRelease not implemented")
}
func (UnimplementedWaypointServer) UpsertStatusReport(context.Context, *UpsertStatusReportRequest) (*UpsertStatusReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertStatusReport not implemented")
}
func (UnimplementedWaypointServer) GetTask(context.Context, *GetTaskRequest) (*GetTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (UnimplementedWaypointServer) ListTask(context.Context, *ListTaskRequest) (*ListTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTask not implemented")
}
func (UnimplementedWaypointServer) CancelTask(context.Context, *CancelTaskRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelTask not implemented")
}
func (UnimplementedWaypointServer) UpsertTrigger(context.Context, *UpsertTriggerRequest) (*UpsertTriggerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertTrigger not implemented")
}
func (UnimplementedWaypointServer) GetTrigger(context.Context, *GetTriggerRequest) (*GetTriggerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrigger not implemented")
}
func (UnimplementedWaypointServer) DeleteTrigger(context.Context, *DeleteTriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrigger not implemented")
}
func (UnimplementedWaypointServer) ListTriggers(context.Context, *ListTriggerRequest) (*ListTriggerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTriggers not implemented")
}
func (UnimplementedWaypointServer) RunTrigger(context.Context, *RunTriggerRequest) (*RunTriggerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTrigger not implemented")
}
func (UnimplementedWaypointServer) UpsertPipeline(context.Context, *UpsertPipelineRequest) (*UpsertPipelineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpsertPipeline not implemented")
}
func (UnimplementedWaypointServer) RunPipeline(context.Context, *RunPipelineRequest) (*RunPipelineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPipeline not implemented")
}
func (UnimplementedWaypointServer) GetPipeline(context.Context, *GetPipelineRequest) (*GetPipelineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipeline not implemented")
}
func (UnimplementedWaypointServer) GetPipelineRun(context.Context, *GetPipelineRunRequest) (*GetPipelineRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipelineRun not implemented")
}
func (UnimplementedWaypointServer) GetLatestPipelineRun(context.Context, *GetPipelineRequest) (*GetPipelineRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLatestPipelineRun not implemented")
}
func (UnimplementedWaypointServer) ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPipelines not implemented")
}
func (UnimplementedWaypointServer) ListPipelineRuns(context.Context, *ListPipelineRunsRequest) (*ListPipelineRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPipelineRuns not implemented")
}
func (UnimplementedWaypointServer) ConfigSyncPipeline(context.Context, *ConfigSyncPipelineRequest) (*ConfigSyncPipelineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigSyncPipeline not implemented")
}
func (UnimplementedWaypointServer) UI_GetProject(context.Context, *UI_GetProjectRequest) (*UI_GetProjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UI_GetProject not implemented")
}
func (UnimplementedWaypointServer) UI_ListDeployments(context.Context, *UI_ListDeploymentsRequest) (*UI_ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UI_ListDeployments not implemented")
}
func (UnimplementedWaypointServer) UI_ListReleases(context.Context, *UI_ListReleasesRequest) (*UI_ListReleasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UI_ListReleases not implemented")
}
func (UnimplementedWaypointServer) mustEmbedUnimplementedWaypointServer() {}

// UnsafeWaypointServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WaypointServer will
// result in compilation errors.
type UnsafeWaypointServer interface {
	mustEmbedUnimplementedWaypointServer()
}

func RegisterWaypointServer(s grpc.ServiceRegistrar, srv WaypointServer) {
	s.RegisterService(&Waypoint_ServiceDesc, srv)
}

func _Waypoint_GetVersionInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetVersionInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetVersionInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetVersionInfo(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListOIDCAuthMethods_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListOIDCAuthMethods(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListOIDCAuthMethods",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListOIDCAuthMethods(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetOIDCAuthURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOIDCAuthURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetOIDCAuthURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetOIDCAuthURL",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetOIDCAuthURL(ctx, req.(*GetOIDCAuthURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_CompleteOIDCAuth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteOIDCAuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).CompleteOIDCAuth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/CompleteOIDCAuth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).CompleteOIDCAuth(ctx, req.(*CompleteOIDCAuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_NoAuthRunTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).NoAuthRunTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/NoAuthRunTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).NoAuthRunTrigger(ctx, req.(*RunTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetUser(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListUsers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListUsers(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpdateUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpdateUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpdateUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpdateUser(ctx, req.(*UpdateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DeleteUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DeleteUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DeleteUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DeleteUser(ctx, req.(*DeleteUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertAuthMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertAuthMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertAuthMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertAuthMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertAuthMethod(ctx, req.(*UpsertAuthMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetAuthMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetAuthMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetAuthMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetAuthMethod(ctx, req.(*GetAuthMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListAuthMethods_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListAuthMethods(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListAuthMethods",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListAuthMethods(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DeleteAuthMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuthMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DeleteAuthMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DeleteAuthMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DeleteAuthMethod(ctx, req.(*DeleteAuthMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListWorkspaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkspacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListWorkspaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListWorkspaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListWorkspaces(ctx, req.(*ListWorkspacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetWorkspace(ctx, req.(*GetWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertWorkspace(ctx, req.(*UpsertWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertProject(ctx, req.(*UpsertProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetProject(ctx, req.(*GetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListProjects(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DestroyProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DestroyProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DestroyProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DestroyProject(ctx, req.(*DestroyProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetApplication(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertApplication(ctx, req.(*UpsertApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetBuild(ctx, req.(*GetBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetLatestBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLatestBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetLatestBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetLatestBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetLatestBuild(ctx, req.(*GetLatestBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListPushedArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPushedArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListPushedArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListPushedArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListPushedArtifacts(ctx, req.(*ListPushedArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetPushedArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPushedArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetPushedArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetPushedArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetPushedArtifact(ctx, req.(*GetPushedArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetLatestPushedArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLatestPushedArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetLatestPushedArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetLatestPushedArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetLatestPushedArtifact(ctx, req.(*GetLatestPushedArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListDeployments(ctx, req.(*ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetDeployment(ctx, req.(*GetDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListReleases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListReleases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListReleases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListReleases(ctx, req.(*ListReleasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetRelease(ctx, req.(*GetReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetLatestRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLatestReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetLatestRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetLatestRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetLatestRelease(ctx, req.(*GetLatestReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetStatusReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStatusReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetStatusReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetStatusReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetStatusReport(ctx, req.(*GetStatusReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetLatestStatusReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLatestStatusReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetLatestStatusReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetLatestStatusReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetLatestStatusReport(ctx, req.(*GetLatestStatusReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListStatusReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStatusReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListStatusReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListStatusReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListStatusReports(ctx, req.(*ListStatusReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ExpediteStatusReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExpediteStatusReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ExpediteStatusReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ExpediteStatusReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ExpediteStatusReport(ctx, req.(*ExpediteStatusReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetLogStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLogStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(WaypointServer).GetLogStream(m, &waypointGetLogStreamServer{stream})
}

type Waypoint_GetLogStreamServer interface {
	Send(*LogBatch) error
	grpc.ServerStream
}

type waypointGetLogStreamServer struct {
	grpc.ServerStream
}

func (x *waypointGetLogStreamServer) Send(m *LogBatch) error {
	return x.ServerStream.SendMsg(m)
}

func _Waypoint_StartExecStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WaypointServer).StartExecStream(&waypointStartExecStreamServer{stream})
}

type Waypoint_StartExecStreamServer interface {
	Send(*ExecStreamResponse) error
	Recv() (*ExecStreamRequest, error)
	grpc.ServerStream
}

type waypointStartExecStreamServer struct {
	grpc.ServerStream
}

func (x *waypointStartExecStreamServer) Send(m *ExecStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *waypointStartExecStreamServer) Recv() (*ExecStreamRequest, error) {
	m := new(ExecStreamRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Waypoint_SetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).SetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/SetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).SetConfig(ctx, req.(*ConfigSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetConfig(ctx, req.(*ConfigGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_SetConfigSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConfigSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).SetConfigSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/SetConfigSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).SetConfigSource(ctx, req.(*SetConfigSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetConfigSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetConfigSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetConfigSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetConfigSource(ctx, req.(*GetConfigSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_CreateHostname_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHostnameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).CreateHostname(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/CreateHostname",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).CreateHostname(ctx, req.(*CreateHostnameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DeleteHostname_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHostnameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DeleteHostname(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DeleteHostname",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DeleteHostname(ctx, req.(*DeleteHostnameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListHostnames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHostnamesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListHostnames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListHostnames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListHostnames(ctx, req.(*ListHostnamesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_QueueJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueueJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).QueueJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/QueueJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).QueueJob(ctx, req.(*QueueJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ValidateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ValidateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ValidateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ValidateJob(ctx, req.(*ValidateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetJobStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetJobStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(WaypointServer).GetJobStream(m, &waypointGetJobStreamServer{stream})
}

type Waypoint_GetJobStreamServer interface {
	Send(*GetJobStreamResponse) error
	grpc.ServerStream
}

type waypointGetJobStreamServer struct {
	grpc.ServerStream
}

func (x *waypointGetJobStreamServer) Send(m *GetJobStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Waypoint_GetRunner_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRunnerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetRunner(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetRunner",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetRunner(ctx, req.(*GetRunnerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListRunners_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRunnersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListRunners(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListRunners",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListRunners(ctx, req.(*ListRunnersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_AdoptRunner_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AdoptRunnerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).AdoptRunner(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/AdoptRunner",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).AdoptRunner(ctx, req.(*AdoptRunnerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ForgetRunner_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForgetRunnerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ForgetRunner(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ForgetRunner",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ForgetRunner(ctx, req.(*ForgetRunnerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetServerConfig(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_SetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).SetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/SetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).SetServerConfig(ctx, req.(*SetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_CreateSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(WaypointServer).CreateSnapshot(m, &waypointCreateSnapshotServer{stream})
}

type Waypoint_CreateSnapshotServer interface {
	Send(*CreateSnapshotResponse) error
	grpc.ServerStream
}

type waypointCreateSnapshotServer struct {
	grpc.ServerStream
}

func (x *waypointCreateSnapshotServer) Send(m *CreateSnapshotResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Waypoint_RestoreSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WaypointServer).RestoreSnapshot(&waypointRestoreSnapshotServer{stream})
}

type Waypoint_RestoreSnapshotServer interface {
	SendAndClose(*emptypb.Empty) error
	Recv() (*RestoreSnapshotRequest, error)
	grpc.ServerStream
}

type waypointRestoreSnapshotServer struct {
	grpc.ServerStream
}

func (x *waypointRestoreSnapshotServer) SendAndClose(m *emptypb.Empty) error {
	return x.ServerStream.SendMsg(m)
}

func (x *waypointRestoreSnapshotServer) Recv() (*RestoreSnapshotRequest, error) {
	m := new(RestoreSnapshotRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Waypoint_BootstrapToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).BootstrapToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/BootstrapToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).BootstrapToken(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DecodeToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecodeTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DecodeToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DecodeToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DecodeToken(ctx, req.(*DecodeTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GenerateInviteToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InviteTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GenerateInviteToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GenerateInviteToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GenerateInviteToken(ctx, req.(*InviteTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GenerateLoginToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoginTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GenerateLoginToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GenerateLoginToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GenerateLoginToken(ctx, req.(*LoginTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GenerateRunnerToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateRunnerTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GenerateRunnerToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GenerateRunnerToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GenerateRunnerToken(ctx, req.(*GenerateRunnerTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ConvertInviteToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConvertInviteTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ConvertInviteToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ConvertInviteToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ConvertInviteToken(ctx, req.(*ConvertInviteTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_RunnerToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunnerTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).RunnerToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/RunnerToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).RunnerToken(ctx, req.(*RunnerTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_RunnerConfig_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WaypointServer).RunnerConfig(&waypointRunnerConfigServer{stream})
}

type Waypoint_RunnerConfigServer interface {
	Send(*RunnerConfigResponse) error
	Recv() (*RunnerConfigRequest, error)
	grpc.ServerStream
}

type waypointRunnerConfigServer struct {
	grpc.ServerStream
}

func (x *waypointRunnerConfigServer) Send(m *RunnerConfigResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *waypointRunnerConfigServer) Recv() (*RunnerConfigRequest, error) {
	m := new(RunnerConfigRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Waypoint_RunnerJobStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WaypointServer).RunnerJobStream(&waypointRunnerJobStreamServer{stream})
}

type Waypoint_RunnerJobStreamServer interface {
	Send(*RunnerJobStreamResponse) error
	Recv() (*RunnerJobStreamRequest, error)
	grpc.ServerStream
}

type waypointRunnerJobStreamServer struct {
	grpc.ServerStream
}

func (x *waypointRunnerJobStreamServer) Send(m *RunnerJobStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *waypointRunnerJobStreamServer) Recv() (*RunnerJobStreamRequest, error) {
	m := new(RunnerJobStreamRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Waypoint_RunnerGetDeploymentConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunnerGetDeploymentConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).RunnerGetDeploymentConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/RunnerGetDeploymentConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).RunnerGetDeploymentConfig(ctx, req.(*RunnerGetDeploymentConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_EntrypointConfig_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EntrypointConfigRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(WaypointServer).EntrypointConfig(m, &waypointEntrypointConfigServer{stream})
}

type Waypoint_EntrypointConfigServer interface {
	Send(*EntrypointConfigResponse) error
	grpc.ServerStream
}

type waypointEntrypointConfigServer struct {
	grpc.ServerStream
}

func (x *waypointEntrypointConfigServer) Send(m *EntrypointConfigResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Waypoint_EntrypointLogStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WaypointServer).EntrypointLogStream(&waypointEntrypointLogStreamServer{stream})
}

type Waypoint_EntrypointLogStreamServer interface {
	SendAndClose(*emptypb.Empty) error
	Recv() (*EntrypointLogBatch, error)
	grpc.ServerStream
}

type waypointEntrypointLogStreamServer struct {
	grpc.ServerStream
}

func (x *waypointEntrypointLogStreamServer) SendAndClose(m *emptypb.Empty) error {
	return x.ServerStream.SendMsg(m)
}

func (x *waypointEntrypointLogStreamServer) Recv() (*EntrypointLogBatch, error) {
	m := new(EntrypointLogBatch)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Waypoint_EntrypointExecStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WaypointServer).EntrypointExecStream(&waypointEntrypointExecStreamServer{stream})
}

type Waypoint_EntrypointExecStreamServer interface {
	Send(*EntrypointExecResponse) error
	Recv() (*EntrypointExecRequest, error)
	grpc.ServerStream
}

type waypointEntrypointExecStreamServer struct {
	grpc.ServerStream
}

func (x *waypointEntrypointExecStreamServer) Send(m *EntrypointExecResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *waypointEntrypointExecStreamServer) Recv() (*EntrypointExecRequest, error) {
	m := new(EntrypointExecRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Waypoint_WaypointHclFmt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WaypointHclFmtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).WaypointHclFmt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/WaypointHclFmt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).WaypointHclFmt(ctx, req.(*WaypointHclFmtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertOnDemandRunnerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertOnDemandRunnerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertOnDemandRunnerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertOnDemandRunnerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertOnDemandRunnerConfig(ctx, req.(*UpsertOnDemandRunnerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetOnDemandRunnerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOnDemandRunnerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetOnDemandRunnerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetOnDemandRunnerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetOnDemandRunnerConfig(ctx, req.(*GetOnDemandRunnerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetDefaultOnDemandRunnerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetDefaultOnDemandRunnerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetDefaultOnDemandRunnerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetDefaultOnDemandRunnerConfig(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DeleteOnDemandRunnerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOnDemandRunnerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DeleteOnDemandRunnerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DeleteOnDemandRunnerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DeleteOnDemandRunnerConfig(ctx, req.(*DeleteOnDemandRunnerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListOnDemandRunnerConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListOnDemandRunnerConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListOnDemandRunnerConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListOnDemandRunnerConfigs(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertBuild(ctx, req.(*UpsertBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertPushedArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertPushedArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertPushedArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertPushedArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertPushedArtifact(ctx, req.(*UpsertPushedArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertDeployment(ctx, req.(*UpsertDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertRelease(ctx, req.(*UpsertReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertStatusReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertStatusReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertStatusReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertStatusReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertStatusReport(ctx, req.(*UpsertStatusReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListTask(ctx, req.(*ListTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_CancelTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).CancelTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/CancelTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).CancelTask(ctx, req.(*CancelTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertTrigger(ctx, req.(*UpsertTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetTrigger(ctx, req.(*GetTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_DeleteTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).DeleteTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/DeleteTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).DeleteTrigger(ctx, req.(*DeleteTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListTriggers(ctx, req.(*ListTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_RunTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).RunTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/RunTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).RunTrigger(ctx, req.(*RunTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UpsertPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UpsertPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UpsertPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UpsertPipeline(ctx, req.(*UpsertPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_RunPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).RunPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/RunPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).RunPipeline(ctx, req.(*RunPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetPipeline(ctx, req.(*GetPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetPipelineRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetPipelineRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetPipelineRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetPipelineRun(ctx, req.(*GetPipelineRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_GetLatestPipelineRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).GetLatestPipelineRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/GetLatestPipelineRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).GetLatestPipelineRun(ctx, req.(*GetPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListPipelines(ctx, req.(*ListPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ListPipelineRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelineRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ListPipelineRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ListPipelineRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ListPipelineRuns(ctx, req.(*ListPipelineRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_ConfigSyncPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigSyncPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).ConfigSyncPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/ConfigSyncPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).ConfigSyncPipeline(ctx, req.(*ConfigSyncPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UI_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UI_GetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UI_GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UI_GetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UI_GetProject(ctx, req.(*UI_GetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UI_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UI_ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UI_ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UI_ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UI_ListDeployments(ctx, req.(*UI_ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Waypoint_UI_ListReleases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UI_ListReleasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WaypointServer).UI_ListReleases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.waypoint.Waypoint/UI_ListReleases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WaypointServer).UI_ListReleases(ctx, req.(*UI_ListReleasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Waypoint_ServiceDesc is the grpc.ServiceDesc for Waypoint service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Waypoint_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.waypoint.Waypoint",
	HandlerType: (*WaypointServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetVersionInfo",
			Handler:    _Waypoint_GetVersionInfo_Handler,
		},
		{
			MethodName: "ListOIDCAuthMethods",
			Handler:    _Waypoint_ListOIDCAuthMethods_Handler,
		},
		{
			MethodName: "GetOIDCAuthURL",
			Handler:    _Waypoint_GetOIDCAuthURL_Handler,
		},
		{
			MethodName: "CompleteOIDCAuth",
			Handler:    _Waypoint_CompleteOIDCAuth_Handler,
		},
		{
			MethodName: "NoAuthRunTrigger",
			Handler:    _Waypoint_NoAuthRunTrigger_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _Waypoint_GetUser_Handler,
		},
		{
			MethodName: "ListUsers",
			Handler:    _Waypoint_ListUsers_Handler,
		},
		{
			MethodName: "UpdateUser",
			Handler:    _Waypoint_UpdateUser_Handler,
		},
		{
			MethodName: "DeleteUser",
			Handler:    _Waypoint_DeleteUser_Handler,
		},
		{
			MethodName: "UpsertAuthMethod",
			Handler:    _Waypoint_UpsertAuthMethod_Handler,
		},
		{
			MethodName: "GetAuthMethod",
			Handler:    _Waypoint_GetAuthMethod_Handler,
		},
		{
			MethodName: "ListAuthMethods",
			Handler:    _Waypoint_ListAuthMethods_Handler,
		},
		{
			MethodName: "DeleteAuthMethod",
			Handler:    _Waypoint_DeleteAuthMethod_Handler,
		},
		{
			MethodName: "ListWorkspaces",
			Handler:    _Waypoint_ListWorkspaces_Handler,
		},
		{
			MethodName: "GetWorkspace",
			Handler:    _Waypoint_GetWorkspace_Handler,
		},
		{
			MethodName: "UpsertWorkspace",
			Handler:    _Waypoint_UpsertWorkspace_Handler,
		},
		{
			MethodName: "UpsertProject",
			Handler:    _Waypoint_UpsertProject_Handler,
		},
		{
			MethodName: "GetProject",
			Handler:    _Waypoint_GetProject_Handler,
		},
		{
			MethodName: "ListProjects",
			Handler:    _Waypoint_ListProjects_Handler,
		},
		{
			MethodName: "DestroyProject",
			Handler:    _Waypoint_DestroyProject_Handler,
		},
		{
			MethodName: "GetApplication",
			Handler:    _Waypoint_GetApplication_Handler,
		},
		{
			MethodName: "UpsertApplication",
			Handler:    _Waypoint_UpsertApplication_Handler,
		},
		{
			MethodName: "ListBuilds",
			Handler:    _Waypoint_ListBuilds_Handler,
		},
		{
			MethodName: "GetBuild",
			Handler:    _Waypoint_GetBuild_Handler,
		},
		{
			MethodName: "GetLatestBuild",
			Handler:    _Waypoint_GetLatestBuild_Handler,
		},
		{
			MethodName: "ListPushedArtifacts",
			Handler:    _Waypoint_ListPushedArtifacts_Handler,
		},
		{
			MethodName: "GetPushedArtifact",
			Handler:    _Waypoint_GetPushedArtifact_Handler,
		},
		{
			MethodName: "GetLatestPushedArtifact",
			Handler:    _Waypoint_GetLatestPushedArtifact_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _Waypoint_ListDeployments_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _Waypoint_GetDeployment_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _Waypoint_ListInstances_Handler,
		},
		{
			MethodName: "ListReleases",
			Handler:    _Waypoint_ListReleases_Handler,
		},
		{
			MethodName: "GetRelease",
			Handler:    _Waypoint_GetRelease_Handler,
		},
		{
			MethodName: "GetLatestRelease",
			Handler:    _Waypoint_GetLatestRelease_Handler,
		},
		{
			MethodName: "GetStatusReport",
			Handler:    _Waypoint_GetStatusReport_Handler,
		},
		{
			MethodName: "GetLatestStatusReport",
			Handler:    _Waypoint_GetLatestStatusReport_Handler,
		},
		{
			MethodName: "ListStatusReports",
			Handler:    _Waypoint_ListStatusReports_Handler,
		},
		{
			MethodName: "ExpediteStatusReport",
			Handler:    _Waypoint_ExpediteStatusReport_Handler,
		},
		{
			MethodName: "SetConfig",
			Handler:    _Waypoint_SetConfig_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _Waypoint_GetConfig_Handler,
		},
		{
			MethodName: "SetConfigSource",
			Handler:    _Waypoint_SetConfigSource_Handler,
		},
		{
			MethodName: "GetConfigSource",
			Handler:    _Waypoint_GetConfigSource_Handler,
		},
		{
			MethodName: "CreateHostname",
			Handler:    _Waypoint_CreateHostname_Handler,
		},
		{
			MethodName: "DeleteHostname",
			Handler:    _Waypoint_DeleteHostname_Handler,
		},
		{
			MethodName: "ListHostnames",
			Handler:    _Waypoint_ListHostnames_Handler,
		},
		{
			MethodName: "QueueJob",
			Handler:    _Waypoint_QueueJob_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _Waypoint_CancelJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _Waypoint_GetJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _Waypoint_ListJobs_Handler,
		},
		{
			MethodName: "ValidateJob",
			Handler:    _Waypoint_ValidateJob_Handler,
		},
		{
			MethodName: "GetRunner",
			Handler:    _Waypoint_GetRunner_Handler,
		},
		{
			MethodName: "ListRunners",
			Handler:    _Waypoint_ListRunners_Handler,
		},
		{
			MethodName: "AdoptRunner",
			Handler:    _Waypoint_AdoptRunner_Handler,
		},
		{
			MethodName: "ForgetRunner",
			Handler:    _Waypoint_ForgetRunner_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _Waypoint_GetServerConfig_Handler,
		},
		{
			MethodName: "SetServerConfig",
			Handler:    _Waypoint_SetServerConfig_Handler,
		},
		{
			MethodName: "BootstrapToken",
			Handler:    _Waypoint_BootstrapToken_Handler,
		},
		{
			MethodName: "DecodeToken",
			Handler:    _Waypoint_DecodeToken_Handler,
		},
		{
			MethodName: "GenerateInviteToken",
			Handler:    _Waypoint_GenerateInviteToken_Handler,
		},
		{
			MethodName: "GenerateLoginToken",
			Handler:    _Waypoint_GenerateLoginToken_Handler,
		},
		{
			MethodName: "GenerateRunnerToken",
			Handler:    _Waypoint_GenerateRunnerToken_Handler,
		},
		{
			MethodName: "ConvertInviteToken",
			Handler:    _Waypoint_ConvertInviteToken_Handler,
		},
		{
			MethodName: "RunnerToken",
			Handler:    _Waypoint_RunnerToken_Handler,
		},
		{
			MethodName: "RunnerGetDeploymentConfig",
			Handler:    _Waypoint_RunnerGetDeploymentConfig_Handler,
		},
		{
			MethodName: "WaypointHclFmt",
			Handler:    _Waypoint_WaypointHclFmt_Handler,
		},
		{
			MethodName: "UpsertOnDemandRunnerConfig",
			Handler:    _Waypoint_UpsertOnDemandRunnerConfig_Handler,
		},
		{
			MethodName: "GetOnDemandRunnerConfig",
			Handler:    _Waypoint_GetOnDemandRunnerConfig_Handler,
		},
		{
			MethodName: "GetDefaultOnDemandRunnerConfig",
			Handler:    _Waypoint_GetDefaultOnDemandRunnerConfig_Handler,
		},
		{
			MethodName: "DeleteOnDemandRunnerConfig",
			Handler:    _Waypoint_DeleteOnDemandRunnerConfig_Handler,
		},
		{
			MethodName: "ListOnDemandRunnerConfigs",
			Handler:    _Waypoint_ListOnDemandRunnerConfigs_Handler,
		},
		{
			MethodName: "UpsertBuild",
			Handler:    _Waypoint_UpsertBuild_Handler,
		},
		{
			MethodName: "UpsertPushedArtifact",
			Handler:    _Waypoint_UpsertPushedArtifact_Handler,
		},
		{
			MethodName: "UpsertDeployment",
			Handler:    _Waypoint_UpsertDeployment_Handler,
		},
		{
			MethodName: "UpsertRelease",
			Handler:    _Waypoint_UpsertRelease_Handler,
		},
		{
			MethodName: "UpsertStatusReport",
			Handler:    _Waypoint_UpsertStatusReport_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _Waypoint_GetTask_Handler,
		},
		{
			MethodName: "ListTask",
			Handler:    _Waypoint_ListTask_Handler,
		},
		{
			MethodName: "CancelTask",
			Handler:    _Waypoint_CancelTask_Handler,
		},
		{
			MethodName: "UpsertTrigger",
			Handler:    _Waypoint_UpsertTrigger_Handler,
		},
		{
			MethodName: "GetTrigger",
			Handler:    _Waypoint_GetTrigger_Handler,
		},
		{
			MethodName: "DeleteTrigger",
			Handler:    _Waypoint_DeleteTrigger_Handler,
		},
		{
			MethodName: "ListTriggers",
			Handler:    _Waypoint_ListTriggers_Handler,
		},
		{
			MethodName: "RunTrigger",
			Handler:    _Waypoint_RunTrigger_Handler,
		},
		{
			MethodName: "UpsertPipeline",
			Handler:    _Waypoint_UpsertPipeline_Handler,
		},
		{
			MethodName: "RunPipeline",
			Handler:    _Waypoint_RunPipeline_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _Waypoint_GetPipeline_Handler,
		},
		{
			MethodName: "GetPipelineRun",
			Handler:    _Waypoint_GetPipelineRun_Handler,
		},
		{
			MethodName: "GetLatestPipelineRun",
			Handler:    _Waypoint_GetLatestPipelineRun_Handler,
		},
		{
			MethodName: "ListPipelines",
			Handler:    _Waypoint_ListPipelines_Handler,
		},
		{
			MethodName: "ListPipelineRuns",
			Handler:    _Waypoint_ListPipelineRuns_Handler,
		},
		{
			MethodName: "ConfigSyncPipeline",
			Handler:    _Waypoint_ConfigSyncPipeline_Handler,
		},
		{
			MethodName: "UI_GetProject",
			Handler:    _Waypoint_UI_GetProject_Handler,
		},
		{
			MethodName: "UI_ListDeployments",
			Handler:    _Waypoint_UI_ListDeployments_Handler,
		},
		{
			MethodName: "UI_ListReleases",
			Handler:    _Waypoint_UI_ListReleases_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetLogStream",
			Handler:       _Waypoint_GetLogStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StartExecStream",
			Handler:       _Waypoint_StartExecStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "GetJobStream",
			Handler:       _Waypoint_GetJobStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateSnapshot",
			Handler:       _Waypoint_CreateSnapshot_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RestoreSnapshot",
			Handler:       _Waypoint_RestoreSnapshot_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "RunnerConfig",
			Handler:       _Waypoint_RunnerConfig_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "RunnerJobStream",
			Handler:       _Waypoint_RunnerJobStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "EntrypointConfig",
			Handler:       _Waypoint_EntrypointConfig_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "EntrypointLogStream",
			Handler:       _Waypoint_EntrypointLogStream_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "EntrypointExecStream",
			Handler:       _Waypoint_EntrypointExecStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "pkg/server/proto/server.proto",
}
