// Code generated by go-swagger; DO NOT EDIT.

package organization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// OrganizationServiceGetIamPolicyReader is a Reader for the OrganizationServiceGetIamPolicy structure.
type OrganizationServiceGetIamPolicyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OrganizationServiceGetIamPolicyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOrganizationServiceGetIamPolicyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOrganizationServiceGetIamPolicyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOrganizationServiceGetIamPolicyOK creates a OrganizationServiceGetIamPolicyOK with default headers values
func NewOrganizationServiceGetIamPolicyOK() *OrganizationServiceGetIamPolicyOK {
	return &OrganizationServiceGetIamPolicyOK{}
}

/*
OrganizationServiceGetIamPolicyOK describes a response with status code 200, with default header values.

A successful response.
*/
type OrganizationServiceGetIamPolicyOK struct {
	Payload *models.HashicorpCloudResourcemanagerOrganizationGetIamPolicyResponse
}

// IsSuccess returns true when this organization service get iam policy o k response has a 2xx status code
func (o *OrganizationServiceGetIamPolicyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this organization service get iam policy o k response has a 3xx status code
func (o *OrganizationServiceGetIamPolicyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this organization service get iam policy o k response has a 4xx status code
func (o *OrganizationServiceGetIamPolicyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this organization service get iam policy o k response has a 5xx status code
func (o *OrganizationServiceGetIamPolicyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this organization service get iam policy o k response a status code equal to that given
func (o *OrganizationServiceGetIamPolicyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the organization service get iam policy o k response
func (o *OrganizationServiceGetIamPolicyOK) Code() int {
	return 200
}

func (o *OrganizationServiceGetIamPolicyOK) Error() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}/iam-policy][%d] organizationServiceGetIamPolicyOK  %+v", 200, o.Payload)
}

func (o *OrganizationServiceGetIamPolicyOK) String() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}/iam-policy][%d] organizationServiceGetIamPolicyOK  %+v", 200, o.Payload)
}

func (o *OrganizationServiceGetIamPolicyOK) GetPayload() *models.HashicorpCloudResourcemanagerOrganizationGetIamPolicyResponse {
	return o.Payload
}

func (o *OrganizationServiceGetIamPolicyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerOrganizationGetIamPolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOrganizationServiceGetIamPolicyDefault creates a OrganizationServiceGetIamPolicyDefault with default headers values
func NewOrganizationServiceGetIamPolicyDefault(code int) *OrganizationServiceGetIamPolicyDefault {
	return &OrganizationServiceGetIamPolicyDefault{
		_statusCode: code,
	}
}

/*
OrganizationServiceGetIamPolicyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OrganizationServiceGetIamPolicyDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this organization service get iam policy default response has a 2xx status code
func (o *OrganizationServiceGetIamPolicyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this organization service get iam policy default response has a 3xx status code
func (o *OrganizationServiceGetIamPolicyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this organization service get iam policy default response has a 4xx status code
func (o *OrganizationServiceGetIamPolicyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this organization service get iam policy default response has a 5xx status code
func (o *OrganizationServiceGetIamPolicyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this organization service get iam policy default response a status code equal to that given
func (o *OrganizationServiceGetIamPolicyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the organization service get iam policy default response
func (o *OrganizationServiceGetIamPolicyDefault) Code() int {
	return o._statusCode
}

func (o *OrganizationServiceGetIamPolicyDefault) Error() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}/iam-policy][%d] OrganizationService_GetIamPolicy default  %+v", o._statusCode, o.Payload)
}

func (o *OrganizationServiceGetIamPolicyDefault) String() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}/iam-policy][%d] OrganizationService_GetIamPolicy default  %+v", o._statusCode, o.Payload)
}

func (o *OrganizationServiceGetIamPolicyDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *OrganizationServiceGetIamPolicyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
