// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudIamUserPrincipal UserPrincipal represents a human user of our platform.
//
// swagger:model hashicorp.cloud.iam.UserPrincipal
type HashicorpCloudIamUserPrincipal struct {

	// email is the unique email address of this user.
	Email string `json:"email,omitempty"`

	// full_name is the name of the user, as provided by Auth0.
	FullName string `json:"full_name,omitempty"`

	// id is the UUID public identifier for a user principal. It is safe
	// to share this value with external users, and it should be how user principals
	// are commonly identified also within our platform.
	ID string `json:"id,omitempty"`

	// identity_type is the identity type for this user.
	IdentityType *HashicorpCloudIamUserPrincipalIdentityType `json:"identity_type,omitempty"`

	// identity_types is an array of the identity types for this user.
	IdentityTypes []*HashicorpCloudIamUserPrincipalIdentityType `json:"identity_types"`

	// scim_synchronized denotes the user principal was synchronized from a
	// customer's IdP using SCIM.
	ScimSynchronized bool `json:"scim_synchronized,omitempty"`

	// subject is the user ID from the authenticating IDP (e.g. Hydra).
	Subject string `json:"subject,omitempty"`
}

// Validate validates this hashicorp cloud iam user principal
func (m *HashicorpCloudIamUserPrincipal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIdentityType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdentityTypes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamUserPrincipal) validateIdentityType(formats strfmt.Registry) error {
	if swag.IsZero(m.IdentityType) { // not required
		return nil
	}

	if m.IdentityType != nil {
		if err := m.IdentityType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("identity_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("identity_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamUserPrincipal) validateIdentityTypes(formats strfmt.Registry) error {
	if swag.IsZero(m.IdentityTypes) { // not required
		return nil
	}

	for i := 0; i < len(m.IdentityTypes); i++ {
		if swag.IsZero(m.IdentityTypes[i]) { // not required
			continue
		}

		if m.IdentityTypes[i] != nil {
			if err := m.IdentityTypes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("identity_types" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("identity_types" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam user principal based on the context it is used
func (m *HashicorpCloudIamUserPrincipal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIdentityType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIdentityTypes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamUserPrincipal) contextValidateIdentityType(ctx context.Context, formats strfmt.Registry) error {

	if m.IdentityType != nil {

		if swag.IsZero(m.IdentityType) { // not required
			return nil
		}

		if err := m.IdentityType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("identity_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("identity_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamUserPrincipal) contextValidateIdentityTypes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IdentityTypes); i++ {

		if m.IdentityTypes[i] != nil {

			if swag.IsZero(m.IdentityTypes[i]) { // not required
				return nil
			}

			if err := m.IdentityTypes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("identity_types" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("identity_types" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamUserPrincipal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamUserPrincipal) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamUserPrincipal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
