mockery
========

Mockery is a project that aims to make the generation of mock implementations of Golang interfaces. The mocks generated in this project are based off of the `github.com/stretchr/testify` suite of packages.

![](https://raw.githubusercontent.com/vektra/mockery/master/docs/Peek%202020-06-28%2000-08.gif)

Why mockery?
-------------

As described in the [documentation](https://pkg.go.dev/github.com/stretchr/testify/mock) for `github.com/stretchr/testify/mock`, fake implementations of your Golang interfaces can be manually curated. These hand-rolled mocks can utilize the `mock` package to direct your mock how it should behave once called, register calls with the package, and assert the way in which the mocks were called. Details of how those mocks are implemented will not be repeated here as it's well-documented on `testify`'s page.

Instead, we provide an automatic way of generating structs that satisfy your interfaces, and interface with `github.com/stretchr/testify/mock` automatically. The methods provided by `mock` are accessible, but we also provide a number of conveniences. Take for example this interface:

```go title="string.go"
package example_project

type Stringer interface {
	String() string
}
```

From this interface, we can generate a mock implementation using Golang reflection and syntax parsing. See this abbreviated snippet that was generated by mockery:

```go title="mock_string.go"
// MockStringer is an autogenerated mock type for the Stringer type
type MockStringer struct {
	mock.Mock
}

type MockStringer_Expecter struct {
	mock *mock.Mock
}

// String provides a mock function with given fields:
func (_m *MockStringer) String() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

type mockConstructorTestingTNewMockStringer interface {
	mock.TestingT
	Cleanup(func())
}

// NewMockStringer creates a new instance of MockStringer. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
func NewMockStringer(t mockConstructorTestingTNewMockStringer) *MockStringer {
	mock := &MockStringer{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
```

[Get Started](/mockery/installation/){ .md-button .md-button--stretch }