package srtp

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Config struct {
	Version              uint32   `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Padding              bool     `protobuf:"varint,2,opt,name=padding,proto3" json:"padding,omitempty"`
	Extension            bool     `protobuf:"varint,3,opt,name=extension,proto3" json:"extension,omitempty"`
	CsrcCount            uint32   `protobuf:"varint,4,opt,name=csrc_count,json=csrcCount,proto3" json:"csrc_count,omitempty"`
	Marker               bool     `protobuf:"varint,5,opt,name=marker,proto3" json:"marker,omitempty"`
	PayloadType          uint32   `protobuf:"varint,6,opt,name=payload_type,json=payloadType,proto3" json:"payload_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Config) Reset()         { *m = Config{} }
func (m *Config) String() string { return proto.CompactTextString(m) }
func (*Config) ProtoMessage()    {}
func (*Config) Descriptor() ([]byte, []int) {
	return fileDescriptor_0aa82c2c1e59b567, []int{0}
}

func (m *Config) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Config.Unmarshal(m, b)
}
func (m *Config) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Config.Marshal(b, m, deterministic)
}
func (m *Config) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Config.Merge(m, src)
}
func (m *Config) XXX_Size() int {
	return xxx_messageInfo_Config.Size(m)
}
func (m *Config) XXX_DiscardUnknown() {
	xxx_messageInfo_Config.DiscardUnknown(m)
}

var xxx_messageInfo_Config proto.InternalMessageInfo

func (m *Config) GetVersion() uint32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Config) GetPadding() bool {
	if m != nil {
		return m.Padding
	}
	return false
}

func (m *Config) GetExtension() bool {
	if m != nil {
		return m.Extension
	}
	return false
}

func (m *Config) GetCsrcCount() uint32 {
	if m != nil {
		return m.CsrcCount
	}
	return 0
}

func (m *Config) GetMarker() bool {
	if m != nil {
		return m.Marker
	}
	return false
}

func (m *Config) GetPayloadType() uint32 {
	if m != nil {
		return m.PayloadType
	}
	return 0
}

func init() {
	proto.RegisterType((*Config)(nil), "v2ray.core.transport.internet.headers.srtp.Config")
}

func init() {
	proto.RegisterFile("v2ray.com/core/transport/internet/headers/srtp/config.proto", fileDescriptor_0aa82c2c1e59b567)
}

var fileDescriptor_0aa82c2c1e59b567 = []byte{
	// 260 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0xd0, 0x31, 0x4b, 0x03, 0x31,
	0x14, 0x07, 0x70, 0xae, 0xd6, 0xd3, 0x46, 0x5d, 0x32, 0x48, 0x06, 0x85, 0xea, 0x54, 0x3a, 0x24,
	0x50, 0x47, 0x37, 0x6f, 0xd1, 0x4d, 0xce, 0xe2, 0xe0, 0x52, 0x62, 0xee, 0x59, 0x0f, 0x6d, 0x12,
	0x5e, 0x9e, 0xc5, 0x7c, 0x25, 0x67, 0x3f, 0xa0, 0x24, 0x5c, 0xea, 0xda, 0x29, 0xfc, 0xff, 0x8f,
	0x5f, 0xe0, 0x3d, 0x76, 0xbb, 0x5d, 0xa0, 0x8e, 0xd2, 0xb8, 0x8d, 0x32, 0x0e, 0x41, 0x11, 0x6a,
	0x1b, 0xbc, 0x43, 0x52, 0xbd, 0x25, 0x40, 0x0b, 0xa4, 0xde, 0x41, 0x77, 0x80, 0x41, 0x05, 0x24,
	0xaf, 0x8c, 0xb3, 0x6f, 0xfd, 0x5a, 0x7a, 0x74, 0xe4, 0xf8, 0xbc, 0x60, 0x04, 0xb9, 0x83, 0xb2,
	0x40, 0x39, 0x40, 0x99, 0xe0, 0xf5, 0x6f, 0xc5, 0xea, 0x26, 0x63, 0x2e, 0xd8, 0xd1, 0x16, 0x30,
	0xf4, 0xce, 0x8a, 0x6a, 0x5a, 0xcd, 0xce, 0xda, 0x12, 0xd3, 0xc4, 0xeb, 0xae, 0xeb, 0xed, 0x5a,
	0x8c, 0xa6, 0xd5, 0xec, 0xb8, 0x2d, 0x91, 0x5f, 0xb0, 0x09, 0x7c, 0x13, 0xd8, 0xac, 0x0e, 0xf2,
	0xec, 0xbf, 0xe0, 0x97, 0x8c, 0x99, 0x80, 0x66, 0x65, 0xdc, 0x97, 0x25, 0x31, 0xce, 0x9f, 0x4e,
	0x52, 0xd3, 0xa4, 0x82, 0x9f, 0xb3, 0x7a, 0xa3, 0xf1, 0x03, 0x50, 0x1c, 0x66, 0x39, 0x24, 0x7e,
	0xc5, 0x4e, 0xbd, 0x8e, 0x9f, 0x4e, 0x77, 0x2b, 0x8a, 0x1e, 0x44, 0x9d, 0xe1, 0xc9, 0xd0, 0x2d,
	0xa3, 0x87, 0x3b, 0x60, 0xe9, 0x36, 0x72, 0xff, 0x45, 0x1f, 0xab, 0x97, 0x71, 0x7a, 0x7f, 0x46,
	0xf3, 0xe7, 0x45, 0xab, 0xa3, 0x6c, 0x12, 0x5a, 0xee, 0xd0, 0x43, 0x41, 0xf7, 0x03, 0x7a, 0x42,
	0xf2, 0xaf, 0x75, 0x3e, 0xe8, 0xcd, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x13, 0x73, 0xfd, 0x63,
	0x8f, 0x01, 0x00, 0x00,
}
