package unidata

// https://tools.ietf.org/html/rfc1345
// grep -v 'ISO-IR' rfc1345.txt |
//   grep -oE '^ .*?   +[0-9a-f]{4}' |
//   sed -E 's/^ ([^ ]*?) +([0-9a-f]{4})/\t0x\2: "\1",/' LL
//
// Manually added:
// =e for 0x20ac €
// =R and =P for 0x20bd (rouble sign)

var Digraphs = map[rune]string{
	0x20ac: `=e`,
	0x20bd: `=R`,

	0x0020: `SP`,
	0x0021: `!`,
	0x0022: `"`,
	0x0023: `Nb`,
	0x0024: `DO`,
	0x0025: `%`,
	0x0026: `&`,
	0x0027: `'`,
	0x0028: `(`,
	0x0029: `)`,
	0x002a: `*`,
	0x002b: `+`,
	0x002c: `,`,
	0x002d: `-`,
	0x002e: `.`,
	0x002f: `/`,
	0x0030: `0`,
	0x0031: `1`,
	0x0032: `2`,
	0x0033: `3`,
	0x0034: `4`,
	0x0035: `5`,
	0x0036: `6`,
	0x0037: `7`,
	0x0038: `8`,
	0x0039: `9`,
	0x003a: `:`,
	0x003b: `;`,
	0x003c: `<`,
	0x003d: `=`,
	0x003e: `>`,
	0x003f: `?`,
	0x0040: `At`,
	0x0041: `A`,
	0x0042: `B`,
	0x0043: `C`,
	0x0044: `D`,
	0x0045: `E`,
	0x0046: `F`,
	0x0047: `G`,
	0x0048: `H`,
	0x0049: `I`,
	0x004a: `J`,
	0x004b: `K`,
	0x004c: `L`,
	0x004d: `M`,
	0x004e: `N`,
	0x004f: `O`,
	0x0050: `P`,
	0x0051: `Q`,
	0x0052: `R`,
	0x0053: `S`,
	0x0054: `T`,
	0x0055: `U`,
	0x0056: `V`,
	0x0057: `W`,
	0x0058: `X`,
	0x0059: `Y`,
	0x005a: `Z`,
	0x005b: `<(`,
	0x005c: `//`,
	0x005d: `)>`,
	0x005e: `'>`,
	0x005f: `_`,
	0x0060: `'!`,
	0x0061: `a`,
	0x0062: `b`,
	0x0063: `c`,
	0x0064: `d`,
	0x0065: `e`,
	0x0066: `f`,
	0x0067: `g`,
	0x0068: `h`,
	0x0069: `i`,
	0x006a: `j`,
	0x006b: `k`,
	0x006c: `l`,
	0x006d: `m`,
	0x006e: `n`,
	0x006f: `o`,
	0x0070: `p`,
	0x0071: `q`,
	0x0072: `r`,
	0x0073: `s`,
	0x0074: `t`,
	0x0075: `u`,
	0x0076: `v`,
	0x0077: `w`,
	0x0078: `x`,
	0x0079: `y`,
	0x007a: `z`,
	0x007b: `(!`,
	0x007c: `!!`,
	0x007d: `!)`,
	0x007e: `'?`,
	0x00a0: `NS`,
	0x00a1: `!I`,
	0x00a2: `Ct`,
	0x00a3: `Pd`,
	0x00a4: `Cu`,
	0x00a5: `Ye`,
	0x00a6: `BB`,
	0x00a7: `SE`,
	0x00a8: `':`,
	0x00a9: `Co`,
	0x00aa: `-a`,
	0x00ab: `<<`,
	0x00ac: `NO`,
	0x00ad: `--`,
	0x00ae: `Rg`,
	0x00af: `'m`,
	0x00b0: `DG`,
	0x00b1: `+-`,
	0x00b2: `2S`,
	0x00b3: `3S`,
	0x00b4: `''`,
	0x00b5: `My`,
	0x00b6: `PI`,
	0x00b7: `.M`,
	0x00b8: `',`,
	0x00b9: `1S`,
	0x00ba: `-o`,
	0x00bb: `>>`,
	0x00bc: `14`,
	0x00bd: `12`,
	0x00be: `34`,
	0x00bf: `?I`,
	0x00c0: `A!`,
	0x00c1: `A'`,
	0x00c2: `A>`,
	0x00c3: `A?`,
	0x00c4: `A:`,
	0x00c5: `AA`,
	0x00c6: `AE`,
	0x00c7: `C,`,
	0x00c8: `E!`,
	0x00c9: `E'`,
	0x00ca: `E>`,
	0x00cb: `E:`,
	0x00cc: `I!`,
	0x00cd: `I'`,
	0x00ce: `I>`,
	0x00cf: `I:`,
	0x00d0: `D-`,
	0x00d1: `N?`,
	0x00d2: `O!`,
	0x00d3: `O'`,
	0x00d4: `O>`,
	0x00d5: `O?`,
	0x00d6: `O:`,
	0x00d7: `*X`,
	0x00d8: `O/`,
	0x00d9: `U!`,
	0x00da: `U'`,
	0x00db: `U>`,
	0x00dc: `U:`,
	0x00dd: `Y'`,
	0x00de: `TH`,
	0x00df: `ss`,
	0x00e0: `a!`,
	0x00e1: `a'`,
	0x00e2: `a>`,
	0x00e3: `a?`,
	0x00e4: `a:`,
	0x00e5: `aa`,
	0x00e6: `ae`,
	0x00e7: `c,`,
	0x00e8: `e!`,
	0x00e9: `e'`,
	0x00ea: `e>`,
	0x00eb: `e:`,
	0x00ec: `i!`,
	0x00ed: `i'`,
	0x00ee: `i>`,
	0x00ef: `i:`,
	0x00f0: `d-`,
	0x00f1: `n?`,
	0x00f2: `o!`,
	0x00f3: `o'`,
	0x00f4: `o>`,
	0x00f5: `o?`,
	0x00f6: `o:`,
	0x00f7: `-:`,
	0x00f8: `o/`,
	0x00f9: `u!`,
	0x00fa: `u'`,
	0x00fb: `u>`,
	0x00fc: `u:`,
	0x00fd: `y'`,
	0x00fe: `th`,
	0x00ff: `y:`,
	0x0100: `A-`,
	0x0101: `a-`,
	0x0102: `A(`,
	0x0103: `a(`,
	0x0104: `A;`,
	0x0105: `a;`,
	0x0106: `C'`,
	0x0107: `c'`,
	0x0108: `C>`,
	0x0109: `c>`,
	0x010a: `C.`,
	0x010b: `c.`,
	0x010c: `C<`,
	0x010d: `c<`,
	0x010e: `D<`,
	0x010f: `d<`,
	0x0110: `D/`,
	0x0111: `d/`,
	0x0112: `E-`,
	0x0113: `e-`,
	0x0114: `E(`,
	0x0115: `e(`,
	0x0116: `E.`,
	0x0117: `e.`,
	0x0118: `E;`,
	0x0119: `e;`,
	0x011a: `E<`,
	0x011b: `e<`,
	0x011c: `G>`,
	0x011d: `g>`,
	0x011e: `G(`,
	0x011f: `g(`,
	0x0120: `G.`,
	0x0121: `g.`,
	0x0122: `G,`,
	0x0123: `g,`,
	0x0124: `H>`,
	0x0125: `h>`,
	0x0126: `H/`,
	0x0127: `h/`,
	0x0128: `I?`,
	0x0129: `i?`,
	0x012a: `I-`,
	0x012b: `i-`,
	0x012c: `I(`,
	0x012d: `i(`,
	0x012e: `I;`,
	0x012f: `i;`,
	0x0130: `I.`,
	0x0131: `i.`,
	0x0132: `IJ`,
	0x0133: `ij`,
	0x0134: `J>`,
	0x0135: `j>`,
	0x0136: `K,`,
	0x0137: `k,`,
	0x0138: `kk`,
	0x0139: `L'`,
	0x013a: `l'`,
	0x013b: `L,`,
	0x013c: `l,`,
	0x013d: `L<`,
	0x013e: `l<`,
	0x013f: `L.`,
	0x0140: `l.`,
	0x0141: `L/`,
	0x0142: `l/`,
	0x0143: `N'`,
	0x0144: `n'`,
	0x0145: `N,`,
	0x0146: `n,`,
	0x0147: `N<`,
	0x0148: `n<`,
	0x0149: `'n`,
	0x014a: `NG`,
	0x014b: `ng`,
	0x014c: `O-`,
	0x014d: `o-`,
	0x014e: `O(`,
	0x014f: `o(`,
	0x0150: `O"`,
	0x0151: `o"`,
	0x0152: `OE`,
	0x0153: `oe`,
	0x0154: `R'`,
	0x0155: `r'`,
	0x0156: `R,`,
	0x0157: `r,`,
	0x0158: `R<`,
	0x0159: `r<`,
	0x015a: `S'`,
	0x015b: `s'`,
	0x015c: `S>`,
	0x015d: `s>`,
	0x015e: `S,`,
	0x015f: `s,`,
	0x0160: `S<`,
	0x0161: `s<`,
	0x0162: `T,`,
	0x0163: `t,`,
	0x0164: `T<`,
	0x0165: `t<`,
	0x0166: `T/`,
	0x0167: `t/`,
	0x0168: `U?`,
	0x0169: `u?`,
	0x016a: `U-`,
	0x016b: `u-`,
	0x016c: `U(`,
	0x016d: `u(`,
	0x016e: `U0`,
	0x016f: `u0`,
	0x0170: `U"`,
	0x0171: `u"`,
	0x0172: `U;`,
	0x0173: `u;`,
	0x0174: `W>`,
	0x0175: `w>`,
	0x0176: `Y>`,
	0x0177: `y>`,
	0x0178: `Y:`,
	0x0179: `Z'`,
	0x017a: `z'`,
	0x017b: `Z.`,
	0x017c: `z.`,
	0x017d: `Z<`,
	0x017e: `z<`,
	0x01a0: `O9`,
	0x01a1: `o9`,
	0x01a2: `OI`,
	0x01a3: `oi`,
	0x01a6: `yr`,
	0x01af: `U9`,
	0x01b0: `u9`,
	0x01b5: `Z/`,
	0x01b6: `z/`,
	0x01b7: `ED`,
	0x01cd: `A<`,
	0x01ce: `a<`,
	0x01cf: `I<`,
	0x01d0: `i<`,
	0x01d1: `O<`,
	0x01d2: `o<`,
	0x01d3: `U<`,
	0x01d4: `u<`,
	0x01d5: `U:-`,
	0x01d6: `u:-`,
	0x01d7: `U:'`,
	0x01d8: `u:'`,
	0x01d9: `U:<`,
	0x01da: `u:<`,
	0x01db: `U:!`,
	0x01dc: `u:!`,
	0x01de: `A1`,
	0x01df: `a1`,
	0x01e0: `A7`,
	0x01e1: `a7`,
	0x01e2: `A3`,
	0x01e3: `a3`,
	0x01e4: `G/`,
	0x01e5: `g/`,
	0x01e6: `G<`,
	0x01e7: `g<`,
	0x01e8: `K<`,
	0x01e9: `k<`,
	0x01ea: `O;`,
	0x01eb: `o;`,
	0x01ec: `O1`,
	0x01ed: `o1`,
	0x01ee: `EZ`,
	0x01ef: `ez`,
	0x01f0: `j<`,
	0x01f4: `G'`,
	0x01f5: `g'`,
	0x01fa: `AA'`,
	0x01fb: `aa'`,
	0x01fc: `AE'`,
	0x01fd: `ae'`,
	0x01fe: `O/'`,
	0x01ff: `o/'`,
	0x02bf: `;S`,
	0x02c7: `'<`,
	0x02d8: `'(`,
	0x02d9: `'.`,
	0x02da: `'0`,
	0x02db: `';`,
	0x02dd: `'"`,
	0x0386: `A%`,
	0x0388: `E%`,
	0x0389: `Y%`,
	0x038a: `I%`,
	0x038c: `O%`,
	0x038e: `U%`,
	0x038f: `W%`,
	0x0390: `i3`,
	0x0391: `A*`,
	0x0392: `B*`,
	0x0393: `G*`,
	0x0394: `D*`,
	0x0395: `E*`,
	0x0396: `Z*`,
	0x0397: `Y*`,
	0x0398: `H*`,
	0x0399: `I*`,
	0x039a: `K*`,
	0x039b: `L*`,
	0x039c: `M*`,
	0x039d: `N*`,
	0x039e: `C*`,
	0x039f: `O*`,
	0x03a0: `P*`,
	0x03a1: `R*`,
	0x03a3: `S*`,
	0x03a4: `T*`,
	0x03a5: `U*`,
	0x03a6: `F*`,
	0x03a7: `X*`,
	0x03a8: `Q*`,
	0x03a9: `W*`,
	0x03aa: `J*`,
	0x03ab: `V*`,
	0x03ac: `a%`,
	0x03ad: `e%`,
	0x03ae: `y%`,
	0x03af: `i%`,
	0x03b0: `u3`,
	0x03b1: `a*`,
	0x03b2: `b*`,
	0x03b3: `g*`,
	0x03b4: `d*`,
	0x03b5: `e*`,
	0x03b6: `z*`,
	0x03b7: `y*`,
	0x03b8: `h*`,
	0x03b9: `i*`,
	0x03ba: `k*`,
	0x03bb: `l*`,
	0x03bc: `m*`,
	0x03bd: `n*`,
	0x03be: `c*`,
	0x03bf: `o*`,
	0x03c0: `p*`,
	0x03c1: `r*`,
	0x03c2: `*s`,
	0x03c3: `s*`,
	0x03c4: `t*`,
	0x03c5: `u*`,
	0x03c6: `f*`,
	0x03c7: `x*`,
	0x03c8: `q*`,
	0x03c9: `w*`,
	0x03ca: `j*`,
	0x03cb: `v*`,
	0x03cc: `o%`,
	0x03cd: `u%`,
	0x03ce: `w%`,
	0x03d8: `'G`,
	0x03d9: `,G`,
	0x03da: `T3`,
	0x03db: `t3`,
	0x03dc: `M3`,
	0x03dd: `m3`,
	0x03de: `K3`,
	0x03df: `k3`,
	0x03e0: `P3`,
	0x03e1: `p3`,
	0x03f4: `'%`,
	0x03f5: `j3`,
	0x0401: `IO`,
	0x0402: `D%`,
	0x0403: `G%`,
	0x0404: `IE`,
	0x0405: `DS`,
	0x0406: `II`,
	0x0407: `YI`,
	0x0408: `J%`,
	0x0409: `LJ`,
	0x040a: `NJ`,
	0x040b: `Ts`,
	0x040c: `KJ`,
	0x040e: `V%`,
	0x040f: `DZ`,
	0x0410: `A=`,
	0x0411: `B=`,
	0x0412: `V=`,
	0x0413: `G=`,
	0x0414: `D=`,
	0x0415: `E=`,
	0x0416: `Z%`,
	0x0417: `Z=`,
	0x0418: `I=`,
	0x0419: `J=`,
	0x041a: `K=`,
	0x041b: `L=`,
	0x041c: `M=`,
	0x041d: `N=`,
	0x041e: `O=`,
	0x041f: `P=`,
	0x0420: `R=`,
	0x0421: `S=`,
	0x0422: `T=`,
	0x0423: `U=`,
	0x0424: `F=`,
	0x0425: `H=`,
	0x0426: `C=`,
	0x0427: `C%`,
	0x0428: `S%`,
	0x0429: `Sc`,
	0x042a: `="`,
	0x042b: `Y=`,
	0x042c: `%"`,
	0x042d: `JE`,
	0x042e: `JU`,
	0x042f: `JA`,
	0x0430: `a=`,
	0x0431: `b=`,
	0x0432: `v=`,
	0x0433: `g=`,
	0x0434: `d=`,
	0x0435: `e=`,
	0x0436: `z%`,
	0x0437: `z=`,
	0x0438: `i=`,
	0x0439: `j=`,
	0x043a: `k=`,
	0x043b: `l=`,
	0x043c: `m=`,
	0x043d: `n=`,
	0x043e: `o=`,
	0x043f: `p=`,
	0x0440: `r=`,
	0x0441: `s=`,
	0x0442: `t=`,
	0x0443: `u=`,
	0x0444: `f=`,
	0x0445: `h=`,
	0x0446: `c=`,
	0x0447: `c%`,
	0x0448: `s%`,
	0x0449: `sc`,
	0x044a: `='`,
	0x044b: `y=`,
	0x044c: `%'`,
	0x044d: `je`,
	0x044e: `ju`,
	0x044f: `ja`,
	0x0451: `io`,
	0x0452: `d%`,
	0x0453: `g%`,
	0x0454: `ie`,
	0x0455: `ds`,
	0x0456: `ii`,
	0x0457: `yi`,
	0x0458: `j%`,
	0x0459: `lj`,
	0x045a: `nj`,
	0x045b: `ts`,
	0x045c: `kj`,
	0x045e: `v%`,
	0x045f: `dz`,
	0x0462: `Y3`,
	0x0463: `y3`,
	0x046a: `O3`,
	0x046b: `o3`,
	0x0472: `F3`,
	0x0473: `f3`,
	0x0474: `V3`,
	0x0475: `v3`,
	0x0480: `C3`,
	0x0481: `c3`,
	0x0490: `G3`,
	0x0491: `g3`,
	0x05d0: `A+`,
	0x05d1: `B+`,
	0x05d2: `G+`,
	0x05d3: `D+`,
	0x05d4: `H+`,
	0x05d5: `W+`,
	0x05d6: `Z+`,
	0x05d7: `X+`,
	0x05d8: `Tj`,
	0x05d9: `J+`,
	0x05da: `K%`,
	0x05db: `K+`,
	0x05dc: `L+`,
	0x05dd: `M%`,
	0x05de: `M+`,
	0x05df: `N%`,
	0x05e0: `N+`,
	0x05e1: `S+`,
	0x05e2: `E+`,
	0x05e3: `P%`,
	0x05e4: `P+`,
	0x05e5: `Zj`,
	0x05e6: `ZJ`,
	0x05e7: `Q+`,
	0x05e8: `R+`,
	0x05e9: `Sh`,
	0x05ea: `T+`,
	0x060c: `,+`,
	0x061b: `;+`,
	0x061f: `?+`,
	0x0621: `H'`,
	0x0622: `aM`,
	0x0623: `aH`,
	0x0624: `wH`,
	0x0625: `ah`,
	0x0626: `yH`,
	0x0627: `a+`,
	0x0628: `b+`,
	0x0629: `tm`,
	0x062a: `t+`,
	0x062b: `tk`,
	0x062c: `g+`,
	0x062d: `hk`,
	0x062e: `x+`,
	0x062f: `d+`,
	0x0630: `dk`,
	0x0631: `r+`,
	0x0632: `z+`,
	0x0633: `s+`,
	0x0634: `sn`,
	0x0635: `c+`,
	0x0636: `dd`,
	0x0637: `tj`,
	0x0638: `zH`,
	0x0639: `e+`,
	0x063a: `i+`,
	0x0640: `++`,
	0x0641: `f+`,
	0x0642: `q+`,
	0x0643: `k+`,
	0x0644: `l+`,
	0x0645: `m+`,
	0x0646: `n+`,
	0x0647: `h+`,
	0x0648: `w+`,
	0x0649: `j+`,
	0x064a: `y+`,
	0x064b: `:+`,
	0x064c: `"+`,
	0x064d: `=+`,
	0x064e: `/+`,
	0x064f: `'+`,
	0x0650: `1+`,
	0x0651: `3+`,
	0x0652: `0+`,
	0x0670: `aS`,
	0x067e: `p+`,
	0x06a4: `v+`,
	0x06af: `gf`,
	0x06f0: `0a`,
	0x06f1: `1a`,
	0x06f2: `2a`,
	0x06f3: `3a`,
	0x06f4: `4a`,
	0x06f5: `5a`,
	0x06f6: `6a`,
	0x06f7: `7a`,
	0x06f8: `8a`,
	0x06f9: `9a`,
	0x1e00: `A-0`,
	0x1e01: `a-0`,
	0x1e02: `B.`,
	0x1e03: `b.`,
	0x1e04: `B-.`,
	0x1e05: `b-.`,
	0x1e06: `B_`,
	0x1e07: `b_`,
	0x1e08: `C,'`,
	0x1e09: `c,'`,
	0x1e0a: `D.`,
	0x1e0b: `d.`,
	0x1e0c: `D-.`,
	0x1e0d: `d-.`,
	0x1e0e: `D_`,
	0x1e0f: `d_`,
	0x1e10: `D,`,
	0x1e11: `d,`,
	0x1e12: `D->`,
	0x1e13: `d->`,
	0x1e14: `E-!`,
	0x1e15: `e-!`,
	0x1e16: `E-'`,
	0x1e17: `e-'`,
	0x1e18: `E->`,
	0x1e19: `e->`,
	0x1e1a: `E-?`,
	0x1e1b: `e-?`,
	0x1e1c: `E,(`,
	0x1e1d: `e,(`,
	0x1e1e: `F.`,
	0x1e1f: `f.`,
	0x1e20: `G-`,
	0x1e21: `g-`,
	0x1e22: `H.`,
	0x1e23: `h.`,
	0x1e24: `H-.`,
	0x1e25: `h-.`,
	0x1e26: `H:`,
	0x1e27: `h:`,
	0x1e28: `H,`,
	0x1e29: `h,`,
	0x1e2a: `H-(`,
	0x1e2b: `h-(`,
	0x1e2c: `I-?`,
	0x1e2d: `i-?`,
	0x1e2e: `I:'`,
	0x1e2f: `i:'`,
	0x1e30: `K'`,
	0x1e31: `k'`,
	0x1e32: `K-.`,
	0x1e33: `k-.`,
	0x1e34: `K_`,
	0x1e35: `k_`,
	0x1e36: `L-.`,
	0x1e37: `l-.`,
	0x1e38: `L--.`,
	0x1e39: `l--.`,
	0x1e3a: `L_`,
	0x1e3b: `l_`,
	0x1e3c: `L->`,
	0x1e3d: `l->`,
	0x1e3e: `M'`,
	0x1e3f: `m'`,
	0x1e40: `M.`,
	0x1e41: `m.`,
	0x1e42: `M-.`,
	0x1e43: `m-.`,
	0x1e44: `N.`,
	0x1e45: `n.`,
	0x1e46: `N-.`,
	0x1e47: `n-.`,
	0x1e48: `N_`,
	0x1e49: `n_`,
	0x1e4a: `N->`,
	0x1e4b: `N->`,
	0x1e4c: `O?'`,
	0x1e4d: `o?'`,
	0x1e4e: `O?:`,
	0x1e4f: `o?:`,
	0x1e50: `O-!`,
	0x1e51: `o-!`,
	0x1e52: `O-'`,
	0x1e53: `o-'`,
	0x1e54: `P'`,
	0x1e55: `p'`,
	0x1e56: `P.`,
	0x1e57: `p.`,
	0x1e58: `R.`,
	0x1e59: `r.`,
	0x1e5a: `R-.`,
	0x1e5b: `r-.`,
	0x1e5c: `R--.`,
	0x1e5d: `r--.`,
	0x1e5e: `R_`,
	0x1e5f: `r_`,
	0x1e60: `S.`,
	0x1e61: `s.`,
	0x1e62: `S-.`,
	0x1e63: `s-.`,
	0x1e64: `S'.`,
	0x1e65: `s'.`,
	0x1e66: `S<.`,
	0x1e67: `s<.`,
	0x1e68: `S.-.`,
	0x1e69: `S.-.`,
	0x1e6a: `T.`,
	0x1e6b: `t.`,
	0x1e6c: `T-.`,
	0x1e6d: `t-.`,
	0x1e6e: `T_`,
	0x1e6f: `t_`,
	0x1e70: `T->`,
	0x1e71: `t->`,
	0x1e72: `U--:`,
	0x1e73: `u--:`,
	0x1e74: `U-?`,
	0x1e75: `u-?`,
	0x1e76: `U->`,
	0x1e77: `u->`,
	0x1e78: `U?'`,
	0x1e79: `u?'`,
	0x1e7a: `U-:`,
	0x1e7b: `u-:`,
	0x1e7c: `V?`,
	0x1e7d: `v?`,
	0x1e7e: `V-.`,
	0x1e7f: `v-.`,
	0x1e80: `W!`,
	0x1e81: `w!`,
	0x1e82: `W'`,
	0x1e83: `w'`,
	0x1e84: `W:`,
	0x1e85: `w:`,
	0x1e86: `W.`,
	0x1e87: `w.`,
	0x1e88: `W-.`,
	0x1e89: `w-.`,
	0x1e8a: `X.`,
	0x1e8b: `x.`,
	0x1e8c: `X:`,
	0x1e8d: `x:`,
	0x1e8e: `Y.`,
	0x1e8f: `y.`,
	0x1e90: `Z>`,
	0x1e91: `z>`,
	0x1e92: `Z-.`,
	0x1e93: `z-.`,
	0x1e94: `Z_`,
	0x1e95: `z_`,
	0x1e96: `h_`,
	0x1e97: `t:`,
	0x1e98: `w0`,
	0x1e99: `y0`,
	0x1ea0: `A-.`,
	0x1ea1: `a-.`,
	0x1ea2: `A2`,
	0x1ea3: `a2`,
	0x1ea4: `A>'`,
	0x1ea5: `a>'`,
	0x1ea6: `A>!`,
	0x1ea7: `a>!`,
	0x1ea8: `A>2`,
	0x1ea9: `a>2`,
	0x1eaa: `A>?`,
	0x1eab: `a>?`,
	0x1eac: `A>-.`,
	0x1ead: `a>-.`,
	0x1eae: `A('`,
	0x1eaf: `a('`,
	0x1eb0: `A(!`,
	0x1eb1: `a(!`,
	0x1eb2: `A(2`,
	0x1eb3: `a(2`,
	0x1eb4: `A(?`,
	0x1eb5: `a(?`,
	0x1eb6: `A(-.`,
	0x1eb7: `a(-.`,
	0x1eb8: `E-.`,
	0x1eb9: `e-.`,
	0x1eba: `E2`,
	0x1ebb: `e2`,
	0x1ebc: `E?`,
	0x1ebd: `e?`,
	0x1ebe: `E>'`,
	0x1ebf: `e>'`,
	0x1ec0: `E>!`,
	0x1ec1: `e>!`,
	0x1ec2: `E>2`,
	0x1ec3: `e>2`,
	0x1ec4: `E>?`,
	0x1ec5: `e>?`,
	0x1ec6: `E>-.`,
	0x1ec7: `e>-.`,
	0x1ec8: `I2`,
	0x1ec9: `i2`,
	0x1eca: `I-.`,
	0x1ecb: `i-.`,
	0x1ecc: `O-.`,
	0x1ecd: `o-.`,
	0x1ece: `O2`,
	0x1ecf: `o2`,
	0x1ed0: `O>'`,
	0x1ed1: `o>'`,
	0x1ed2: `O>!`,
	0x1ed3: `o>!`,
	0x1ed4: `O>2`,
	0x1ed5: `o>2`,
	0x1ed6: `O>?`,
	0x1ed7: `o>?`,
	0x1ed8: `O>-.`,
	0x1ed9: `o>-.`,
	0x1eda: `O9'`,
	0x1edb: `o9'`,
	0x1edc: `O9!`,
	0x1edd: `o9!`,
	0x1ede: `O92`,
	0x1edf: `o92`,
	0x1ee0: `O9?`,
	0x1ee1: `o9?`,
	0x1ee2: `O9-.`,
	0x1ee3: `o9-.`,
	0x1ee4: `U-.`,
	0x1ee5: `u-.`,
	0x1ee6: `U2`,
	0x1ee7: `u2`,
	0x1ee8: `U9'`,
	0x1ee9: `u9'`,
	0x1eea: `U9!`,
	0x1eeb: `u9!`,
	0x1eec: `U92`,
	0x1eed: `u92`,
	0x1eee: `U9?`,
	0x1eef: `u9?`,
	0x1ef0: `U9-.`,
	0x1ef1: `u9-.`,
	0x1ef2: `Y!`,
	0x1ef3: `y!`,
	0x1ef4: `Y-.`,
	0x1ef5: `y-.`,
	0x1ef6: `Y2`,
	0x1ef7: `y2`,
	0x1ef8: `Y?`,
	0x1ef9: `y?`,
	0x1f00: `;'`,
	0x1f01: `,'`,
	0x1f02: `;!`,
	0x1f03: `,!`,
	0x1f04: `?;`,
	0x1f05: `?,`,
	0x1f06: `!:`,
	0x1f07: `?:`,
	0x2002: `1N`,
	0x2003: `1M`,
	0x2004: `3M`,
	0x2005: `4M`,
	0x2006: `6M`,
	0x2009: `1T`,
	0x200a: `1H`,
	0x2010: `-1`,
	0x2013: `-N`,
	0x2014: `-M`,
	0x2015: `-3`,
	0x2016: `!2`,
	0x2017: `=2`,
	0x2018: `'6`,
	0x2019: `'9`,
	0x201a: `.9`,
	0x201b: `9'`,
	0x201c: `"6`,
	0x201d: `"9`,
	0x201e: `:9`,
	0x201f: `9"`,
	0x2020: `/-`,
	0x2021: `/=`,
	0x2025: `..`,
	0x2030: `%0`,
	0x2032: `1'`,
	0x2033: `2'`,
	0x2034: `3'`,
	0x2035: `1"`,
	0x2036: `2"`,
	0x2037: `3"`,
	0x2038: `Ca`,
	0x2039: `<1`,
	0x203a: `>1`,
	0x203b: `:X`,
	0x203c: `!*2`,
	0x203e: `'-`,
	0x2044: `/f`,
	0x2070: `0S`,
	0x2074: `4S`,
	0x2075: `5S`,
	0x2076: `6S`,
	0x2077: `7S`,
	0x2078: `8S`,
	0x2079: `9S`,
	0x207a: `+S`,
	0x207b: `-S`,
	0x207c: `=S`,
	0x207d: `(S`,
	0x207e: `)S`,
	0x207f: `nS`,
	0x2080: `0s`,
	0x2081: `1s`,
	0x2082: `2s`,
	0x2083: `3s`,
	0x2084: `4s`,
	0x2085: `5s`,
	0x2086: `6s`,
	0x2087: `7s`,
	0x2088: `8s`,
	0x2089: `9s`,
	0x208a: `+s`,
	0x208b: `-s`,
	0x208c: `=s`,
	0x208d: `(s`,
	0x208e: `)s`,
	0x20a4: `Li`,
	0x20a7: `Pt`,
	0x20a9: `W=`,
	0x2103: `oC`,
	0x2105: `co`,
	0x2109: `oF`,
	0x2116: `N0`,
	0x2117: `PO`,
	0x211e: `Rx`,
	0x2120: `SM`,
	0x2122: `TM`,
	0x2126: `Om`,
	0x212b: `AO`,
	0x2153: `13`,
	0x2154: `23`,
	0x2155: `15`,
	0x2156: `25`,
	0x2157: `35`,
	0x2158: `45`,
	0x2159: `16`,
	0x215a: `56`,
	0x215b: `18`,
	0x215c: `38`,
	0x215d: `58`,
	0x215e: `78`,
	0x2160: `1R`,
	0x2161: `2R`,
	0x2162: `3R`,
	0x2163: `4R`,
	0x2164: `5R`,
	0x2165: `6R`,
	0x2166: `7R`,
	0x2167: `8R`,
	0x2168: `9R`,
	0x2169: `aR`,
	0x216a: `bR`,
	0x216b: `cR`,
	0x216c: `50R`,
	0x216d: `100R`,
	0x216e: `500R`,
	0x2170: `1r`,
	0x2171: `2r`,
	0x2172: `3r`,
	0x2173: `4r`,
	0x2174: `5r`,
	0x2175: `6r`,
	0x2176: `7r`,
	0x2177: `8r`,
	0x2178: `9r`,
	0x2179: `ar`,
	0x217a: `br`,
	0x217b: `cr`,
	0x217c: `50r`,
	0x217d: `100r`,
	0x217e: `500r`,
	0x2180: `1000RCD`,
	0x2190: `<-`,
	0x2191: `-!`,
	0x2192: `->`,
	0x2193: `-v`,
	0x2194: `<>`,
	0x2195: `UD`,
	0x2196: `<!!`,
	0x2197: `//>`,
	0x2198: `!!>`,
	0x2199: `<//`,
	0x21d0: `<=`,
	0x21d2: `=>`,
	0x21d4: `==`,
	0x2200: `FA`,
	0x2202: `dP`,
	0x2203: `TE`,
	0x2205: `/0`,
	0x2206: `DE`,
	0x2207: `NB`,
	0x2208: `(-`,
	0x220b: `-)`,
	0x220f: `*P`,
	0x2211: `+Z`,
	0x2212: `-2`,
	0x2213: `-+`,
	0x2217: `*-`,
	0x2218: `Ob`,
	0x2219: `Sb`,
	0x221a: `RT`,
	0x221d: `0(`,
	0x221e: `00`,
	0x221f: `-L`,
	0x2220: `-V`,
	0x2225: `PP`,
	0x2227: `AN`,
	0x2228: `OR`,
	0x2229: `(U`,
	0x222a: `)U`,
	0x222b: `In`,
	0x222c: `DI`,
	0x222e: `Io`,
	0x2234: `.:`,
	0x2235: `:.`,
	0x2236: `:R`,
	0x2237: `::`,
	0x223c: `?1`,
	0x223e: `CG`,
	0x2243: `?-`,
	0x2245: `?=`,
	0x2248: `?2`,
	0x224c: `=?`,
	0x2253: `HI`,
	0x2260: `!=`,
	0x2261: `=3`,
	0x2264: `=<`,
	0x2265: `>=`,
	0x226a: `<*`,
	0x226b: `*>`,
	0x226e: `!<`,
	0x226f: `!>`,
	0x2282: `(C`,
	0x2283: `)C`,
	0x2286: `(_`,
	0x2287: `)_`,
	0x2299: `0.`,
	0x229a: `02`,
	0x22a5: `-T`,
	0x22c5: `.P`,
	0x22ee: `:3`,
	0x22ef: `.3`,
	0x2302: `Eh`,
	0x2308: `<7`,
	0x2309: `>7`,
	0x230a: `7<`,
	0x230b: `7>`,
	0x2310: `NI`,
	0x2312: `(A`,
	0x2315: `TR`,
	0x2320: `Iu`,
	0x2321: `Il`,
	0x2329: `</`,
	0x232a: `/>`,
	0x2423: `Vs`,
	0x2440: `1h`,
	0x2441: `3h`,
	0x2442: `2h`,
	0x2443: `4h`,
	0x2446: `1j`,
	0x2447: `2j`,
	0x2448: `3j`,
	0x2449: `4j`,
	0x2460: `1-o`,
	0x2461: `2-o`,
	0x2462: `3-o`,
	0x2463: `4-o`,
	0x2464: `5-o`,
	0x2465: `6-o`,
	0x2466: `7-o`,
	0x2467: `8-o`,
	0x2468: `9-o`,
	0x2469: `10-o`,
	0x246a: `11-o`,
	0x246b: `12-o`,
	0x246c: `13-o`,
	0x246d: `14-o`,
	0x246e: `15-o`,
	0x246f: `16-o`,
	0x2470: `17-o`,
	0x2471: `18-o`,
	0x2472: `19-o`,
	0x2473: `20-o`,
	0x2474: `(1)`,
	0x2475: `(2)`,
	0x2476: `(3)`,
	0x2477: `(4)`,
	0x2478: `(5)`,
	0x2479: `(6)`,
	0x247a: `(7)`,
	0x247b: `(8)`,
	0x247c: `(9)`,
	0x247d: `(10)`,
	0x247e: `(11)`,
	0x247f: `(12)`,
	0x2480: `(13)`,
	0x2481: `(14)`,
	0x2482: `(15)`,
	0x2483: `(16)`,
	0x2484: `(17)`,
	0x2485: `(18)`,
	0x2486: `(19)`,
	0x2487: `(20)`,
	0x2488: `1.`,
	0x2489: `2.`,
	0x248a: `3.`,
	0x248b: `4.`,
	0x248c: `5.`,
	0x248d: `6.`,
	0x248e: `7.`,
	0x248f: `8.`,
	0x2490: `9.`,
	0x2491: `10.`,
	0x2492: `11.`,
	0x2493: `12.`,
	0x2494: `13.`,
	0x2495: `14.`,
	0x2496: `15.`,
	0x2497: `16.`,
	0x2498: `17.`,
	0x2499: `18.`,
	0x249a: `19.`,
	0x249b: `20.`,
	0x249c: `(a)`,
	0x249d: `(b)`,
	0x249e: `(c)`,
	0x249f: `(d)`,
	0x24a0: `(e)`,
	0x24a1: `(f)`,
	0x24a2: `(g)`,
	0x24a3: `(h)`,
	0x24a4: `(i)`,
	0x24a5: `(j)`,
	0x24a6: `(k)`,
	0x24a7: `(l)`,
	0x24a8: `(m)`,
	0x24a9: `(n)`,
	0x24aa: `(o)`,
	0x24ab: `(p)`,
	0x24ac: `(q)`,
	0x24ad: `(r)`,
	0x24ae: `(s)`,
	0x24af: `(t)`,
	0x24b0: `(u)`,
	0x24b1: `(v)`,
	0x24b2: `(w)`,
	0x24b3: `(x)`,
	0x24b4: `(y)`,
	0x24b5: `(z)`,
	0x24b6: `A-o`,
	0x24b7: `B-o`,
	0x24b8: `C-o`,
	0x24b9: `D-o`,
	0x24ba: `E-o`,
	0x24bb: `F-o`,
	0x24bc: `G-o`,
	0x24bd: `H-o`,
	0x24be: `I-o`,
	0x24bf: `J-o`,
	0x24c0: `K-o`,
	0x24c1: `L-o`,
	0x24c2: `M-o`,
	0x24c3: `N-o`,
	0x24c4: `O-o`,
	0x24c5: `P-o`,
	0x24c6: `Q-o`,
	0x24c7: `R-o`,
	0x24c8: `S-o`,
	0x24c9: `T-o`,
	0x24ca: `U-o`,
	0x24cb: `V-o`,
	0x24cc: `W-o`,
	0x24cd: `X-o`,
	0x24ce: `Y-o`,
	0x24cf: `Z-o`,
	0x24d0: `a-o`,
	0x24d1: `b-o`,
	0x24d2: `c-o`,
	0x24d3: `d-o`,
	0x24d4: `e-o`,
	0x24d5: `f-o`,
	0x24d6: `g-o`,
	0x24d7: `h-o`,
	0x24d8: `i-o`,
	0x24d9: `j-o`,
	0x24da: `k-o`,
	0x24db: `l-o`,
	0x24dc: `m-o`,
	0x24dd: `n-o`,
	0x24de: `o-o`,
	0x24df: `p-o`,
	0x24e0: `q-o`,
	0x24e1: `r-o`,
	0x24e2: `s-o`,
	0x24e3: `t-o`,
	0x24e4: `u-o`,
	0x24e5: `v-o`,
	0x24e6: `w-o`,
	0x24e7: `x-o`,
	0x24e8: `y-o`,
	0x24e9: `z-o`,
	0x24ea: `0-o`,
	0x2500: `hh`,
	0x2501: `HH`,
	0x2502: `vv`,
	0x2503: `VV`,
	0x2504: `3-`,
	0x2505: `3_`,
	0x2506: `3!`,
	0x2507: `3/`,
	0x2508: `4-`,
	0x2509: `4_`,
	0x250a: `4!`,
	0x250b: `4/`,
	0x250c: `dr`,
	0x250d: `dR`,
	0x250e: `Dr`,
	0x250f: `DR`,
	0x2510: `dl`,
	0x2511: `dL`,
	0x2512: `Dl`,
	0x2513: `LD`,
	0x2514: `ur`,
	0x2515: `uR`,
	0x2516: `Ur`,
	0x2517: `UR`,
	0x2518: `ul`,
	0x2519: `uL`,
	0x251a: `Ul`,
	0x251b: `UL`,
	0x251c: `vr`,
	0x251d: `vR`,
	0x251e: `Udr`,
	0x251f: `uDr`,
	0x2520: `Vr`,
	0x2521: `UdR`,
	0x2522: `uDR`,
	0x2523: `VR`,
	0x2524: `vl`,
	0x2525: `vL`,
	0x2526: `Udl`,
	0x2527: `uDl`,
	0x2528: `Vl`,
	0x2529: `UdL`,
	0x252a: `uDL`,
	0x252b: `VL`,
	0x252c: `dh`,
	0x252d: `dLr`,
	0x252e: `dlR`,
	0x252f: `dH`,
	0x2530: `Dh`,
	0x2531: `DLr`,
	0x2532: `DlR`,
	0x2533: `DH`,
	0x2534: `uh`,
	0x2535: `uLr`,
	0x2536: `ulR`,
	0x2537: `uH`,
	0x2538: `Uh`,
	0x2539: `ULr`,
	0x253a: `UlR`,
	0x253b: `UH`,
	0x253c: `vh`,
	0x253d: `vLr`,
	0x253e: `vlR`,
	0x253f: `vH`,
	0x2540: `Udh`,
	0x2541: `uDh`,
	0x2542: `Vh`,
	0x2543: `UdLr`,
	0x2544: `UdlR`,
	0x2545: `uDLr`,
	0x2546: `uDlR`,
	0x2547: `UdH`,
	0x2548: `uDH`,
	0x2549: `VLr`,
	0x254a: `VlR`,
	0x254b: `VH`,
	0x2571: `FD`,
	0x2572: `BD`,
	0x2580: `TB`,
	0x2584: `LB`,
	0x2588: `FB`,
	0x258c: `lB`,
	0x2590: `RB`,
	0x2591: `.S`,
	0x2592: `:S`,
	0x2593: `?S`,
	0x25a0: `fS`,
	0x25a1: `OS`,
	0x25a2: `RO`,
	0x25a3: `Rr`,
	0x25a4: `RF`,
	0x25a5: `RY`,
	0x25a6: `RH`,
	0x25a7: `RZ`,
	0x25a8: `RK`,
	0x25a9: `RX`,
	0x25aa: `sB`,
	0x25ac: `SR`,
	0x25ad: `Or`,
	0x25b2: `UT`,
	0x25b3: `uT`,
	0x25b6: `PR`,
	0x25b7: `Tr`,
	0x25bc: `Dt`,
	0x25bd: `dT`,
	0x25c0: `PL`,
	0x25c1: `Tl`,
	0x25c6: `Db`,
	0x25c7: `Dw`,
	0x25ca: `LZ`,
	0x25cb: `0m`,
	0x25ce: `0o`,
	0x25cf: `0M`,
	0x25d0: `0L`,
	0x25d1: `0R`,
	0x25d8: `Sn`,
	0x25d9: `Ic`,
	0x25e2: `Fd`,
	0x25e3: `Bd`,
	0x2605: `*2`,
	0x2606: `*1`,
	0x260e: `TEL`,
	0x260f: `tel`,
	0x261c: `<H`,
	0x261e: `>H`,
	0x263a: `0u`,
	0x263b: `0U`,
	0x263c: `SU`,
	0x2640: `Fm`,
	0x2642: `Ml`,
	0x2660: `cS`,
	0x2661: `cH`,
	0x2662: `cD`,
	0x2663: `cC`,
	0x2664: `cS-`,
	0x2665: `cH-`,
	0x2666: `cD-`,
	0x2667: `cC-`,
	0x2669: `Md`,
	0x266a: `M8`,
	0x266b: `M2`,
	0x266c: `M16`,
	0x266d: `Mb`,
	0x266e: `Mx`,
	0x266f: `MX`,
	0x2713: `OK`,
	0x2717: `XX`,
	0x2720: `-X`,
	0x3000: `IS`,
	0x3001: `,_`,
	0x3002: `._`,
	0x3003: `+"`,
	0x3004: `+_`,
	0x3005: `*_`,
	0x3006: `;_`,
	0x3007: `0_`,
	0x300a: `<+`,
	0x300b: `>+`,
	0x300c: `<'`,
	0x300d: `>'`,
	0x300e: `<"`,
	0x300f: `>"`,
	0x3010: `("`,
	0x3011: `)"`,
	0x3012: `=T`,
	0x3013: `=_`,
	0x3014: `('`,
	0x3015: `)'`,
	0x3016: `(I`,
	0x3017: `)I`,
	0x301c: `-?`,
	0x3020: `=T:)`,
	0x3041: `A5`,
	0x3042: `a5`,
	0x3043: `I5`,
	0x3044: `i5`,
	0x3045: `U5`,
	0x3046: `u5`,
	0x3047: `E5`,
	0x3048: `e5`,
	0x3049: `O5`,
	0x304a: `o5`,
	0x304b: `ka`,
	0x304c: `ga`,
	0x304d: `ki`,
	0x304e: `gi`,
	0x304f: `ku`,
	0x3050: `gu`,
	0x3051: `ke`,
	0x3052: `ge`,
	0x3053: `ko`,
	0x3054: `go`,
	0x3055: `sa`,
	0x3056: `za`,
	0x3057: `si`,
	0x3058: `zi`,
	0x3059: `su`,
	0x305a: `zu`,
	0x305b: `se`,
	0x305c: `ze`,
	0x305d: `so`,
	0x305e: `zo`,
	0x305f: `ta`,
	0x3060: `da`,
	0x3061: `ti`,
	0x3062: `di`,
	0x3063: `tU`,
	0x3064: `tu`,
	0x3065: `du`,
	0x3066: `te`,
	0x3067: `de`,
	0x3068: `to`,
	0x3069: `do`,
	0x306a: `na`,
	0x306b: `ni`,
	0x306c: `nu`,
	0x306d: `ne`,
	0x306e: `no`,
	0x306f: `ha`,
	0x3070: `ba`,
	0x3071: `pa`,
	0x3072: `hi`,
	0x3073: `bi`,
	0x3074: `pi`,
	0x3075: `hu`,
	0x3076: `bu`,
	0x3077: `pu`,
	0x3078: `he`,
	0x3079: `be`,
	0x307a: `pe`,
	0x307b: `ho`,
	0x307c: `bo`,
	0x307d: `po`,
	0x307e: `ma`,
	0x307f: `mi`,
	0x3080: `mu`,
	0x3081: `me`,
	0x3082: `mo`,
	0x3083: `yA`,
	0x3084: `ya`,
	0x3085: `yU`,
	0x3086: `yu`,
	0x3087: `yO`,
	0x3088: `yo`,
	0x3089: `ra`,
	0x308a: `ri`,
	0x308b: `ru`,
	0x308c: `re`,
	0x308d: `ro`,
	0x308e: `wA`,
	0x308f: `wa`,
	0x3090: `wi`,
	0x3091: `we`,
	0x3092: `wo`,
	0x3093: `n5`,
	0x3094: `vu`,
	0x309b: `"5`,
	0x309c: `05`,
	0x309d: `*5`,
	0x309e: `+5`,
	0x30a1: `a6`,
	0x30a2: `A6`,
	0x30a3: `i6`,
	0x30a4: `I6`,
	0x30a5: `u6`,
	0x30a6: `U6`,
	0x30a7: `e6`,
	0x30a8: `E6`,
	0x30a9: `o6`,
	0x30aa: `O6`,
	0x30ab: `Ka`,
	0x30ac: `Ga`,
	0x30ad: `Ki`,
	0x30ae: `Gi`,
	0x30af: `Ku`,
	0x30b0: `Gu`,
	0x30b1: `Ke`,
	0x30b2: `Ge`,
	0x30b3: `Ko`,
	0x30b4: `Go`,
	0x30b5: `Sa`,
	0x30b6: `Za`,
	0x30b7: `Si`,
	0x30b8: `Zi`,
	0x30b9: `Su`,
	0x30ba: `Zu`,
	0x30bb: `Se`,
	0x30bc: `Ze`,
	0x30bd: `So`,
	0x30be: `Zo`,
	0x30bf: `Ta`,
	0x30c0: `Da`,
	0x30c1: `Ti`,
	0x30c2: `Di`,
	0x30c3: `TU`,
	0x30c4: `Tu`,
	0x30c5: `Du`,
	0x30c6: `Te`,
	0x30c7: `De`,
	0x30c8: `To`,
	0x30c9: `Do`,
	0x30ca: `Na`,
	0x30cb: `Ni`,
	0x30cc: `Nu`,
	0x30cd: `Ne`,
	0x30ce: `No`,
	0x30cf: `Ha`,
	0x30d0: `Ba`,
	0x30d1: `Pa`,
	0x30d2: `Hi`,
	0x30d3: `Bi`,
	0x30d4: `Pi`,
	0x30d5: `Hu`,
	0x30d6: `Bu`,
	0x30d7: `Pu`,
	0x30d8: `He`,
	0x30d9: `Be`,
	0x30da: `Pe`,
	0x30db: `Ho`,
	0x30dc: `Bo`,
	0x30dd: `Po`,
	0x30de: `Ma`,
	0x30df: `Mi`,
	0x30e0: `Mu`,
	0x30e1: `Me`,
	0x30e2: `Mo`,
	0x30e3: `YA`,
	0x30e4: `Ya`,
	0x30e5: `YU`,
	0x30e6: `Yu`,
	0x30e7: `YO`,
	0x30e8: `Yo`,
	0x30e9: `Ra`,
	0x30ea: `Ri`,
	0x30eb: `Ru`,
	0x30ec: `Re`,
	0x30ed: `Ro`,
	0x30ee: `WA`,
	0x30ef: `Wa`,
	0x30f0: `Wi`,
	0x30f1: `We`,
	0x30f2: `Wo`,
	0x30f3: `N6`,
	0x30f4: `Vu`,
	0x30f5: `KA`,
	0x30f6: `KE`,
	0x30f7: `Va`,
	0x30f8: `Vi`,
	0x30f9: `Ve`,
	0x30fa: `Vo`,
	0x30fb: `.6`,
	0x30fc: `-6`,
	0x30fd: `*6`,
	0x30fe: `+6`,
	0x3105: `b4`,
	0x3106: `p4`,
	0x3107: `m4`,
	0x3108: `f4`,
	0x3109: `d4`,
	0x310a: `t4`,
	0x310b: `n4`,
	0x310c: `l4`,
	0x310d: `g4`,
	0x310e: `k4`,
	0x310f: `h4`,
	0x3110: `j4`,
	0x3111: `q4`,
	0x3112: `x4`,
	0x3113: `zh`,
	0x3114: `ch`,
	0x3115: `sh`,
	0x3116: `r4`,
	0x3117: `z4`,
	0x3118: `c4`,
	0x3119: `s4`,
	0x311a: `a4`,
	0x311b: `o4`,
	0x311c: `e4`,
	0x311d: `eh4`,
	0x311e: `ai`,
	0x311f: `ei`,
	0x3120: `au`,
	0x3121: `ou`,
	0x3122: `an`,
	0x3123: `en`,
	0x3124: `aN`,
	0x3125: `eN`,
	0x3126: `er`,
	0x3127: `i4`,
	0x3128: `u4`,
	0x3129: `iu`,
	0x312a: `v4`,
	0x312b: `nG`,
	0x312c: `gn`,
	0x321c: `(JU)`,
	0x3220: `1c`,
	0x3221: `2c`,
	0x3222: `3c`,
	0x3223: `4c`,
	0x3224: `5c`,
	0x3225: `6c`,
	0x3226: `7c`,
	0x3227: `8c`,
	0x3228: `9c`,
	0x3229: `10c`,
	0x327f: `KSC`,
	0xfb00: `ff`,
	0xfb01: `fi`,
	0xfb02: `fl`,
	0xfb03: `ffi`,
	0xfb04: `ffl`,
	0xfb05: `ft`,
	0xfb06: `st`,
	0xfe7d: `3+;`,
	0xfe82: `aM.`,
	0xfe84: `aH.`,
	0xfe8d: `a+-`,
	0xfe8e: `a+.`,
	0xfe8f: `b+-`,
	0xfe90: `b+,`,
	0xfe91: `b+;`,
	0xfe92: `b+.`,
	0xfe93: `tm-`,
	0xfe94: `tm.`,
	0xfe95: `t+-`,
	0xfe96: `t+,`,
	0xfe97: `t+;`,
	0xfe98: `t+.`,
	0xfe99: `tk-`,
	0xfe9a: `tk,`,
	0xfe9b: `tk;`,
	0xfe9c: `tk.`,
	0xfe9d: `g+-`,
	0xfe9e: `g+,`,
	0xfe9f: `g+;`,
	0xfea0: `g+.`,
	0xfea1: `hk-`,
	0xfea2: `hk,`,
	0xfea3: `hk;`,
	0xfea4: `hk.`,
	0xfea5: `x+-`,
	0xfea6: `x+,`,
	0xfea7: `x+;`,
	0xfea8: `x+.`,
	0xfea9: `d+-`,
	0xfeaa: `d+.`,
	0xfeab: `dk-`,
	0xfeac: `dk.`,
	0xfead: `r+-`,
	0xfeae: `r+.`,
	0xfeaf: `z+-`,
	0xfeb0: `z+.`,
	0xfeb1: `s+-`,
	0xfeb2: `s+,`,
	0xfeb3: `s+;`,
	0xfeb4: `s+.`,
	0xfeb5: `sn-`,
	0xfeb6: `sn,`,
	0xfeb7: `sn;`,
	0xfeb8: `sn.`,
	0xfeb9: `c+-`,
	0xfeba: `c+,`,
	0xfebb: `c+;`,
	0xfebc: `c+.`,
	0xfebd: `dd-`,
	0xfebe: `dd,`,
	0xfebf: `dd;`,
	0xfec0: `dd.`,
	0xfec1: `tj-`,
	0xfec2: `tj,`,
	0xfec3: `tj;`,
	0xfec4: `tj.`,
	0xfec5: `zH-`,
	0xfec6: `zH,`,
	0xfec7: `zH;`,
	0xfec8: `zH.`,
	0xfec9: `e+-`,
	0xfeca: `e+,`,
	0xfecb: `e+;`,
	0xfecc: `e+.`,
	0xfecd: `i+-`,
	0xfece: `i+,`,
	0xfecf: `i+;`,
	0xfed0: `i+.`,
	0xfed1: `f+-`,
	0xfed2: `f+,`,
	0xfed3: `f+;`,
	0xfed4: `f+.`,
	0xfed5: `q+-`,
	0xfed6: `q+,`,
	0xfed7: `q+;`,
	0xfed8: `q+.`,
	0xfed9: `k+-`,
	0xfeda: `k+,`,
	0xfedb: `k+;`,
	0xfedc: `k+.`,
	0xfedd: `l+-`,
	0xfede: `l+,`,
	0xfedf: `l+;`,
	0xfee0: `l+.`,
	0xfee1: `m+-`,
	0xfee2: `m+,`,
	0xfee3: `m+;`,
	0xfee4: `m+.`,
	0xfee5: `n+-`,
	0xfee6: `n+,`,
	0xfee7: `n+;`,
	0xfee8: `n+.`,
	0xfee9: `h+-`,
	0xfeea: `h+,`,
	0xfeeb: `h+;`,
	0xfeec: `h+.`,
	0xfeed: `w+-`,
	0xfeee: `w+.`,
	0xfeef: `j+-`,
	0xfef0: `j+.`,
	0xfef1: `y+-`,
	0xfef2: `y+,`,
	0xfef3: `y+;`,
	0xfef4: `y+.`,
	0xfef5: `lM-`,
	0xfef6: `lM.`,
	0xfef7: `lH-`,
	0xfef8: `lH.`,
	0xfef9: `lh-`,
	0xfefa: `lh.`,
	0xfefb: `la-`,
	0xfefc: `la.`,
	0x0000: `NU`,
	0x0001: `SH`,
	0x0002: `SX`,
	0x0003: `EX`,
	0x0004: `ET`,
	0x0005: `EQ`,
	0x0006: `AK`,
	0x0007: `BL`,
	0x0008: `BS`,
	0x0009: `HT`,
	0x000a: `LF`,
	0x000b: `VT`,
	0x000c: `FF`,
	0x000d: `CR`,
	0x000e: `SO`,
	0x000f: `SI`,
	0x0010: `DL`,
	0x0011: `D1`,
	0x0012: `D2`,
	0x0013: `D3`,
	0x0014: `D4`,
	0x0015: `NK`,
	0x0016: `SY`,
	0x0017: `EB`,
	0x0018: `CN`,
	0x0019: `EM`,
	0x001a: `SB`,
	0x001b: `EC`,
	0x001c: `FS`,
	0x001d: `GS`,
	0x001e: `RS`,
	0x001f: `US`,
	0x007f: `DT`,
	0x0080: `PA`,
	0x0081: `HO`,
	0x0082: `BH`,
	0x0083: `NH`,
	0x0084: `IN`,
	0x0085: `NL`,
	0x0086: `SA`,
	0x0087: `ES`,
	0x0088: `HS`,
	0x0089: `HJ`,
	0x008a: `VS`,
	0x008b: `PD`,
	0x008c: `PU`,
	0x008d: `RI`,
	0x008e: `S2`,
	0x008f: `S3`,
	0x0090: `DC`,
	0x0091: `P1`,
	0x0092: `P2`,
	0x0093: `TS`,
	0x0094: `CC`,
	0x0095: `MW`,
	0x0096: `SG`,
	0x0097: `EG`,
	0x0098: `SS`,
	0x0099: `GC`,
	0x009a: `SC`,
	0x009b: `CI`,
	0x009c: `ST`,
	0x009d: `OC`,
	0x009e: `PM`,
	0x009f: `AC`,
	0xe000: ``,
	0xe001: `/c`,
	0xe022: `a+:`,
	0xe023: `Fl`,
	0xe024: `GF`,
	0xe025: `>V`,
	0xe026: `!*`,
	0xe027: `?*`,
	0xe028: `J<`,
}
