// Code generated by go generate; DO NOT EDIT.
package bitbucket

import "errors"

type Permission int

const (
    Invalid Permission = iota
    Project Permission = iota
    ProjectAdmin Permission = iota
    Repository Permission = iota
    RepositoryWrite Permission = iota
    RepositoryAdmin Permission = iota
    RepositoryDelete Permission = iota
    Pullrequest Permission = iota
    PullrequestWrite Permission = iota
    Webhook Permission = iota
    Account Permission = iota
    Pipeline Permission = iota
    PipelineWrite Permission = iota
    PipelineVariable Permission = iota
    Runner Permission = iota
    RunnerWrite Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        Project: "project",
        ProjectAdmin: "project:admin",
        Repository: "repository",
        RepositoryWrite: "repository:write",
        RepositoryAdmin: "repository:admin",
        RepositoryDelete: "repository:delete",
        Pullrequest: "pullrequest",
        PullrequestWrite: "pullrequest:write",
        Webhook: "webhook",
        Account: "account",
        Pipeline: "pipeline",
        PipelineWrite: "pipeline:write",
        PipelineVariable: "pipeline:variable",
        Runner: "runner",
        RunnerWrite: "runner:write",
    }

    StringToPermission = map[string]Permission{
        "project": Project,
        "project:admin": ProjectAdmin,
        "repository": Repository,
        "repository:write": RepositoryWrite,
        "repository:admin": RepositoryAdmin,
        "repository:delete": RepositoryDelete,
        "pullrequest": Pullrequest,
        "pullrequest:write": PullrequestWrite,
        "webhook": Webhook,
        "account": Account,
        "pipeline": Pipeline,
        "pipeline:write": PipelineWrite,
        "pipeline:variable": PipelineVariable,
        "runner": Runner,
        "runner:write": RunnerWrite,
    }

    PermissionIDs = map[Permission]int{
        Project: 1,
        ProjectAdmin: 2,
        Repository: 3,
        RepositoryWrite: 4,
        RepositoryAdmin: 5,
        RepositoryDelete: 6,
        Pullrequest: 7,
        PullrequestWrite: 8,
        Webhook: 9,
        Account: 10,
        Pipeline: 11,
        PipelineWrite: 12,
        PipelineVariable: 13,
        Runner: 14,
        RunnerWrite: 15,
    }

    IdToPermission = map[int]Permission{
        1: Project,
        2: ProjectAdmin,
        3: Repository,
        4: RepositoryWrite,
        5: RepositoryAdmin,
        6: RepositoryDelete,
        7: Pullrequest,
        8: PullrequestWrite,
        9: Webhook,
        10: Account,
        11: Pipeline,
        12: PipelineWrite,
        13: PipelineVariable,
        14: Runner,
        15: RunnerWrite,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
