# Vulnerability Scanners

Vulnerability scanning is an important way to identify and remediate security gaps in Kubernetes workloads. The
process involves scanning container images to check all software on them and report any vulnerabilities found.

Trivy Operator automatically discovers and scans all images that are being used in a Kubernetes cluster, including
images of application pods and system pods. Scan reports are saved as [VulnerabilityReport] resources, which are owned
by a Kubernetes controller.

For example, when Trivy scans a Deployment, the corresponding VulnerabilityReport instance is attached to its
current revision. In other words, the VulnerabilityReport inherits the life cycle of the Kubernetes controller. This
also implies that when a Deployment is rolling updated, it will get scanned automatically, and a new instance of the
VulnerabilityReport will be created and attached to the new revision. On the other hand, if the previous revision is
deleted, the corresponding VulnerabilityReport will be deleted automatically by the Kubernetes garbage collector.

Trivy may scan Kubernetes workloads that run images from [Private Registries] and certain [Managed Registries].

[Trivy]: ./trivy.md
[Private Registries]: ./managed-registries.md
[Managed Registries]: ./managed-registries.md
