# Helm

[Helm], which is a popular package manager for Kubernetes, allows installing applications from parameterized
YAML manifests called Helm [charts].

The Helm chart is available on GitHub in [https://github.com/aquasecurity/trivy-operator](https://github.com/aquasecurity/trivy-operator) under `/deploy/helm` and is also hosted in a Chart repository for your convenience under [https://aquasecurity.github.io/helm-charts/](https://aquasecurity.github.io/helm-charts/).

## Example - Chart repository

This will install the operator in the `trivy-system` namespace and configure it to scan all namespaces, except `kube-system` and `trivy-system`:

```bash
helm repo add aqua https://aquasecurity.github.io/helm-charts/
helm repo update
helm install trivy-operator aqua/trivy-operator \
   --namespace trivy-system \
   --create-namespace \
   --set="trivy.ignoreUnfixed=true" \
   --version {{ var.operator_version }}
```

## Example - Download the chart

This will install the operator in the `trivy-system` namespace and configure it to scan all namespaces, except `kube-system` and `trivy-system`:

```bash
git clone --depth 1 --branch {{ var.operator_version }} https://github.com/aquasecurity/trivy-operator.git
cd trivy-operator
helm install trivy-operator ./deploy/helm \
--namespace trivy-system \
--create-namespace \
--set="trivy.ignoreUnfixed=true"
```

## Post install sanity check

Check that the `trivy-operator` Helm release is created in the `trivy-system` namespace, and it has status `deployed`:

```console
$ helm list -n trivy-system
NAME              	NAMESPACE         	REVISION	UPDATED                             	STATUS  	CHART                   	APP VERSION
trivy-operator	trivy-system	1       	2021-01-27 20:09:53.158961 +0100 CET	deployed	trivy-operator-{{ var.operator_version }}	{{  var.operator_version[1:] }}
```

To confirm that the operator is running, check that the `trivy-operator` Deployment in the `trivy-system`
namespace is available and all its containers are ready:

```console
$ kubectl get deployment -n trivy-system
NAME                 READY   UP-TO-DATE   AVAILABLE   AGE
trivy-operator   1/1     1            1           11m
```

If for some reason it's not ready yet, check the logs of the Deployment for errors:

```
kubectl logs deployment/trivy-operator -n trivy-system
```

## Advanced Configuration

The Helm chart supports all available [installation modes](./../configuration.md#install-modes) of Trivy Operator. 

Please refer to the chart's [values] file for configuration options.

## Uninstall

You can uninstall the operator with the following command:

```
helm uninstall trivy-operator -n trivy-system
```

You have to manually delete custom resource definitions created by the `helm install` command:

!!! danger
    Deleting custom resource definitions will also delete all security reports generated by the operator.

    ```
    kubectl delete crd vulnerabilityreports.aquasecurity.github.io
    kubectl delete crd clustervulnerabilityreports.aquasecurity.github.io
    kubectl delete crd configauditreports.aquasecurity.github.io
    kubectl delete crd clusterconfigauditreports.aquasecurity.github.io
    kubectl delete crd clustercompliancereports.aquasecurity.github.io
    kubectl delete crd clustercompliancedetailreports.aquasecurity.github.io
    ```

[Helm]: https://helm.sh/
[charts]: https://helm.sh/docs/topics/charts/
[values]: https://raw.githubusercontent.com/aquasecurity/trivy-operator/{{  var.operator_version }}/deploy/helm/values.yaml
