// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package com.google.crypto.tink.testing;

import static com.google.common.truth.Truth.assertThat;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

/** Tests some of the more complex functions from TestdataUtil. */
@RunWith(JUnit4.class)
public class TestdataTest {

  @Test
  public void getKeyTemplateProto() throws IOException, GeneralSecurityException {
    assertThat(Testdata.getKeyTemplateProto("aead", "AES128_GCM").getTypeUrl())
        .isEqualTo("type.googleapis.com/google.crypto.tink.AesGcmKey");
  }
}
