// Code generated by cue get go. DO NOT EDIT.

//cue:generate cue get go k8s.io/apimachinery/pkg/apis/meta/v1

// Package v1 contains API types that are common to all versions.
//
// The package contains two categories of types:
//   - external (serialized) types that lack their own version (e.g TypeMeta)
//   - internal (never-serialized) types that are needed by several different
//     api groups, and so live here, to avoid duplication and/or import loops
//     (e.g. LabelSelector).
//
// In the future, we will probably move these categories of objects into
// separate packages.
package v1

import (
	"k8s.io/apimachinery/pkg/types"
	"k8s.io/apimachinery/pkg/runtime"
)

// TypeMeta describes an individual object in an API response or request
// with strings representing the type of the object and its API schema version.
// Structures that are versioned or persisted should inline TypeMeta.
//
// +k8s:deepcopy-gen=false
#TypeMeta: {
	// Kind is a string value representing the REST resource this object represents.
	// Servers may infer this from the endpoint the client submits requests to.
	// Cannot be updated.
	// In CamelCase.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	kind?: string @go(Kind) @protobuf(1,bytes,opt)

	// APIVersion defines the versioned schema of this representation of an object.
	// Servers should convert recognized schemas to the latest internal value, and
	// may reject unrecognized values.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
	// +optional
	apiVersion?: string @go(APIVersion) @protobuf(2,bytes,opt)
}

// ListMeta describes metadata that synthetic resources must have, including lists and
// various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
#ListMeta: {
	// Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
	// +optional
	selfLink?: string @go(SelfLink) @protobuf(1,bytes,opt)

	// String that identifies the server's internal version of this object that
	// can be used by clients to determine when objects have changed.
	// Value must be treated as opaque by clients and passed unmodified back to the server.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
	// +optional
	resourceVersion?: string @go(ResourceVersion) @protobuf(2,bytes,opt)

	// continue may be set if the user set a limit on the number of items returned, and indicates that
	// the server has more data available. The value is opaque and may be used to issue another request
	// to the endpoint that served this list to retrieve the next set of available objects. Continuing a
	// consistent list may not be possible if the server configuration has changed or more than a few
	// minutes have passed. The resourceVersion field returned when using this continue value will be
	// identical to the value in the first response, unless you have received this token from an error
	// message.
	continue?: string @go(Continue) @protobuf(3,bytes,opt)

	// remainingItemCount is the number of subsequent items in the list which are not included in this
	// list response. If the list request contained label or field selectors, then the number of
	// remaining items is unknown and the field will be left unset and omitted during serialization.
	// If the list is complete (either because it is not chunking or because this is the last chunk),
	// then there are no more remaining items and this field will be left unset and omitted during
	// serialization.
	// Servers older than v1.15 do not set this field.
	// The intended use of the remainingItemCount is *estimating* the size of a collection. Clients
	// should not rely on the remainingItemCount to be set or to be exact.
	// +optional
	remainingItemCount?: null | int64 @go(RemainingItemCount,*int64) @protobuf(4,bytes,opt)
}

#ObjectNameField: "metadata.name"

#FinalizerOrphanDependents: "orphan"
#FinalizerDeleteDependents: "foregroundDeletion"

// ObjectMeta is metadata that all persisted resources must have, which includes all objects
// users must create.
#ObjectMeta: {
	// Name must be unique within a namespace. Is required when creating resources, although
	// some resources may allow a client to request the generation of an appropriate name
	// automatically. Name is primarily intended for creation idempotence and configuration
	// definition.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
	// +optional
	name?: string @go(Name) @protobuf(1,bytes,opt)

	// GenerateName is an optional prefix, used by the server, to generate a unique
	// name ONLY IF the Name field has not been provided.
	// If this field is used, the name returned to the client will be different
	// than the name passed. This value will also be combined with a unique suffix.
	// The provided value has the same validation rules as the Name field,
	// and may be truncated by the length of the suffix required to make the value
	// unique on the server.
	//
	// If this field is specified and the generated name exists, the server will return a 409.
	//
	// Applied only if Name is not specified.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
	// +optional
	generateName?: string @go(GenerateName) @protobuf(2,bytes,opt)

	// Namespace defines the space within which each name must be unique. An empty namespace is
	// equivalent to the "default" namespace, but "default" is the canonical representation.
	// Not all objects are required to be scoped to a namespace - the value of this field for
	// those objects will be empty.
	//
	// Must be a DNS_LABEL.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
	// +optional
	namespace?: string @go(Namespace) @protobuf(3,bytes,opt)

	// Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
	// +optional
	selfLink?: string @go(SelfLink) @protobuf(4,bytes,opt)

	// UID is the unique in time and space value for this object. It is typically generated by
	// the server on successful creation of a resource and is not allowed to change on PUT
	// operations.
	//
	// Populated by the system.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
	// +optional
	uid?: types.#UID @go(UID) @protobuf(5,bytes,opt,casttype=k8s.io/kubernetes/pkg/types.UID)

	// An opaque value that represents the internal version of this object that can
	// be used by clients to determine when objects have changed. May be used for optimistic
	// concurrency, change detection, and the watch operation on a resource or set of resources.
	// Clients must treat these values as opaque and passed unmodified back to the server.
	// They may only be valid for a particular resource or set of resources.
	//
	// Populated by the system.
	// Read-only.
	// Value must be treated as opaque by clients and .
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
	// +optional
	resourceVersion?: string @go(ResourceVersion) @protobuf(6,bytes,opt)

	// A sequence number representing a specific generation of the desired state.
	// Populated by the system. Read-only.
	// +optional
	generation?: int64 @go(Generation) @protobuf(7,varint,opt)

	// CreationTimestamp is a timestamp representing the server time when this object was
	// created. It is not guaranteed to be set in happens-before order across separate operations.
	// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
	//
	// Populated by the system.
	// Read-only.
	// Null for lists.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
	// +optional
	creationTimestamp?: #Time @go(CreationTimestamp) @protobuf(8,bytes,opt)

	// DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This
	// field is set by the server when a graceful deletion is requested by the user, and is not
	// directly settable by a client. The resource is expected to be deleted (no longer visible
	// from resource lists, and not reachable by name) after the time in this field, once the
	// finalizers list is empty. As long as the finalizers list contains items, deletion is blocked.
	// Once the deletionTimestamp is set, this value may not be unset or be set further into the
	// future, although it may be shortened or the resource may be deleted prior to this time.
	// For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react
	// by sending a graceful termination signal to the containers in the pod. After that 30 seconds,
	// the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup,
	// remove the pod from the API. In the presence of network partitions, this object may still
	// exist after this timestamp, until an administrator or automated process can determine the
	// resource is fully terminated.
	// If not set, graceful deletion of the object has not been requested.
	//
	// Populated by the system when a graceful deletion is requested.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
	// +optional
	deletionTimestamp?: null | #Time @go(DeletionTimestamp,*Time) @protobuf(9,bytes,opt)

	// Number of seconds allowed for this object to gracefully terminate before
	// it will be removed from the system. Only set when deletionTimestamp is also set.
	// May only be shortened.
	// Read-only.
	// +optional
	deletionGracePeriodSeconds?: null | int64 @go(DeletionGracePeriodSeconds,*int64) @protobuf(10,varint,opt)

	// Map of string keys and values that can be used to organize and categorize
	// (scope and select) objects. May match selectors of replication controllers
	// and services.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
	// +optional
	labels?: {[string]: string} @go(Labels,map[string]string) @protobuf(11,bytes,rep)

	// Annotations is an unstructured key value map stored with a resource that may be
	// set by external tools to store and retrieve arbitrary metadata. They are not
	// queryable and should be preserved when modifying objects.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
	// +optional
	annotations?: {[string]: string} @go(Annotations,map[string]string) @protobuf(12,bytes,rep)

	// List of objects depended by this object. If ALL objects in the list have
	// been deleted, this object will be garbage collected. If this object is managed by a controller,
	// then an entry in this list will point to this controller, with the controller field set to true.
	// There cannot be more than one managing controller.
	// +optional
	// +patchMergeKey=uid
	// +patchStrategy=merge
	ownerReferences?: [...#OwnerReference] @go(OwnerReferences,[]OwnerReference) @protobuf(13,bytes,rep)

	// Must be empty before the object is deleted from the registry. Each entry
	// is an identifier for the responsible component that will remove the entry
	// from the list. If the deletionTimestamp of the object is non-nil, entries
	// in this list can only be removed.
	// Finalizers may be processed and removed in any order.  Order is NOT enforced
	// because it introduces significant risk of stuck finalizers.
	// finalizers is a shared field, any actor with permission can reorder it.
	// If the finalizer list is processed in order, then this can lead to a situation
	// in which the component responsible for the first finalizer in the list is
	// waiting for a signal (field value, external system, or other) produced by a
	// component responsible for a finalizer later in the list, resulting in a deadlock.
	// Without enforced ordering finalizers are free to order amongst themselves and
	// are not vulnerable to ordering changes in the list.
	// +optional
	// +patchStrategy=merge
	finalizers?: [...string] @go(Finalizers,[]string) @protobuf(14,bytes,rep)

	// ManagedFields maps workflow-id and version to the set of fields
	// that are managed by that workflow. This is mostly for internal
	// housekeeping, and users typically shouldn't need to set or
	// understand this field. A workflow can be the user's name, a
	// controller's name, or the name of a specific apply path like
	// "ci-cd". The set of fields is always in the version that the
	// workflow used when modifying the object.
	//
	// +optional
	managedFields?: [...#ManagedFieldsEntry] @go(ManagedFields,[]ManagedFieldsEntry) @protobuf(17,bytes,rep)
}

// NamespaceDefault means the object is in the default namespace which is applied when not specified by clients
#NamespaceDefault: "default"

// NamespaceAll is the default argument to specify on a context when you want to list or filter resources across all namespaces
#NamespaceAll: ""

// NamespaceNone is the argument for a context when there is no namespace.
#NamespaceNone: ""

// NamespaceSystem is the system namespace where we place system components.
#NamespaceSystem: "kube-system"

// NamespacePublic is the namespace where we place public info (ConfigMaps)
#NamespacePublic: "kube-public"

// OwnerReference contains enough information to let you identify an owning
// object. An owning object must be in the same namespace as the dependent, or
// be cluster-scoped, so there is no namespace field.
// +structType=atomic
#OwnerReference: {
	// API version of the referent.
	apiVersion: string @go(APIVersion) @protobuf(5,bytes,opt)

	// Kind of the referent.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	kind: string @go(Kind) @protobuf(1,bytes,opt)

	// Name of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
	name: string @go(Name) @protobuf(3,bytes,opt)

	// UID of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
	uid: types.#UID @go(UID) @protobuf(4,bytes,opt,casttype=k8s.io/apimachinery/pkg/types.UID)

	// If true, this reference points to the managing controller.
	// +optional
	controller?: null | bool @go(Controller,*bool) @protobuf(6,varint,opt)

	// If true, AND if the owner has the "foregroundDeletion" finalizer, then
	// the owner cannot be deleted from the key-value store until this
	// reference is removed.
	// See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion
	// for how the garbage collector interacts with this field and enforces the foreground deletion.
	// Defaults to false.
	// To set this field, a user needs "delete" permission of the owner,
	// otherwise 422 (Unprocessable Entity) will be returned.
	// +optional
	blockOwnerDeletion?: null | bool @go(BlockOwnerDeletion,*bool) @protobuf(7,varint,opt)
}

// ListOptions is the query options to a standard REST list call.
#ListOptions: {
	#TypeMeta

	// A selector to restrict the list of returned objects by their labels.
	// Defaults to everything.
	// +optional
	labelSelector?: string @go(LabelSelector) @protobuf(1,bytes,opt)

	// A selector to restrict the list of returned objects by their fields.
	// Defaults to everything.
	// +optional
	fieldSelector?: string @go(FieldSelector) @protobuf(2,bytes,opt)

	// Watch for changes to the described resources and return them as a stream of
	// add, update, and remove notifications. Specify resourceVersion.
	// +optional
	watch?: bool @go(Watch) @protobuf(3,varint,opt)

	// allowWatchBookmarks requests watch events with type "BOOKMARK".
	// Servers that do not implement bookmarks may ignore this flag and
	// bookmarks are sent at the server's discretion. Clients should not
	// assume bookmarks are returned at any specific interval, nor may they
	// assume the server will send any BOOKMARK event during a session.
	// If this is not a watch, this field is ignored.
	// +optional
	allowWatchBookmarks?: bool @go(AllowWatchBookmarks) @protobuf(9,varint,opt)

	// resourceVersion sets a constraint on what resource versions a request may be served from.
	// See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
	// details.
	//
	// Defaults to unset
	// +optional
	resourceVersion?: string @go(ResourceVersion) @protobuf(4,bytes,opt)

	// resourceVersionMatch determines how resourceVersion is applied to list calls.
	// It is highly recommended that resourceVersionMatch be set for list calls where
	// resourceVersion is set
	// See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
	// details.
	//
	// Defaults to unset
	// +optional
	resourceVersionMatch?: #ResourceVersionMatch @go(ResourceVersionMatch) @protobuf(10,bytes,opt,casttype=ResourceVersionMatch)

	// Timeout for the list/watch call.
	// This limits the duration of the call, regardless of any activity or inactivity.
	// +optional
	timeoutSeconds?: null | int64 @go(TimeoutSeconds,*int64) @protobuf(5,varint,opt)

	// limit is a maximum number of responses to return for a list call. If more items exist, the
	// server will set the `continue` field on the list metadata to a value that can be used with the
	// same initial query to retrieve the next set of results. Setting a limit may return fewer than
	// the requested amount of items (up to zero items) in the event all requested objects are
	// filtered out and clients should only use the presence of the continue field to determine whether
	// more results are available. Servers may choose not to support the limit argument and will return
	// all of the available results. If limit is specified and the continue field is empty, clients may
	// assume that no more results are available. This field is not supported if watch is true.
	//
	// The server guarantees that the objects returned when using continue will be identical to issuing
	// a single list call without a limit - that is, no objects created, modified, or deleted after the
	// first request is issued will be included in any subsequent continued requests. This is sometimes
	// referred to as a consistent snapshot, and ensures that a client that is using limit to receive
	// smaller chunks of a very large result can ensure they see all possible objects. If objects are
	// updated during a chunked list the version of the object that was present at the time the first list
	// result was calculated is returned.
	limit?: int64 @go(Limit) @protobuf(7,varint,opt)

	// The continue option should be set when retrieving more results from the server. Since this value is
	// server defined, clients may only use the continue value from a previous query result with identical
	// query parameters (except for the value of continue) and the server may reject a continue value it
	// does not recognize. If the specified continue value is no longer valid whether due to expiration
	// (generally five to fifteen minutes) or a configuration change on the server, the server will
	// respond with a 410 ResourceExpired error together with a continue token. If the client needs a
	// consistent list, it must restart their list without the continue field. Otherwise, the client may
	// send another list request with the token received with the 410 error, the server will respond with
	// a list starting from the next key, but from the latest snapshot, which is inconsistent from the
	// previous list results - objects that are created, modified, or deleted after the first list request
	// will be included in the response, as long as their keys are after the "next key".
	//
	// This field is not supported when watch is true. Clients may start a watch from the last
	// resourceVersion value returned by the server and not miss any modifications.
	continue?: string @go(Continue) @protobuf(8,bytes,opt)

	// `sendInitialEvents=true` may be set together with `watch=true`.
	// In that case, the watch stream will begin with synthetic events to
	// produce the current state of objects in the collection. Once all such
	// events have been sent, a synthetic "Bookmark" event  will be sent.
	// The bookmark will report the ResourceVersion (RV) corresponding to the
	// set of objects, and be marked with `"k8s.io/initial-events-end": "true"` annotation.
	// Afterwards, the watch stream will proceed as usual, sending watch events
	// corresponding to changes (subsequent to the RV) to objects watched.
	//
	// When `sendInitialEvents` option is set, we require `resourceVersionMatch`
	// option to also be set. The semantic of the watch request is as following:
	// - `resourceVersionMatch` = NotOlderThan
	//   is interpreted as "data at least as new as the provided `resourceVersion`"
	//   and the bookmark event is send when the state is synced
	//   to a `resourceVersion` at least as fresh as the one provided by the ListOptions.
	//   If `resourceVersion` is unset, this is interpreted as "consistent read" and the
	//   bookmark event is send when the state is synced at least to the moment
	//   when request started being processed.
	// - `resourceVersionMatch` set to any other value or unset
	//   Invalid error is returned.
	//
	// Defaults to true if `resourceVersion=""` or `resourceVersion="0"` (for backward
	// compatibility reasons) and to false otherwise.
	// +optional
	sendInitialEvents?: null | bool @go(SendInitialEvents,*bool) @protobuf(11,varint,opt)
}

// resourceVersionMatch specifies how the resourceVersion parameter is applied. resourceVersionMatch
// may only be set if resourceVersion is also set.
//
// "NotOlderThan" matches data at least as new as the provided resourceVersion.
// "Exact" matches data at the exact resourceVersion provided.
//
// See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
// details.
#ResourceVersionMatch: string // #enumResourceVersionMatch

#enumResourceVersionMatch:
	#ResourceVersionMatchNotOlderThan |
	#ResourceVersionMatchExact

// ResourceVersionMatchNotOlderThan matches data at least as new as the provided
// resourceVersion.
#ResourceVersionMatchNotOlderThan: #ResourceVersionMatch & "NotOlderThan"

// ResourceVersionMatchExact matches data at the exact resourceVersion
// provided.
#ResourceVersionMatchExact: #ResourceVersionMatch & "Exact"

// GetOptions is the standard query options to the standard REST get call.
#GetOptions: {
	#TypeMeta

	// resourceVersion sets a constraint on what resource versions a request may be served from.
	// See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
	// details.
	//
	// Defaults to unset
	// +optional
	resourceVersion?: string @go(ResourceVersion) @protobuf(1,bytes,opt)
}

// DeletionPropagation decides if a deletion will propagate to the dependents of
// the object, and how the garbage collector will handle the propagation.
#DeletionPropagation: string // #enumDeletionPropagation

#enumDeletionPropagation:
	#DeletePropagationOrphan |
	#DeletePropagationBackground |
	#DeletePropagationForeground

// Orphans the dependents.
#DeletePropagationOrphan: #DeletionPropagation & "Orphan"

// Deletes the object from the key-value store, the garbage collector will
// delete the dependents in the background.
#DeletePropagationBackground: #DeletionPropagation & "Background"

// The object exists in the key-value store until the garbage collector
// deletes all the dependents whose ownerReference.blockOwnerDeletion=true
// from the key-value store.  API sever will put the "foregroundDeletion"
// finalizer on the object, and sets its deletionTimestamp.  This policy is
// cascading, i.e., the dependents will be deleted with Foreground.
#DeletePropagationForeground: #DeletionPropagation & "Foreground"

// DryRunAll means to complete all processing stages, but don't
// persist changes to storage.
#DryRunAll: "All"

// DeleteOptions may be provided when deleting an API object.
#DeleteOptions: {
	#TypeMeta

	// The duration in seconds before the object should be deleted. Value must be non-negative integer.
	// The value zero indicates delete immediately. If this value is nil, the default grace period for the
	// specified type will be used.
	// Defaults to a per object value if not specified. zero means delete immediately.
	// +optional
	gracePeriodSeconds?: null | int64 @go(GracePeriodSeconds,*int64) @protobuf(1,varint,opt)

	// Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be
	// returned.
	// +k8s:conversion-gen=false
	// +optional
	preconditions?: null | #Preconditions @go(Preconditions,*Preconditions) @protobuf(2,bytes,opt)

	// Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7.
	// Should the dependent objects be orphaned. If true/false, the "orphan"
	// finalizer will be added to/removed from the object's finalizers list.
	// Either this field or PropagationPolicy may be set, but not both.
	// +optional
	orphanDependents?: null | bool @go(OrphanDependents,*bool) @protobuf(3,varint,opt)

	// Whether and how garbage collection will be performed.
	// Either this field or OrphanDependents may be set, but not both.
	// The default policy is decided by the existing finalizer set in the
	// metadata.finalizers and the resource-specific default policy.
	// Acceptable values are: 'Orphan' - orphan the dependents; 'Background' -
	// allow the garbage collector to delete the dependents in the background;
	// 'Foreground' - a cascading policy that deletes all dependents in the
	// foreground.
	// +optional
	propagationPolicy?: null | #DeletionPropagation @go(PropagationPolicy,*DeletionPropagation) @protobuf(4,varint,opt)

	// When present, indicates that modifications should not be
	// persisted. An invalid or unrecognized dryRun directive will
	// result in an error response and no further processing of the
	// request. Valid values are:
	// - All: all dry run stages will be processed
	// +optional
	dryRun?: [...string] @go(DryRun,[]string) @protobuf(5,bytes,rep)
}

// FieldValidationIgnore ignores unknown/duplicate fields
#FieldValidationIgnore: "Ignore"

// FieldValidationWarn responds with a warning, but successfully serve the request
#FieldValidationWarn: "Warn"

// FieldValidationStrict fails the request on unknown/duplicate fields
#FieldValidationStrict: "Strict"

// CreateOptions may be provided when creating an API object.
#CreateOptions: {
	#TypeMeta

	// When present, indicates that modifications should not be
	// persisted. An invalid or unrecognized dryRun directive will
	// result in an error response and no further processing of the
	// request. Valid values are:
	// - All: all dry run stages will be processed
	// +optional
	dryRun?: [...string] @go(DryRun,[]string) @protobuf(1,bytes,rep)

	// fieldManager is a name associated with the actor or entity
	// that is making these changes. The value must be less than or
	// 128 characters long, and only contain printable characters,
	// as defined by https://golang.org/pkg/unicode/#IsPrint.
	// +optional
	fieldManager?: string @go(FieldManager) @protobuf(3,bytes)

	// fieldValidation instructs the server on how to handle
	// objects in the request (POST/PUT/PATCH) containing unknown
	// or duplicate fields. Valid values are:
	// - Ignore: This will ignore any unknown fields that are silently
	// dropped from the object, and will ignore all but the last duplicate
	// field that the decoder encounters. This is the default behavior
	// prior to v1.23.
	// - Warn: This will send a warning via the standard warning response
	// header for each unknown field that is dropped from the object, and
	// for each duplicate field that is encountered. The request will
	// still succeed if there are no other errors, and will only persist
	// the last of any duplicate fields. This is the default in v1.23+
	// - Strict: This will fail the request with a BadRequest error if
	// any unknown fields would be dropped from the object, or if any
	// duplicate fields are present. The error returned from the server
	// will contain all unknown and duplicate fields encountered.
	// +optional
	fieldValidation?: string @go(FieldValidation) @protobuf(4,bytes)
}

// PatchOptions may be provided when patching an API object.
// PatchOptions is meant to be a superset of UpdateOptions.
#PatchOptions: {
	#TypeMeta

	// When present, indicates that modifications should not be
	// persisted. An invalid or unrecognized dryRun directive will
	// result in an error response and no further processing of the
	// request. Valid values are:
	// - All: all dry run stages will be processed
	// +optional
	dryRun?: [...string] @go(DryRun,[]string) @protobuf(1,bytes,rep)

	// Force is going to "force" Apply requests. It means user will
	// re-acquire conflicting fields owned by other people. Force
	// flag must be unset for non-apply patch requests.
	// +optional
	force?: null | bool @go(Force,*bool) @protobuf(2,varint,opt)

	// fieldManager is a name associated with the actor or entity
	// that is making these changes. The value must be less than or
	// 128 characters long, and only contain printable characters,
	// as defined by https://golang.org/pkg/unicode/#IsPrint. This
	// field is required for apply requests
	// (application/apply-patch) but optional for non-apply patch
	// types (JsonPatch, MergePatch, StrategicMergePatch).
	// +optional
	fieldManager?: string @go(FieldManager) @protobuf(3,bytes)

	// fieldValidation instructs the server on how to handle
	// objects in the request (POST/PUT/PATCH) containing unknown
	// or duplicate fields. Valid values are:
	// - Ignore: This will ignore any unknown fields that are silently
	// dropped from the object, and will ignore all but the last duplicate
	// field that the decoder encounters. This is the default behavior
	// prior to v1.23.
	// - Warn: This will send a warning via the standard warning response
	// header for each unknown field that is dropped from the object, and
	// for each duplicate field that is encountered. The request will
	// still succeed if there are no other errors, and will only persist
	// the last of any duplicate fields. This is the default in v1.23+
	// - Strict: This will fail the request with a BadRequest error if
	// any unknown fields would be dropped from the object, or if any
	// duplicate fields are present. The error returned from the server
	// will contain all unknown and duplicate fields encountered.
	// +optional
	fieldValidation?: string @go(FieldValidation) @protobuf(4,bytes)
}

// ApplyOptions may be provided when applying an API object.
// FieldManager is required for apply requests.
// ApplyOptions is equivalent to PatchOptions. It is provided as a convenience with documentation
// that speaks specifically to how the options fields relate to apply.
#ApplyOptions: {
	#TypeMeta

	// When present, indicates that modifications should not be
	// persisted. An invalid or unrecognized dryRun directive will
	// result in an error response and no further processing of the
	// request. Valid values are:
	// - All: all dry run stages will be processed
	// +optional
	dryRun?: [...string] @go(DryRun,[]string) @protobuf(1,bytes,rep)

	// Force is going to "force" Apply requests. It means user will
	// re-acquire conflicting fields owned by other people.
	force: bool @go(Force) @protobuf(2,varint,opt)

	// fieldManager is a name associated with the actor or entity
	// that is making these changes. The value must be less than or
	// 128 characters long, and only contain printable characters,
	// as defined by https://golang.org/pkg/unicode/#IsPrint. This
	// field is required.
	fieldManager: string @go(FieldManager) @protobuf(3,bytes)
}

// UpdateOptions may be provided when updating an API object.
// All fields in UpdateOptions should also be present in PatchOptions.
#UpdateOptions: {
	#TypeMeta

	// When present, indicates that modifications should not be
	// persisted. An invalid or unrecognized dryRun directive will
	// result in an error response and no further processing of the
	// request. Valid values are:
	// - All: all dry run stages will be processed
	// +optional
	dryRun?: [...string] @go(DryRun,[]string) @protobuf(1,bytes,rep)

	// fieldManager is a name associated with the actor or entity
	// that is making these changes. The value must be less than or
	// 128 characters long, and only contain printable characters,
	// as defined by https://golang.org/pkg/unicode/#IsPrint.
	// +optional
	fieldManager?: string @go(FieldManager) @protobuf(2,bytes)

	// fieldValidation instructs the server on how to handle
	// objects in the request (POST/PUT/PATCH) containing unknown
	// or duplicate fields. Valid values are:
	// - Ignore: This will ignore any unknown fields that are silently
	// dropped from the object, and will ignore all but the last duplicate
	// field that the decoder encounters. This is the default behavior
	// prior to v1.23.
	// - Warn: This will send a warning via the standard warning response
	// header for each unknown field that is dropped from the object, and
	// for each duplicate field that is encountered. The request will
	// still succeed if there are no other errors, and will only persist
	// the last of any duplicate fields. This is the default in v1.23+
	// - Strict: This will fail the request with a BadRequest error if
	// any unknown fields would be dropped from the object, or if any
	// duplicate fields are present. The error returned from the server
	// will contain all unknown and duplicate fields encountered.
	// +optional
	fieldValidation?: string @go(FieldValidation) @protobuf(3,bytes)
}

// Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
#Preconditions: {
	// Specifies the target UID.
	// +optional
	uid?: null | types.#UID @go(UID,*types.UID) @protobuf(1,bytes,opt,casttype=k8s.io/apimachinery/pkg/types.UID)

	// Specifies the target ResourceVersion
	// +optional
	resourceVersion?: null | string @go(ResourceVersion,*string) @protobuf(2,bytes,opt)
}

// Status is a return value for calls that don't return other objects.
#Status: {
	#TypeMeta

	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	metadata?: #ListMeta @go(ListMeta) @protobuf(1,bytes,opt)

	// Status of the operation.
	// One of: "Success" or "Failure".
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	// +optional
	status?: string @go(Status) @protobuf(2,bytes,opt)

	// A human-readable description of the status of this operation.
	// +optional
	message?: string @go(Message) @protobuf(3,bytes,opt)

	// A machine-readable description of why this operation is in the
	// "Failure" status. If this value is empty there
	// is no information available. A Reason clarifies an HTTP status
	// code but does not override it.
	// +optional
	reason?: #StatusReason @go(Reason) @protobuf(4,bytes,opt,casttype=StatusReason)

	// Extended data associated with the reason.  Each reason may define its
	// own extended details. This field is optional and the data returned
	// is not guaranteed to conform to any schema except that defined by
	// the reason type.
	// +optional
	details?: null | #StatusDetails @go(Details,*StatusDetails) @protobuf(5,bytes,opt)

	// Suggested HTTP return code for this status, 0 if not set.
	// +optional
	code?: int32 @go(Code) @protobuf(6,varint,opt)
}

// StatusDetails is a set of additional properties that MAY be set by the
// server to provide additional information about a response. The Reason
// field of a Status object defines what attributes will be set. Clients
// must ignore fields that do not match the defined type of each attribute,
// and should assume that any attribute may be empty, invalid, or under
// defined.
#StatusDetails: {
	// The name attribute of the resource associated with the status StatusReason
	// (when there is a single name which can be described).
	// +optional
	name?: string @go(Name) @protobuf(1,bytes,opt)

	// The group attribute of the resource associated with the status StatusReason.
	// +optional
	group?: string @go(Group) @protobuf(2,bytes,opt)

	// The kind attribute of the resource associated with the status StatusReason.
	// On some operations may differ from the requested resource Kind.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	kind?: string @go(Kind) @protobuf(3,bytes,opt)

	// UID of the resource.
	// (when there is a single resource which can be described).
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
	// +optional
	uid?: types.#UID @go(UID) @protobuf(6,bytes,opt,casttype=k8s.io/apimachinery/pkg/types.UID)

	// The Causes array includes more details associated with the StatusReason
	// failure. Not all StatusReasons may provide detailed causes.
	// +optional
	causes?: [...#StatusCause] @go(Causes,[]StatusCause) @protobuf(4,bytes,rep)

	// If specified, the time in seconds before the operation should be retried. Some errors may indicate
	// the client must take an alternate action - for those errors this field may indicate how long to wait
	// before taking the alternate action.
	// +optional
	retryAfterSeconds?: int32 @go(RetryAfterSeconds) @protobuf(5,varint,opt)
}

#StatusSuccess: "Success"
#StatusFailure: "Failure"

// StatusReason is an enumeration of possible failure causes.  Each StatusReason
// must map to a single HTTP status code, but multiple reasons may map
// to the same HTTP status code.
// TODO: move to apiserver
#StatusReason: string // #enumStatusReason

#enumStatusReason:
	#StatusReasonUnknown |
	#StatusReasonUnauthorized |
	#StatusReasonForbidden |
	#StatusReasonNotFound |
	#StatusReasonAlreadyExists |
	#StatusReasonConflict |
	#StatusReasonGone |
	#StatusReasonInvalid |
	#StatusReasonServerTimeout |
	#StatusReasonTimeout |
	#StatusReasonTooManyRequests |
	#StatusReasonBadRequest |
	#StatusReasonMethodNotAllowed |
	#StatusReasonNotAcceptable |
	#StatusReasonRequestEntityTooLarge |
	#StatusReasonUnsupportedMediaType |
	#StatusReasonInternalError |
	#StatusReasonExpired |
	#StatusReasonServiceUnavailable

// StatusReasonUnknown means the server has declined to indicate a specific reason.
// The details field may contain other information about this error.
// Status code 500.
#StatusReasonUnknown: #StatusReason & ""

// StatusReasonUnauthorized means the server can be reached and understood the request, but requires
// the user to present appropriate authorization credentials (identified by the WWW-Authenticate header)
// in order for the action to be completed. If the user has specified credentials on the request, the
// server considers them insufficient.
// Status code 401
#StatusReasonUnauthorized: #StatusReason & "Unauthorized"

// StatusReasonForbidden means the server can be reached and understood the request, but refuses
// to take any further action.  It is the result of the server being configured to deny access for some reason
// to the requested resource by the client.
// Details (optional):
//   "kind" string - the kind attribute of the forbidden resource
//                   on some operations may differ from the requested
//                   resource.
//   "id"   string - the identifier of the forbidden resource
// Status code 403
#StatusReasonForbidden: #StatusReason & "Forbidden"

// StatusReasonNotFound means one or more resources required for this operation
// could not be found.
// Details (optional):
//   "kind" string - the kind attribute of the missing resource
//                   on some operations may differ from the requested
//                   resource.
//   "id"   string - the identifier of the missing resource
// Status code 404
#StatusReasonNotFound: #StatusReason & "NotFound"

// StatusReasonAlreadyExists means the resource you are creating already exists.
// Details (optional):
//   "kind" string - the kind attribute of the conflicting resource
//   "id"   string - the identifier of the conflicting resource
// Status code 409
#StatusReasonAlreadyExists: #StatusReason & "AlreadyExists"

// StatusReasonConflict means the requested operation cannot be completed
// due to a conflict in the operation. The client may need to alter the
// request. Each resource may define custom details that indicate the
// nature of the conflict.
// Status code 409
#StatusReasonConflict: #StatusReason & "Conflict"

// StatusReasonGone means the item is no longer available at the server and no
// forwarding address is known.
// Status code 410
#StatusReasonGone: #StatusReason & "Gone"

// StatusReasonInvalid means the requested create or update operation cannot be
// completed due to invalid data provided as part of the request. The client may
// need to alter the request. When set, the client may use the StatusDetails
// message field as a summary of the issues encountered.
// Details (optional):
//   "kind" string - the kind attribute of the invalid resource
//   "id"   string - the identifier of the invalid resource
//   "causes"      - one or more StatusCause entries indicating the data in the
//                   provided resource that was invalid.  The code, message, and
//                   field attributes will be set.
// Status code 422
#StatusReasonInvalid: #StatusReason & "Invalid"

// StatusReasonServerTimeout means the server can be reached and understood the request,
// but cannot complete the action in a reasonable time. The client should retry the request.
// This is may be due to temporary server load or a transient communication issue with
// another server. Status code 500 is used because the HTTP spec provides no suitable
// server-requested client retry and the 5xx class represents actionable errors.
// Details (optional):
//   "kind" string - the kind attribute of the resource being acted on.
//   "id"   string - the operation that is being attempted.
//   "retryAfterSeconds" int32 - the number of seconds before the operation should be retried
// Status code 500
#StatusReasonServerTimeout: #StatusReason & "ServerTimeout"

// StatusReasonTimeout means that the request could not be completed within the given time.
// Clients can get this response only when they specified a timeout param in the request,
// or if the server cannot complete the operation within a reasonable amount of time.
// The request might succeed with an increased value of timeout param. The client *should*
// wait at least the number of seconds specified by the retryAfterSeconds field.
// Details (optional):
//   "retryAfterSeconds" int32 - the number of seconds before the operation should be retried
// Status code 504
#StatusReasonTimeout: #StatusReason & "Timeout"

// StatusReasonTooManyRequests means the server experienced too many requests within a
// given window and that the client must wait to perform the action again. A client may
// always retry the request that led to this error, although the client should wait at least
// the number of seconds specified by the retryAfterSeconds field.
// Details (optional):
//   "retryAfterSeconds" int32 - the number of seconds before the operation should be retried
// Status code 429
#StatusReasonTooManyRequests: #StatusReason & "TooManyRequests"

// StatusReasonBadRequest means that the request itself was invalid, because the request
// doesn't make any sense, for example deleting a read-only object.  This is different than
// StatusReasonInvalid above which indicates that the API call could possibly succeed, but the
// data was invalid.  API calls that return BadRequest can never succeed.
// Status code 400
#StatusReasonBadRequest: #StatusReason & "BadRequest"

// StatusReasonMethodNotAllowed means that the action the client attempted to perform on the
// resource was not supported by the code - for instance, attempting to delete a resource that
// can only be created. API calls that return MethodNotAllowed can never succeed.
// Status code 405
#StatusReasonMethodNotAllowed: #StatusReason & "MethodNotAllowed"

// StatusReasonNotAcceptable means that the accept types indicated by the client were not acceptable
// to the server - for instance, attempting to receive protobuf for a resource that supports only json and yaml.
// API calls that return NotAcceptable can never succeed.
// Status code 406
#StatusReasonNotAcceptable: #StatusReason & "NotAcceptable"

// StatusReasonRequestEntityTooLarge means that the request entity is too large.
// Status code 413
#StatusReasonRequestEntityTooLarge: #StatusReason & "RequestEntityTooLarge"

// StatusReasonUnsupportedMediaType means that the content type sent by the client is not acceptable
// to the server - for instance, attempting to send protobuf for a resource that supports only json and yaml.
// API calls that return UnsupportedMediaType can never succeed.
// Status code 415
#StatusReasonUnsupportedMediaType: #StatusReason & "UnsupportedMediaType"

// StatusReasonInternalError indicates that an internal error occurred, it is unexpected
// and the outcome of the call is unknown.
// Details (optional):
//   "causes" - The original error
// Status code 500
#StatusReasonInternalError: #StatusReason & "InternalError"

// StatusReasonExpired indicates that the request is invalid because the content you are requesting
// has expired and is no longer available. It is typically associated with watches that can't be
// serviced.
// Status code 410 (gone)
#StatusReasonExpired: #StatusReason & "Expired"

// StatusReasonServiceUnavailable means that the request itself was valid,
// but the requested service is unavailable at this time.
// Retrying the request after some time might succeed.
// Status code 503
#StatusReasonServiceUnavailable: #StatusReason & "ServiceUnavailable"

// StatusCause provides more information about an api.Status failure, including
// cases when multiple errors are encountered.
#StatusCause: {
	// A machine-readable description of the cause of the error. If this value is
	// empty there is no information available.
	// +optional
	reason?: #CauseType @go(Type) @protobuf(1,bytes,opt,casttype=CauseType)

	// A human-readable description of the cause of the error.  This field may be
	// presented as-is to a reader.
	// +optional
	message?: string @go(Message) @protobuf(2,bytes,opt)

	// The field of the resource that has caused this error, as named by its JSON
	// serialization. May include dot and postfix notation for nested attributes.
	// Arrays are zero-indexed.  Fields may appear more than once in an array of
	// causes due to fields having multiple errors.
	// Optional.
	//
	// Examples:
	//   "name" - the field "name" on the current resource
	//   "items[0].name" - the field "name" on the first array entry in "items"
	// +optional
	field?: string @go(Field) @protobuf(3,bytes,opt)
}

// CauseType is a machine readable value providing more detail about what
// occurred in a status response. An operation may have multiple causes for a
// status (whether Failure or Success).
#CauseType: string // #enumCauseType

#enumCauseType:
	#CauseTypeFieldValueNotFound |
	#CauseTypeFieldValueRequired |
	#CauseTypeFieldValueDuplicate |
	#CauseTypeFieldValueInvalid |
	#CauseTypeFieldValueNotSupported |
	#CauseTypeForbidden |
	#CauseTypeTooLong |
	#CauseTypeTooMany |
	#CauseTypeInternal |
	#CauseTypeTypeInvalid |
	#CauseTypeUnexpectedServerResponse |
	#CauseTypeFieldManagerConflict |
	#CauseTypeResourceVersionTooLarge

// CauseTypeFieldValueNotFound is used to report failure to find a requested value
// (e.g. looking up an ID).
#CauseTypeFieldValueNotFound: #CauseType & "FieldValueNotFound"

// CauseTypeFieldValueRequired is used to report required values that are not
// provided (e.g. empty strings, null values, or empty arrays).
#CauseTypeFieldValueRequired: #CauseType & "FieldValueRequired"

// CauseTypeFieldValueDuplicate is used to report collisions of values that must be
// unique (e.g. unique IDs).
#CauseTypeFieldValueDuplicate: #CauseType & "FieldValueDuplicate"

// CauseTypeFieldValueInvalid is used to report malformed values (e.g. failed regex
// match).
#CauseTypeFieldValueInvalid: #CauseType & "FieldValueInvalid"

// CauseTypeFieldValueNotSupported is used to report valid (as per formatting rules)
// values that can not be handled (e.g. an enumerated string).
#CauseTypeFieldValueNotSupported: #CauseType & "FieldValueNotSupported"

// CauseTypeForbidden is used to report valid (as per formatting rules)
// values which would be accepted under some conditions, but which are not
// permitted by the current conditions (such as security policy).  See
// Forbidden().
#CauseTypeForbidden: #CauseType & "FieldValueForbidden"

// CauseTypeTooLong is used to report that the given value is too long.
// This is similar to ErrorTypeInvalid, but the error will not include the
// too-long value.  See TooLong().
#CauseTypeTooLong: #CauseType & "FieldValueTooLong"

// CauseTypeTooMany is used to report "too many". This is used to
// report that a given list has too many items. This is similar to FieldValueTooLong,
// but the error indicates quantity instead of length.
#CauseTypeTooMany: #CauseType & "FieldValueTooMany"

// CauseTypeInternal is used to report other errors that are not related
// to user input.  See InternalError().
#CauseTypeInternal: #CauseType & "InternalError"

// CauseTypeTypeInvalid is for the value did not match the schema type for that field
#CauseTypeTypeInvalid: #CauseType & "FieldValueTypeInvalid"

// CauseTypeUnexpectedServerResponse is used to report when the server responded to the client
// without the expected return type. The presence of this cause indicates the error may be
// due to an intervening proxy or the server software malfunctioning.
#CauseTypeUnexpectedServerResponse: #CauseType & "UnexpectedServerResponse"

// FieldManagerConflict is used to report when another client claims to manage this field,
// It should only be returned for a request using server-side apply.
#CauseTypeFieldManagerConflict: #CauseType & "FieldManagerConflict"

// CauseTypeResourceVersionTooLarge is used to report that the requested resource version
// is newer than the data observed by the API server, so the request cannot be served.
#CauseTypeResourceVersionTooLarge: #CauseType & "ResourceVersionTooLarge"

// List holds a list of objects, which may not be known by the server.
#List: {
	#TypeMeta

	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	metadata?: #ListMeta @go(ListMeta) @protobuf(1,bytes,opt)

	// List of objects
	items: [...runtime.#RawExtension] @go(Items,[]runtime.RawExtension) @protobuf(2,bytes,rep)
}

// APIVersions lists the versions that are available, to allow clients to
// discover the API at /api, which is the root path of the legacy v1 API.
//
// +protobuf.options.(gogoproto.goproto_stringer)=false
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
#APIVersions: {
	#TypeMeta

	// versions are the api versions that are available.
	versions: [...string] @go(Versions,[]string) @protobuf(1,bytes,rep)

	// a map of client CIDR to server address that is serving this group.
	// This is to help clients reach servers in the most network-efficient way possible.
	// Clients can use the appropriate server address as per the CIDR that they match.
	// In case of multiple matches, clients should use the longest matching CIDR.
	// The server returns only those CIDRs that it thinks that the client can match.
	// For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP.
	// Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.
	serverAddressByClientCIDRs: [...#ServerAddressByClientCIDR] @go(ServerAddressByClientCIDRs,[]ServerAddressByClientCIDR) @protobuf(2,bytes,rep)
}

// APIGroupList is a list of APIGroup, to allow clients to discover the API at
// /apis.
#APIGroupList: {
	#TypeMeta

	// groups is a list of APIGroup.
	groups: [...#APIGroup] @go(Groups,[]APIGroup) @protobuf(1,bytes,rep)
}

// APIGroup contains the name, the supported versions, and the preferred version
// of a group.
#APIGroup: {
	#TypeMeta

	// name is the name of the group.
	name: string @go(Name) @protobuf(1,bytes,opt)

	// versions are the versions supported in this group.
	versions: [...#GroupVersionForDiscovery] @go(Versions,[]GroupVersionForDiscovery) @protobuf(2,bytes,rep)

	// preferredVersion is the version preferred by the API server, which
	// probably is the storage version.
	// +optional
	preferredVersion?: #GroupVersionForDiscovery @go(PreferredVersion) @protobuf(3,bytes,opt)

	// a map of client CIDR to server address that is serving this group.
	// This is to help clients reach servers in the most network-efficient way possible.
	// Clients can use the appropriate server address as per the CIDR that they match.
	// In case of multiple matches, clients should use the longest matching CIDR.
	// The server returns only those CIDRs that it thinks that the client can match.
	// For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP.
	// Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.
	// +optional
	serverAddressByClientCIDRs?: [...#ServerAddressByClientCIDR] @go(ServerAddressByClientCIDRs,[]ServerAddressByClientCIDR) @protobuf(4,bytes,rep)
}

// ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.
#ServerAddressByClientCIDR: {
	// The CIDR with which clients can match their IP to figure out the server address that they should use.
	clientCIDR: string @go(ClientCIDR) @protobuf(1,bytes,opt)

	// Address of this server, suitable for a client that matches the above CIDR.
	// This can be a hostname, hostname:port, IP or IP:port.
	serverAddress: string @go(ServerAddress) @protobuf(2,bytes,opt)
}

// GroupVersion contains the "group/version" and "version" string of a version.
// It is made a struct to keep extensibility.
#GroupVersionForDiscovery: {
	// groupVersion specifies the API group and version in the form "group/version"
	groupVersion: string @go(GroupVersion) @protobuf(1,bytes,opt)

	// version specifies the version in the form of "version". This is to save
	// the clients the trouble of splitting the GroupVersion.
	version: string @go(Version) @protobuf(2,bytes,opt)
}

// APIResource specifies the name of a resource and whether it is namespaced.
#APIResource: {
	// name is the plural name of the resource.
	name: string @go(Name) @protobuf(1,bytes,opt)

	// singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely.
	// The singularName is more correct for reporting status on a single item and both singular and plural are allowed
	// from the kubectl CLI interface.
	singularName: string @go(SingularName) @protobuf(6,bytes,opt)

	// namespaced indicates if a resource is namespaced or not.
	namespaced: bool @go(Namespaced) @protobuf(2,varint,opt)

	// group is the preferred group of the resource.  Empty implies the group of the containing resource list.
	// For subresources, this may have a different value, for example: Scale".
	group?: string @go(Group) @protobuf(8,bytes,opt)

	// version is the preferred version of the resource.  Empty implies the version of the containing resource list
	// For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource's group)".
	version?: string @go(Version) @protobuf(9,bytes,opt)

	// kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')
	kind: string @go(Kind) @protobuf(3,bytes,opt)

	// verbs is a list of supported kube verbs (this includes get, list, watch, create,
	// update, patch, delete, deletecollection, and proxy)
	verbs: #Verbs @go(Verbs) @protobuf(4,bytes,opt)

	// shortNames is a list of suggested short names of the resource.
	shortNames?: [...string] @go(ShortNames,[]string) @protobuf(5,bytes,rep)

	// categories is a list of the grouped resources this resource belongs to (e.g. 'all')
	categories?: [...string] @go(Categories,[]string) @protobuf(7,bytes,rep)

	// The hash value of the storage version, the version this resource is
	// converted to when written to the data store. Value must be treated
	// as opaque by clients. Only equality comparison on the value is valid.
	// This is an alpha feature and may change or be removed in the future.
	// The field is populated by the apiserver only if the
	// StorageVersionHash feature gate is enabled.
	// This field will remain optional even if it graduates.
	// +optional
	storageVersionHash?: string @go(StorageVersionHash) @protobuf(10,bytes,opt)
}

// Verbs masks the value so protobuf can generate
//
// +protobuf.nullable=true
// +protobuf.options.(gogoproto.goproto_stringer)=false
#Verbs: [...string]

// APIResourceList is a list of APIResource, it is used to expose the name of the
// resources supported in a specific group and version, and if the resource
// is namespaced.
#APIResourceList: {
	#TypeMeta

	// groupVersion is the group and version this APIResourceList is for.
	groupVersion: string @go(GroupVersion) @protobuf(1,bytes,opt)

	// resources contains the name of the resources and if they are namespaced.
	resources: [...#APIResource] @go(APIResources,[]APIResource) @protobuf(2,bytes,rep)
}

// RootPaths lists the paths available at root.
// For example: "/healthz", "/apis".
#RootPaths: {
	// paths are the paths available at root.
	paths: [...string] @go(Paths,[]string) @protobuf(1,bytes,rep)
}

// Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.
#Patch: {
}

// A label selector is a label query over a set of resources. The result of matchLabels and
// matchExpressions are ANDed. An empty label selector matches all objects. A null
// label selector matches no objects.
// +structType=atomic
#LabelSelector: {
	// matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
	// map is equivalent to an element of matchExpressions, whose key field is "key", the
	// operator is "In", and the values array contains only "value". The requirements are ANDed.
	// +optional
	matchLabels?: {[string]: string} @go(MatchLabels,map[string]string) @protobuf(1,bytes,rep)

	// matchExpressions is a list of label selector requirements. The requirements are ANDed.
	// +optional
	matchExpressions?: [...#LabelSelectorRequirement] @go(MatchExpressions,[]LabelSelectorRequirement) @protobuf(2,bytes,rep)
}

// A label selector requirement is a selector that contains values, a key, and an operator that
// relates the key and values.
#LabelSelectorRequirement: {
	// key is the label key that the selector applies to.
	key: string @go(Key) @protobuf(1,bytes,opt)

	// operator represents a key's relationship to a set of values.
	// Valid operators are In, NotIn, Exists and DoesNotExist.
	operator: #LabelSelectorOperator @go(Operator) @protobuf(2,bytes,opt,casttype=LabelSelectorOperator)

	// values is an array of string values. If the operator is In or NotIn,
	// the values array must be non-empty. If the operator is Exists or DoesNotExist,
	// the values array must be empty. This array is replaced during a strategic
	// merge patch.
	// +optional
	values?: [...string] @go(Values,[]string) @protobuf(3,bytes,rep)
}

// A label selector operator is the set of operators that can be used in a selector requirement.
#LabelSelectorOperator: string // #enumLabelSelectorOperator

#enumLabelSelectorOperator:
	#LabelSelectorOpIn |
	#LabelSelectorOpNotIn |
	#LabelSelectorOpExists |
	#LabelSelectorOpDoesNotExist

#LabelSelectorOpIn:           #LabelSelectorOperator & "In"
#LabelSelectorOpNotIn:        #LabelSelectorOperator & "NotIn"
#LabelSelectorOpExists:       #LabelSelectorOperator & "Exists"
#LabelSelectorOpDoesNotExist: #LabelSelectorOperator & "DoesNotExist"

// ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource
// that the fieldset applies to.
#ManagedFieldsEntry: {
	// Manager is an identifier of the workflow managing these fields.
	manager?: string @go(Manager) @protobuf(1,bytes,opt)

	// Operation is the type of operation which lead to this ManagedFieldsEntry being created.
	// The only valid values for this field are 'Apply' and 'Update'.
	operation?: #ManagedFieldsOperationType @go(Operation) @protobuf(2,bytes,opt,casttype=ManagedFieldsOperationType)

	// APIVersion defines the version of this resource that this field set
	// applies to. The format is "group/version" just like the top-level
	// APIVersion field. It is necessary to track the version of a field
	// set because it cannot be automatically converted.
	apiVersion?: string @go(APIVersion) @protobuf(3,bytes,opt)

	// Time is the timestamp of when the ManagedFields entry was added. The
	// timestamp will also be updated if a field is added, the manager
	// changes any of the owned fields value or removes a field. The
	// timestamp does not update when a field is removed from the entry
	// because another manager took it over.
	// +optional
	time?: null | #Time @go(Time,*Time) @protobuf(4,bytes,opt)

	// FieldsType is the discriminator for the different fields format and version.
	// There is currently only one possible value: "FieldsV1"
	fieldsType?: string @go(FieldsType) @protobuf(6,bytes,opt)

	// FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
	// +optional
	fieldsV1?: null | #FieldsV1 @go(FieldsV1,*FieldsV1) @protobuf(7,bytes,opt)

	// Subresource is the name of the subresource used to update that object, or
	// empty string if the object was updated through the main resource. The
	// value of this field is used to distinguish between managers, even if they
	// share the same name. For example, a status update will be distinct from a
	// regular update using the same manager name.
	// Note that the APIVersion field is not related to the Subresource field and
	// it always corresponds to the version of the main resource.
	subresource?: string @go(Subresource) @protobuf(8,bytes,opt)
}

// ManagedFieldsOperationType is the type of operation which lead to a ManagedFieldsEntry being created.
#ManagedFieldsOperationType: string // #enumManagedFieldsOperationType

#enumManagedFieldsOperationType:
	#ManagedFieldsOperationApply |
	#ManagedFieldsOperationUpdate

#ManagedFieldsOperationApply:  #ManagedFieldsOperationType & "Apply"
#ManagedFieldsOperationUpdate: #ManagedFieldsOperationType & "Update"

// FieldsV1 stores a set of fields in a data structure like a Trie, in JSON format.
//
// Each key is either a '.' representing the field itself, and will always map to an empty set,
// or a string representing a sub-field or item. The string will follow one of these four formats:
// 'f:<name>', where <name> is the name of a field in a struct, or key in a map
// 'v:<value>', where <value> is the exact json formatted value of a list item
// 'i:<index>', where <index> is position of a item in a list
// 'k:<keys>', where <keys> is a map of  a list item's key fields to their unique values
// If a key maps to an empty Fields value, the field that key represents is part of the set.
//
// The exact format is defined in sigs.k8s.io/structured-merge-diff
// +protobuf.options.(gogoproto.goproto_stringer)=false
#FieldsV1: _

// Table is a tabular representation of a set of API resources. The server transforms the
// object into a set of preferred columns for quickly reviewing the objects.
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
// +protobuf=false
#Table: {
	#TypeMeta

	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	metadata?: #ListMeta @go(ListMeta)

	// columnDefinitions describes each column in the returned items array. The number of cells per row
	// will always match the number of column definitions.
	columnDefinitions: [...#TableColumnDefinition] @go(ColumnDefinitions,[]TableColumnDefinition)

	// rows is the list of items in the table.
	rows: [...#TableRow] @go(Rows,[]TableRow)
}

// TableColumnDefinition contains information about a column returned in the Table.
// +protobuf=false
#TableColumnDefinition: {
	// name is a human readable name for the column.
	name: string @go(Name)

	// type is an OpenAPI type definition for this column, such as number, integer, string, or
	// array.
	// See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.
	type: string @go(Type)

	// format is an optional OpenAPI type modifier for this column. A format modifies the type and
	// imposes additional rules, like date or time formatting for a string. The 'name' format is applied
	// to the primary identifier column which has type 'string' to assist in clients identifying column
	// is the resource name.
	// See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.
	format: string @go(Format)

	// description is a human readable description of this column.
	description: string @go(Description)

	// priority is an integer defining the relative importance of this column compared to others. Lower
	// numbers are considered higher priority. Columns that may be omitted in limited space scenarios
	// should be given a higher priority.
	priority: int32 @go(Priority)
}

// TableRow is an individual row in a table.
// +protobuf=false
#TableRow: {
	// cells will be as wide as the column definitions array and may contain strings, numbers (float64 or
	// int64), booleans, simple maps, lists, or null. See the type field of the column definition for a
	// more detailed description.
	cells: [...] @go(Cells,[]interface{})

	// conditions describe additional status of a row that are relevant for a human user. These conditions
	// apply to the row, not to the object, and will be specific to table output. The only defined
	// condition type is 'Completed', for a row that indicates a resource that has run to completion and
	// can be given less visual priority.
	// +optional
	conditions?: [...#TableRowCondition] @go(Conditions,[]TableRowCondition)

	// This field contains the requested additional information about each object based on the includeObject
	// policy when requesting the Table. If "None", this field is empty, if "Object" this will be the
	// default serialization of the object for the current API version, and if "Metadata" (the default) will
	// contain the object metadata. Check the returned kind and apiVersion of the object before parsing.
	// The media type of the object will always match the enclosing list - if this as a JSON table, these
	// will be JSON encoded objects.
	// +optional
	object?: runtime.#RawExtension @go(Object)
}

// TableRowCondition allows a row to be marked with additional information.
// +protobuf=false
#TableRowCondition: {
	// Type of row condition. The only defined value is 'Completed' indicating that the
	// object this row represents has reached a completed state and may be given less visual
	// priority than other rows. Clients are not required to honor any conditions but should
	// be consistent where possible about handling the conditions.
	type: #RowConditionType @go(Type)

	// Status of the condition, one of True, False, Unknown.
	status: #ConditionStatus @go(Status)

	// (brief) machine readable reason for the condition's last transition.
	// +optional
	reason?: string @go(Reason)

	// Human readable message indicating details about last transition.
	// +optional
	message?: string @go(Message)
}

#RowConditionType: string // #enumRowConditionType

#enumRowConditionType:
	#RowCompleted

// RowCompleted means the underlying resource has reached completion and may be given less
// visual priority than other resources.
#RowCompleted: #RowConditionType & "Completed"

#ConditionStatus: string // #enumConditionStatus

#enumConditionStatus:
	#ConditionTrue |
	#ConditionFalse |
	#ConditionUnknown

#ConditionTrue:    #ConditionStatus & "True"
#ConditionFalse:   #ConditionStatus & "False"
#ConditionUnknown: #ConditionStatus & "Unknown"

// IncludeObjectPolicy controls which portion of the object is returned with a Table.
#IncludeObjectPolicy: string // #enumIncludeObjectPolicy

#enumIncludeObjectPolicy:
	#IncludeNone |
	#IncludeMetadata |
	#IncludeObject

// IncludeNone returns no object.
#IncludeNone: #IncludeObjectPolicy & "None"

// IncludeMetadata serializes the object containing only its metadata field.
#IncludeMetadata: #IncludeObjectPolicy & "Metadata"

// IncludeObject contains the full object.
#IncludeObject: #IncludeObjectPolicy & "Object"

// TableOptions are used when a Table is requested by the caller.
// +k8s:conversion-gen:explicit-from=net/url.Values
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
#TableOptions: {
	#TypeMeta

	// includeObject decides whether to include each object along with its columnar information.
	// Specifying "None" will return no object, specifying "Object" will return the full object contents, and
	// specifying "Metadata" (the default) will return the object's metadata in the PartialObjectMetadata kind
	// in version v1beta1 of the meta.k8s.io API group.
	includeObject?: #IncludeObjectPolicy @go(IncludeObject) @protobuf(1,bytes,opt,casttype=IncludeObjectPolicy)
}

// PartialObjectMetadata is a generic representation of any object with ObjectMeta. It allows clients
// to get access to a particular ObjectMeta schema without knowing the details of the version.
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
#PartialObjectMetadata: {
	#TypeMeta

	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
	// +optional
	metadata?: #ObjectMeta @go(ObjectMeta) @protobuf(1,bytes,opt)
}

// PartialObjectMetadataList contains a list of objects containing only their metadata
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
#PartialObjectMetadataList: {
	#TypeMeta

	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	metadata?: #ListMeta @go(ListMeta) @protobuf(1,bytes,opt)

	// items contains each of the included items.
	items: [...#PartialObjectMetadata] @go(Items,[]PartialObjectMetadata) @protobuf(2,bytes,rep)
}

// Condition contains details for one aspect of the current state of this API Resource.
// ---
// This struct is intended for direct use as an array at the field path .status.conditions.  For example,
//
//	type FooStatus struct{
//	    // Represents the observations of a foo's current state.
//	    // Known .status.conditions.type are: "Available", "Progressing", and "Degraded"
//	    // +patchMergeKey=type
//	    // +patchStrategy=merge
//	    // +listType=map
//	    // +listMapKey=type
//	    Conditions []metav1.Condition `json:"conditions,omitempty" patchStrategy:"merge" patchMergeKey:"type" protobuf:"bytes,1,rep,name=conditions"`
//
//	    // other fields
//	}
#Condition: {
	// type of condition in CamelCase or in foo.example.com/CamelCase.
	// ---
	// Many .condition.type values are consistent across resources like Available, but because arbitrary conditions can be
	// useful (see .node.status.conditions), the ability to deconflict is important.
	// The regex it matches is (dns1123SubdomainFmt/)?(qualifiedNameFmt)
	// +required
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:Pattern=`^([a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*/)?(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])$`
	// +kubebuilder:validation:MaxLength=316
	type: string @go(Type) @protobuf(1,bytes,opt)

	// status of the condition, one of True, False, Unknown.
	// +required
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:Enum=True;False;Unknown
	status: #ConditionStatus @go(Status) @protobuf(2,bytes,opt)

	// observedGeneration represents the .metadata.generation that the condition was set based upon.
	// For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date
	// with respect to the current state of the instance.
	// +optional
	// +kubebuilder:validation:Minimum=0
	observedGeneration?: int64 @go(ObservedGeneration) @protobuf(3,varint,opt)

	// lastTransitionTime is the last time the condition transitioned from one status to another.
	// This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.
	// +required
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:Type=string
	// +kubebuilder:validation:Format=date-time
	lastTransitionTime: #Time @go(LastTransitionTime) @protobuf(4,bytes,opt)

	// reason contains a programmatic identifier indicating the reason for the condition's last transition.
	// Producers of specific condition types may define expected values and meanings for this field,
	// and whether the values are considered a guaranteed API.
	// The value should be a CamelCase string.
	// This field may not be empty.
	// +required
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MaxLength=1024
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:Pattern=`^[A-Za-z]([A-Za-z0-9_,:]*[A-Za-z0-9_])?$`
	reason: string @go(Reason) @protobuf(5,bytes,opt)

	// message is a human readable message indicating details about the transition.
	// This may be an empty string.
	// +required
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MaxLength=32768
	message: string @go(Message) @protobuf(6,bytes,opt)
}
