// Code generated by cue get go. DO NOT EDIT.

//cue:generate cue get go github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/api/core/v1"
)

#AlertmanagersKind:   "Alertmanager"
#AlertmanagerName:    "alertmanagers"
#AlertManagerKindKey: "alertmanager"

// Alertmanager describes an Alertmanager cluster.
#Alertmanager: {
	metav1.#TypeMeta
	metadata?: metav1.#ObjectMeta @go(ObjectMeta)

	// Specification of the desired behavior of the Alertmanager cluster. More info:
	// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	spec: #AlertmanagerSpec @go(Spec)

	// Most recent observed status of the Alertmanager cluster. Read-only.
	// More info:
	// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	status?: #AlertmanagerStatus @go(Status)
}

// AlertmanagerSpec is a specification of the desired behavior of the Alertmanager cluster. More info:
// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
// +k8s:openapi-gen=true
#AlertmanagerSpec: {
	// PodMetadata configures Labels and Annotations which are propagated to the alertmanager pods.
	podMetadata?: null | #EmbeddedObjectMetadata @go(PodMetadata,*EmbeddedObjectMetadata)

	// Image if specified has precedence over baseImage, tag and sha
	// combinations. Specifying the version is still necessary to ensure the
	// Prometheus Operator knows what version of Alertmanager is being
	// configured.
	image?: null | string @go(Image,*string)

	// Image pull policy for the 'alertmanager', 'init-config-reloader' and 'config-reloader' containers.
	// See https://kubernetes.io/docs/concepts/containers/images/#image-pull-policy for more details.
	// +kubebuilder:validation:Enum="";Always;Never;IfNotPresent
	imagePullPolicy?: v1.#PullPolicy @go(ImagePullPolicy)

	// Version the cluster should be on.
	version?: string @go(Version)

	// Tag of Alertmanager container image to be deployed. Defaults to the value of `version`.
	// Version is ignored if Tag is set.
	// Deprecated: use 'image' instead.  The image tag can be specified
	// as part of the image URL.
	tag?: string @go(Tag)

	// SHA of Alertmanager container image to be deployed. Defaults to the value of `version`.
	// Similar to a tag, but the SHA explicitly deploys an immutable container image.
	// Version and Tag are ignored if SHA is set.
	// Deprecated: use 'image' instead.  The image digest can be specified
	// as part of the image URL.
	sha?: string @go(SHA)

	// Base image that is used to deploy pods, without tag.
	// Deprecated: use 'image' instead
	baseImage?: string @go(BaseImage)

	// An optional list of references to secrets in the same namespace
	// to use for pulling prometheus and alertmanager images from registries
	// see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod
	imagePullSecrets?: [...v1.#LocalObjectReference] @go(ImagePullSecrets,[]v1.LocalObjectReference)

	// Secrets is a list of Secrets in the same namespace as the Alertmanager
	// object, which shall be mounted into the Alertmanager Pods.
	// Each Secret is added to the StatefulSet definition as a volume named `secret-<secret-name>`.
	// The Secrets are mounted into `/etc/alertmanager/secrets/<secret-name>` in the 'alertmanager' container.
	secrets?: [...string] @go(Secrets,[]string)

	// ConfigMaps is a list of ConfigMaps in the same namespace as the Alertmanager
	// object, which shall be mounted into the Alertmanager Pods.
	// Each ConfigMap is added to the StatefulSet definition as a volume named `configmap-<configmap-name>`.
	// The ConfigMaps are mounted into `/etc/alertmanager/configmaps/<configmap-name>` in the 'alertmanager' container.
	configMaps?: [...string] @go(ConfigMaps,[]string)

	// ConfigSecret is the name of a Kubernetes Secret in the same namespace as the
	// Alertmanager object, which contains the configuration for this Alertmanager
	// instance. If empty, it defaults to `alertmanager-<alertmanager-name>`.
	//
	// The Alertmanager configuration should be available under the
	// `alertmanager.yaml` key. Additional keys from the original secret are
	// copied to the generated secret and mounted into the
	// `/etc/alertmanager/config` directory in the `alertmanager` container.
	//
	// If either the secret or the `alertmanager.yaml` key is missing, the
	// operator provisions a minimal Alertmanager configuration with one empty
	// receiver (effectively dropping alert notifications).
	configSecret?: string @go(ConfigSecret)

	// Log level for Alertmanager to be configured with.
	//+kubebuilder:validation:Enum="";debug;info;warn;error
	logLevel?: string @go(LogLevel)

	// Log format for Alertmanager to be configured with.
	//+kubebuilder:validation:Enum="";logfmt;json
	logFormat?: string @go(LogFormat)

	// Size is the expected size of the alertmanager cluster. The controller will
	// eventually make the size of the running cluster equal to the expected
	// size.
	replicas?: null | int32 @go(Replicas,*int32)

	// Time duration Alertmanager shall retain data for. Default is '120h',
	// and must match the regular expression `[0-9]+(ms|s|m|h)` (milliseconds seconds minutes hours).
	// +kubebuilder:default:="120h"
	retention?: #GoDuration @go(Retention)

	// Storage is the definition of how storage will be used by the Alertmanager
	// instances.
	storage?: null | #StorageSpec @go(Storage,*StorageSpec)

	// Volumes allows configuration of additional volumes on the output StatefulSet definition.
	// Volumes specified will be appended to other volumes that are generated as a result of
	// StorageSpec objects.
	volumes?: [...v1.#Volume] @go(Volumes,[]v1.Volume)

	// VolumeMounts allows configuration of additional VolumeMounts on the output StatefulSet definition.
	// VolumeMounts specified will be appended to other VolumeMounts in the alertmanager container,
	// that are generated as a result of StorageSpec objects.
	volumeMounts?: [...v1.#VolumeMount] @go(VolumeMounts,[]v1.VolumeMount)

	// The external URL the Alertmanager instances will be available under. This is
	// necessary to generate correct URLs. This is necessary if Alertmanager is not
	// served from root of a DNS name.
	externalUrl?: string @go(ExternalURL)

	// The route prefix Alertmanager registers HTTP handlers for. This is useful,
	// if using ExternalURL and a proxy is rewriting HTTP routes of a request,
	// and the actual ExternalURL is still true, but the server serves requests
	// under a different route prefix. For example for use with `kubectl proxy`.
	routePrefix?: string @go(RoutePrefix)

	// If set to true all actions on the underlying managed objects are not
	// goint to be performed, except for delete actions.
	paused?: bool @go(Paused)

	// Define which Nodes the Pods are scheduled on.
	nodeSelector?: {[string]: string} @go(NodeSelector,map[string]string)

	// Define resources requests and limits for single Pods.
	resources?: v1.#ResourceRequirements @go(Resources)

	// If specified, the pod's scheduling constraints.
	affinity?: null | v1.#Affinity @go(Affinity,*v1.Affinity)

	// If specified, the pod's tolerations.
	tolerations?: [...v1.#Toleration] @go(Tolerations,[]v1.Toleration)

	// If specified, the pod's topology spread constraints.
	topologySpreadConstraints?: [...v1.#TopologySpreadConstraint] @go(TopologySpreadConstraints,[]v1.TopologySpreadConstraint)

	// SecurityContext holds pod-level security attributes and common container settings.
	// This defaults to the default PodSecurityContext.
	securityContext?: null | v1.#PodSecurityContext @go(SecurityContext,*v1.PodSecurityContext)

	// ServiceAccountName is the name of the ServiceAccount to use to run the
	// Prometheus Pods.
	serviceAccountName?: string @go(ServiceAccountName)

	// ListenLocal makes the Alertmanager server listen on loopback, so that it
	// does not bind against the Pod IP. Note this is only for the Alertmanager
	// UI, not the gossip communication.
	listenLocal?: bool @go(ListenLocal)

	// Containers allows injecting additional containers. This is meant to
	// allow adding an authentication proxy to an Alertmanager pod.
	// Containers described here modify an operator generated container if they
	// share the same name and modifications are done via a strategic merge
	// patch. The current container names are: `alertmanager` and
	// `config-reloader`. Overriding containers is entirely outside the scope
	// of what the maintainers will support and by doing so, you accept that
	// this behaviour may break at any time without notice.
	containers?: [...v1.#Container] @go(Containers,[]v1.Container)

	// InitContainers allows adding initContainers to the pod definition. Those can be used to e.g.
	// fetch secrets for injection into the Alertmanager configuration from external sources. Any
	// errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
	// Using initContainers for any use case other then secret fetching is entirely outside the scope
	// of what the maintainers will support and by doing so, you accept that this behaviour may break
	// at any time without notice.
	initContainers?: [...v1.#Container] @go(InitContainers,[]v1.Container)

	// Priority class assigned to the Pods
	priorityClassName?: string @go(PriorityClassName)

	// AdditionalPeers allows injecting a set of additional Alertmanagers to peer with to form a highly available cluster.
	additionalPeers?: [...string] @go(AdditionalPeers,[]string)

	// ClusterAdvertiseAddress is the explicit address to advertise in cluster.
	// Needs to be provided for non RFC1918 [1] (public) addresses.
	// [1] RFC1918: https://tools.ietf.org/html/rfc1918
	clusterAdvertiseAddress?: string @go(ClusterAdvertiseAddress)

	// Interval between gossip attempts.
	clusterGossipInterval?: #GoDuration @go(ClusterGossipInterval)

	// Interval between pushpull attempts.
	clusterPushpullInterval?: #GoDuration @go(ClusterPushpullInterval)

	// Timeout for cluster peering.
	clusterPeerTimeout?: #GoDuration @go(ClusterPeerTimeout)

	// Port name used for the pods and governing service.
	// This defaults to web
	portName?: string @go(PortName)

	// ForceEnableClusterMode ensures Alertmanager does not deactivate the cluster mode when running with a single replica.
	// Use case is e.g. spanning an Alertmanager cluster across Kubernetes clusters with a single replica in each.
	forceEnableClusterMode?: bool @go(ForceEnableClusterMode)

	// AlertmanagerConfigs to be selected for to merge and configure Alertmanager with.
	alertmanagerConfigSelector?: null | metav1.#LabelSelector @go(AlertmanagerConfigSelector,*metav1.LabelSelector)

	// The AlertmanagerConfigMatcherStrategy defines how AlertmanagerConfig objects match the alerts.
	// In the future more options may be added.
	alertmanagerConfigMatcherStrategy?: #AlertmanagerConfigMatcherStrategy @go(AlertmanagerConfigMatcherStrategy)

	// Namespaces to be selected for AlertmanagerConfig discovery. If nil, only
	// check own namespace.
	alertmanagerConfigNamespaceSelector?: null | metav1.#LabelSelector @go(AlertmanagerConfigNamespaceSelector,*metav1.LabelSelector)

	// Minimum number of seconds for which a newly created pod should be ready
	// without any of its container crashing for it to be considered available.
	// Defaults to 0 (pod will be considered available as soon as it is ready)
	// This is an alpha field from kubernetes 1.22 until 1.24 which requires enabling the StatefulSetMinReadySeconds feature gate.
	// +optional
	minReadySeconds?: null | uint32 @go(MinReadySeconds,*uint32)

	// Pods' hostAliases configuration
	// +listType=map
	// +listMapKey=ip
	hostAliases?: [...#HostAlias] @go(HostAliases,[]HostAlias)

	// Defines the web command line flags when starting Alertmanager.
	web?: null | #AlertmanagerWebSpec @go(Web,*AlertmanagerWebSpec)

	// EXPERIMENTAL: alertmanagerConfiguration specifies the configuration of Alertmanager.
	// If defined, it takes precedence over the `configSecret` field.
	// This field may change in future releases.
	alertmanagerConfiguration?: null | #AlertmanagerConfiguration @go(AlertmanagerConfiguration,*AlertmanagerConfiguration)
}

// AlertmanagerConfigMatcherStrategy defines the strategy used by AlertmanagerConfig objects to match alerts.
#AlertmanagerConfigMatcherStrategy: {
	// If set to `OnNamespace`, the operator injects a label matcher matching the namespace of the AlertmanagerConfig object for all its routes and inhibition rules.
	// `None` will not add any additional matchers other than the ones specified in the AlertmanagerConfig.
	// Default is `OnNamespace`.
	// +kubebuilder:validation:Enum="OnNamespace";"None"
	// +kubebuilder:default:="OnNamespace"
	type?: string @go(Type)
}

// AlertmanagerConfiguration defines the Alertmanager configuration.
// +k8s:openapi-gen=true
#AlertmanagerConfiguration: {
	// The name of the AlertmanagerConfig resource which is used to generate the Alertmanager configuration.
	// It must be defined in the same namespace as the Alertmanager object.
	// The operator will not enforce a `namespace` label for routes and inhibition rules.
	// +kubebuilder:validation:MinLength=1
	name?: string @go(Name)

	// Defines the global parameters of the Alertmanager configuration.
	// +optional
	global?: null | #AlertmanagerGlobalConfig @go(Global,*AlertmanagerGlobalConfig)

	// Custom notification templates.
	// +optional
	templates?: [...#SecretOrConfigMap] @go(Templates,[]SecretOrConfigMap)
}

// AlertmanagerGlobalConfig configures parameters that are valid in all other configuration contexts.
// See https://prometheus.io/docs/alerting/latest/configuration/#configuration-file
#AlertmanagerGlobalConfig: {
	// ResolveTimeout is the default value used by alertmanager if the alert does
	// not include EndsAt, after this time passes it can declare the alert as resolved if it has not been updated.
	// This has no impact on alerts from Prometheus, as they always include EndsAt.
	resolveTimeout?: #Duration @go(ResolveTimeout)

	// HTTP client configuration.
	httpConfig?: null | #HTTPConfig @go(HTTPConfig,*HTTPConfig)
}

// AlertmanagerStatus is the most recent observed status of the Alertmanager cluster. Read-only.
// More info:
// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
// +k8s:openapi-gen=true
#AlertmanagerStatus: {
	// Represents whether any actions on the underlying managed objects are
	// being performed. Only delete actions will be performed.
	paused: bool @go(Paused)

	// Total number of non-terminated pods targeted by this Alertmanager
	// object (their labels match the selector).
	replicas: int32 @go(Replicas)

	// Total number of non-terminated pods targeted by this Alertmanager
	// object that have the desired version spec.
	updatedReplicas: int32 @go(UpdatedReplicas)

	// Total number of available pods (ready for at least minReadySeconds)
	// targeted by this Alertmanager cluster.
	availableReplicas: int32 @go(AvailableReplicas)

	// Total number of unavailable pods targeted by this Alertmanager object.
	unavailableReplicas: int32 @go(UnavailableReplicas)

	// The current state of the Alertmanager object.
	// +listType=map
	// +listMapKey=type
	// +optional
	conditions?: [...#Condition] @go(Conditions,[]Condition)
}

// AlertmanagerWebSpec defines the web command line flags when starting Alertmanager.
// +k8s:openapi-gen=true
#AlertmanagerWebSpec: {
	#WebConfigFileFields
}

// HTTPConfig defines a client HTTP configuration.
// See https://prometheus.io/docs/alerting/latest/configuration/#http_config
#HTTPConfig: {
	// Authorization header configuration for the client.
	// This is mutually exclusive with BasicAuth and is only available starting from Alertmanager v0.22+.
	// +optional
	authorization?: null | #SafeAuthorization @go(Authorization,*SafeAuthorization)

	// BasicAuth for the client.
	// This is mutually exclusive with Authorization. If both are defined, BasicAuth takes precedence.
	// +optional
	basicAuth?: null | #BasicAuth @go(BasicAuth,*BasicAuth)

	// OAuth2 client credentials used to fetch a token for the targets.
	// +optional
	oauth2?: null | #OAuth2 @go(OAuth2,*OAuth2)

	// The secret's key that contains the bearer token to be used by the client
	// for authentication.
	// The secret needs to be in the same namespace as the Alertmanager
	// object and accessible by the Prometheus Operator.
	// +optional
	bearerTokenSecret?: null | v1.#SecretKeySelector @go(BearerTokenSecret,*v1.SecretKeySelector)

	// TLS configuration for the client.
	// +optional
	tlsConfig?: null | #SafeTLSConfig @go(TLSConfig,*SafeTLSConfig)

	// Optional proxy URL.
	// +optional
	proxyURL?: string @go(ProxyURL)

	// FollowRedirects specifies whether the client should follow HTTP 3xx redirects.
	// +optional
	followRedirects?: null | bool @go(FollowRedirects,*bool)
}

// AlertmanagerList is a list of Alertmanagers.
// +k8s:openapi-gen=true
#AlertmanagerList: {
	metav1.#TypeMeta

	// Standard list metadata
	// More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
	metadata?: metav1.#ListMeta @go(ListMeta)

	// List of Alertmanagers
	items: [...#Alertmanager] @go(Items,[]Alertmanager)
}
