// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package buildcontrol

import (
	"context"

	"github.com/google/wire"
	"github.com/jonboulle/clockwork"
	"sigs.k8s.io/controller-runtime/pkg/client"

	"github.com/tilt-dev/clusterid"
	"github.com/tilt-dev/tilt/internal/analytics"
	"github.com/tilt-dev/tilt/internal/build"
	"github.com/tilt-dev/tilt/internal/containerupdate"
	"github.com/tilt-dev/tilt/internal/controllers/core/cmd"
	"github.com/tilt-dev/tilt/internal/controllers/core/cmdimage"
	"github.com/tilt-dev/tilt/internal/controllers/core/dockercomposeservice"
	"github.com/tilt-dev/tilt/internal/controllers/core/dockerimage"
	"github.com/tilt-dev/tilt/internal/controllers/core/kubernetesapply"
	"github.com/tilt-dev/tilt/internal/docker"
	"github.com/tilt-dev/tilt/internal/dockercompose"
	"github.com/tilt-dev/tilt/internal/dockerfile"
	"github.com/tilt-dev/tilt/internal/k8s"
	"github.com/tilt-dev/tilt/internal/localexec"
	"github.com/tilt-dev/tilt/internal/store"
	"github.com/tilt-dev/tilt/internal/store/liveupdates"
	"github.com/tilt-dev/tilt/internal/tracer"
	"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1"
	"github.com/tilt-dev/wmclient/pkg/dirs"
)

// Injectors from wire.go:

func ProvideImageBuildAndDeployer(ctx context.Context, docker2 docker.Client, kClient k8s.Client, env clusterid.Product, kubeContext k8s.KubeContext, clusterEnv docker.ClusterEnv, dir *dirs.TiltDevDir, clock build.Clock, clock2 clockwork.Clock, kp build.KINDLoader, analytics2 *analytics.TiltAnalytics, ctrlclient client.Client, st store.RStore) (*ImageBuildAndDeployer, error) {
	scheme := v1alpha1.NewScheme()
	labels := _wireLabelsValue
	dockerBuilder := build.NewDockerBuilder(docker2, labels)
	localexecEnv := localexec.EmptyEnv()
	execer := cmd.ProvideExecer(localexecEnv)
	fakeProberManager := cmd.NewFakeProberManager()
	controller := cmd.NewController(ctx, execer, fakeProberManager, ctrlclient, st, clock2, scheme)
	customBuilder := build.NewCustomBuilder(docker2, clock, controller)
	imageBuilder := build.NewImageBuilder(dockerBuilder, customBuilder, kp)
	reconciler := dockerimage.NewReconciler(ctrlclient, st, scheme, docker2, imageBuilder)
	cmdimageReconciler := cmdimage.NewReconciler(ctrlclient, st, scheme, docker2, imageBuilder)
	processExecer := localexec.NewProcessExecer(localexecEnv)
	kubernetesapplyReconciler := kubernetesapply.NewReconciler(ctrlclient, kClient, scheme, dockerBuilder, st, processExecer)
	imageBuildAndDeployer := NewImageBuildAndDeployer(reconciler, cmdimageReconciler, imageBuilder, analytics2, clock, ctrlclient, kubernetesapplyReconciler)
	return imageBuildAndDeployer, nil
}

var (
	_wireLabelsValue = dockerfile.Labels{}
)

func ProvideDockerComposeBuildAndDeployer(ctx context.Context, dcCli dockercompose.DockerComposeClient, dCli docker.Client, ctrlclient client.Client, st store.RStore, clock clockwork.Clock, dir *dirs.TiltDevDir) (*DockerComposeBuildAndDeployer, error) {
	scheme := v1alpha1.NewScheme()
	labels := _wireLabelsValue
	dockerBuilder := build.NewDockerBuilder(dCli, labels)
	buildClock := build.ProvideClock()
	env := localexec.EmptyEnv()
	execer := cmd.ProvideExecer(env)
	fakeProberManager := cmd.NewFakeProberManager()
	controller := cmd.NewController(ctx, execer, fakeProberManager, ctrlclient, st, clock, scheme)
	customBuilder := build.NewCustomBuilder(dCli, buildClock, controller)
	kindLoader := build.NewKINDLoader()
	imageBuilder := build.NewImageBuilder(dockerBuilder, customBuilder, kindLoader)
	reconciler := dockerimage.NewReconciler(ctrlclient, st, scheme, dCli, imageBuilder)
	cmdimageReconciler := cmdimage.NewReconciler(ctrlclient, st, scheme, dCli, imageBuilder)
	disableSubscriber := dockercomposeservice.NewDisableSubscriber(ctx, dcCli, clock)
	dockercomposeserviceReconciler := dockercomposeservice.NewReconciler(ctrlclient, dcCli, dCli, st, scheme, disableSubscriber)
	dockerComposeBuildAndDeployer := NewDockerComposeBuildAndDeployer(reconciler, cmdimageReconciler, imageBuilder, dockercomposeserviceReconciler, buildClock, ctrlclient)
	return dockerComposeBuildAndDeployer, nil
}

// wire.go:

var BaseWireSet = wire.NewSet(wire.Value(dockerfile.Labels{}), v1alpha1.NewScheme, k8s.ProvideMinikubeClient, build.NewDockerBuilder, build.NewCustomBuilder, wire.Bind(new(build.DockerKubeConnection), new(*build.DockerBuilder)), NewDockerComposeBuildAndDeployer,
	NewImageBuildAndDeployer,
	NewLocalTargetBuildAndDeployer, containerupdate.NewDockerUpdater, containerupdate.NewExecUpdater, build.NewImageBuilder, tracer.InitOpenTelemetry, liveupdates.ProvideUpdateMode,
)
