// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package cli

import (
	"context"
	"time"

	"github.com/google/wire"
	"github.com/jonboulle/clockwork"
	"go.opentelemetry.io/otel/sdk/trace"
	version2 "k8s.io/apimachinery/pkg/version"
	"sigs.k8s.io/controller-runtime/pkg/client"

	"github.com/tilt-dev/clusterid"
	"github.com/tilt-dev/tilt/internal/analytics"
	"github.com/tilt-dev/tilt/internal/build"
	client2 "github.com/tilt-dev/tilt/internal/cli/client"
	"github.com/tilt-dev/tilt/internal/cloud"
	"github.com/tilt-dev/tilt/internal/cloud/cloudurl"
	"github.com/tilt-dev/tilt/internal/container"
	"github.com/tilt-dev/tilt/internal/containerupdate"
	"github.com/tilt-dev/tilt/internal/controllers"
	"github.com/tilt-dev/tilt/internal/controllers/core/cluster"
	"github.com/tilt-dev/tilt/internal/controllers/core/cmd"
	"github.com/tilt-dev/tilt/internal/controllers/core/cmdimage"
	"github.com/tilt-dev/tilt/internal/controllers/core/configmap"
	"github.com/tilt-dev/tilt/internal/controllers/core/dockercomposelogstream"
	"github.com/tilt-dev/tilt/internal/controllers/core/dockercomposeservice"
	"github.com/tilt-dev/tilt/internal/controllers/core/dockerimage"
	"github.com/tilt-dev/tilt/internal/controllers/core/extension"
	"github.com/tilt-dev/tilt/internal/controllers/core/extensionrepo"
	"github.com/tilt-dev/tilt/internal/controllers/core/filewatch"
	"github.com/tilt-dev/tilt/internal/controllers/core/filewatch/fsevent"
	"github.com/tilt-dev/tilt/internal/controllers/core/imagemap"
	"github.com/tilt-dev/tilt/internal/controllers/core/kubernetesapply"
	"github.com/tilt-dev/tilt/internal/controllers/core/kubernetesdiscovery"
	"github.com/tilt-dev/tilt/internal/controllers/core/liveupdate"
	"github.com/tilt-dev/tilt/internal/controllers/core/podlogstream"
	"github.com/tilt-dev/tilt/internal/controllers/core/portforward"
	"github.com/tilt-dev/tilt/internal/controllers/core/session"
	tiltfile2 "github.com/tilt-dev/tilt/internal/controllers/core/tiltfile"
	"github.com/tilt-dev/tilt/internal/controllers/core/togglebutton"
	"github.com/tilt-dev/tilt/internal/controllers/core/uibutton"
	"github.com/tilt-dev/tilt/internal/controllers/core/uiresource"
	"github.com/tilt-dev/tilt/internal/controllers/core/uisession"
	"github.com/tilt-dev/tilt/internal/docker"
	"github.com/tilt-dev/tilt/internal/dockercompose"
	"github.com/tilt-dev/tilt/internal/dockerfile"
	"github.com/tilt-dev/tilt/internal/engine"
	analytics2 "github.com/tilt-dev/tilt/internal/engine/analytics"
	"github.com/tilt-dev/tilt/internal/engine/buildcontrol"
	"github.com/tilt-dev/tilt/internal/engine/configs"
	"github.com/tilt-dev/tilt/internal/engine/dockerprune"
	"github.com/tilt-dev/tilt/internal/engine/k8srollout"
	"github.com/tilt-dev/tilt/internal/engine/k8swatch"
	"github.com/tilt-dev/tilt/internal/engine/local"
	session2 "github.com/tilt-dev/tilt/internal/engine/session"
	"github.com/tilt-dev/tilt/internal/engine/telemetry"
	uiresource2 "github.com/tilt-dev/tilt/internal/engine/uiresource"
	uisession2 "github.com/tilt-dev/tilt/internal/engine/uisession"
	"github.com/tilt-dev/tilt/internal/feature"
	"github.com/tilt-dev/tilt/internal/git"
	"github.com/tilt-dev/tilt/internal/hud"
	"github.com/tilt-dev/tilt/internal/hud/prompt"
	"github.com/tilt-dev/tilt/internal/hud/server"
	"github.com/tilt-dev/tilt/internal/k8s"
	"github.com/tilt-dev/tilt/internal/localexec"
	"github.com/tilt-dev/tilt/internal/openurl"
	"github.com/tilt-dev/tilt/internal/store"
	"github.com/tilt-dev/tilt/internal/store/liveupdates"
	"github.com/tilt-dev/tilt/internal/tiltfile"
	"github.com/tilt-dev/tilt/internal/tiltfile/cisettings"
	"github.com/tilt-dev/tilt/internal/tiltfile/config"
	"github.com/tilt-dev/tilt/internal/tiltfile/k8scontext"
	"github.com/tilt-dev/tilt/internal/tiltfile/tiltextension"
	"github.com/tilt-dev/tilt/internal/tiltfile/version"
	"github.com/tilt-dev/tilt/internal/token"
	"github.com/tilt-dev/tilt/internal/tracer"
	"github.com/tilt-dev/tilt/internal/xdg"
	"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1"
	"github.com/tilt-dev/tilt/pkg/logger"
	"github.com/tilt-dev/tilt/pkg/model"
	"github.com/tilt-dev/wmclient/pkg/dirs"

	_ "embed"
)

// Injectors from wire.go:

func wireTiltfileResult(ctx context.Context, analytics2 *analytics.TiltAnalytics, subcommand model.TiltSubcommand) (cmdTiltfileResultDeps, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	plugin := k8scontext.NewPlugin(kubeContext, namespace, product)
	tiltBuild := provideTiltInfo()
	versionPlugin := version.NewPlugin(tiltBuild)
	configPlugin := config.NewPlugin(subcommand)
	deferredClient := controllers.ProvideDeferredClient()
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	base := xdg.NewTiltDevBase()
	reconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return cmdTiltfileResultDeps{}, err
	}
	scheme := v1alpha1.NewScheme()
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, analytics2)
	tiltextensionPlugin := tiltextension.NewPlugin(reconciler, extensionReconciler)
	ciTimeoutFlag := provideCITimeoutFlag()
	cisettingsPlugin := cisettings.NewPlugin(ciTimeoutFlag)
	realClientCreator := _wireRealClientCreatorValue
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	client := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, client)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	dockerComposeClient := dockercompose.NewDockerComposeClient(localEnv)
	webHost := provideWebHost()
	webPort := provideWebPort()
	env := localexec.DefaultEnv(webPort, webHost)
	processExecer := localexec.NewProcessExecer(env)
	defaults := _wireDefaultsValue
	tiltfileLoader := tiltfile.ProvideTiltfileLoader(analytics2, plugin, versionPlugin, configPlugin, tiltextensionPlugin, cisettingsPlugin, dockerComposeClient, webHost, processExecer, defaults, product)
	cliCmdTiltfileResultDeps := newTiltfileResultDeps(tiltfileLoader)
	return cliCmdTiltfileResultDeps, nil
}

var (
	_wireReducerValue           = engine.UpperReducer
	_wireRealClientCreatorValue = docker.RealClientCreator{}
	_wireDefaultsValue          = feature.MainDefaults
)

func wireDockerPrune(ctx context.Context, analytics2 *analytics.TiltAnalytics, subcommand model.TiltSubcommand) (dpDeps, error) {
	realClientCreator := _wireRealClientCreatorValue
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	client := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, client)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return dpDeps{}, err
	}
	compositeClient := docker.ProvideSwitchCli(clusterClient, localClient)
	plugin := k8scontext.NewPlugin(kubeContext, namespace, product)
	tiltBuild := provideTiltInfo()
	versionPlugin := version.NewPlugin(tiltBuild)
	configPlugin := config.NewPlugin(subcommand)
	deferredClient := controllers.ProvideDeferredClient()
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	base := xdg.NewTiltDevBase()
	reconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return dpDeps{}, err
	}
	scheme := v1alpha1.NewScheme()
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, analytics2)
	tiltextensionPlugin := tiltextension.NewPlugin(reconciler, extensionReconciler)
	ciTimeoutFlag := provideCITimeoutFlag()
	cisettingsPlugin := cisettings.NewPlugin(ciTimeoutFlag)
	dockerComposeClient := dockercompose.NewDockerComposeClient(localEnv)
	webHost := provideWebHost()
	webPort := provideWebPort()
	env := localexec.DefaultEnv(webPort, webHost)
	processExecer := localexec.NewProcessExecer(env)
	defaults := _wireDefaultsValue
	tiltfileLoader := tiltfile.ProvideTiltfileLoader(analytics2, plugin, versionPlugin, configPlugin, tiltextensionPlugin, cisettingsPlugin, dockerComposeClient, webHost, processExecer, defaults, product)
	cliDpDeps := newDPDeps(compositeClient, client, tiltfileLoader)
	return cliDpDeps, nil
}

func wireCmdUp(ctx context.Context, analytics3 *analytics.TiltAnalytics, cmdTags analytics2.CmdTags, subcommand model.TiltSubcommand) (CmdUpDeps, error) {
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	tiltDevDir, err := dirs.UseTiltDevDir()
	if err != nil {
		return CmdUpDeps{}, err
	}
	configAccess := server.ProvideConfigAccess(tiltDevDir)
	webPort := provideWebPort()
	apiServerName := model.ProvideAPIServerName(webPort)
	webHost := provideWebHost()
	webListener, err := server.ProvideWebListener(webHost, webPort)
	if err != nil {
		return CmdUpDeps{}, err
	}
	tiltBuild := provideTiltInfo()
	connProvider := server.ProvideMemConn()
	bearerToken, err := server.NewBearerToken()
	if err != nil {
		return CmdUpDeps{}, err
	}
	base := xdg.NewTiltDevBase()
	generatableKeyCert, err := server.ProvideKeyCert(apiServerName, webHost, webPort, base)
	if err != nil {
		return CmdUpDeps{}, err
	}
	apiServerPort, err := server.ProvideAPIServerPort()
	if err != nil {
		return CmdUpDeps{}, err
	}
	apiserverConfig, err := server.ProvideTiltServerOptions(ctx, tiltBuild, connProvider, bearerToken, generatableKeyCert, apiServerPort)
	if err != nil {
		return CmdUpDeps{}, err
	}
	webMode, err := provideWebMode(tiltBuild)
	if err != nil {
		return CmdUpDeps{}, err
	}
	webVersion := provideWebVersion(tiltBuild)
	assetsServer, err := provideAssetServer(webMode, webVersion)
	if err != nil {
		return CmdUpDeps{}, err
	}
	websocketList := server.NewWebsocketList()
	deferredClient := controllers.ProvideDeferredClient()
	headsUpServer, err := server.ProvideHeadsUpServer(ctx, storeStore, assetsServer, analytics3, websocketList, deferredClient)
	if err != nil {
		return CmdUpDeps{}, err
	}
	webURL, err := provideWebURL(webHost, webPort)
	if err != nil {
		return CmdUpDeps{}, err
	}
	headsUpServerController := server.ProvideHeadsUpServerController(configAccess, apiServerName, webListener, apiserverConfig, headsUpServer, assetsServer, webURL)
	scheme := v1alpha1.NewScheme()
	uncachedObjects := controllers.ProvideUncachedObjects()
	tiltServerControllerManager, err := controllers.NewTiltServerControllerManager(apiserverConfig, scheme, deferredClient, uncachedObjects)
	if err != nil {
		return CmdUpDeps{}, err
	}
	watcherMaker := fsevent.ProvideWatcherMaker()
	timerMaker := fsevent.ProvideTimerMaker()
	clock := clockwork.NewRealClock()
	controller := filewatch.NewController(deferredClient, storeStore, watcherMaker, timerMaker, scheme, clock)
	env := localexec.DefaultEnv(webPort, webHost)
	execer := cmd.ProvideExecer(env)
	proberManager := cmd.ProvideProberManager()
	cmdController := cmd.NewController(ctx, execer, proberManager, deferredClient, storeStore, clock, scheme)
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	client := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	podSource := podlogstream.NewPodSource(ctx, client, scheme, clock)
	podlogstreamController := podlogstream.NewController(ctx, deferredClient, scheme, storeStore, client, podSource, clock)
	connectionManager := cluster.NewConnectionManager()
	containerRestartDetector := kubernetesdiscovery.NewContainerRestartDetector()
	reconciler := kubernetesdiscovery.NewReconciler(deferredClient, scheme, connectionManager, containerRestartDetector, storeStore)
	realClientCreator := _wireRealClientCreatorValue
	runtime := k8s.ProvideContainerRuntime(ctx, client)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return CmdUpDeps{}, err
	}
	compositeClient := docker.ProvideSwitchCli(clusterClient, localClient)
	labels := _wireLabelsValue
	dockerBuilder := build.NewDockerBuilder(compositeClient, labels)
	processExecer := localexec.NewProcessExecer(env)
	kubernetesapplyReconciler := kubernetesapply.NewReconciler(deferredClient, client, scheme, dockerBuilder, storeStore, processExecer)
	uisessionReconciler := uisession.NewReconciler(deferredClient, websocketList)
	uiresourceReconciler := uiresource.NewReconciler(deferredClient, websocketList, storeStore)
	uibuttonReconciler := uibutton.NewReconciler(deferredClient, websocketList, storeStore)
	portforwardReconciler := portforward.NewReconciler(deferredClient, scheme, storeStore, connectionManager)
	plugin := k8scontext.NewPlugin(kubeContext, namespace, product)
	versionPlugin := version.NewPlugin(tiltBuild)
	configPlugin := config.NewPlugin(subcommand)
	extensionrepoReconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return CmdUpDeps{}, err
	}
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, analytics3)
	tiltextensionPlugin := tiltextension.NewPlugin(extensionrepoReconciler, extensionReconciler)
	ciTimeoutFlag := provideCITimeoutFlag()
	cisettingsPlugin := cisettings.NewPlugin(ciTimeoutFlag)
	dockerComposeClient := dockercompose.NewDockerComposeClient(localEnv)
	defaults := _wireDefaultsValue
	tiltfileLoader := tiltfile.ProvideTiltfileLoader(analytics3, plugin, versionPlugin, configPlugin, tiltextensionPlugin, cisettingsPlugin, dockerComposeClient, webHost, processExecer, defaults, product)
	engineMode := _wireEngineModeValue
	tiltfileReconciler := tiltfile2.NewReconciler(storeStore, tiltfileLoader, compositeClient, deferredClient, scheme, engineMode, k8sKubeContextOverride, k8sNamespaceOverride, ciTimeoutFlag)
	togglebuttonReconciler := togglebutton.NewReconciler(deferredClient, scheme)
	dockerUpdater := containerupdate.NewDockerUpdater(compositeClient)
	execUpdater := containerupdate.NewExecUpdater(client)
	liveupdatesUpdateModeFlag := provideUpdateModeFlag()
	updateMode, err := liveupdates.ProvideUpdateMode(liveupdatesUpdateModeFlag, kubeContext, clusterEnv)
	if err != nil {
		return CmdUpDeps{}, err
	}
	liveupdateReconciler := liveupdate.NewReconciler(storeStore, dockerUpdater, execUpdater, updateMode, kubeContext, deferredClient, scheme)
	configmapReconciler := configmap.NewReconciler(deferredClient, storeStore)
	buildClock := build.ProvideClock()
	customBuilder := build.NewCustomBuilder(compositeClient, buildClock, cmdController)
	kindLoader := build.NewKINDLoader()
	imageBuilder := build.NewImageBuilder(dockerBuilder, customBuilder, kindLoader)
	dockerimageReconciler := dockerimage.NewReconciler(deferredClient, storeStore, scheme, compositeClient, imageBuilder)
	cmdimageReconciler := cmdimage.NewReconciler(deferredClient, storeStore, scheme, compositeClient, imageBuilder)
	dockerClientFactory := _wireDockerClientFuncValue
	kubernetesClientFactory := _wireKubernetesClientFuncValue
	clusterReconciler := cluster.NewReconciler(ctx, deferredClient, storeStore, clock, connectionManager, localEnv, dockerClientFactory, kubernetesClientFactory, websocketList, base, apiServerName)
	disableSubscriber := dockercomposeservice.NewDisableSubscriber(ctx, dockerComposeClient, clock)
	dockercomposeserviceReconciler := dockercomposeservice.NewReconciler(deferredClient, dockerComposeClient, compositeClient, storeStore, scheme, disableSubscriber)
	imagemapReconciler := imagemap.NewReconciler(deferredClient, storeStore)
	dockercomposelogstreamReconciler := dockercomposelogstream.NewReconciler(deferredClient, storeStore, dockerComposeClient, compositeClient)
	sessionReconciler := session.NewReconciler(deferredClient, storeStore, clock)
	v := controllers.ProvideControllers(controller, cmdController, podlogstreamController, reconciler, kubernetesapplyReconciler, uisessionReconciler, uiresourceReconciler, uibuttonReconciler, portforwardReconciler, tiltfileReconciler, togglebuttonReconciler, extensionReconciler, extensionrepoReconciler, liveupdateReconciler, configmapReconciler, dockerimageReconciler, cmdimageReconciler, clusterReconciler, dockercomposeserviceReconciler, imagemapReconciler, dockercomposelogstreamReconciler, sessionReconciler)
	controllerBuilder := controllers.NewControllerBuilder(tiltServerControllerManager, v)
	v2 := provideClock()
	renderer := hud.NewRenderer(v2)
	openURL := _wireOpenURLValue
	headsUpDisplay := hud.NewHud(renderer, webURL, analytics3, openURL)
	stdout := hud.ProvideStdout()
	incrementalPrinter := hud.NewIncrementalPrinter(stdout)
	terminalStream := hud.NewTerminalStream(incrementalPrinter, storeStore)
	openInput := _wireOpenInputValue
	terminalPrompt := prompt.NewTerminalPrompt(analytics3, openInput, openURL, stdout, webHost, webURL)
	serviceWatcher := k8swatch.NewServiceWatcher(connectionManager, namespace)
	imageBuildAndDeployer := buildcontrol.NewImageBuildAndDeployer(dockerimageReconciler, cmdimageReconciler, imageBuilder, analytics3, buildClock, deferredClient, kubernetesapplyReconciler)
	dockerComposeBuildAndDeployer := buildcontrol.NewDockerComposeBuildAndDeployer(dockerimageReconciler, cmdimageReconciler, imageBuilder, dockercomposeserviceReconciler, buildClock, deferredClient)
	localTargetBuildAndDeployer := buildcontrol.NewLocalTargetBuildAndDeployer(buildClock, deferredClient, cmdController)
	buildOrder := engine.DefaultBuildOrder(imageBuildAndDeployer, dockerComposeBuildAndDeployer, localTargetBuildAndDeployer, updateMode)
	spanCollector := tracer.NewSpanCollector(ctx)
	traceTracer := tracer.InitOpenTelemetry(spanCollector)
	compositeBuildAndDeployer := engine.NewCompositeBuildAndDeployer(buildOrder, traceTracer)
	buildController := engine.NewBuildController(compositeBuildAndDeployer)
	configsController := configs.NewConfigsController(deferredClient)
	triggerQueueSubscriber := configs.NewTriggerQueueSubscriber(deferredClient)
	analyticsReporter := analytics2.ProvideAnalyticsReporter(analytics3, storeStore, client, product, defaults)
	analyticsUpdater := analytics2.NewAnalyticsUpdater(analytics3, cmdTags, engineMode)
	eventWatchManager := k8swatch.NewEventWatchManager(connectionManager, namespace)
	httpClient := cloud.ProvideHttpClient()
	cloudStatusManager := cloud.NewStatusManager(httpClient, clock)
	dockerPruner := dockerprune.NewDockerPruner(compositeClient)
	telemetryController := telemetry.NewController(buildClock, spanCollector)
	serverController := local.NewServerController(deferredClient)
	podMonitor := k8srollout.NewPodMonitor(clock)
	sessionController := session2.NewController(sessionReconciler)
	subscriber := uisession2.NewSubscriber(deferredClient)
	uiresourceSubscriber := uiresource2.NewSubscriber(deferredClient)
	v3 := engine.ProvideSubscribers(headsUpServerController, tiltServerControllerManager, controllerBuilder, headsUpDisplay, terminalStream, terminalPrompt, serviceWatcher, buildController, configsController, triggerQueueSubscriber, analyticsReporter, analyticsUpdater, eventWatchManager, cloudStatusManager, dockerPruner, telemetryController, serverController, podMonitor, sessionController, subscriber, uiresourceSubscriber)
	upper, err := engine.NewUpper(ctx, storeStore, v3)
	if err != nil {
		return CmdUpDeps{}, err
	}
	tokenToken, err := token.GetOrCreateToken(tiltDevDir)
	if err != nil {
		return CmdUpDeps{}, err
	}
	address := cloudurl.ProvideAddress()
	snapshotter := cloud.NewSnapshotter(storeStore, deferredClient)
	cmdUpDeps := CmdUpDeps{
		Upper:        upper,
		TiltBuild:    tiltBuild,
		Token:        tokenToken,
		CloudAddress: address,
		Prompt:       terminalPrompt,
		Snapshotter:  snapshotter,
	}
	return cmdUpDeps, nil
}

var (
	_wireLabelsValue               = dockerfile.Labels{}
	_wireEngineModeValue           = store.EngineModeUp
	_wireDockerClientFuncValue     = cluster.DockerClientFunc(cluster.DockerClientFromEnv)
	_wireKubernetesClientFuncValue = cluster.KubernetesClientFunc(cluster.KubernetesClientFromEnv)
	_wireOpenURLValue              = openurl.OpenURL(openurl.BrowserOpen)
	_wireOpenInputValue            = prompt.OpenInput(prompt.TTYOpen)
)

func wireCmdCI(ctx context.Context, analytics3 *analytics.TiltAnalytics, subcommand model.TiltSubcommand) (CmdCIDeps, error) {
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	tiltDevDir, err := dirs.UseTiltDevDir()
	if err != nil {
		return CmdCIDeps{}, err
	}
	configAccess := server.ProvideConfigAccess(tiltDevDir)
	webPort := provideWebPort()
	apiServerName := model.ProvideAPIServerName(webPort)
	webHost := provideWebHost()
	webListener, err := server.ProvideWebListener(webHost, webPort)
	if err != nil {
		return CmdCIDeps{}, err
	}
	tiltBuild := provideTiltInfo()
	connProvider := server.ProvideMemConn()
	bearerToken, err := server.NewBearerToken()
	if err != nil {
		return CmdCIDeps{}, err
	}
	base := xdg.NewTiltDevBase()
	generatableKeyCert, err := server.ProvideKeyCert(apiServerName, webHost, webPort, base)
	if err != nil {
		return CmdCIDeps{}, err
	}
	apiServerPort, err := server.ProvideAPIServerPort()
	if err != nil {
		return CmdCIDeps{}, err
	}
	apiserverConfig, err := server.ProvideTiltServerOptions(ctx, tiltBuild, connProvider, bearerToken, generatableKeyCert, apiServerPort)
	if err != nil {
		return CmdCIDeps{}, err
	}
	webMode, err := provideWebMode(tiltBuild)
	if err != nil {
		return CmdCIDeps{}, err
	}
	webVersion := provideWebVersion(tiltBuild)
	assetsServer, err := provideAssetServer(webMode, webVersion)
	if err != nil {
		return CmdCIDeps{}, err
	}
	websocketList := server.NewWebsocketList()
	deferredClient := controllers.ProvideDeferredClient()
	headsUpServer, err := server.ProvideHeadsUpServer(ctx, storeStore, assetsServer, analytics3, websocketList, deferredClient)
	if err != nil {
		return CmdCIDeps{}, err
	}
	webURL, err := provideWebURL(webHost, webPort)
	if err != nil {
		return CmdCIDeps{}, err
	}
	headsUpServerController := server.ProvideHeadsUpServerController(configAccess, apiServerName, webListener, apiserverConfig, headsUpServer, assetsServer, webURL)
	scheme := v1alpha1.NewScheme()
	uncachedObjects := controllers.ProvideUncachedObjects()
	tiltServerControllerManager, err := controllers.NewTiltServerControllerManager(apiserverConfig, scheme, deferredClient, uncachedObjects)
	if err != nil {
		return CmdCIDeps{}, err
	}
	watcherMaker := fsevent.ProvideWatcherMaker()
	timerMaker := fsevent.ProvideTimerMaker()
	clock := clockwork.NewRealClock()
	controller := filewatch.NewController(deferredClient, storeStore, watcherMaker, timerMaker, scheme, clock)
	env := localexec.DefaultEnv(webPort, webHost)
	execer := cmd.ProvideExecer(env)
	proberManager := cmd.ProvideProberManager()
	cmdController := cmd.NewController(ctx, execer, proberManager, deferredClient, storeStore, clock, scheme)
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	client := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	podSource := podlogstream.NewPodSource(ctx, client, scheme, clock)
	podlogstreamController := podlogstream.NewController(ctx, deferredClient, scheme, storeStore, client, podSource, clock)
	connectionManager := cluster.NewConnectionManager()
	containerRestartDetector := kubernetesdiscovery.NewContainerRestartDetector()
	reconciler := kubernetesdiscovery.NewReconciler(deferredClient, scheme, connectionManager, containerRestartDetector, storeStore)
	realClientCreator := _wireRealClientCreatorValue
	runtime := k8s.ProvideContainerRuntime(ctx, client)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return CmdCIDeps{}, err
	}
	compositeClient := docker.ProvideSwitchCli(clusterClient, localClient)
	labels := _wireLabelsValue
	dockerBuilder := build.NewDockerBuilder(compositeClient, labels)
	processExecer := localexec.NewProcessExecer(env)
	kubernetesapplyReconciler := kubernetesapply.NewReconciler(deferredClient, client, scheme, dockerBuilder, storeStore, processExecer)
	uisessionReconciler := uisession.NewReconciler(deferredClient, websocketList)
	uiresourceReconciler := uiresource.NewReconciler(deferredClient, websocketList, storeStore)
	uibuttonReconciler := uibutton.NewReconciler(deferredClient, websocketList, storeStore)
	portforwardReconciler := portforward.NewReconciler(deferredClient, scheme, storeStore, connectionManager)
	plugin := k8scontext.NewPlugin(kubeContext, namespace, product)
	versionPlugin := version.NewPlugin(tiltBuild)
	configPlugin := config.NewPlugin(subcommand)
	extensionrepoReconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return CmdCIDeps{}, err
	}
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, analytics3)
	tiltextensionPlugin := tiltextension.NewPlugin(extensionrepoReconciler, extensionReconciler)
	ciTimeoutFlag := provideCITimeoutFlag()
	cisettingsPlugin := cisettings.NewPlugin(ciTimeoutFlag)
	dockerComposeClient := dockercompose.NewDockerComposeClient(localEnv)
	defaults := _wireDefaultsValue
	tiltfileLoader := tiltfile.ProvideTiltfileLoader(analytics3, plugin, versionPlugin, configPlugin, tiltextensionPlugin, cisettingsPlugin, dockerComposeClient, webHost, processExecer, defaults, product)
	engineMode := _wireStoreEngineModeValue
	tiltfileReconciler := tiltfile2.NewReconciler(storeStore, tiltfileLoader, compositeClient, deferredClient, scheme, engineMode, k8sKubeContextOverride, k8sNamespaceOverride, ciTimeoutFlag)
	togglebuttonReconciler := togglebutton.NewReconciler(deferredClient, scheme)
	dockerUpdater := containerupdate.NewDockerUpdater(compositeClient)
	execUpdater := containerupdate.NewExecUpdater(client)
	liveupdatesUpdateModeFlag := provideUpdateModeFlag()
	updateMode, err := liveupdates.ProvideUpdateMode(liveupdatesUpdateModeFlag, kubeContext, clusterEnv)
	if err != nil {
		return CmdCIDeps{}, err
	}
	liveupdateReconciler := liveupdate.NewReconciler(storeStore, dockerUpdater, execUpdater, updateMode, kubeContext, deferredClient, scheme)
	configmapReconciler := configmap.NewReconciler(deferredClient, storeStore)
	buildClock := build.ProvideClock()
	customBuilder := build.NewCustomBuilder(compositeClient, buildClock, cmdController)
	kindLoader := build.NewKINDLoader()
	imageBuilder := build.NewImageBuilder(dockerBuilder, customBuilder, kindLoader)
	dockerimageReconciler := dockerimage.NewReconciler(deferredClient, storeStore, scheme, compositeClient, imageBuilder)
	cmdimageReconciler := cmdimage.NewReconciler(deferredClient, storeStore, scheme, compositeClient, imageBuilder)
	dockerClientFactory := _wireDockerClientFuncValue
	kubernetesClientFactory := _wireKubernetesClientFuncValue
	clusterReconciler := cluster.NewReconciler(ctx, deferredClient, storeStore, clock, connectionManager, localEnv, dockerClientFactory, kubernetesClientFactory, websocketList, base, apiServerName)
	disableSubscriber := dockercomposeservice.NewDisableSubscriber(ctx, dockerComposeClient, clock)
	dockercomposeserviceReconciler := dockercomposeservice.NewReconciler(deferredClient, dockerComposeClient, compositeClient, storeStore, scheme, disableSubscriber)
	imagemapReconciler := imagemap.NewReconciler(deferredClient, storeStore)
	dockercomposelogstreamReconciler := dockercomposelogstream.NewReconciler(deferredClient, storeStore, dockerComposeClient, compositeClient)
	sessionReconciler := session.NewReconciler(deferredClient, storeStore, clock)
	v := controllers.ProvideControllers(controller, cmdController, podlogstreamController, reconciler, kubernetesapplyReconciler, uisessionReconciler, uiresourceReconciler, uibuttonReconciler, portforwardReconciler, tiltfileReconciler, togglebuttonReconciler, extensionReconciler, extensionrepoReconciler, liveupdateReconciler, configmapReconciler, dockerimageReconciler, cmdimageReconciler, clusterReconciler, dockercomposeserviceReconciler, imagemapReconciler, dockercomposelogstreamReconciler, sessionReconciler)
	controllerBuilder := controllers.NewControllerBuilder(tiltServerControllerManager, v)
	v2 := provideClock()
	renderer := hud.NewRenderer(v2)
	openURL := _wireOpenURLValue
	headsUpDisplay := hud.NewHud(renderer, webURL, analytics3, openURL)
	stdout := hud.ProvideStdout()
	incrementalPrinter := hud.NewIncrementalPrinter(stdout)
	terminalStream := hud.NewTerminalStream(incrementalPrinter, storeStore)
	openInput := _wireOpenInputValue
	terminalPrompt := prompt.NewTerminalPrompt(analytics3, openInput, openURL, stdout, webHost, webURL)
	serviceWatcher := k8swatch.NewServiceWatcher(connectionManager, namespace)
	imageBuildAndDeployer := buildcontrol.NewImageBuildAndDeployer(dockerimageReconciler, cmdimageReconciler, imageBuilder, analytics3, buildClock, deferredClient, kubernetesapplyReconciler)
	dockerComposeBuildAndDeployer := buildcontrol.NewDockerComposeBuildAndDeployer(dockerimageReconciler, cmdimageReconciler, imageBuilder, dockercomposeserviceReconciler, buildClock, deferredClient)
	localTargetBuildAndDeployer := buildcontrol.NewLocalTargetBuildAndDeployer(buildClock, deferredClient, cmdController)
	buildOrder := engine.DefaultBuildOrder(imageBuildAndDeployer, dockerComposeBuildAndDeployer, localTargetBuildAndDeployer, updateMode)
	spanCollector := tracer.NewSpanCollector(ctx)
	traceTracer := tracer.InitOpenTelemetry(spanCollector)
	compositeBuildAndDeployer := engine.NewCompositeBuildAndDeployer(buildOrder, traceTracer)
	buildController := engine.NewBuildController(compositeBuildAndDeployer)
	configsController := configs.NewConfigsController(deferredClient)
	triggerQueueSubscriber := configs.NewTriggerQueueSubscriber(deferredClient)
	analyticsReporter := analytics2.ProvideAnalyticsReporter(analytics3, storeStore, client, product, defaults)
	cmdTags := _wireCmdTagsValue
	analyticsUpdater := analytics2.NewAnalyticsUpdater(analytics3, cmdTags, engineMode)
	eventWatchManager := k8swatch.NewEventWatchManager(connectionManager, namespace)
	httpClient := cloud.ProvideHttpClient()
	cloudStatusManager := cloud.NewStatusManager(httpClient, clock)
	dockerPruner := dockerprune.NewDockerPruner(compositeClient)
	telemetryController := telemetry.NewController(buildClock, spanCollector)
	serverController := local.NewServerController(deferredClient)
	podMonitor := k8srollout.NewPodMonitor(clock)
	sessionController := session2.NewController(sessionReconciler)
	subscriber := uisession2.NewSubscriber(deferredClient)
	uiresourceSubscriber := uiresource2.NewSubscriber(deferredClient)
	v3 := engine.ProvideSubscribers(headsUpServerController, tiltServerControllerManager, controllerBuilder, headsUpDisplay, terminalStream, terminalPrompt, serviceWatcher, buildController, configsController, triggerQueueSubscriber, analyticsReporter, analyticsUpdater, eventWatchManager, cloudStatusManager, dockerPruner, telemetryController, serverController, podMonitor, sessionController, subscriber, uiresourceSubscriber)
	upper, err := engine.NewUpper(ctx, storeStore, v3)
	if err != nil {
		return CmdCIDeps{}, err
	}
	tokenToken, err := token.GetOrCreateToken(tiltDevDir)
	if err != nil {
		return CmdCIDeps{}, err
	}
	address := cloudurl.ProvideAddress()
	snapshotter := cloud.NewSnapshotter(storeStore, deferredClient)
	cmdCIDeps := CmdCIDeps{
		Upper:        upper,
		TiltBuild:    tiltBuild,
		Token:        tokenToken,
		CloudAddress: address,
		Snapshotter:  snapshotter,
	}
	return cmdCIDeps, nil
}

var (
	_wireStoreEngineModeValue = store.EngineModeCI
	_wireCmdTagsValue         = analytics2.CmdTags(map[string]string{})
)

func wireCmdUpdog(ctx context.Context, analytics3 *analytics.TiltAnalytics, cmdTags analytics2.CmdTags, subcommand model.TiltSubcommand, objects []client.Object) (CmdUpdogDeps, error) {
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	tiltDevDir, err := dirs.UseTiltDevDir()
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	configAccess := server.ProvideConfigAccess(tiltDevDir)
	webPort := provideWebPort()
	apiServerName := model.ProvideAPIServerName(webPort)
	webHost := provideWebHost()
	webListener, err := server.ProvideWebListener(webHost, webPort)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	tiltBuild := provideTiltInfo()
	connProvider := server.ProvideMemConn()
	bearerToken, err := server.NewBearerToken()
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	base := xdg.NewTiltDevBase()
	generatableKeyCert, err := server.ProvideKeyCert(apiServerName, webHost, webPort, base)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	apiServerPort, err := server.ProvideAPIServerPort()
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	apiserverConfig, err := server.ProvideTiltServerOptions(ctx, tiltBuild, connProvider, bearerToken, generatableKeyCert, apiServerPort)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	webMode, err := provideWebMode(tiltBuild)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	webVersion := provideWebVersion(tiltBuild)
	assetsServer, err := provideAssetServer(webMode, webVersion)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	websocketList := server.NewWebsocketList()
	deferredClient := controllers.ProvideDeferredClient()
	headsUpServer, err := server.ProvideHeadsUpServer(ctx, storeStore, assetsServer, analytics3, websocketList, deferredClient)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	webURL, err := provideWebURL(webHost, webPort)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	headsUpServerController := server.ProvideHeadsUpServerController(configAccess, apiServerName, webListener, apiserverConfig, headsUpServer, assetsServer, webURL)
	scheme := v1alpha1.NewScheme()
	uncachedObjects := controllers.ProvideUncachedObjects()
	tiltServerControllerManager, err := controllers.NewTiltServerControllerManager(apiserverConfig, scheme, deferredClient, uncachedObjects)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	watcherMaker := fsevent.ProvideWatcherMaker()
	timerMaker := fsevent.ProvideTimerMaker()
	clock := clockwork.NewRealClock()
	controller := filewatch.NewController(deferredClient, storeStore, watcherMaker, timerMaker, scheme, clock)
	env := localexec.DefaultEnv(webPort, webHost)
	execer := cmd.ProvideExecer(env)
	proberManager := cmd.ProvideProberManager()
	cmdController := cmd.NewController(ctx, execer, proberManager, deferredClient, storeStore, clock, scheme)
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	podSource := podlogstream.NewPodSource(ctx, k8sClient, scheme, clock)
	podlogstreamController := podlogstream.NewController(ctx, deferredClient, scheme, storeStore, k8sClient, podSource, clock)
	connectionManager := cluster.NewConnectionManager()
	containerRestartDetector := kubernetesdiscovery.NewContainerRestartDetector()
	reconciler := kubernetesdiscovery.NewReconciler(deferredClient, scheme, connectionManager, containerRestartDetector, storeStore)
	realClientCreator := _wireRealClientCreatorValue
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	compositeClient := docker.ProvideSwitchCli(clusterClient, localClient)
	labels := _wireLabelsValue
	dockerBuilder := build.NewDockerBuilder(compositeClient, labels)
	processExecer := localexec.NewProcessExecer(env)
	kubernetesapplyReconciler := kubernetesapply.NewReconciler(deferredClient, k8sClient, scheme, dockerBuilder, storeStore, processExecer)
	uisessionReconciler := uisession.NewReconciler(deferredClient, websocketList)
	uiresourceReconciler := uiresource.NewReconciler(deferredClient, websocketList, storeStore)
	uibuttonReconciler := uibutton.NewReconciler(deferredClient, websocketList, storeStore)
	portforwardReconciler := portforward.NewReconciler(deferredClient, scheme, storeStore, connectionManager)
	plugin := k8scontext.NewPlugin(kubeContext, namespace, product)
	versionPlugin := version.NewPlugin(tiltBuild)
	configPlugin := config.NewPlugin(subcommand)
	extensionrepoReconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, analytics3)
	tiltextensionPlugin := tiltextension.NewPlugin(extensionrepoReconciler, extensionReconciler)
	ciTimeoutFlag := provideCITimeoutFlag()
	cisettingsPlugin := cisettings.NewPlugin(ciTimeoutFlag)
	dockerComposeClient := dockercompose.NewDockerComposeClient(localEnv)
	defaults := _wireDefaultsValue
	tiltfileLoader := tiltfile.ProvideTiltfileLoader(analytics3, plugin, versionPlugin, configPlugin, tiltextensionPlugin, cisettingsPlugin, dockerComposeClient, webHost, processExecer, defaults, product)
	engineMode := _wireEngineModeValue2
	tiltfileReconciler := tiltfile2.NewReconciler(storeStore, tiltfileLoader, compositeClient, deferredClient, scheme, engineMode, k8sKubeContextOverride, k8sNamespaceOverride, ciTimeoutFlag)
	togglebuttonReconciler := togglebutton.NewReconciler(deferredClient, scheme)
	dockerUpdater := containerupdate.NewDockerUpdater(compositeClient)
	execUpdater := containerupdate.NewExecUpdater(k8sClient)
	liveupdatesUpdateModeFlag := provideUpdateModeFlag()
	updateMode, err := liveupdates.ProvideUpdateMode(liveupdatesUpdateModeFlag, kubeContext, clusterEnv)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	liveupdateReconciler := liveupdate.NewReconciler(storeStore, dockerUpdater, execUpdater, updateMode, kubeContext, deferredClient, scheme)
	configmapReconciler := configmap.NewReconciler(deferredClient, storeStore)
	buildClock := build.ProvideClock()
	customBuilder := build.NewCustomBuilder(compositeClient, buildClock, cmdController)
	kindLoader := build.NewKINDLoader()
	imageBuilder := build.NewImageBuilder(dockerBuilder, customBuilder, kindLoader)
	dockerimageReconciler := dockerimage.NewReconciler(deferredClient, storeStore, scheme, compositeClient, imageBuilder)
	cmdimageReconciler := cmdimage.NewReconciler(deferredClient, storeStore, scheme, compositeClient, imageBuilder)
	dockerClientFactory := _wireDockerClientFuncValue
	kubernetesClientFactory := _wireKubernetesClientFuncValue
	clusterReconciler := cluster.NewReconciler(ctx, deferredClient, storeStore, clock, connectionManager, localEnv, dockerClientFactory, kubernetesClientFactory, websocketList, base, apiServerName)
	disableSubscriber := dockercomposeservice.NewDisableSubscriber(ctx, dockerComposeClient, clock)
	dockercomposeserviceReconciler := dockercomposeservice.NewReconciler(deferredClient, dockerComposeClient, compositeClient, storeStore, scheme, disableSubscriber)
	imagemapReconciler := imagemap.NewReconciler(deferredClient, storeStore)
	dockercomposelogstreamReconciler := dockercomposelogstream.NewReconciler(deferredClient, storeStore, dockerComposeClient, compositeClient)
	sessionReconciler := session.NewReconciler(deferredClient, storeStore, clock)
	v := controllers.ProvideControllers(controller, cmdController, podlogstreamController, reconciler, kubernetesapplyReconciler, uisessionReconciler, uiresourceReconciler, uibuttonReconciler, portforwardReconciler, tiltfileReconciler, togglebuttonReconciler, extensionReconciler, extensionrepoReconciler, liveupdateReconciler, configmapReconciler, dockerimageReconciler, cmdimageReconciler, clusterReconciler, dockercomposeserviceReconciler, imagemapReconciler, dockercomposelogstreamReconciler, sessionReconciler)
	controllerBuilder := controllers.NewControllerBuilder(tiltServerControllerManager, v)
	stdout := hud.ProvideStdout()
	incrementalPrinter := hud.NewIncrementalPrinter(stdout)
	terminalStream := hud.NewTerminalStream(incrementalPrinter, storeStore)
	cliUpdogSubscriber := provideUpdogSubscriber(objects, deferredClient)
	v2 := provideUpdogCmdSubscribers(headsUpServerController, tiltServerControllerManager, controllerBuilder, terminalStream, cliUpdogSubscriber)
	upper, err := engine.NewUpper(ctx, storeStore, v2)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	tokenToken, err := token.GetOrCreateToken(tiltDevDir)
	if err != nil {
		return CmdUpdogDeps{}, err
	}
	address := cloudurl.ProvideAddress()
	cmdUpdogDeps := CmdUpdogDeps{
		Upper:        upper,
		TiltBuild:    tiltBuild,
		Token:        tokenToken,
		CloudAddress: address,
		Store:        storeStore,
	}
	return cmdUpdogDeps, nil
}

var (
	_wireEngineModeValue2 = store.EngineModeCI
)

func wireKubeContext(ctx context.Context) (k8s.KubeContext, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	return kubeContext, nil
}

func wireEnv(ctx context.Context) (clusterid.Product, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	return product, nil
}

func wireNamespace(ctx context.Context) (k8s.Namespace, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	return namespace, nil
}

func wireClusterName(ctx context.Context) (k8s.ClusterName, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	return clusterName, nil
}

func wireRuntime(ctx context.Context) (container.Runtime, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	return runtime, nil
}

func wireK8sClient(ctx context.Context) (k8s.Client, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	return k8sClient, nil
}

func wireK8sVersion(ctx context.Context) (*version2.Info, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	info, err := k8s.ProvideServerVersion(clientsetOrError)
	if err != nil {
		return nil, err
	}
	return info, nil
}

func wireDockerClusterClient(ctx context.Context) (docker.ClusterClient, error) {
	realClientCreator := _wireRealClientCreatorValue
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return nil, err
	}
	return clusterClient, nil
}

func wireDockerLocalClient(ctx context.Context) (docker.LocalClient, error) {
	realClientCreator := _wireRealClientCreatorValue
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	return localClient, nil
}

func wireDockerCompositeClient(ctx context.Context) (docker.CompositeClient, error) {
	realClientCreator := _wireRealClientCreatorValue
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return nil, err
	}
	compositeClient := docker.ProvideSwitchCli(clusterClient, localClient)
	return compositeClient, nil
}

func wireDownDeps(ctx context.Context, tiltAnalytics *analytics.TiltAnalytics, subcommand model.TiltSubcommand) (DownDeps, error) {
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	plugin := k8scontext.NewPlugin(kubeContext, namespace, product)
	tiltBuild := provideTiltInfo()
	versionPlugin := version.NewPlugin(tiltBuild)
	configPlugin := config.NewPlugin(subcommand)
	deferredClient := controllers.ProvideDeferredClient()
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	base := xdg.NewTiltDevBase()
	reconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return DownDeps{}, err
	}
	scheme := v1alpha1.NewScheme()
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, tiltAnalytics)
	tiltextensionPlugin := tiltextension.NewPlugin(reconciler, extensionReconciler)
	ciTimeoutFlag := provideCITimeoutFlag()
	cisettingsPlugin := cisettings.NewPlugin(ciTimeoutFlag)
	realClientCreator := _wireRealClientCreatorValue
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	dockerComposeClient := dockercompose.NewDockerComposeClient(localEnv)
	webHost := provideWebHost()
	webPort := provideWebPort()
	env := localexec.DefaultEnv(webPort, webHost)
	processExecer := localexec.NewProcessExecer(env)
	defaults := _wireDefaultsValue
	tiltfileLoader := tiltfile.ProvideTiltfileLoader(tiltAnalytics, plugin, versionPlugin, configPlugin, tiltextensionPlugin, cisettingsPlugin, dockerComposeClient, webHost, processExecer, defaults, product)
	downDeps := ProvideDownDeps(tiltfileLoader, dockerComposeClient, k8sClient, processExecer)
	return downDeps, nil
}

func wireLogsDeps(ctx context.Context, tiltAnalytics *analytics.TiltAnalytics, subcommand model.TiltSubcommand) (LogsDeps, error) {
	webHost := provideWebHost()
	webPort := provideWebPort()
	webURL, err := provideWebURL(webHost, webPort)
	if err != nil {
		return LogsDeps{}, err
	}
	stdout := hud.ProvideStdout()
	incrementalPrinter := hud.NewIncrementalPrinter(stdout)
	logsDeps := ProvideLogsDeps(webURL, incrementalPrinter)
	return logsDeps, nil
}

func wireDumpImageDeployRefDeps(ctx context.Context) (DumpImageDeployRefDeps, error) {
	realClientCreator := _wireRealClientCreatorValue
	k8sKubeContextOverride := ProvideKubeContextOverride()
	k8sNamespaceOverride := ProvideNamespaceOverride()
	clientConfig := k8s.ProvideClientConfig(k8sKubeContextOverride, k8sNamespaceOverride)
	apiConfigOrError := k8s.ProvideAPIConfig(clientConfig, k8sKubeContextOverride, k8sNamespaceOverride)
	kubeContext := k8s.ProvideKubeContext(apiConfigOrError)
	product := k8s.ProvideClusterProduct(apiConfigOrError)
	restConfigOrError := k8s.ProvideRESTConfig(clientConfig)
	clientsetOrError := k8s.ProvideClientset(restConfigOrError)
	portForwardClient := k8s.ProvidePortForwardClient(restConfigOrError, clientsetOrError)
	clusterName := k8s.ProvideClusterName(apiConfigOrError)
	namespace := k8s.ProvideConfigNamespace(clientConfig)
	minikubeClient := k8s.ProvideMinikubeClient(kubeContext)
	k8sClient := k8s.ProvideK8sClient(ctx, product, restConfigOrError, clientsetOrError, portForwardClient, kubeContext, clusterName, namespace, minikubeClient, apiConfigOrError, clientConfig)
	runtime := k8s.ProvideContainerRuntime(ctx, k8sClient)
	clusterEnv := docker.ProvideClusterEnv(ctx, realClientCreator, kubeContext, product, runtime, minikubeClient)
	localEnv := docker.ProvideLocalEnv(ctx, realClientCreator, kubeContext, product, clusterEnv)
	localClient := docker.ProvideLocalCli(ctx, localEnv)
	clusterClient, err := docker.ProvideClusterCli(ctx, localEnv, clusterEnv, localClient)
	if err != nil {
		return DumpImageDeployRefDeps{}, err
	}
	compositeClient := docker.ProvideSwitchCli(clusterClient, localClient)
	labels := _wireLabelsValue
	dockerBuilder := build.NewDockerBuilder(compositeClient, labels)
	dumpImageDeployRefDeps := DumpImageDeployRefDeps{
		DockerBuilder: dockerBuilder,
		DockerClient:  compositeClient,
	}
	return dumpImageDeployRefDeps, nil
}

func wireAnalytics(l logger.Logger, cmdName model.TiltSubcommand) (*analytics.TiltAnalytics, error) {
	tiltBuild := provideTiltInfo()
	gitRemote := git.ProvideGitRemote()
	tiltAnalytics, err := newAnalytics(l, cmdName, tiltBuild, gitRemote)
	if err != nil {
		return nil, err
	}
	return tiltAnalytics, nil
}

func wireClientGetter(ctx context.Context) (*client2.Getter, error) {
	tiltDevDir, err := dirs.UseTiltDevDir()
	if err != nil {
		return nil, err
	}
	webPort := provideWebPort()
	apiServerName := model.ProvideAPIServerName(webPort)
	configAccess := server.ProvideConfigAccess(tiltDevDir)
	tiltClientConfig, err := client2.ProvideClientConfig(apiServerName, configAccess)
	if err != nil {
		return nil, err
	}
	getter := client2.NewGetter(tiltDevDir, tiltClientConfig)
	return getter, nil
}

func wireLsp(ctx context.Context, l logger.Logger, subcommand model.TiltSubcommand) (cmdLspDeps, error) {
	deferredClient := controllers.ProvideDeferredClient()
	reducer := _wireReducerValue
	storeLogActionsFlag := provideLogActions()
	storeStore := store.NewStore(reducer, storeLogActionsFlag)
	base := xdg.NewTiltDevBase()
	reconciler, err := extensionrepo.NewReconciler(deferredClient, storeStore, base)
	if err != nil {
		return cmdLspDeps{}, err
	}
	scheme := v1alpha1.NewScheme()
	tiltBuild := provideTiltInfo()
	gitRemote := git.ProvideGitRemote()
	tiltAnalytics, err := newAnalytics(l, subcommand, tiltBuild, gitRemote)
	if err != nil {
		return cmdLspDeps{}, err
	}
	extensionReconciler := extension.NewReconciler(deferredClient, scheme, tiltAnalytics)
	cliCmdLspDeps := newLspDeps(reconciler, extensionReconciler, tiltAnalytics)
	return cliCmdLspDeps, nil
}

// wire.go:

var K8sWireSet = wire.NewSet(k8s.ProvideClusterProduct, k8s.ProvideClusterName, k8s.ProvideKubeContext, k8s.ProvideAPIConfig, k8s.ProvideClientConfig, k8s.ProvideClientset, k8s.ProvideRESTConfig, k8s.ProvidePortForwardClient, k8s.ProvideConfigNamespace, k8s.ProvideContainerRuntime, k8s.ProvideServerVersion, k8s.ProvideK8sClient, ProvideKubeContextOverride,
	ProvideNamespaceOverride)

var BaseWireSet = wire.NewSet(
	K8sWireSet, tiltfile.WireSet, git.ProvideGitRemote, localexec.DefaultEnv, localexec.NewProcessExecer, wire.Bind(new(localexec.Execer), new(*localexec.ProcessExecer)), docker.SwitchWireSet, dockercompose.NewDockerComposeClient, clockwork.NewRealClock, engine.DeployerWireSet, engine.NewBuildController, local.NewServerController, kubernetesdiscovery.NewContainerRestartDetector, k8swatch.NewServiceWatcher, k8swatch.NewEventWatchManager, uisession2.NewSubscriber, uiresource2.NewSubscriber, configs.NewConfigsController, configs.NewTriggerQueueSubscriber, telemetry.NewController, cloud.WireSet, cloudurl.ProvideAddress, k8srollout.NewPodMonitor, telemetry.NewStartTracker, session2.NewController, build.ProvideClock, provideClock, hud.WireSet, prompt.WireSet, wire.Value(openurl.OpenURL(openurl.BrowserOpen)), provideLogActions, store.NewStore, wire.Bind(new(store.RStore), new(*store.Store)), wire.Bind(new(store.Dispatcher), new(*store.Store)), dockerprune.NewDockerPruner, provideTiltInfo, engine.NewUpper, analytics2.NewAnalyticsUpdater, analytics2.ProvideAnalyticsReporter, provideUpdateModeFlag, fsevent.ProvideWatcherMaker, fsevent.ProvideTimerMaker, controllers.WireSet, provideCITimeoutFlag,
	provideWebVersion,
	provideWebMode,
	provideWebURL,
	provideWebPort,
	provideWebHost, server.WireSet, provideAssetServer, tracer.NewSpanCollector, wire.Bind(new(trace.SpanExporter), new(*tracer.SpanCollector)), wire.Bind(new(tracer.SpanSource), new(*tracer.SpanCollector)), dirs.UseTiltDevDir, xdg.NewTiltDevBase, token.GetOrCreateToken, build.NewKINDLoader, wire.Value(feature.MainDefaults),
)

var CLIClientWireSet = wire.NewSet(
	BaseWireSet, client2.WireSet,
)

var UpWireSet = wire.NewSet(
	BaseWireSet, engine.ProvideSubscribers,
)

type CmdUpDeps struct {
	Upper        engine.Upper
	TiltBuild    model.TiltBuild
	Token        token.Token
	CloudAddress cloudurl.Address
	Prompt       *prompt.TerminalPrompt
	Snapshotter  *cloud.Snapshotter
}

type CmdCIDeps struct {
	Upper        engine.Upper
	TiltBuild    model.TiltBuild
	Token        token.Token
	CloudAddress cloudurl.Address
	Snapshotter  *cloud.Snapshotter
}

type CmdUpdogDeps struct {
	Upper        engine.Upper
	TiltBuild    model.TiltBuild
	Token        token.Token
	CloudAddress cloudurl.Address
	Store        *store.Store
}

type DownDeps struct {
	tfl      tiltfile.TiltfileLoader
	dcClient dockercompose.DockerComposeClient
	kClient  k8s.Client
	execer   localexec.Execer
}

func ProvideDownDeps(
	tfl tiltfile.TiltfileLoader,
	dcClient dockercompose.DockerComposeClient,
	kClient k8s.Client,
	execer localexec.Execer) DownDeps {
	return DownDeps{
		tfl:      tfl,
		dcClient: dcClient,
		kClient:  kClient,
		execer:   execer,
	}
}

type LogsDeps struct {
	url     model.WebURL
	printer *hud.IncrementalPrinter
}

func ProvideLogsDeps(u model.WebURL, p *hud.IncrementalPrinter) LogsDeps {
	return LogsDeps{
		url:     u,
		printer: p,
	}
}

func provideClock() func() time.Time {
	return time.Now
}

type DumpImageDeployRefDeps struct {
	DockerBuilder *build.DockerBuilder
	DockerClient  docker.Client
}

func provideCITimeoutFlag() model.CITimeoutFlag {
	return model.CITimeoutFlag(ciTimeout)
}
