# Responsible Disclosure Policy

Data security is a top priority for Windmill Engineering (the company behind
Tilt).  We believe that working with skilled security researchers can identify
weaknesses in any technology.

If you believe you've found a security vulnerability in Tilt or in any cloud
service that Tilt sends data to (including but not limited to
https://cloud.tilt.dev), please notify us. We will work with you to resolve the
issue promptly.

## Disclosure Policy

- If you believe you've discovered a potential vulnerability, please
  let us know by emailing us at security@tilt.dev. We will
  acknowledge your email within 3 days.

- Provide us with a reasonable amount of time to resolve the issue before
  disclosing it to the public or a third party. We aim to resolve critical
  issues within 30 days of disclosure.

- Make a good faith effort to avoid violating privacy, destroying
  data, or interrupting or degrading Tilt services. Please
  only interact with accounts you own or for which you have explicit
  permission from the account holder.

## Exclusions

While researching, we'd like you to refrain from:

- Distributed Denial of Service (DDoS)

- Spamming

- Social engineering or phishing of Windmill Engineering employees or
  contractors

- Any attacks against Windmill Engineering's physical property

Thank you for helping to keep Windmill Engineering and our users safe!

## Changes

We may revise these guidelines from time to time. The most current
version of the guidelines will be available at https://github.com/tilt-dev/tilt/blob/master/SECURITY.md.

## Contact

Windmill Engineering is always open to feedback, questions, and suggestions. If
you would like to talk to us, please feel free to email us at hi@tilt.dev.

## Disciplinary Action

Employees who violate this policy may face disciplinary consequences in
proportion to their violation. Windmill Engineering management will determine how
serious an employee's offense is and take the appropriate action.

## Responsibility

It is the CTO of Windmill Engineering's responsibility to see this policy is
enforced.
