package mssql

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.AzureProvider,
		Service:   "mssql",
		ShortCode: "threat-alert-email-set",
		Documentation: rule.RuleDocumentation{
			Summary:     "At least one email address is set for threat alerts",
			Explanation: `SQL Server sends alerts for threat detection via email, if there are no email addresses set then mitigation will be delayed.`,
			Impact:      "Nobody will be prompty alerted in the case of a threat being detected",
			Resolution:  "Provide at least one email address for threat alerts",
			BadExample: []string{`
resource "azurerm_mssql_server_security_alert_policy" "bad_example" {
  resource_group_name        = azurerm_resource_group.example.name
  server_name                = azurerm_sql_server.example.name
  state                      = "Enabled"
  storage_endpoint           = azurerm_storage_account.example.primary_blob_endpoint
  storage_account_access_key = azurerm_storage_account.example.primary_access_key
  disabled_alerts = [
    "Sql_Injection",
    "Data_Exfiltration"
  ]
  email_addresses = []
}
`},
			GoodExample: []string{`
resource "azurerm_mssql_server_security_alert_policy" "good_example" {
  resource_group_name        = azurerm_resource_group.example.name
  server_name                = azurerm_sql_server.example.name
  state                      = "Enabled"
  storage_endpoint           = azurerm_storage_account.example.primary_blob_endpoint
  storage_account_access_key = azurerm_storage_account.example.primary_access_key
  disabled_alerts = [
    "Sql_Injection",
    "Data_Exfiltration"
  ]
  email_addresses = ["db-security@acme.org"]
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/mssql_server_security_alert_policy#email_addresses",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"azurerm_mssql_server_security_alert_policy",
		},
		DefaultSeverity: severity.Medium,
		CheckFunc: func(set result.Set, resourceBlock block.Block, module block.Module) {
			if emailAddressesAttr := resourceBlock.GetAttribute("email_addresses"); emailAddressesAttr.IsNil() || emailAddressesAttr.IsEmpty() {
				set.AddResult().
					WithDescription("Resource '%s' does not specified emails_addresses for alerts", resourceBlock.FullName())
			}
		},
	})
}
