---
title: GCP005
summary: Legacy ABAC permissions are enabled. [google_container_cluster] 
resources: 
permalink: /docs/google/GCP005/
nav_order: 2
parent: GOOGLE Checks
---

## Legacy ABAC permissions are enabled.

### Explanation


You should disable Attribute-Based Access Control (ABAC), and instead use Role-Based Access Control (RBAC) in GKE.

RBAC has significant security advantages and is now stable in Kubernetes, so it’s time to disable ABAC.



### Insecure Example

The following example will fail the GCP005 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	enable_legacy_abac = "true"
}

{% endhighlight %}



### Secure Example

The following example will pass the GCP005 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	# ...
	# enable_legacy_abac not set
	# ...
}

{% endhighlight %}


### Related Links


- [https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#leave_abac_disabled_default_for_110](https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#leave_abac_disabled_default_for_110){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_legacy_abac](https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_legacy_abac){:target="_blank" rel="nofollow noreferrer noopener"}

