---
title: AZU005
summary: Password authentication in use instead of SSH keys. [azurerm_virtual_machine] 
resources: 
permalink: /docs/azure/AZU005/
nav_order: 2
parent: AZURE Checks
---

## Password authentication in use instead of SSH keys.

### Explanation


Access to instances should be authenticated using SSH keys. Removing the option of password authentication enforces more secure methods while removing the risks inherent with passwords.



### Insecure Example

The following example will fail the AZU005 check.

{% highlight terraform %}

resource "azurerm_virtual_machine" "my-disk" {
	os_profile_linux_config {
		disable_password_authentication = false
	}
}
{% endhighlight %}



### Secure Example

The following example will pass the AZU005 check.

{% highlight terraform %}

resource "azurerm_virtual_machine" "my-disk" {
	os_profile_linux_config {
		disable_password_authentication = true
	}
}
{% endhighlight %}


### Related Links


- [https://docs.microsoft.com/en-us/azure/virtual-machines/linux/create-ssh-keys-detailed](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/create-ssh-keys-detailed){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html](https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html){:target="_blank" rel="nofollow noreferrer noopener"}

