---
title: AWS053
summary: Encryption for RDS Perfomance Insights should be enabled. [aws_rds_cluster_instance aws_db_instance] 
resources: 
permalink: /docs/aws/AWS053/
nav_order: 2
parent: AWS Checks
---

## Encryption for RDS Perfomance Insights should be enabled.

### Explanation


When enabling Performance Insights on an RDS cluster or RDS DB Instance, and encryption key should be provided.

The encryption key specified in `performance_insights_kms_key_id` references a KMS ARN



### Insecure Example

The following example will fail the AWS053 check.

{% highlight terraform %}

resource "aws_rds_cluster_instance" "foo" {
  name                 = "bar"
  performance_insights_enabled = true
  performance_insights_kms_key_id = ""
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS053 check.

{% highlight terraform %}

resource "aws_rds_cluster_instance" "foo" {
  name                 = "bar"
  performance_insights_enabled = true
  performance_insights_kms_key_id = "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/rds_cluster_instance#performance_insights_kms_key_id](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/rds_cluster_instance#performance_insights_kms_key_id){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance#performance_insights_kms_key_id](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance#performance_insights_kms_key_id){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Encryption.htm](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Encryption.htm){:target="_blank" rel="nofollow noreferrer noopener"}

