---
title: AWS032
summary: Elasticsearch domain uses plaintext traffic for node to node communication. [aws_elasticsearch_domain] 
resources: 
permalink: /docs/aws/AWS032/
nav_order: 2
parent: AWS Checks
---

## Elasticsearch domain uses plaintext traffic for node to node communication.

### Explanation


Traffic flowing between Elasticsearch nodes should be encrypted to ensure sensitive data is kept private.



### Insecure Example

The following example will fail the AWS032 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  node_to_node_encryption {
    enabled = false
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS032 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  node_to_node_encryption {
    enabled = true
  }
}

{% endhighlight %}


### Related Links


