---
title: AWS020
summary: CloudFront distribution allows unencrypted (HTTP) communications. [aws_cloudfront_distribution] 
resources: 
permalink: /docs/aws/AWS020/
nav_order: 2
parent: AWS Checks
---

## CloudFront distribution allows unencrypted (HTTP) communications.

### Explanation


Plain HTTP is unencrypted and human-readable. This means that if a malicious actor was to eavesdrop on your connection, they would be able to see all of your data flowing back and forth.

You should use HTTPS, which is HTTP over an encrypted (TLS) connection, meaning eavesdroppers cannot read your traffic.



### Insecure Example

The following example will fail the AWS020 check.

{% highlight terraform %}

resource "aws_cloudfront_distribution" "s3_distribution" {
	default_cache_behavior {
	    viewer_protocol_policy = "allow-all"
	  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS020 check.

{% highlight terraform %}

resource "aws_cloudfront_distribution" "s3_distribution" {
	default_cache_behavior {
	    viewer_protocol_policy = "redirect-to-https"
	  }
}

{% endhighlight %}


### Related Links


