---
title: AWS013
summary: Task definition defines sensitive environment variable(s). [aws_ecs_task_definition] 
resources: 
permalink: /docs/aws/AWS013/
nav_order: 2
parent: AWS Checks
---

## Task definition defines sensitive environment variable(s).

### Explanation


You should not make secrets available to a user in plaintext in any scenario. Secrets can instead be pulled from a secure secret storage system by the service requiring them.  



### Insecure Example

The following example will fail the AWS013 check.

{% highlight terraform %}

resource "aws_ecs_task_definition" "my-task" {
  container_definitions = <<EOF
[
  {
    "name": "my_service",
    "essential": true,
    "memory": 256,
    "environment": [
      { "name": "ENVIRONMENT", "value": "development" },
      { "name": "DATABASE_PASSWORD", "value": "oh no D:"}
    ]
  }
]
EOF

}

{% endhighlight %}



### Secure Example

The following example will pass the AWS013 check.

{% highlight terraform %}

resource "aws_ecs_task_definition" "my-task" {
  container_definitions = <<EOF
[
  {
    "name": "my_service",
    "essential": true,
    "memory": 256,
    "environment": [
      { "name": "ENVIRONMENT", "value": "development" }
    ]
  }
]
EOF

}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/systems-manager/latest/userguide/integration-ps-secretsmanager.html](https://docs.aws.amazon.com/systems-manager/latest/userguide/integration-ps-secretsmanager.html){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.vaultproject.io/](https://www.vaultproject.io/){:target="_blank" rel="nofollow noreferrer noopener"}

