---
title: GCP008
summary: Legacy client authentication methods utilized. [google_container_cluster] 
resources: 
permalink: /docs/google/GCP008/
nav_order: 2
parent: GOOGLE Checks
---

## Legacy client authentication methods utilized.

### Explanation


It is recommended to use Serivce Accounts and OAuth as authentication methods for accessing the master in the container cluster. 

Basic authentication should be disabled by explicitly unsetting the <code>username</code> and <code>password</code> on the <code>master_auth</code> block.



### Insecure Example

The following example will fail the GCP008 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
}

resource "google_container_cluster" "gke" {
	master_auth {
	    username = ""
	    password = ""
		client_certificate_config {
			issue_client_certificate = true
	    }
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the GCP008 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	master_auth {
	    username = ""
	    password = ""
	}
}

{% endhighlight %}


### Related Links


- [https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#restrict_authn_methods](https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#restrict_authn_methods){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_auth](https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_auth){:target="_blank" rel="nofollow noreferrer noopener"}

