---
title: AZU011
summary: Storage containers in blob storage mode should not have public access [azure_storage_container] 
resources: 
permalink: /docs/azure/AZU011/
nav_order: 2
parent: AZURE Checks
---

## Storage containers in blob storage mode should not have public access

### Explanation


Storage container public access should be off. It can be configured for blobs only, containers and blobs or off entirely. The default is off, with no public access.

Explicitly overriding publicAccess to anything other than off should be avoided.



### Insecure Example

The following example will fail the AZU011 check.

{% highlight terraform %}

resource "azure_storage_container" "blob_storage_container" {
	name                  = "terraform-container-storage"
	container_access_type = "blob"
	
	properties = {
		"publicAccess" = "blob"
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU011 check.

{% highlight terraform %}

resource "azure_storage_container" "blob_storage_container" {
	name                  = "terraform-container-storage"
	container_access_type = "blob"
	
	properties = {
		"publicAccess" = "off"
	}
}

{% endhighlight %}


### Related Links


- [https://www.terraform.io/docs/providers/azure/r/storage_container.html#properties](https://www.terraform.io/docs/providers/azure/r/storage_container.html#properties){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/storage/blobs/anonymous-read-access-configure?tabs=portal#set-the-public-access-level-for-a-container](https://docs.microsoft.com/en-us/azure/storage/blobs/anonymous-read-access-configure?tabs=portal#set-the-public-access-level-for-a-container){:target="_blank" rel="nofollow noreferrer noopener"}

